/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.asn.passport;

import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import tr.gov.tubitak.uekae.esya.api.asn.BaseASNWrapper;
import tr.gov.tubitak.uekae.esya.api.asn.passport.ECertificateReference;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.asn.passport.ElcPuK;

public class EElcPuK
extends BaseASNWrapper<ElcPuK> {
    public static final byte UNCOMPRESSED_POINT_TAG = 4;

    public EElcPuK(byte[] encodedElcPuk) throws ESYAException {
        super(encodedElcPuk, new ElcPuK());
    }

    public EElcPuK(ElcPuK aElcPuk) {
        super(aElcPuk);
    }

    public EElcPuK() {
        super(new ElcPuK());
    }

    public EElcPuK(int[] aOid, ECPublicKey ecPublicKey, boolean addAllParam) throws ESYAException {
        super(new ElcPuK());
        ECParameterSpec eCParameterSpec = ecPublicKey.getParams();
        byte[] byArray = this.encodePoint(ecPublicKey.getW(), eCParameterSpec.getCurve());
        if (addAllParam) {
            byte[] byArray2;
            Object object;
            ECField eCField = eCParameterSpec.getCurve().getField();
            if (eCField instanceof ECFieldFp) {
                object = (ECFieldFp)eCField;
                byArray2 = EElcPuK.trimByteArray(((ECFieldFp)object).getP().toByteArray());
                this.setPrimeModulus(byArray2);
            }
            object = EElcPuK.trimByteArray(eCParameterSpec.getCurve().getA().toByteArray());
            byArray2 = EElcPuK.trimByteArray(eCParameterSpec.getCurve().getB().toByteArray());
            byte[] byArray3 = this.encodePoint(eCParameterSpec.getGenerator(), eCParameterSpec.getCurve());
            byte[] byArray4 = EElcPuK.trimByteArray(eCParameterSpec.getOrder().toByteArray());
            int n = eCParameterSpec.getCofactor();
            this.setFirsCoefficient((byte[])object);
            this.setSecondCoefficient(byArray2);
            this.setBasePoint(byArray3);
            this.setBaseOrderPoint(byArray4);
            this.setCofactor(n);
        }
        this.setPublicPoint(byArray);
        this.setAlgId(aOid);
    }

    public byte[] encodePoint(ECPoint ecPoint, EllipticCurve curve) {
        int n;
        byte[] byArray;
        byte[] byArray2;
        int n2;
        block7: {
            block6: {
                n2 = ECertificateReference.b;
                byArray2 = EElcPuK.trimByteArray(ecPoint.getAffineX().toByteArray());
                byArray = EElcPuK.trimByteArray(ecPoint.getAffineY().toByteArray());
                n = 0;
                if (curve == null) break block6;
                n = curve.getField().getFieldSize() + 7 >> 3;
                if (n2 == 0) break block7;
            }
            n = byArray2.length > byArray.length ? byArray2.length : byArray.length;
        }
        int n3 = 0;
        int n4 = 0;
        if (byArray2.length < n) {
            n3 = n - byArray2.length;
        }
        if (byArray.length < n) {
            n4 = n - byArray.length;
        }
        byte[] byArray3 = new byte[1 + (n << 1)];
        Arrays.fill(byArray3, (byte)0);
        byArray3[0] = 4;
        System.arraycopy(byArray2, 0, byArray3, 1 + n3, n - n3);
        System.arraycopy(byArray, 0, byArray3, 1 + n + n4, n - n4);
        if (BaseASNWrapper.b != 0) {
            ECertificateReference.b = ++n2;
        }
        return byArray3;
    }

    protected static byte[] trimByteArray(byte[] data) {
        int n = ECertificateReference.b;
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < data.length; ++n2) {
            boolean bl2 = bl = data[n2] != 0;
            if (bl && n == 0) break;
            if (n == 0) continue;
        }
        byte[] byArray = null;
        if (bl) {
            byArray = new byte[data.length - n2];
            System.arraycopy(data, n2, byArray, 0, data.length - n2);
        } else {
            byArray = new byte[]{0};
        }
        return byArray;
    }

    public void setPrimeModulus(byte[] aModulus) {
        ((ElcPuK)((Object)this.getObject())).p = new Asn1OctetString(aModulus);
    }

    public void setFirsCoefficient(byte[] aFirstCoefficient) {
        ((ElcPuK)((Object)this.getObject())).a = new Asn1OctetString(aFirstCoefficient);
    }

    public void setSecondCoefficient(byte[] secondCoefficient) {
        ((ElcPuK)((Object)this.getObject())).b = new Asn1OctetString(secondCoefficient);
    }

    public void setBasePoint(byte[] basePoint) {
        ((ElcPuK)((Object)this.getObject())).g = new Asn1OctetString(basePoint);
    }

    public void setBaseOrderPoint(byte[] aBaseOrderPoint) {
        ((ElcPuK)((Object)this.getObject())).r = new Asn1OctetString(aBaseOrderPoint);
    }

    public void setPublicPoint(byte[] publicPoint) {
        ((ElcPuK)((Object)this.getObject())).y = new Asn1OctetString(publicPoint);
    }

    public void setAlgId(int[] algId) {
        ((ElcPuK)((Object)this.getObject())).oid = new Asn1ObjectIdentifier(algId);
    }

    public void setCofactor(Integer aCofactor) {
        ((ElcPuK)((Object)this.getObject())).f = new Asn1Integer((long)aCofactor.intValue());
    }
}

