/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.asn.cmp;

import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BitString;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.BaseASNWrapper;
import tr.gov.tubitak.uekae.esya.api.asn.cmp.EPKIBody;
import tr.gov.tubitak.uekae.esya.api.asn.cmp.EPKIHeader;
import tr.gov.tubitak.uekae.esya.api.asn.cmp.EPKIStatusInfo;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EGeneralName;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.asn.cmp.CMPCertificate;
import tr.gov.tubitak.uekae.esya.asn.cmp.PKIBody;
import tr.gov.tubitak.uekae.esya.asn.cmp.PKIHeader;
import tr.gov.tubitak.uekae.esya.asn.cmp.PKIMessage;
import tr.gov.tubitak.uekae.esya.asn.cmp.PKIMessage_extraCerts;
import tr.gov.tubitak.uekae.esya.asn.cmp.ProtectedPart;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;

public class EPKIMessage
extends BaseASNWrapper<PKIMessage> {
    protected static Logger logger;
    private static final String[] a;

    public EPKIMessage(PKIMessage aObject) {
        super(aObject);
    }

    public EPKIMessage(InputStream aStream) throws ESYAException {
        super(aStream, new PKIMessage());
    }

    public EPKIMessage(byte[] aBytes) throws ESYAException {
        super(aBytes, new PKIMessage());
    }

    public EPKIMessage(EPKIHeader header, EPKIBody body, byte[] signature, List<ECertificate> extraCerts) throws ESYAException {
        this(header, body);
        this.setSignatureValue(signature);
        this.addExtraCerts(extraCerts);
    }

    public EPKIMessage(EPKIHeader header, EPKIBody body) {
        super(new PKIMessage());
        ((PKIMessage)this.mObject).header = (PKIHeader)((Object)header.getObject());
        ((PKIMessage)this.mObject).body = (PKIBody)((Object)body.getObject());
    }

    public void setSignatureValue(byte[] signature) {
        ((PKIMessage)this.mObject).protection = new Asn1BitString(signature.length << 3, signature);
    }

    public byte[] getSignatureValue() {
        return ((PKIMessage)this.mObject).protection.value;
    }

    public void addExtraCerts(List<ECertificate> extraCerts) {
        CMPCertificate[] cMPCertificateArray;
        block8: {
            int n = EPKIStatusInfo.c;
            cMPCertificateArray = new CMPCertificate[extraCerts.size()];
            for (int i = 0; i < extraCerts.size(); ++i) {
                cMPCertificateArray[i] = new CMPCertificate(1, (Asn1Type)extraCerts.get(i).getObject());
                if (n == 0) continue;
            }
            if (((PKIMessage)this.mObject).extraCerts == null || ((PKIMessage)this.mObject).extraCerts.elements == null) break block8;
            if (((PKIMessage)this.mObject).extraCerts.elements.length <= 0) break block8;
            ArrayList<CMPCertificate> arrayList = new ArrayList<CMPCertificate>();
            arrayList.addAll(Arrays.asList(((PKIMessage)this.mObject).extraCerts.elements));
            arrayList.addAll(Arrays.asList(cMPCertificateArray));
            cMPCertificateArray = arrayList.toArray(new CMPCertificate[arrayList.size()]);
        }
        if (cMPCertificateArray.length > 0) {
            ((PKIMessage)this.mObject).extraCerts = new PKIMessage_extraCerts(cMPCertificateArray);
        }
    }

    public List<ECertificate> getExtraCerts() {
        ArrayList<ECertificate> arrayList;
        int n;
        block8: {
            block7: {
                n = EPKIStatusInfo.c;
                arrayList = new ArrayList<ECertificate>();
                if (((PKIMessage)this.mObject).extraCerts == null || ((PKIMessage)this.mObject).extraCerts.elements == null) break block7;
                if (((PKIMessage)this.mObject).extraCerts.elements.length != 0) break block8;
            }
            return arrayList;
        }
        for (CMPCertificate cMPCertificate : ((PKIMessage)this.mObject).extraCerts.elements) {
            arrayList.add(new ECertificate((Certificate)cMPCertificate.getElement()));
            if (n == 0) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMessageOrigin() {
        int n = EPKIStatusInfo.c;
        if (this.mObject == null) return "";
        if (((PKIMessage)this.mObject).header == null) {
            return "";
        }
        String string = a[0] + new EGeneralName(((PKIMessage)this.mObject).header.sender);
        if (((PKIMessage)this.mObject).header.freeText != null) {
            string = string + a[3];
            if (((PKIMessage)this.mObject).header.freeText.elements != null) {
                for (int i = 0; i < ((PKIMessage)this.mObject).header.freeText.elements.length; ++i) {
                    string = string + a[2] + ((PKIMessage)this.mObject).header.freeText.elements[i].value;
                    if (n == 0) continue;
                }
            }
        }
        if (((PKIMessage)this.mObject).header.senderKID == null) return string;
        try {
            return string + a[4] + new String(((PKIMessage)this.mObject).header.senderKID.value, a[5]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.debug(a[1], (Throwable)unsupportedEncodingException);
        }
        return string;
    }

    public EPKIHeader getHeader() {
        return new EPKIHeader(((PKIMessage)this.mObject).header);
    }

    public EPKIBody getBody() {
        return new EPKIBody(((PKIMessage)this.mObject).body);
    }

    public int getChoiceID() {
        return ((PKIMessage)this.mObject).body.getChoiceID();
    }

    public byte[] getProtectedPart() throws Asn1Exception {
        ProtectedPart protectedPart = new ProtectedPart(((PKIMessage)this.mObject).header, ((PKIMessage)this.mObject).body);
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        protectedPart.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "jj5\u000fAN/!\u0001ECj4\u000bE\u001d";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 39;
                                break;
                            }
                            case 1: {
                                n8 = 15;
                                break;
                            }
                            case 2: {
                                n8 = 70;
                                break;
                            }
                            case 3: {
                                n8 = 110;
                                break;
                            }
                            default: {
                                n8 = 43;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "uj NEH/'\u0002BIf4\u0005NI/6\u001cDEc#\u0003\u000bDf-\u001aB\t";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "-\u0006";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "-/\u000b\u000bXFe\"\u000f@NI4\u000bNsj>\u001a\u0011";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "-H)\u0000OB}#\u0000BI/4\u000bMB}'\u0000X\u0007a)T";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "f\\\u0005'b";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
        logger = LoggerFactory.getLogger(EPKIMessage.class);
    }
}

