/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands;

import java.util.ArrayList;
import java.util.Random;
import javax.smartcardio.CardException;
import javax.smartcardio.ResponseAPDU;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.AkisException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.UnsupportedVersionException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands.AbstractAkisCommands;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.AkisKey;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.Algorithm;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.AuthenticationType;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FCI;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileAccessRules;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileIDs;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileLevel;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileTypes;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.GetDataModes;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.KeyType;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.P1P2;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.RSAKeyFields;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.Version;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.Crypto;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.ICommandTransmitter;

public class CommandsV10
extends AbstractAkisCommands {
    protected byte[] OAOA_ABA = new byte[24];
    private static final String[] a;

    public CommandsV10(ICommandTransmitter transmitter, Version vers) {
        super(transmitter, vers);
        this.phaseBytePosition = 6;
        this.pso_param.cds = new P1P2(-98, -102);
        this.pso_param.ccc = new P1P2(-114, -128);
        this.pso_param.vcc = new P1P2(0, -94);
        this.pso_param.enc = new P1P2(-122, -128);
        this.pso_param.dec = new P1P2(-128, -122);
        this.pso_param.hash = new P1P2(-112, -128);
        this.pso_param.vds = new P1P2(0, -88);
        this.fileAccessRules = new FileAccessRules(-1, -66, -66, 0);
        this.fileTypes = new FileTypes(-128, 65, 67, 69);
    }

    @Override
    public void createBinaryEFbySFI(byte[] FID, byte SFI, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void createDFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[7];
        byArray[0] = -128;
        byArray[1] = 16;
        byArray[3] = -73;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
    }

    @Override
    public void createDFbyName(byte[] FID, byte[] name, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 16;
        byArray[3] = 55;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)name.length;
        byArray3 = new byte[name.length + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(name, 0, byArray3, byArray2.length, name.length);
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
    }

    @Override
    public void deleteCurrent() throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteByFIDUnderMF(byte[] FID, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[7];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[4] = 2;
        byArray[5] = FID[0];
        byArray[6] = FID[1];
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public void deleteByFIDUnderDF(byte[] FID, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        int n2 = level == FileLevel.DF ? 1 : 2;
        byte by2 = (byte)n2;
        byte[] byArray = new byte[7];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = by2;
        byArray[4] = 2;
        byArray[5] = FID[0];
        byArray[6] = FID[1];
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public void deleteDFByName(byte[] name) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 17;
        byArray[2] = 4;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + name.length];
        byArray2[4] = (byte)name.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(name, 0, byArray3, byArray2.length, name.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByFIDPathFromMF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 8;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByFIDPathFromDF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 9;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByNamePathFromMF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 12;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByNamePathFromDF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 13;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteParentDF() throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public FCI selectMF() throws AkisException, CardException {
        return this.selectFileUnderMF(FileIDs.MF);
    }

    @Override
    public FCI selectFileUnderMF(byte[] FID) throws AkisException, CardException {
        byte[] byArray = new byte[7];
        byArray[1] = -92;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectChildDF(byte[] FID) throws AkisException, CardException {
        byte[] byArray = new byte[7];
        byArray[1] = -92;
        byArray[2] = 1;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectEFUnderDF(byte[] FID) throws AkisException, CardException {
        byte[] byArray = new byte[7];
        byArray[1] = -92;
        byArray[2] = 2;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectParentDF() throws AkisException, CardException {
        byte[] byArray = new byte[4];
        byArray[1] = -92;
        byArray[2] = 3;
        byte[] byArray2 = byArray;
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectDFByName(byte[] name) throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = -92;
        byArray[2] = 4;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)name.length;
        byArray3 = new byte[name.length + 5];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(name, 0, byArray3, byArray2.length, name.length);
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
        byte[] byArray4 = responseAPDU.getData();
        return new FCI(byArray4);
    }

    @Override
    public FCI selectFromMFByPath(byte[] path) throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = -92;
        byArray[2] = 8;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)path.length;
        byArray3 = new byte[path.length + 5];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
        byte[] byArray4 = responseAPDU.getData();
        return new FCI(byArray4);
    }

    @Override
    public FCI selectFromDFByPath(byte[] path) throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = -92;
        byArray[2] = 9;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)path.length;
        byArray3 = new byte[path.length + 5];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
        byte[] byArray4 = responseAPDU.getData();
        return new FCI(byArray4);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] readFileBySelectingUnderActiveDF(byte[] FID) throws AkisException, CardException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = null;
        int n = this.selectEFUnderDF(FID).getFileLength();
        if (n > 0) {
            byArray = new byte[n];
            int n2 = n;
            int n3 = 0;
            boolean bl2 = true;
            do {
                ResponseAPDU responseAPDU;
                if (bl2 && !(bl2 = false) && !bl) continue;
                byte by = (byte)((n3 & 0xFF00) >> 8);
                byte by2 = (byte)(n3 & 0xFF);
                int n4 = -1;
                if (n2 < 255) {
                    n4 = (byte)n2;
                }
                byte[] byArray2 = new byte[5];
                byArray2[1] = -80;
                byArray2[2] = by;
                byArray2[3] = by2;
                byArray2[4] = n4;
                byte[] byArray3 = byArray2;
                try {
                    responseAPDU = this.sendCommand(byArray3);
                }
                catch (AkisException akisException) {
                    if (akisException.getErrorCode() == -126L && !bl) continue;
                    throw akisException;
                }
                int n5 = responseAPDU.getData().length;
                byte[] byArray4 = responseAPDU.getData();
                System.arraycopy(byArray4, 0, byArray, n3, n5);
                n2 -= n5;
                n3 += n5;
            } while (n2 > 0);
        }
        return byArray;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public void updateBinaryFile(byte[] data) throws AkisException, CardException {
        boolean bl = AbstractAkisCommands.b;
        int n = 0;
        int n2 = data.length;
        boolean bl2 = true;
        do {
            int n3;
            byte[] byArray;
            block4: {
                block3: {
                    if (bl2 && !(bl2 = false) && !bl) continue;
                    byte by = (byte)((n & 0xFF00) >> 8);
                    byte by2 = (byte)(n & 0xFF);
                    byte[] byArray2 = new byte[5];
                    byArray2[1] = -42;
                    byArray2[2] = by;
                    byArray2[3] = by2;
                    byArray = byArray2;
                    n3 = 0;
                    if (n2 <= 196) break block3;
                    n3 = 196;
                    if (!bl) break block4;
                }
                n3 = n2;
            }
            byArray[4] = (byte)n3;
            byte[] byArray3 = new byte[byArray.length + n3];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(data, n, byArray3, byArray.length, n3);
            this.sendCommand(byArray3);
            n += n3;
            n2 -= n3;
        } while (n2 > 0);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AkisKey[] getKeyInfos() throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray;
        byte[] byArray2;
        boolean bl;
        block11: {
            block10: {
                bl = AbstractAkisCommands.b;
                if (!this.isSecureMessagingActive) break block10;
                byte[] byArray3 = new byte[5];
                byArray3[0] = -128;
                byArray3[1] = 31;
                byArray3[4] = 8;
                byArray = byArray2 = byArray3;
                if (!bl) break block11;
            }
            byte[] byArray4 = new byte[4];
            byArray4[0] = -128;
            byArray4[1] = 31;
            byArray = byArray2 = byArray4;
        }
        byArray2 = null;
        int n = 0;
        while (n < 5) {
            try {
                byArray2 = this.sendCommand(byArray).getData();
                break;
            }
            catch (AkisException akisException) {
                block13: {
                    block12: {
                        if (akisException.getErrorCode() != 27010L) break block12;
                        byArray[4] = (byte)(byArray[4] + 8);
                        if (!bl) break block13;
                    }
                    throw akisException;
                }
                ++n;
            }
        }
        n = byArray2[2];
        int n2 = 5;
        AkisKey[] akisKeyArray = new AkisKey[n];
        int n3 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            byte by = byArray2[n2 + 3 * n3];
            byte by2 = byArray2[n2 + 2 + 3 * n3];
            KeyType keyType = null;
            keyType = (by2 & 0x1F) == 31 ? KeyType.PRIVATE_RSA : ((by2 & 0x60) == 96 ? KeyType.PUBLIC_RSA : KeyType.UNKNOWN);
            akisKeyArray[n3] = new AkisKey(by, keyType);
            ++n3;
        } while (n3 < n);
        return akisKeyArray;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getMaxKeyID() throws AkisException, CardException, UnsupportedVersionException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 31;
        byte[] byArray2 = byArray;
        byte by = 0;
        ResponseAPDU responseAPDU = null;
        try {
            responseAPDU = this.sendCommand(byArray2);
        }
        catch (AkisException akisException) {
            if (akisException.getErrorCode() == 25625L) {
                return 0;
            }
            throw akisException;
        }
        byte[] byArray3 = responseAPDU.getData();
        int n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            by = byArray3[n * 3 + 5] > by ? byArray3[n * 3 + 5] : by;
            ++n;
        } while (n < byArray3[2]);
        return by;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getPublicExponent(byte keyID) throws AkisException, CardException, UnsupportedVersionException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[]{-128, 31, 64, keyID, 1};
        ResponseAPDU responseAPDU = null;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        try {
            responseAPDU = this.sendCommand(byArray);
            return responseAPDU.getData();
        }
        catch (AkisException akisException) {
            boolean bl2 = true;
            do {
                if (bl2 && !(bl2 = false) && !bl) continue;
                arrayList.add(responseAPDU.getData()[0]);
                responseAPDU = this.sendCommand(byArray);
            } while (akisException.getErrorCode() < -1L && akisException.getErrorCode() > 0L);
            byte[] byArray2 = new byte[arrayList.size()];
            int n = 0;
            boolean bl3 = true;
            do {
                if (bl3 && !(bl3 = false) && !bl) continue;
                byArray2[0] = (Byte)arrayList.get(n);
                ++n;
            } while (n < arrayList.size());
            return byArray2;
        }
    }

    @Override
    public byte[] getModulus(byte keyID) throws AkisException, CardException, UnsupportedVersionException {
        ResponseAPDU responseAPDU;
        block4: {
            byte[] byArray = new byte[]{-128, 31, 32, keyID, -128};
            byte[] byArray2 = new byte[256];
            responseAPDU = null;
            try {
                responseAPDU = this.sendCommand(byArray);
            }
            catch (AkisException akisException) {
                if (akisException.getErrorCode() >= -1L || akisException.getErrorCode() <= 0L) break block4;
                System.arraycopy(responseAPDU.getBytes(), 0, byArray2, 0, 128);
                responseAPDU = this.sendCommand(byArray);
                System.arraycopy(responseAPDU.getBytes(), 0, byArray2, 128, 128);
                return byArray2;
            }
        }
        return responseAPDU.getData();
    }

    @Override
    public void writePublicKey(RSAKeyFields fields, int keyID) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[fields.public_Exponent.length + 2];
        byArray[0] = -42;
        byte[] byArray2 = byArray;
        int n = 1;
        int n2 = fields.public_Exponent.length == 256 ? 0 : fields.public_Exponent.length;
        byArray2[n] = (byte)n2;
        System.arraycopy(fields.public_Exponent, 0, byArray, 2, fields.public_Exponent.length);
        this.writeKey(byArray, (byte)76, keyID);
        byArray = new byte[fields.modBytes.length + 2];
        byArray[0] = -41;
        byte[] byArray3 = byArray;
        int n3 = 1;
        int n4 = fields.modBytes.length == 256 ? 0 : fields.modBytes.length;
        byArray3[n3] = (byte)n4;
        System.arraycopy(fields.modBytes, 0, byArray, 2, fields.modBytes.length);
        this.writeKey(byArray, (byte)44, keyID);
    }

    @Override
    public void writePrivateKey(RSAKeyFields fields, int keyID) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[fields.prime_1.length + 2];
        byArray[0] = -47;
        byArray[1] = (byte)fields.prime_1.length;
        System.arraycopy(fields.prime_1, 0, byArray, 2, fields.prime_1.length);
        this.writeKey(byArray, (byte)-100, keyID);
        byArray = new byte[fields.prime_2.length + 2];
        byArray[0] = -46;
        byArray[1] = (byte)fields.prime_2.length;
        System.arraycopy(fields.prime_2, 0, byArray, 2, fields.prime_2.length);
        this.writeKey(byArray, (byte)-84, keyID);
        byArray = new byte[fields.exponent_1.length + 2];
        byArray[0] = -45;
        byArray[1] = (byte)fields.exponent_1.length;
        System.arraycopy(fields.exponent_1, 0, byArray, 2, fields.exponent_1.length);
        this.writeKey(byArray, (byte)-68, keyID);
        byArray = new byte[fields.exponent_2.length + 2];
        byArray[0] = -44;
        byArray[1] = (byte)fields.exponent_2.length;
        System.arraycopy(fields.exponent_2, 0, byArray, 2, fields.exponent_1.length);
        this.writeKey(byArray, (byte)-52, keyID);
        byArray = new byte[fields.coefficient.length + 2];
        byArray[0] = -43;
        byArray[1] = (byte)fields.coefficient.length;
        System.arraycopy(fields.coefficient, 0, byArray, 2, fields.coefficient.length);
        this.writeKey(byArray, (byte)-36, keyID);
        byArray = new byte[fields.modBytes.length + 2];
        byArray[0] = -41;
        byte[] byArray2 = byArray;
        int n = 1;
        int n2 = fields.modBytes.length > 256 ? 0 : fields.modBytes.length;
        byArray2[n] = (byte)n2;
        System.arraycopy(fields.modBytes, 0, byArray, 2, fields.modBytes.length);
        this.writeKey(byArray, (byte)44, keyID);
    }

    protected void writeKey(byte[] data, byte type, int keyID) throws AkisException, CardException {
        block9: {
            byte[] byArray;
            block8: {
                boolean bl = AbstractAkisCommands.b;
                byArray = new byte[]{-128, 30, (byte)(keyID | 0x80), type};
                if (data.length <= 230) break block8;
                int n = data.length;
                int n2 = 0;
                do {
                    int n3 = n > 230 ? 230 : n;
                    byte[] byArray2 = new byte[byArray.length + 1 + n3];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    byArray2[byArray.length] = (byte)n3;
                    System.arraycopy(data, n2, byArray2, byArray.length + 1, n3);
                    if (n > 230) {
                        byArray2[0] = (byte)(byArray2[0] | 0x10);
                    }
                    this.sendCommand(byArray2);
                    n2 += n3;
                } while ((n -= 230) > 0);
                if (!bl) break block9;
            }
            byte[] byArray3 = new byte[byArray.length + 1 + data.length];
            byArray3[byArray.length] = (byte)data.length;
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(data, 0, byArray3, byArray.length + 1, data.length);
            this.sendCommand(byArray3);
        }
    }

    @Override
    public void writeBACKey(byte[] key, byte passportKeyProp, byte passportKeyId) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteKey(int keyID) throws AkisException, CardException {
        byte[] byArray = new byte[4];
        byArray[0] = -128;
        byArray[1] = 30;
        byArray[2] = (byte)keyID;
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public void putData(P1P2 params, byte[] data) throws CardException {
        throw new RuntimeException(a[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getData(byte mode) throws AkisException, CardException {
        int n;
        byte[] byArray;
        block11: {
            block16: {
                boolean bl;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    bl = AbstractAkisCommands.b;
                                    byte[] byArray2 = new byte[5];
                                    byArray2[1] = -54;
                                    byArray2[2] = 1;
                                    byArray = byArray2;
                                    n = 0;
                                    if (mode != GetDataModes.copyright) break block10;
                                    n = 23;
                                    if (!bl) break block11;
                                }
                                if (mode != GetDataModes.chip) break block12;
                                n = 2;
                                if (!bl) break block11;
                            }
                            if (mode != GetDataModes.atr) break block13;
                            n = 18;
                            if (!bl) break block11;
                        }
                        if (mode != GetDataModes.memory) break block14;
                        n = 10;
                        if (!bl) break block11;
                    }
                    if (mode != GetDataModes.cardType) break block15;
                    n = 1;
                    if (!bl) break block11;
                }
                if (mode != GetDataModes.system) break block16;
                n = 77;
                if (!bl) break block11;
            }
            if (mode == GetDataModes.romCheckSum) {
                n = 2;
            }
        }
        byArray[3] = mode;
        byArray[byArray.length - 1] = n;
        ResponseAPDU responseAPDU = this.sendCommand(byArray);
        return responseAPDU.getData();
    }

    @Override
    protected byte[] getSerialGetData() throws AkisException, CardException {
        byte[] byArray = this.getData(GetDataModes.system);
        byte[] byArray2 = new byte[8];
        if (byArray.length < 67) {
            throw new RuntimeException(a[1]);
        }
        System.arraycopy(byArray, 57, byArray2, 0, 2);
        System.arraycopy(byArray, 61, byArray2, 2, 6);
        return byArray2;
    }

    @Override
    protected byte[] getSerialGetDataForActivation() throws AkisException, CardException {
        return this.getSerialGetData();
    }

    @Override
    public int getEmptyMemory() throws AkisException, CardException {
        int n = 0;
        byte[] byArray = this.getData(GetDataModes.system);
        n = 0xFF & byArray[73];
        n <<= 8;
        return n += 0xFF & byArray[74];
    }

    @Override
    public void activate(byte[] data) throws CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyInit(byte[] initKey) throws CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyPerso(byte[] persoKey) throws CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    protected byte[] exchangeChallenge(byte[] encryptedRandomNumber) throws AkisException, CardException {
        byte[] byArray = new byte[encryptedRandomNumber.length + 6];
        byArray[0] = -128;
        byArray[1] = -122;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = (byte)encryptedRandomNumber.length;
        byArray[encryptedRandomNumber.length + 5] = 8;
        System.arraycopy(encryptedRandomNumber, 0, byArray, 5, encryptedRandomNumber.length);
        ResponseAPDU responseAPDU = this.sendCommand(byArray);
        if (responseAPDU.getSW() != 36864) {
            throw new AkisException(responseAPDU.getSW());
        }
        return responseAPDU.getData();
    }

    @Override
    public void externalAuthenticatePure(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws Exception {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] generateMseData(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, AuthenticationType authType) throws Exception {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] getChallenge(int len) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyWithPinPad(byte pinNo, boolean isMF) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void verify(byte[] pin, boolean isMF) throws AkisException, CardException {
        boolean bl = AbstractAkisCommands.b;
        int n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            pin[n] = (byte)(pin[n] - 48);
            ++n;
        } while (n < pin.length);
        byte[] byArray = new byte[5];
        byArray[1] = 32;
        byArray[3] = -128;
        byte[] byArray2 = byArray;
        if (isMF) {
            byArray2[3] = 1;
        }
        byArray2[4] = (byte)pin.length;
        byte[] byArray3 = new byte[byArray2.length + pin.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(pin, 0, byArray3, byArray2.length, pin.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void verify(byte pinNo, byte[] pin, boolean isMF) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unlockDFPIN(byte[] fid, byte[] PUK, byte[] yeniPIN) throws AkisException, CardException, UnsupportedVersionException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[PUK.length];
        byte[] byArray2 = new byte[yeniPIN.length];
        int n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            byArray[n] = (byte)(PUK[n] - 48);
            ++n;
        } while (n < PUK.length);
        n = 0;
        boolean bl3 = true;
        do {
            if (bl3 && !(bl3 = false) && !bl) continue;
            byArray2[n] = (byte)(yeniPIN[n] - 48);
            ++n;
        } while (n < yeniPIN.length);
        this.changePhaseToAdmin(PUK);
        this.selectFileUnderMF(fid);
        byte[] byArray3 = new byte[7];
        byArray3[0] = -128;
        byArray3[1] = 25;
        byArray3[2] = 5;
        byArray3[3] = 61;
        byArray3[4] = 2;
        byArray3[5] = 61;
        byte[] byArray4 = byArray3;
        if (fid != null) {
            byArray4[5] = fid[0];
            byArray4[6] = fid[1];
        }
        this.sendCommand(byArray4);
        byte[] byArray5 = new byte[4];
        byArray5[1] = 36;
        byArray5[2] = 2;
        byte[] byArray6 = byArray5;
        int n2 = PUK.length + byArray2.length + 2;
        byte[] byArray7 = new byte[n2 + 5];
        System.arraycopy(byArray6, 0, byArray7, 0, 4);
        byArray7[4] = (byte)n2;
        byArray7[5] = (byte)PUK.length;
        System.arraycopy(PUK, 0, byArray7, 6, PUK.length);
        byArray7[6 + PUK.length] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray7, 6 + PUK.length + 1, byArray2.length);
        this.sendCommand(byArray7);
    }

    @Override
    public void unlockMFPIN(byte[] PUK, byte[] newPIN) throws AkisException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changeDFPIN(byte[] fid, byte[] eskiPIN, byte[] yeniPIN) throws AkisException, CardException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[eskiPIN.length];
        byte[] byArray2 = new byte[yeniPIN.length];
        int n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            byArray[n] = (byte)(eskiPIN[n] - 48);
            ++n;
        } while (n < eskiPIN.length);
        n = 0;
        boolean bl3 = true;
        do {
            if (bl3 && !(bl3 = false) && !bl) continue;
            byArray2[n] = (byte)(yeniPIN[n] - 48);
            ++n;
        } while (n < yeniPIN.length);
        byte[] byArray3 = new byte[7 + byArray.length + byArray2.length];
        byte[] byArray4 = new byte[4];
        byArray4[1] = 36;
        byArray4[2] = 2;
        byte[] byArray5 = byArray4;
        byte[] byArray6 = new byte[]{(byte)(byArray2.length + byArray.length + 2)};
        System.arraycopy(byArray5, 0, byArray3, 0, 4);
        System.arraycopy(byArray6, 0, byArray3, 4, 1);
        byte[] byArray7 = new byte[2];
        byArray7[0] = (byte)byArray.length;
        System.arraycopy(byArray7, 0, byArray3, 5, 1);
        System.arraycopy(byArray, 0, byArray3, 6, byArray7[0]);
        byArray7[1] = (byte)byArray2.length;
        System.arraycopy(byArray7, 1, byArray3, 6 + byArray7[0], 1);
        System.arraycopy(byArray2, 0, byArray3, 6 + byArray7[0] + 1, byArray7[1]);
        this.selectMF();
        this.selectFileUnderMF(fid);
        this.sendCommand(byArray3);
    }

    @Override
    public void changeDFPUK(byte[] fid, byte[] oldPIN, byte[] newPIN) throws AkisException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changeMFPIN(byte[] eskiPIN, byte[] yeniPIN) throws AkisException, CardException, UnsupportedVersionException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[eskiPIN.length];
        byte[] byArray2 = new byte[yeniPIN.length];
        int n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            byArray[n] = (byte)(eskiPIN[n] - 48);
            ++n;
        } while (n < eskiPIN.length);
        n = 0;
        boolean bl3 = true;
        do {
            if (bl3 && !(bl3 = false) && !bl) continue;
            byArray2[n] = (byte)(yeniPIN[n] - 48);
            ++n;
        } while (n < yeniPIN.length);
        byte[] byArray3 = new byte[7 + byArray.length + byArray2.length];
        byte[] byArray4 = new byte[4];
        byArray4[1] = 36;
        byArray4[2] = 1;
        byte[] byArray5 = byArray4;
        byte[] byArray6 = new byte[]{(byte)(byArray2.length + byArray.length + 2)};
        System.arraycopy(byArray5, 0, byArray3, 0, 4);
        System.arraycopy(byArray6, 0, byArray3, 4, 1);
        byte[] byArray7 = new byte[2];
        byArray7[0] = (byte)byArray.length;
        System.arraycopy(byArray7, 0, byArray3, 5, 1);
        System.arraycopy(byArray, 0, byArray3, 6, byArray7[0]);
        byArray7[1] = (byte)byArray2.length;
        System.arraycopy(byArray7, 1, byArray3, 6 + byArray7[0], 1);
        System.arraycopy(byArray2, 0, byArray3, 6 + byArray7[0] + 1, byArray7[1]);
        this.selectMF();
        this.changePhaseToAdmin(yeniPIN);
        this.sendCommand(byArray3);
    }

    @Override
    public void changeMFPUK(byte[] mfPIN, byte[] oldPIN, byte[] newPIN) throws AkisException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void mse(byte keyID) throws AkisException, CardException {
        byte[] byArray = new byte[4];
        byArray[1] = 34;
        byArray[2] = -61;
        byArray[3] = keyID;
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public byte[] pso(P1P2 psoMode, byte[] data) throws AkisException, CardException {
        int n = -1;
        if (psoMode.equals(this.pso_param.ccc)) {
            n = 8;
        }
        if (psoMode.equals(this.pso_param.cds)) {
            n = -1;
        }
        if (psoMode.equals(this.pso_param.enc)) {
            n = -1;
        }
        if (psoMode.equals(this.pso_param.dec)) {
            n = -1;
        }
        if (psoMode.equals(this.pso_param.vcc)) {
            n = -1;
        }
        if (psoMode.equals(this.pso_param.hash)) {
            n = 20;
        }
        byte[] byArray = new byte[4];
        byArray[1] = 42;
        byArray[2] = psoMode.getp1();
        byArray[3] = psoMode.getp2();
        byte[] byArray2 = byArray;
        int n2 = byArray2.length + data.length + 1;
        if (n > -1) {
            ++n2;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byArray3[byArray2.length] = (byte)data.length;
        System.arraycopy(data, 0, byArray3, byArray2.length + 1, data.length);
        if (n > -1) {
            byArray3[byArray3.length - 1] = n;
        }
        return this.sendCommand(byArray3).getData();
    }

    @Override
    public byte[] sign(byte[] data, byte keyID) throws CardException {
        this.mse(keyID);
        return this.pso(this.pso_param.cds, data);
    }

    @Override
    public void decideSecureMessageKeyGeneratingKey() throws AkisException, CardException {
        byte[] byArray = new byte[]{16, 50, 84, 118, -104, -70, -36, -2};
        byte[] byArray2 = new byte[]{17, 34, 51, 68, 85, 102, 119, -120};
        this.OAOA_ABA = new byte[24];
        System.arraycopy(byArray, 0, this.OAOA_ABA, 0, 8);
        System.arraycopy(byArray2, 0, this.OAOA_ABA, 8, 8);
        System.arraycopy(byArray, 0, this.OAOA_ABA, 16, 8);
    }

    @Override
    public void generateSecureMessagingKey() throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        block4: {
            byArray4 = new byte[8];
            byArray3 = new byte[8];
            Random random = new Random();
            byArray2 = new byte[8];
            random.nextBytes(byArray2);
            byte[] byArray5 = new byte[16];
            byArray5 = Crypto.triDes(this.OAOA_ABA, byArray2, true);
            byArray = new byte[8];
            byArray = this.exchangeChallenge(byArray5);
            if (byArray != null && byArray.length == 8) break block4;
            throw new RuntimeException(a[3]);
        }
        byte[] byArray6 = new byte[16];
        byArray6 = Crypto.triDes(this.OAOA_ABA, byArray, false);
        System.arraycopy(byArray2, 0, byArray4, 0, 8);
        System.arraycopy(byArray6, 0, byArray3, 0, 8);
        System.arraycopy(byArray4, 0, this.secureMessagingKey_ABA, 0, 8);
        System.arraycopy(byArray3, 0, this.secureMessagingKey_ABA, 8, 8);
        System.arraycopy(byArray4, 0, this.secureMessagingKey_ABA, 16, 8);
    }

    @Override
    public void generateSecureMessagingKey(String documentNumber, String dateOfBirth, String expireDate) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] createEncryptedCommand(byte[] command) throws AkisException {
        int n;
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        boolean bl;
        block52: {
            int n5;
            int n6;
            int n7;
            block54: {
                block53: {
                    boolean bl2;
                    block51: {
                        block50: {
                            block49: {
                                block46: {
                                    block48: {
                                        block47: {
                                            block45: {
                                                int n8;
                                                block43: {
                                                    int n9;
                                                    block44: {
                                                        bl = AbstractAkisCommands.b;
                                                        bl2 = false;
                                                        n4 = 0;
                                                        n3 = 0;
                                                        n7 = 0;
                                                        n8 = -2;
                                                        n6 = -2;
                                                        n5 = -2;
                                                        n9 = 1000;
                                                        if (command.length > 4) {
                                                            n9 = command[4] & 0xFF;
                                                        }
                                                        if (command.length < 5) break block43;
                                                        if (command.length != 5) break block44;
                                                        n8 = command[command.length - 1];
                                                        n6 = n8 & 0xFF;
                                                        if (!bl) break block43;
                                                    }
                                                    if (command.length > 5 && n9 < command.length - 5) {
                                                        n8 = command[command.length - 1];
                                                        n6 = n8 & 0xFF;
                                                    }
                                                }
                                                if (n6 != 0 && n6 != 255) break block45;
                                                n5 = n8;
                                                if (!bl) break block46;
                                            }
                                            if (n6 <= -2 || n6 % 8 != 0) break block47;
                                            n5 = (byte)(n6 + 8);
                                            if (!bl) break block46;
                                        }
                                        if (n6 <= -2 || n6 % 8 >= 2) break block48;
                                        n5 = (byte)(n6 + (16 - n6 % 8));
                                        if (!bl) break block46;
                                    }
                                    if (n6 > -2) {
                                        n5 = (byte)(n6 + (8 - n6 % 8));
                                    }
                                }
                                if (command.length > 5) break block49;
                                bl2 = false;
                                if (!bl) break block50;
                            }
                            if (command.length > 5) {
                                bl2 = true;
                            }
                        }
                        byArray = new byte[256];
                        System.arraycopy(command, 0, byArray, 0, command.length);
                        byArray[0] = (byte)(byArray[0] | 4);
                        n2 = 0;
                        if (bl2) break block51;
                        n4 = 4;
                        n2 = command.length;
                        if (n6 <= -2) break block52;
                        byArray[n4++] = n5;
                        if (!bl) break block52;
                    }
                    if (!bl2) break block52;
                    n = 5;
                    if (n6 > -2) {
                        ++n;
                    }
                    if (((n7 = command.length - n) + 2) % 8 <= 0) break block53;
                    n3 = n7 + 2 + (8 - (n7 + 2) % 8);
                    if (!bl) break block54;
                }
                n3 = n7 + 2;
            }
            n4 = 4;
            byArray[n4++] = (byte)n3;
            byArray[n4++] = -122;
            byArray[n4++] = (byte)n7;
            int n10 = 0;
            boolean bl3 = true;
            do {
                if (bl3 && !(bl3 = false) && !bl) continue;
                byArray[n4++] = command[n10 + 5];
                ++n10;
            } while (n10 < n7);
            n4 += n7;
            n2 = n3 + n;
            if (n6 > -2) {
                byArray[n4++] = n5;
            }
        }
        if (n3 > 0) {
            n = n4;
            boolean bl4 = true;
            do {
                if (bl4 && !(bl4 = false) && !bl) continue;
                byArray[n] = 0;
                ++n;
            } while (n < n2);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 5, byArray2, 0, n3);
            byte[] byArray3 = Crypto.triDes(this.secureMessagingKey_ABA, byArray2, true);
            if (byArray3 == null) {
                return null;
            }
            System.arraycopy(byArray3, 0, byArray, 5, byArray3.length);
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        return byArray4;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] createDecryptedCommand(byte[] response) throws AkisException {
        byte[] byArray;
        boolean bl = AbstractAkisCommands.b;
        if (response.length < 3) {
            return response;
        }
        byte[] byArray2 = null;
        if (response.length % 8 > 2) {
            throw new RuntimeException(a[2]);
        }
        if (response.length % 8 <= 2) {
            byArray = new byte[response.length - response.length % 8];
            System.arraycopy(response, 0, byArray, 0, byArray.length);
            byArray2 = Crypto.triDes(this.secureMessagingKey_ABA, byArray, false);
        } else {
            byArray = new byte[response.length - response.length % 8];
            System.arraycopy(response, response.length - (response.length - response.length % 8 + 2), byArray, 0, byArray.length);
            byArray2 = Crypto.triDes(this.secureMessagingKey_ABA, byArray, false);
        }
        if (byArray2 == null || byArray2.length == 0) {
            return null;
        }
        int n = 0;
        int n2 = byArray2[1] & 0xFF;
        int n3 = 2;
        if (byArray2[0] != -122 && byArray2.length == 256) {
            n2 = 256;
            n3 = 0;
        }
        byte[] byArray3 = new byte[n2 + 2];
        n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            byArray3[n] = byArray2[n3++];
            ++n;
        } while (n < byArray3.length - 2);
        byArray3[byArray3.length - 2] = response[response.length - 2];
        byArray3[byArray3.length - 1] = response[response.length - 1];
        return byArray3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "$\u0017w2l\u0007\bowh\u000f\u0016wwaJ\u0001ff";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 106;
                                break;
                            }
                            case 1: {
                                n8 = 120;
                                break;
                            }
                            case 2: {
                                n8 = 3;
                                break;
                            }
                            case 3: {
                                n8 = 18;
                                break;
                            }
                            default: {
                                n8 = 5;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "9\u001dq{d\u0006Xmgh\b\u001dq2f\u000b\u0016#|j\u001eXaw%\u0018\u001dbv+J?ff%.\u0019ws%\t\u0017n\u007fd\u0004\u001c#``\u001e\rq|`\u000eXj|v\u001f\u001ee{f\u0003\u001dmf%\u0006\u001dmuq\u0002Xgsq\u000bV";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "9\u001d`gw\u000fXNwv\u0019\u0019d{k\rXGwf\u0018\u0001sf%/\nq}wPXgsq\u000bXowk\r\fk2l\u0019Xm}qJ\u0015v~q\u0003\bow%\u0005\u001e#*+";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "/\u0000`zd\u0004\u001ff2F\u0002\u0019o~d\u0004\u001ff2w\u000f\fv`k\u000f\u001c#vd\u001e\u0019#el\u001e\u0010#gk\u000f\u0000swf\u001e\u001dg2i\u000f\u0016dfmJPm}qJI52g\u0013\ff;";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

