/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.util.Base64;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.OcspConfigTags;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.DecryptorConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.IOcspConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.IResponsibleCaElement;

public class ResponsibleCaElement
extends AbstractConfigElement
implements IResponsibleCaElement {
    private List<IOcspConfigElement> a;
    private OcspConfigTags[] c = new OcspConfigTags[]{OcspConfigTags.NAME, OcspConfigTags.CACERTIFICATE};

    public ResponsibleCaElement() {
    }

    public ResponsibleCaElement(ECertificate caCertificate, String name, List<IOcspConfigElement> statusProviders) {
        this.map.put(OcspConfigTags.NAME, name);
        this.map.put(OcspConfigTags.CACERTIFICATE, Base64.encode((byte[])caCertificate.getEncoded()));
        this.a = statusProviders;
    }

    @Override
    public Element constructElement(Document document) {
        int n = DecryptorConfigElement.c;
        Element element = super.constructElement(document);
        Element element2 = document.createElement(OcspConfigTags.STATUSPROVIDERS.getTagName());
        element.appendChild(element2);
        for (IOcspConfigElement iOcspConfigElement : this.a) {
            element2.appendChild(iOcspConfigElement.constructElement(document));
            if (n == 0) continue;
        }
        return element;
    }

    @Override
    public OcspConfigTags getRootTag() {
        return OcspConfigTags.RESPONSIBLECA;
    }

    @Override
    public OcspConfigTags[] getElementNames() {
        return this.c;
    }

    @Override
    public boolean isMultiple() {
        return true;
    }

    @Override
    public ECertificate getCaCertificate() {
        try {
            return new ECertificate((String)this.map.get((Object)OcspConfigTags.CACERTIFICATE));
        }
        catch (ESYAException eSYAException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return (String)this.map.get((Object)OcspConfigTags.NAME);
    }

    @Override
    public List<IOcspConfigElement> getStatusProviders() {
        return this.a;
    }

    @Override
    public void addStatusProviders(List<IOcspConfigElement> configElement) {
        this.a = configElement;
    }
}

