/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.creator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.OcspConfigTags;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.creator.IOcspConfigHolder;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.creator.IOcspConfigurationCreator;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.IOcspConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.OcspEncCertificateConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.OcspSignCertificateConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.PreferredSignAlgElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.SupportedSignAlgElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.URLConfigElement;

public abstract class AbstractOcspConfigurationCreator
implements IOcspConfigurationCreator {
    private Logger a = LoggerFactory.getLogger(AbstractOcspConfigurationCreator.class);
    protected Document doc;
    protected Element config;
    public static boolean b;
    private static final String[] c;

    public AbstractOcspConfigurationCreator() throws Exception {
        this.a();
    }

    @Override
    public void createConfiguration(IOcspConfigHolder configHolder) throws ESYAException {
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            String string = configHolder.getDefaultSigningAlgorithm();
                            if (string != null) {
                                new PreferredSignAlgElement(string).constructElement(this.doc);
                            }
                            List<ECertificate> list = configHolder.getSigningCertificates();
                            if (list == null || list.isEmpty()) break block26;
                            this.addOcspCertificatesEncoded(list);
                        }
                        List<String> list = configHolder.getSupportedSigningAlgorithms();
                        if (list == null || list.isEmpty()) break block27;
                        this.addSupportedSignAlgs(list);
                    }
                    List<IOcspConfigElement> list = configHolder.getSigners();
                    if (list == null || list.isEmpty()) break block28;
                    this.addListByRootName(OcspConfigTags.SIGNERS, list);
                }
                List<IOcspConfigElement> list = configHolder.getResponsibleCas();
                if (list == null || list.isEmpty()) break block29;
                this.addListByRootName(OcspConfigTags.RESPONSIBLECAS, list);
            }
            ECertificate eCertificate = configHolder.getEncryptionCertificate();
            if (eCertificate != null) {
                this.addOcspEncCertificate(eCertificate);
            }
            String string = configHolder.getUrl();
            if (string == null || string.isEmpty()) break block30;
            this.setUrl(string);
        }
    }

    protected void addListByRootName(OcspConfigTags rootTag, List<IOcspConfigElement> elements) {
        boolean bl = b;
        for (IOcspConfigElement iOcspConfigElement : elements) {
            this.addElementByElementRootName(rootTag, iOcspConfigElement);
            if (!bl) continue;
        }
    }

    public void setUrl(String url) {
        if (url != null) {
            new URLConfigElement(url).constructElement(this.doc);
        }
    }

    private void a() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.newDocument();
        Element element = this.doc.createElement(OcspConfigTags.OCSPCONFIGROOT.getTagName());
        this.doc.appendChild(element);
        this.config = this.doc.createElement(OcspConfigTags.OCSPCONFIG.getTagName());
        element.appendChild(this.config);
    }

    protected void addOcspCertificatesEncoded(List<ECertificate> aOcspSignCertificateList) {
        boolean bl = b;
        for (ECertificate eCertificate : aOcspSignCertificateList) {
            OcspSignCertificateConfigElement ocspSignCertificateConfigElement = new OcspSignCertificateConfigElement(eCertificate);
            this.appendToConfig(ocspSignCertificateConfigElement);
            if (!bl) continue;
        }
    }

    protected void addSupportedSignAlgs(List<String> aSupportedSignAlgList) {
        boolean bl = b;
        for (String string : aSupportedSignAlgList) {
            SupportedSignAlgElement supportedSignAlgElement = new SupportedSignAlgElement(string);
            this.appendToConfig(supportedSignAlgElement);
            if (!bl) continue;
        }
    }

    protected void addOcspEncCertificate(ECertificate ocspEncryptionCertificate) {
        if (ocspEncryptionCertificate != null) {
            OcspEncCertificateConfigElement ocspEncCertificateConfigElement = new OcspEncCertificateConfigElement(ocspEncryptionCertificate);
            ocspEncCertificateConfigElement.constructElement(this.doc);
        }
    }

    protected void appendToConfig(IOcspConfigElement element) {
        Element element2 = element.constructElement(this.doc);
        this.config.appendChild(element2);
    }

    protected void addElementByElementRootName(OcspConfigTags rootTag, IOcspConfigElement element) {
        block2: {
            Element element2;
            block4: {
                block3: {
                    if (element == null) break block2;
                    NodeList nodeList = this.doc.getElementsByTagName(rootTag.getTagName());
                    if (nodeList == null || nodeList.getLength() <= 0) break block3;
                    element2 = (Element)nodeList.item(0);
                    if (!b) break block4;
                }
                element2 = this.doc.createElement(rootTag.getTagName());
                this.config.appendChild(element2);
            }
            element2.appendChild(element.constructElement(this.doc));
        }
    }

    @Override
    public String send(String url) throws ESYAException {
        String string;
        block14: {
            boolean bl;
            block16: {
                block15: {
                    boolean bl2 = b;
                    HttpURLConnection httpURLConnection = null;
                    OutputStreamWriter outputStreamWriter = null;
                    String string2 = null;
                    try {
                        URL uRL = new URL(url);
                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setAllowUserInteraction(true);
                        httpURLConnection.setDoInput(true);
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setUseCaches(false);
                        httpURLConnection.setRequestProperty(c[1], c[2]);
                        outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), c[6]);
                        StreamResult streamResult = new StreamResult(outputStreamWriter);
                        this.a(streamResult);
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                        InputStream inputStream = httpURLConnection.getInputStream();
                        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                        try {
                            string2 = (String)objectInputStream.readObject();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.a.error(c[5]);
                            throw new ESYAException(c[4], (Throwable)classNotFoundException);
                        }
                        objectInputStream.close();
                        inputStream.close();
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.a.error(c[0], (Throwable)iOException);
                            throw new ESYAException(c[3], (Throwable)iOException);
                        }
                        catch (Throwable throwable) {
                            if (httpURLConnection != null) {
                                httpURLConnection.disconnect();
                            }
                            throw throwable;
                        }
                    }
                    string = string2;
                    if (!AbstractConfigElement.b) break block14;
                    if (!bl2) break block15;
                    bl = false;
                    break block16;
                }
                bl = true;
            }
            b = bl;
        }
        return string;
    }

    @Override
    public void saveToFile(File file) throws ESYAException {
        StreamResult streamResult = new StreamResult(file.toURI().getPath());
        this.a(streamResult);
    }

    private void a(StreamResult streamResult) throws ESYAException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.doc);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            this.a.error(c[8], (Throwable)exception);
            throw new ESYAException(c[7], (Throwable)exception);
        }
    }

    @Override
    public byte[] getStreamAsByteArray() throws ESYAException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        this.a(streamResult);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "{~!/\u0013Wk\u0177c\u0017Jq'0\u0143W{'c\u001bV?#;\u0011\\o2*\u001dW?.\"\u0006Xl\u0177";
        int n2 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block20;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 57;
                                break;
                            }
                            case 1: {
                                n8 = 31;
                                break;
                            }
                            case 2: {
                                n8 = 70;
                                break;
                            }
                            case 3: {
                                n8 = 67;
                                break;
                            }
                            default: {
                                n8 = 114;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "zp(7\u0017Wkk\u0017\u000bIz";
                    n2 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "Mz>7]Ar*";
                    n2 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "zp(-\u0017Zk/,\u001c\u0019Y'*\u001e\\{|\n=\u0019Z> \u0017Ik/,\u001c\u0019p% \u0007Km#'";
                    n2 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "|m4,\u0000\u0019h.*\u001e\\?4&\u0013]v($RXq54\u0017K";
                    n2 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "jz45\u001e\\ka7\u0017W?!&\u001e\\qf \u0017O~6c\u001dRj(\"\u001fX{\u0177";
                    n2 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "lK\u0000nJ";
                    n2 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "}p+c\u0016V|3.\u0017Wkf \u0013Wq)7R[zf \u001dWi#1\u0006\\{f7\u001d\u0019g+/";
                    n2 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "}p+c\u0019Xf(\"\u0015\u0108?>.\u001e\u0019f'3\u0143J\u012e(\"R]p(6\u0001Mj46\u001e\\r#'\u001b";
                    n2 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
    }
}

