/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import jcifs.http.NtlmHttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtension;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.util.HashMultiMap;
import tr.gov.tubitak.uekae.esya.asn.ocsp.BasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.CertID;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Request;
import tr.gov.tubitak.uekae.esya.asn.ocsp.TBSRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Version;
import tr.gov.tubitak.uekae.esya.asn.ocsp._SeqOfRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp._ocspValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Extension;
import tr.gov.tubitak.uekae.esya.asn.x509.Extensions;

public class OCSPClient {
    protected static Logger logger;
    public static final int REASON_UNSPECIFIED = 0;
    public static final int REASON_KEY_COMPROMISE = 1;
    public static final int REASON_CA_COMPROMISE = 2;
    public static final int REASON_AFFILIATION_CHANGED = 3;
    public static final int REASON_SUPERSEDED = 4;
    public static final int REASON_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CERTIFICATE_HOLD = 6;
    public static final int REASON_PRIVILEGE_WITHDRAWN = 9;
    public static final int REASON_AA_COMPROMISE = 10;
    public static final int STATUS_RESPONSE_HAS_INVALID_SIGNATURE = 1;
    public static final int STATUS_RESPONSE_CANT_BE_RECEIVED = 2;
    public static final int STATUS_RESPONCE_INVALID_NONCE = 3;
    private static final String a;
    private static final String b;
    private static final String c;
    private static final String d;
    private static final String e;
    public static final Asn1ObjectIdentifier NONCE_OID;
    private int f;
    protected HashMultiMap<BigInteger, ESingleResponse> singleResponses;
    protected ECertificate signingCertificate;
    protected EBasicOCSPResponse mBasicResponse;
    protected EOCSPResponse mOCSPResponce;
    private static final Logger g;
    private String h;
    private HttpURLConnection i;
    private URL j;
    private byte[] k;
    private int l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    public static DigestAlg digestAlgForOcspRequest;
    public static boolean q;
    private static final String[] r;

    protected OCSPClient() {
        block6: {
            boolean bl;
            block8: {
                block7: {
                    boolean bl2 = q;
                    this.h = null;
                    this.i = null;
                    this.j = null;
                    this.k = null;
                    this.l = 0;
                    this.m = true;
                    this.n = true;
                    this.o = true;
                    this.p = false;
                    this.singleResponses = new HashMultiMap();
                    try {
                        LV.getInstance().checkLD(LV.Urunler.ORTAK);
                    }
                    catch (LE lE) {
                        throw new ESYARuntimeException(r[0] + lE.getMessage());
                    }
                    if (!bl2) break block6;
                    if (!AbstractConfigElement.b) break block7;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            AbstractConfigElement.b = bl;
        }
    }

    public OCSPClient(String aConnectionAddress) throws ESYAException {
        this();
        try {
            this.j = new URL(aConnectionAddress);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ESYAException((Throwable)malformedURLException);
        }
        this.h = aConnectionAddress;
    }

    public void setCheckSignature(boolean aCheckSignature) {
        this.m = aCheckSignature;
    }

    public void setCheckNonce(boolean aCheckNonce) {
        this.n = aCheckNonce;
    }

    public void setCheckResponseStatus(boolean aCheckResponseStatus) {
        this.o = aCheckResponseStatus;
    }

    public void setCheckDate(boolean aCheckDate) {
        this.p = aCheckDate;
    }

    public void openConnection() throws ESYAException {
        this.openConnection(null);
    }

    public void closeConnection() throws ESYAException {
        this.i.disconnect();
    }

    public void openConnection(String aTimeOut) throws ESYAException {
        block9: {
            boolean bl;
            block11: {
                block10: {
                    boolean bl2 = q;
                    try {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)this.j.openConnection();
                        if (aTimeOut != null) {
                            httpURLConnection.setConnectTimeout(Integer.parseInt(aTimeOut));
                            httpURLConnection.setReadTimeout(Integer.parseInt(aTimeOut));
                        }
                        httpURLConnection.setRequestProperty(r[6], r[9]);
                        httpURLConnection.setRequestProperty(r[3], r[8]);
                        httpURLConnection.setRequestMethod(r[5]);
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setUseCaches(false);
                        this.i = new NtlmHttpURLConnection(httpURLConnection);
                        this.i.connect();
                    }
                    catch (IOException iOException) {
                        g.error(r[4] + this.h, (Throwable)iOException);
                        throw new ESYAException(r[7] + this.h, (Throwable)iOException);
                    }
                    if (!AbstractConfigElement.b) break block9;
                    if (!bl2) break block10;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
            q = bl;
        }
    }

    public Calendar getProducedAt() {
        return this.mBasicResponse.getProducedAt();
    }

    public void queryCertificate(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        this.queryCertificate(new ECertificate[]{aCertificateToQuery}, new ECertificate[]{aIssuerCertificate});
    }

    public EOCSPResponse queryCertificate(ECertificate[] aCertificatesToQuery, ECertificate[] aIssuerCertificates) throws ESYAException {
        if (this.i == null) {
            g.error(r[37]);
            throw new ESYAException(r[35]);
        }
        byte[] byArray = this.a(aCertificatesToQuery, aIssuerCertificates);
        this.a(byArray);
        g.debug(r[36]);
        return this.mOCSPResponce;
    }

    public EOCSPResponse queryCertificate(BigInteger aSertifikaSeriNo, byte[] aSMSubjectHashDegeri, byte[] aSMAcikAnahtarHashDegeri) throws ESYAException {
        if (this.i == null) {
            g.error(r[10]);
            throw new ESYAException(r[11]);
        }
        byte[] byArray = this.a(aSertifikaSeriNo, aSMSubjectHashDegeri, aSMAcikAnahtarHashDegeri);
        this.a(byArray);
        g.debug(r[12]);
        return this.mOCSPResponce;
    }

    public int getStatus() {
        return this.l;
    }

    private EOCSPResponse a(byte[] byArray) throws ESYAException {
        block10: {
            block11: {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.i.getOutputStream());
                    dataOutputStream.write(byArray);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    g.error(r[41], (Throwable)iOException);
                    throw new ESYAException(r[45], (Throwable)iOException);
                }
                try {
                    g.debug(r[38]);
                    this.mOCSPResponce = this.b();
                    g.debug(r[39]);
                }
                catch (Exception exception) {
                    this.l = 2;
                    g.error(r[44], (Throwable)exception);
                    throw new ESYAException(r[42], (Throwable)exception);
                }
                if (!this.o) break block10;
                if (!this.checkResponseStatus()) break block11;
                this.a(this.mOCSPResponce);
                if (!q) break block10;
            }
            this.mOCSPResponce = null;
            g.error(r[43]);
            throw new ESYAException(r[40]);
        }
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(ECertificate[] eCertificateArray, ECertificate[] eCertificateArray2) throws ESYAException {
        boolean bl = q;
        g.debug(r[14]);
        if (eCertificateArray == null || eCertificateArray.length == 0) {
            g.error(r[15]);
            throw new ESYAException(r[16]);
        }
        int n = eCertificateArray.length;
        Request[] requestArray = new Request[n];
        for (int i = 0; i < n; ++i) {
            ECertificate eCertificate = eCertificateArray[i];
            ECertificate eCertificate2 = eCertificateArray2[i];
            try {
                requestArray[i] = this.a(eCertificate, eCertificate2);
                continue;
            }
            catch (Exception exception) {
                g.error(r[17], (Throwable)exception);
                throw new ESYAException(r[13], (Throwable)exception);
            }
        }
        return this.a(requestArray);
    }

    private byte[] a(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        Request[] requestArray = new Request[1];
        try {
            requestArray[0] = this.b(bigInteger, byArray, byArray2);
        }
        catch (Exception exception) {
            g.error(r[65], (Throwable)exception);
            return null;
        }
        return this.a(requestArray);
    }

    private byte[] a(Request[] requestArray) throws ESYAException {
        Extension extension;
        OCSPRequest oCSPRequest = new OCSPRequest();
        TBSRequest tBSRequest = new TBSRequest();
        try {
            extension = this.a();
        }
        catch (Exception exception) {
            g.warn(r[47], (Throwable)exception);
            throw new ESYAException(r[50]);
        }
        tBSRequest.requestList = new _SeqOfRequest(requestArray);
        tBSRequest.requestExtensions = new Extensions(new Extension[]{extension});
        tBSRequest.version = new Version(0L);
        oCSPRequest.tbsRequest = tBSRequest;
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            oCSPRequest.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            g.error(r[48], (Throwable)exception);
            throw new ESYAException(r[49]);
        }
        byte[] byArray = asn1DerEncodeBuffer.getMsgCopy();
        g.debug(r[46]);
        return byArray;
    }

    private Extension a() throws ESYAException {
        try {
            Extension extension = new Extension();
            extension.extnID = NONCE_OID;
            this.k = new byte[16];
            SecureRandom.getInstance(r[64]).nextBytes(this.k);
            Asn1OctetString asn1OctetString = new Asn1OctetString(this.k);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            asn1OctetString.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            extension.extnValue = new Asn1OctetString(asn1DerEncodeBuffer.getMsgCopy());
            return extension;
        }
        catch (Exception exception) {
            throw new ESYAException((Throwable)exception);
        }
    }

    private EOCSPResponse b() throws ESYAException {
        OCSPResponse oCSPResponse = new OCSPResponse();
        InputStream inputStream = null;
        try {
            inputStream = this.i.getInputStream();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(inputStream);
            oCSPResponse.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            g.debug(r[30]);
        }
        catch (IOException iOException) {
            g.error(r[28], (Throwable)iOException);
            throw new ESYAException(r[29], (Throwable)iOException);
        }
        catch (Exception exception) {
            g.error(r[31], (Throwable)exception);
            throw new ESYAException(r[32], (Throwable)exception);
        }
        return new EOCSPResponse(oCSPResponse);
    }

    private Request a(ECertificate eCertificate, ECertificate eCertificate2) throws Exception {
        BigInteger bigInteger = eCertificate.getSerialNumber();
        byte[] byArray = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubject().getEncoded());
        byte[] byArray2 = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey());
        return this.b(bigInteger, byArray, byArray2);
    }

    private Request b(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        CertID certID = new CertID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgForOcspRequest.getOID());
        Asn1OctetString asn1OctetString = new Asn1OctetString(byArray);
        Asn1OctetString asn1OctetString2 = new Asn1OctetString(byArray2);
        Asn1BigInteger asn1BigInteger = new Asn1BigInteger(bigInteger);
        certID.hashAlgorithm = algorithmIdentifier;
        certID.issuerNameHash = asn1OctetString;
        certID.issuerKeyHash = asn1OctetString2;
        certID.serialNumber = asn1BigInteger;
        return new Request(certID);
    }

    public int getResponseStatus() {
        return this.f;
    }

    public ESingleResponse getSingleResponse(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        boolean bl = q;
        List<ESingleResponse> list = this.singleResponses.get(aCertificateToQuery.getSerialNumber());
        if (list == null) {
            throw new ESYAException(r[67]);
        }
        for (ESingleResponse eSingleResponse : list) {
            ECertID eCertID = eSingleResponse.getCertID();
            if (OCSPClient.isEqual(eCertID, aCertificateToQuery, aIssuerCertificate)) {
                return eSingleResponse;
            }
            if (!bl) continue;
        }
        throw new ESYAException(r[66]);
    }

    public static boolean isEqual(ECertID certID, ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) {
        block5: {
            if (certID.getSerialNumber().equals(aCertificateToQuery.getSerialNumber())) {
                try {
                    byte[] byArray = aIssuerCertificate.getSubject().getEncoded();
                    byte[] byArray2 = aIssuerCertificate.getSubjectPublicKeyInfo().getSubjectPublicKey();
                    DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)certID.getHashAlgorithm());
                    byte[] byArray3 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray);
                    byte[] byArray4 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray2);
                    if (!Arrays.equals(certID.getIssuerNameHash(), byArray3) || !Arrays.equals(certID.getIssuerKeyHash(), byArray4)) break block5;
                    return true;
                }
                catch (CryptoException cryptoException) {
                    logger.warn(r[1], (Throwable)cryptoException);
                    return false;
                }
            }
        }
        return false;
    }

    public EBasicOCSPResponse getBasicResponse() {
        return this.mBasicResponse;
    }

    public EOCSPResponse getOCSPResponse() {
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkResponseStatus() {
        int n;
        this.f = n = this.mOCSPResponce.getResponseStatus();
        g.debug(r[24] + n);
        switch (n) {
            case 0: {
                g.debug(r[22]);
                return true;
            }
            case 1: {
                g.debug(r[21]);
                return false;
            }
            case 2: {
                g.debug(r[23]);
                return false;
            }
            case 3: {
                g.debug(r[18]);
                return false;
            }
            case 5: {
                g.debug(r[19]);
                return false;
            }
            case 6: {
                g.debug(r[20]);
                return false;
            }
        }
        return false;
    }

    public void checkResponse() throws ESYAException {
        this.a(this.mOCSPResponce);
    }

    private void a(EOCSPResponse eOCSPResponse) throws ESYAException {
        boolean bl;
        block17: {
            block18: {
                block15: {
                    block16: {
                        bl = q;
                        try {
                            this.mBasicResponse = eOCSPResponse.getBasicOCSPResponse();
                        }
                        catch (Exception exception) {
                            g.error(r[55], (Throwable)exception);
                            throw new ESYAException(r[54], (Throwable)exception);
                        }
                        if (!this.n) break block15;
                        if (this.checkNonce()) break block16;
                        this.mOCSPResponce = null;
                        this.l = 3;
                        g.error(r[60]);
                        throw new ESYAException(r[57]);
                    }
                    g.debug(r[58]);
                }
                if (!this.m) break block17;
                if (this.checkSignature()) break block18;
                this.mOCSPResponce = null;
                this.l = 1;
                g.error(r[59]);
                throw new ESYAException(r[56]);
            }
            g.debug(r[63]);
        }
        EResponseData eResponseData = this.mBasicResponse.getTbsResponseData();
        int n = eResponseData.getSingleResponseCount();
        for (int i = 0; i < n; ++i) {
            ESingleResponse eSingleResponse = eResponseData.getSingleResponse(i);
            if (this.p) {
                Calendar calendar = Calendar.getInstance();
                if (!this.checkDate(eSingleResponse, calendar)) {
                    g.error(r[61]);
                    throw new ESYAException(r[62]);
                }
            }
            this.singleResponses.put(eSingleResponse.getCertID().getSerialNumber(), eSingleResponse);
            if (!bl) continue;
        }
    }

    public boolean checkDate(ESingleResponse aResponse, Calendar aDate) {
        block7: {
            if (aDate.before(aResponse.getThisUpdate())) {
                g.warn(r[34]);
                return false;
            }
            if (aResponse.getNextUpdate() == null || !aDate.after(aResponse.getNextUpdate())) break block7;
            g.warn(r[33]);
            return false;
        }
        return true;
    }

    public byte[] getNonce() {
        return this.k;
    }

    public boolean checkNonce() {
        boolean bl = q;
        EExtensions eExtensions = this.mBasicResponse.getResponseExtensions();
        if (eExtensions == null) {
            g.error(r[26]);
            return false;
        }
        for (int i = 0; i < eExtensions.getExtensionCount(); ++i) {
            EExtension eExtension = eExtensions.getExtension(i);
            if (!eExtension.getIdentifier().equals((Asn1Type)NONCE_OID)) continue;
            byte[] byArray = eExtension.getValue();
            Asn1OctetString asn1OctetString = new Asn1OctetString();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(byArray);
            try {
                asn1OctetString.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            }
            catch (Exception exception) {
                g.error(r[27], (Throwable)exception);
                return false;
            }
            if (Arrays.equals(asn1OctetString.value, this.k)) {
                return true;
            }
            return false;
        }
        g.error(r[25]);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSignature() {
        boolean bl = q;
        byte[] byArray = null;
        byArray = this.mBasicResponse.getTbsResponseData().getEncoded();
        byte[] byArray2 = this.mBasicResponse.getSignature();
        if (this.mBasicResponse.getObject() == null || ((BasicOCSPResponse)this.mBasicResponse.getObject()).certs == null) {
            g.error(r[51]);
            return false;
        }
        for (int i = 0; i < this.mBasicResponse.getCertificateCount(); ++i) {
            ECertificate eCertificate = this.mBasicResponse.getCertificate(i);
            try {
                Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)this.mBasicResponse.getSignatureAlgorithm());
                PublicKey publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)eCertificate.getSubjectPublicKeyInfo());
                if (SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray2, (PublicKey)publicKey)) {
                    return true;
                }
                byte[] byArray3 = new byte[byArray2.length];
                int n = byArray2.length - 1;
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray3[j] = byArray2[n - j];
                    if (!bl) continue;
                }
                if (!SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray3, (PublicKey)publicKey)) continue;
                return true;
            }
            catch (CryptoException cryptoException) {
                g.error(r[53], (Throwable)cryptoException);
                return false;
            }
        }
        g.debug(r[52]);
        return false;
    }

    public ECertificate getSigningCertificate() throws ESYAException {
        if (this.mBasicResponse == null) {
            throw new ESYAException(r[2]);
        }
        if (this.signingCertificate != null) {
            return this.signingCertificate;
        }
        if (this.checkSignature()) {
            return this.signingCertificate;
        }
        return null;
    }

    public void setDigestAlgForOcspRequest(DigestAlg digestAlg) {
        digestAlgForOcspRequest = digestAlg;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[68];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "x)I";
        int n2 = 67;
        block80: while (true) {
            char[] cArray;
            block85: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block84: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block84;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block85;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 63;
                                break;
                            }
                            case 1: {
                                n8 = 108;
                                break;
                            }
                            case 2: {
                                n8 = 29;
                                break;
                            }
                            case 3: {
                                n8 = 65;
                                break;
                            }
                            default: {
                                n8 = 86;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                case 67: {
                    e = string.intern();
                    string2 = "|\u0003s53Q\u00180\u0015/O\t";
                    n2 = 68;
                    continue block80;
                }
                case 68: {
                    a = string.intern();
                    string2 = "^\u001cm-?\\\ri(9QCr\"%OAo$'J\tn5";
                    n2 = 69;
                    continue block80;
                }
                case 69: {
                    b = string.intern();
                    string2 = "j)V\u0000\u0013\u001f#^\u0012\u0006\u001f/q(3Q\u0018";
                    n2 = 70;
                    continue block80;
                }
                case 70: {
                    d = string.intern();
                    string2 = "j\u001fx3{~\u000bx/\"";
                    n2 = 71;
                    continue block80;
                }
                case 71: {
                    c = string.intern();
                    string2 = "s\u0005n 8LLv.8K\u001er-#\u001f\u000e|27M\u0005n(,\u0011L";
                    n2 = -1;
                    continue block80;
                }
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "h\ro/?Q\u000b=(8\u001f#^\u0012\u0006|\u0000t$8K";
                    n2 = 0;
                    continue block80;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "q\u0003=.5L\u001c=33L\u001cr/%Z";
                    n2 = 1;
                    continue block80;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "j\u001fx3{~\u000bx/\"";
                    n2 = 2;
                    continue block80;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "p/N\u0011vL\to73M\r=#7\u0120\u0000|/\u0167S\u015do*3QLu \"^Lr-#\u0160\u0018h{";
                    n2 = 3;
                    continue block80;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "x)I";
                    n2 = 4;
                    continue block80;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "|\u0003s53Q\u00180\u0015/O\t";
                    n2 = 5;
                    continue block80;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "p/N\u0011vL\to73M\r=#7\u0120\u0000|/\u0167S\rp 2\u010eV";
                    n2 = 6;
                    continue block80;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "j)V\u0000\u0013\u001f#^\u0012\u0006\u001f/q(3Q\u0018";
                    n2 = 7;
                    continue block80;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "^\u001cm-?\\\ri(9QCr\"%OAo$'J\tn5";
                    n2 = 8;
                    continue block80;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "l\to73M\r=#7\u0120\u0000|/\"\u010eLv4$J\u0000p ;\u010e\u01333";
                    n2 = 9;
                    continue block80;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "l\to5?Y\u0005v vL\u0003o&#S\rp 2^\u0002=\u00b78\\\t=23M\u001ax37\u001f\u000e|\u015e:^\u0002i\u0170vT\u0019o4:R\rq\u0170";
                    n2 = 10;
                    continue block80;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "p/N\u0011vO\u001er59T\u0003q4v]\r\u0142 $\u010e\u0015q vK\rp ;S\rs%\u0167";
                    n2 = 11;
                    continue block80;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "N\u0019x3/\u001f\u000f|/qKL\u007f$vX\ts$$^\u0018x%";
                    n2 = 12;
                    continue block80;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "p/N\u0011vV\u001fi$\u0149VLr-#\u0160\u0018h3#S\r~ =";
                    n2 = 13;
                    continue block80;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "t\u0003s5$P\u0000=$2V\u0000x\"3TLn$$K\u0005{(=^Ld.=";
                    n2 = 14;
                    continue block80;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "q\u0003=\"3M\u0018t'?\\\ri$vK\u0003=0#Z\u001ed";
                    n2 = 15;
                    continue block80;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "\u010f\u001fi$=\u001f\u0003q4\u0109K\u0019o4:^\u0001|%\u0167";
                    n2 = 16;
                    continue block80;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "|\tk &\u001f\u001fi \"J\u001f'a\"M\u0015Q \"Z\u001e";
                    n2 = 17;
                    continue block80;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "|\tk &\u001f\u001fi \"J\u001f'a%V\u000bO$'J\u0005o$2";
                    n2 = 18;
                    continue block80;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "|\tk &\u001f\u001fi \"J\u001f'a#Q\rh5>P\u001et;3[";
                    n2 = 19;
                    continue block80;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "|\tk &\u001f\u001fi \"J\u001f'a;^\u0000{.$R\ty\u00133N\u0019x2\"";
                    n2 = 20;
                    continue block80;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "|\tk &\u001f\u000e|\u011e7M\u015dq\u0170";
                    n2 = 21;
                    continue block80;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "|\tk &\u001f\u001fi \"J\u001f'a?Q\u0018x38^\u0000X3$P\u001e";
                    n2 = 22;
                    continue block80;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "x\tq$8\u001f\u000fx77OLn57K\u0019n{";
                    n2 = 23;
                    continue block80;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "p/N\u0011v\\\tk 4\u010eLt\u00a6?Q\bxa\u0018P\u0002~$vZ\u0014i$8L\u0005r/v]\u0019q48^\u0001|%\u0167";
                    n2 = 24;
                    continue block80;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "p/N\u0011v\\\tk 4\u010eLt\u00a6?Q\bxa3G\u0018x/%V\u0003sa4J\u0000h/7R\ry\u0170";
                    n2 = 25;
                    continue block80;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "p/N\u0011v\\\tk 4\u010eLt\u00a6?Q\bxa\u0018P\u0002~$vZ\u0014i$8L\u0005r/v[\t~.2ZLx%?S\tp$2V";
                    n2 = 26;
                    continue block80;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005s(v^\u0000t3=Z\u0002=)7K\r=.:J\u001fi4";
                    n2 = 27;
                    continue block80;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005s(v^\u0000t3=Z\u0002=)7K\r=.:J\u001fi4";
                    n2 = 28;
                    continue block80;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "p/N\u0011vR\tn <VL\u007f %^\u001et8:^Ly$5P\bxa3[\u0005q%?";
                    n2 = 29;
                    continue block80;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=%3\\\u0003y$vZ\bt-?M\u0007x/vW\ri vP\u0000h2\"J";
                    n2 = 30;
                    continue block80;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=%3\\\u0003y$vZ\bt-?M\u0007x/vW\ri vP\u0000h2\"J";
                    n2 = 31;
                    continue block80;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0002x9\"j\u001cy \"ZLy$\u0149Z\u001eta\u0109V\u0001y(=VLg ;^\u0002y 8\u001f\u009as\"3\u0011";
                    n2 = 32;
                    continue block80;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0018u(%j\u001cy \"ZLy$\u0149Z\u001eta\u0109V\u0001y(=VLg ;^\u0002y 8\u001f\u001fr/$^B";
                    n2 = 33;
                    continue block80;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "|\u0003s/3\\\u0018t.8\u001f\u0005na8P\u0018=23K";
                    n2 = 34;
                    continue block80;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "p/N\u0011vO\u001er59T\u0003q4v]\r\u0142 $\u010e\u0015q vK\rp ;S\rs%\u0167";
                    n2 = 35;
                    continue block80;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = "l\to73M\r=#7\u0120\u0000|/\"\u010eLv4$J\u0000p ;\u010e\u01333";
                    n2 = 36;
                    continue block80;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = "|\tk &\u001f\rq\u01708^\u000f|*";
                    n2 = 37;
                    continue block80;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = "|\tk &\u001f\rq\u01708[\u015d";
                    n2 = 38;
                    continue block80;
                }
                case 38: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 40;
                    string2 = "m\tn19Q\u000fxa%K\ri4%\u001f\u0005na8P\u0018=77S\u0005y";
                    n2 = 39;
                    continue block80;
                }
                case 39: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 41;
                    string2 = "\u010f\u001fi$=\u001f\u000b\u00eb/2Z\u001et-?M\u0007x/vW\ri vP\u0000h\u011e\"J";
                    n2 = 40;
                    continue block80;
                }
                case 40: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 42;
                    string2 = "p/N\u0011vL\to73M\b|/v\\\tk &\u001f\rq\u01708^\u0001|%\u0167";
                    n2 = 41;
                    continue block80;
                }
                case 41: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 43;
                    string2 = "|\tk &\u001f\u000e|\u011e7M\u015dq\u0170v[\t\u0102(:";
                    n2 = 42;
                    continue block80;
                }
                case 42: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 44;
                    string2 = "p/N\u0011vL\to73M\b|/v\\\tk &\u001f\rq\u01708\u010e\u001ev$8\u001f\u0004|57\u001f\u0003q4\u0109K\u0019";
                    n2 = 43;
                    continue block80;
                }
                case 43: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 45;
                    string2 = "\u010f\u001fi$=\u001f\u000b\u00eb/2Z\u001et-?M\u0007x/vW\ri vP\u0000h\u011e\"J";
                    n2 = 44;
                    continue block80;
                }
                case 44: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 46;
                    string2 = "p/N\u0011vV\u001fi$\u0149VL\u007f \u0109^\u001e\u012c8:^Lr-#\u0160\u0018h3#S\bh";
                    n2 = 45;
                    continue block80;
                }
                case 45: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 47;
                    string2 = "q\u0003s\"3\u001f\te53Q\u001ft.8\u001f\u0003q4\u0109K\u0019o4:^\u0001|%\u0167";
                    n2 = 46;
                    continue block80;
                }
                case 46: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 48;
                    string2 = "p/N\u0011vV\u001fi$=\u001f\u0001x27U\u0005=.:J\u001fi4$J\u0000h3=Z\u0002=)7K\r=.:J\u001fi4";
                    n2 = 47;
                    continue block80;
                }
                case 47: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 49;
                    string2 = "N\u0019x3/\u001f\u000f|/qKL\u007f$vX\ts$$^\u0018x%";
                    n2 = 48;
                    continue block80;
                }
                case 48: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 50;
                    string2 = "q\u0003s\"3\u001f\te53Q\u001ft.8\u001f\u000f|/qKL\u007f$vX\ts$$^\u0018x%";
                    n2 = 49;
                    continue block80;
                }
                case 49: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 51;
                    string2 = "v\u0001g :^\u0015t\"?\u001f\u001fx3\"V\nt*7\u001f\u000eh-#Q\rp 2V";
                    n2 = 50;
                    continue block80;
                }
                case 50: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 52;
                    string2 = "v\u0001g v[\t\u0102$$VLU(\u00b1]\u0005oa\u0005Z\u001ei(0V\u0007|a?\u00d8\u0005sa2P\u000bo4:^\u0002|,7[\u015d'";
                    n2 = 51;
                    continue block80;
                }
                case 51: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 53;
                    string2 = "v\u0001g v[\u0003\u01023#S\rs\u0170$T\tsa>^\u0018|a9S\u0019\u01425#";
                    n2 = 52;
                    continue block80;
                }
                case 52: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 54;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=%3\\\u0003y$vZ\bt-?M\u0007x/vW\ri vP\u0000h2\"J";
                    n2 = 53;
                    continue block80;
                }
                case 53: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 55;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=%3\\\u0003y$vZ\bt-?M\u0007x/vW\ri vP\u0000h2\"J";
                    n2 = 54;
                    continue block80;
                }
                case 54: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 56;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=(;E\r=*9Q\u0018o.:\u00c3L\u007f \u0109^\u001e\u012c2\u0167E";
                    n2 = 55;
                    continue block80;
                }
                case 55: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 57;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=/9Q\u000fxa=P\u0002i39S\u0090=#7\u0160\ro\u0170%\u010e\u0016";
                    n2 = 56;
                    continue block80;
                }
                case 56: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 58;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=/9Q\u000fxa=P\u0002i39S\u0090=#7\u0160\ro\u0170:\u010e";
                    n2 = 57;
                    continue block80;
                }
                case 57: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 59;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=(;E\r=*9Q\u0018o.:\u00c3L\u007f \u0109^\u001e\u012c2\u0167E";
                    n2 = 58;
                    continue block80;
                }
                case 58: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 60;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=/9Q\u000fxa=P\u0002i39S\u0090=#7\u0160\ro\u0170%\u010e\u0016";
                    n2 = 59;
                    continue block80;
                }
                case 59: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 61;
                    string2 = "p/N\u0011v\\\tk &\u001f\u000bx\u00a63M\u0000t-?TLi $V\u0004q$$VLv.8K\u001er-\u00aa\u001f\u0004|57S\u015d";
                    n2 = 60;
                    continue block80;
                }
                case 60: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 62;
                    string2 = "p/N\u0011v\\\tk &\u001f\u000bx\u00a63M\u0000t-?TLi $V\u0004q$$VLv.8K\u001er-\u00aa\u001f\u0004|57S\u015d";
                    n2 = 61;
                    continue block80;
                }
                case 61: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 63;
                    string2 = "p/N\u0011v\\\tk &\u001f\u0001x27U\u0005=(;E\r=*9Q\u0018o.:\u00c3L\u007f \u0109^\u001e\u012c-\u0167";
                    n2 = 62;
                    continue block80;
                }
                case 62: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 64;
                    string2 = "l$\\p\u0006m\"Z";
                    n2 = 63;
                    continue block80;
                }
                case 63: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 65;
                    string2 = "\u010f\u001fi$=\u001f\u0003q4\u0109K\u0019o4:^\u0001|%\u0167";
                    n2 = 64;
                    continue block80;
                }
                case 64: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 66;
                    string2 = "p/N\u0011vM\tn19Q\u001fxa2P\tna8P\u0018=\"9Q\u0018|(8\u001f\u001ex0#L\u0018x%v\\\to5?Y\u0005~ \"ZLo$%O\u0003s23";
                    n2 = 65;
                    continue block80;
                }
                case 65: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 67;
                    string2 = "p/N\u0011vM\tn19Q\u001fxa2P\tna8P\u0018=\"9Q\u0018|(8\u001f\u001ex0#L\u0018x%v\\\to5?Y\u0005~ \"ZLo$%O\u0003s23";
                    n2 = 66;
                    continue block80;
                }
                case 66: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        r = stringArray3;
        logger = LoggerFactory.getLogger(OCSPClient.class);
        NONCE_OID = new Asn1ObjectIdentifier(_ocspValues.id_pkix_ocsp_nonce);
        g = LoggerFactory.getLogger(OCSPClient.class);
        digestAlgForOcspRequest = DigestAlg.SHA256;
    }
}

