/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;

public abstract class CardTemplate
implements ICardTemplate {
    protected MessageDigest OZET_ALICI;
    protected CardType cardType;
    protected IPKCS11Ops mIslem;
    private Logger a = LoggerFactory.getLogger(CardTemplate.class);
    public static boolean b;
    private static final String[] c;

    public CardTemplate(CardType aCardType) {
        this.cardType = aCardType;
        try {
            this.OZET_ALICI = MessageDigest.getInstance(c[6]);
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(c[7] + lE.getMessage(), (Throwable)lE);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.a.warn(c[8], (Throwable)noSuchAlgorithmException);
            throw new ESYARuntimeException((Throwable)noSuchAlgorithmException);
        }
    }

    @Override
    public CardType getCardType() {
        return this.cardType;
    }

    @Override
    public List<List<CK_ATTRIBUTE>> getCertSerialNumberTemplates(byte[] aSerialNumber) {
        boolean bl = b;
        ArrayList<List<CK_ATTRIBUTE>> arrayList = new ArrayList<List<CK_ATTRIBUTE>>();
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE(0L, 1L);
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE(1L, true);
        ArrayList<CK_ATTRIBUTE> arrayList2 = new ArrayList<CK_ATTRIBUTE>();
        arrayList2.add(cK_ATTRIBUTE);
        arrayList2.add(new CK_ATTRIBUTE(130L, aSerialNumber));
        arrayList2.add(cK_ATTRIBUTE2);
        arrayList.add(arrayList2);
        String string = new BigInteger(aSerialNumber).toString(16);
        for (int i = 0; i < aSerialNumber.length * 2 - string.length(); ++i) {
            string = '0' + string;
            if (!bl) continue;
            boolean bl2 = !SmartCardException.b;
            SmartCardException.b = bl2;
            break;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes(c[3]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.a.warn(c[4], (Throwable)unsupportedEncodingException);
            throw new ESYARuntimeException((Throwable)unsupportedEncodingException);
        }
        byte[] byArray2 = new byte[byArray.length + 4];
        byArray2[0] = 2;
        byArray2[1] = (byte)(byArray.length + 2);
        byArray2[2] = 48;
        byArray2[3] = 120;
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        ArrayList<CK_ATTRIBUTE> arrayList3 = new ArrayList<CK_ATTRIBUTE>();
        arrayList3.add(cK_ATTRIBUTE);
        arrayList3.add(new CK_ATTRIBUTE(130L, byArray2));
        arrayList3.add(cK_ATTRIBUTE2);
        arrayList.add(arrayList3);
        String string2 = new BigInteger(aSerialNumber).toString(16);
        for (int i = 0; i <= aSerialNumber.length * 2 - string2.length(); ++i) {
            string2 = '0' + string2;
            if (!bl) continue;
        }
        byte[] byArray3 = null;
        try {
            byArray3 = string2.getBytes(c[5]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.a.warn(c[2], (Throwable)unsupportedEncodingException);
            throw new ESYARuntimeException((Throwable)unsupportedEncodingException);
        }
        byte[] byArray4 = new byte[byArray3.length + 4];
        byArray4[0] = 2;
        byArray4[1] = (byte)(byArray3.length + 2);
        byArray4[2] = 48;
        byArray4[3] = 120;
        System.arraycopy(byArray3, 0, byArray4, 4, byArray3.length);
        ArrayList<CK_ATTRIBUTE> arrayList4 = new ArrayList<CK_ATTRIBUTE>();
        arrayList4.add(cK_ATTRIBUTE);
        arrayList4.add(new CK_ATTRIBUTE(130L, byArray4));
        arrayList4.add(cK_ATTRIBUTE2);
        arrayList.add(arrayList4);
        byte[] byArray5 = new byte[aSerialNumber.length + 2];
        byArray5[0] = 2;
        byArray5[1] = (byte)aSerialNumber.length;
        System.arraycopy(aSerialNumber, 0, byArray5, 2, aSerialNumber.length);
        ArrayList<CK_ATTRIBUTE> arrayList5 = new ArrayList<CK_ATTRIBUTE>();
        arrayList5.add(cK_ATTRIBUTE);
        arrayList5.add(new CK_ATTRIBUTE(130L, byArray5));
        arrayList5.add(cK_ATTRIBUTE2);
        arrayList.add(arrayList5);
        return arrayList;
    }

    @Override
    @Deprecated
    public List<CK_ATTRIBUTE> getRSAPrivateKeyCreateTemplate(String aKeyLabel, boolean aIsSign, boolean aIsEncrypt) {
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(0L, 3L));
        arrayList.add(new CK_ATTRIBUTE(256L, 0L));
        arrayList.add(new CK_ATTRIBUTE(3L, aKeyLabel));
        arrayList.add(new CK_ATTRIBUTE(2L, true));
        arrayList.add(new CK_ATTRIBUTE(261L, aIsEncrypt));
        arrayList.add(new CK_ATTRIBUTE(264L, aIsSign));
        return arrayList;
    }

    @Override
    @Deprecated
    public List<CK_ATTRIBUTE> getRSAPublicKeyCreateTemplate(String aKeyLabel, int aModulusBits, BigInteger aPublicExponent, boolean aIsSign, boolean aIsEncrypt) {
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(256L, 0L));
        arrayList.add(new CK_ATTRIBUTE(3L, aKeyLabel));
        arrayList.add(new CK_ATTRIBUTE(2L, false));
        arrayList.add(new CK_ATTRIBUTE(290L, aPublicExponent.toByteArray()));
        arrayList.add(new CK_ATTRIBUTE(260L, aIsEncrypt));
        arrayList.add(new CK_ATTRIBUTE(266L, aIsSign));
        arrayList.add(new CK_ATTRIBUTE(289L, aModulusBits));
        return arrayList;
    }

    @Override
    @Deprecated
    public List<CK_ATTRIBUTE> getRSAPrivateKeyImportTemplate(String aLabel, RSAPrivateCrtKey aPrivKey, X509Certificate aSertifika, boolean aIsSign, boolean aIsEncrypt) {
        ArrayList<CK_ATTRIBUTE> arrayList;
        block5: {
            boolean bl;
            block7: {
                block6: {
                    boolean bl2 = b;
                    ArrayList<CK_ATTRIBUTE> arrayList2 = new ArrayList<CK_ATTRIBUTE>();
                    byte[] byArray = CardTemplate.toByteArray(aPrivKey.getModulus());
                    byte[] byArray2 = CardTemplate.toByteArray(aPrivKey.getPublicExponent());
                    byte[] byArray3 = CardTemplate.toByteArray(aPrivKey.getPrivateExponent());
                    byte[] byArray4 = CardTemplate.toByteArray(aPrivKey.getPrimeP());
                    byte[] byArray5 = CardTemplate.toByteArray(aPrivKey.getPrimeQ());
                    byte[] byArray6 = CardTemplate.toByteArray(aPrivKey.getPrimeExponentP());
                    byte[] byArray7 = CardTemplate.toByteArray(aPrivKey.getPrimeExponentQ());
                    byte[] byArray8 = CardTemplate.toByteArray(aPrivKey.getCrtCoefficient());
                    this.OZET_ALICI.update(byArray);
                    byte[] byArray9 = this.OZET_ALICI.digest();
                    arrayList2.add(new CK_ATTRIBUTE(0L, 3L));
                    arrayList2.add(new CK_ATTRIBUTE(256L, 0L));
                    arrayList2.add(new CK_ATTRIBUTE(1L, true));
                    arrayList2.add(new CK_ATTRIBUTE(2L, true));
                    arrayList2.add(new CK_ATTRIBUTE(259L, true));
                    arrayList2.add(new CK_ATTRIBUTE(288L, byArray));
                    arrayList2.add(new CK_ATTRIBUTE(290L, byArray2));
                    arrayList2.add(new CK_ATTRIBUTE(291L, byArray3));
                    arrayList2.add(new CK_ATTRIBUTE(292L, byArray4));
                    arrayList2.add(new CK_ATTRIBUTE(293L, byArray5));
                    arrayList2.add(new CK_ATTRIBUTE(294L, byArray6));
                    arrayList2.add(new CK_ATTRIBUTE(295L, byArray7));
                    arrayList2.add(new CK_ATTRIBUTE(296L, byArray8));
                    arrayList2.add(new CK_ATTRIBUTE(258L, byArray9));
                    arrayList2.add(new CK_ATTRIBUTE(3L, aLabel));
                    arrayList2.add(new CK_ATTRIBUTE(264L, aIsSign));
                    arrayList2.add(new CK_ATTRIBUTE(261L, aIsEncrypt));
                    if (aSertifika != null) {
                        byte[] byArray10 = aSertifika.getSubjectX500Principal().getEncoded();
                        arrayList2.add(new CK_ATTRIBUTE(257L, byArray10));
                    }
                    arrayList = arrayList2;
                    if (!SmartCardException.b) break block5;
                    if (!bl2) break block6;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            b = bl;
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public List<CK_ATTRIBUTE> getRSAPublicKeyImportTemplate(String aLabel, RSAPrivateCrtKey aPrivKey, X509Certificate aSertifika, boolean aIsSign, boolean aIsEncrypt) {
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        byte[] byArray = CardTemplate.toByteArray(aPrivKey.getModulus());
        byte[] byArray2 = CardTemplate.toByteArray(aPrivKey.getPublicExponent());
        this.OZET_ALICI.update(byArray);
        byte[] byArray3 = this.OZET_ALICI.digest();
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(256L, 0L));
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(2L, false));
        arrayList.add(new CK_ATTRIBUTE(3L, aLabel));
        arrayList.add(new CK_ATTRIBUTE(288L, byArray));
        arrayList.add(new CK_ATTRIBUTE(290L, byArray2));
        arrayList.add(new CK_ATTRIBUTE(258L, byArray3));
        arrayList.add(new CK_ATTRIBUTE(266L, aIsSign));
        arrayList.add(new CK_ATTRIBUTE(260L, aIsEncrypt));
        return arrayList;
    }

    @Override
    @Deprecated
    public List<CK_ATTRIBUTE> getSecretKeyCreateTemplate(SecretKey aKey) {
        return aKey.getCreationTemplate();
    }

    @Override
    @Deprecated
    public List<CK_ATTRIBUTE> getSecretKeyImportTemplate(SecretKey aKey) {
        return aKey.getImportTemplate();
    }

    @Override
    public void applyTemplate(KeyPairTemplate template) throws SmartCardException {
    }

    @Override
    public void applyTemplate(SecretKeyTemplate template) throws SmartCardException {
    }

    @Override
    public List<CK_ATTRIBUTE> getCertificateTemplate(String aLabel, X509Certificate aCert) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        ArrayList<CK_ATTRIBUTE> arrayList;
        block7: {
            PublicKey publicKey;
            block6: {
                Object object;
                arrayList = new ArrayList<CK_ATTRIBUTE>();
                byArray4 = aCert.getSerialNumber().toByteArray();
                byArray3 = aCert.getIssuerX500Principal().getEncoded();
                byArray2 = aCert.getSubjectX500Principal().getEncoded();
                publicKey = aCert.getPublicKey();
                byArray = null;
                if (publicKey.getAlgorithm().contains(Algorithms.ASYM_ALGO_RSA)) {
                    object = CardTemplate.toByteArray(((RSAPublicKey)publicKey).getModulus());
                    this.OZET_ALICI.update((byte[])object);
                    byArray = this.OZET_ALICI.digest();
                } else {
                    if (!publicKey.getAlgorithm().contains(Algorithms.ASYM_ALGO_EC) && !publicKey.getAlgorithm().contains(Algorithms.ASYM_ALGO_ECDSA)) break block6;
                    object = (ECPublicKey)aCert.getPublicKey();
                    ECPoint eCPoint = object.getW();
                    byte[] byArray5 = ECParameters.encodePoint(eCPoint, object.getParams().getCurve());
                    byArray = this.OZET_ALICI.digest(byArray5);
                }
                break block7;
            }
            this.OZET_ALICI.update(publicKey.getEncoded());
            byArray = this.OZET_ALICI.digest();
        }
        arrayList.add(new CK_ATTRIBUTE(0L, 1L));
        arrayList.add(new CK_ATTRIBUTE(128L, 0L));
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(3L, aLabel));
        arrayList.add(new CK_ATTRIBUTE(2L, false));
        arrayList.add(new CK_ATTRIBUTE(129L, byArray3));
        arrayList.add(new CK_ATTRIBUTE(130L, byArray4));
        try {
            arrayList.add(new CK_ATTRIBUTE(17L, aCert.getEncoded()));
        }
        catch (Exception exception) {
            this.a.warn(c[9], (Throwable)exception);
        }
        arrayList.add(new CK_ATTRIBUTE(258L, byArray));
        arrayList.add(new CK_ATTRIBUTE(257L, byArray2));
        arrayList.add(new CK_ATTRIBUTE(368L, true));
        return arrayList;
    }

    public static byte[] toByteArray(BigInteger aX) {
        byte[] byArray = aX.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    @Override
    public byte[] getPointValue(byte[] aDerEncodedPoint) throws IOException {
        DerValue derValue = null;
        try {
            derValue = new DerValue(aDerEncodedPoint);
        }
        catch (Exception exception) {
            this.a.debug(c[0], (Throwable)exception);
            try {
                derValue = new DerValue(4, aDerEncodedPoint);
            }
            catch (Exception exception2) {
                this.a.warn(c[1], (Throwable)exception2);
            }
        }
        if (derValue != null) {
            return derValue.getDataBytes();
        }
        return aDerEncodedPoint;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0006\u0013m<>b\u001fai\u001a#\u0004k\u001d</\u0006c(-'";
        int n2 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block21;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 66;
                                break;
                            }
                            case 1: {
                                n8 = 118;
                                break;
                            }
                            case 2: {
                                n8 = 15;
                                break;
                            }
                            case 3: {
                                n8 = 73;
                                break;
                            }
                            default: {
                                n8 = 89;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u0015\u0017}'0,\u0011/ 7b5n;=\u0016\u0013b95#\u0002j";
                    n2 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0015\u0017}'0,\u0011/ 7b5n;=\u0016\u0013b95#\u0002j";
                    n2 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0003%L\u0000\u0010";
                    n2 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u0015\u0017}'0,\u0011/ 7b5n;=\u0016\u0013b95#\u0002j";
                    n2 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0003%L\u0000\u0010";
                    n2 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0011>Ndh";
                    n2 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u000e\u001f|(71Vd&76\u0004`%,b\u0014n:80\u001f| #lV";
                    n2 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0015\u0017}'0,\u0011/ 7b5n;=\u0016\u0013b95#\u0002j";
                    n2 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u0015\u0017}'0,\u0011/ 7b5n;=\u0016\u0013b95#\u0002j";
                    n2 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
    }
}

