/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.ATR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.util.DerOutputStream;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.AkisOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardTemplate;

public class AkisTemplate
extends CardTemplate {
    protected static Logger logger;
    public static List<String> ATR_HASHES;
    public static List<String> HISTORICAL_BYTE_REGEXES;
    private static final String[] c;

    public AkisTemplate(CardType aCardType) {
        super(aCardType);
    }

    @Override
    public IPKCS11Ops getPKCS11Ops() {
        if (this.mIslem == null) {
            this.mIslem = new AkisOps(this.cardType);
        }
        return this.mIslem;
    }

    public static boolean isAkisATR(String atrHex) {
        boolean bl = CardTemplate.b;
        String string = c[0];
        String string2 = c[1];
        if (atrHex.contains(string) || atrHex.contains(string2)) {
            return true;
        }
        ATR aTR = new ATR(StringUtil.toByteArray((String)atrHex));
        byte[] byArray = aTR.getHistoricalBytes();
        String string3 = StringUtil.toHexString((byte[])byArray);
        for (String string4 : HISTORICAL_BYTE_REGEXES) {
            boolean bl2 = string3.matches(string4);
            if (bl2) {
                return true;
            }
            if (!bl) continue;
        }
        return false;
    }

    @Override
    public List<List<CK_ATTRIBUTE>> getCertSerialNumberTemplates(byte[] aSerialNumber) {
        boolean bl = CardTemplate.b;
        List<List<CK_ATTRIBUTE>> list = super.getCertSerialNumberTemplates(aSerialNumber);
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE(0L, 1L);
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE(2L, false);
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE(1L, true);
        BigInteger bigInteger = new BigInteger(1, aSerialNumber);
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(cK_ATTRIBUTE);
        arrayList.add(cK_ATTRIBUTE2);
        arrayList.add(new CK_ATTRIBUTE(130L, bigInteger.toString(16)));
        arrayList.add(cK_ATTRIBUTE3);
        ArrayList<CK_ATTRIBUTE> arrayList2 = new ArrayList<CK_ATTRIBUTE>();
        arrayList2.add(cK_ATTRIBUTE);
        arrayList2.add(cK_ATTRIBUTE2);
        arrayList2.add(new CK_ATTRIBUTE(130L, aSerialNumber.toString()));
        arrayList2.add(cK_ATTRIBUTE3);
        String string = new BigInteger(aSerialNumber).toString(16);
        CharsetEncoder charsetEncoder = Charset.forName(c[4]).newEncoder();
        ByteBuffer byteBuffer = null;
        for (int i = 0; i <= aSerialNumber.length * 2 - string.length(); ++i) {
            string = '0' + string;
            if (!bl) continue;
        }
        try {
            byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string.toCharArray()));
        }
        catch (CharacterCodingException characterCodingException) {
            logger.warn(c[2], (Throwable)characterCodingException);
        }
        ArrayList<CK_ATTRIBUTE> arrayList3 = new ArrayList<CK_ATTRIBUTE>();
        arrayList3.add(cK_ATTRIBUTE);
        arrayList3.add(cK_ATTRIBUTE2);
        arrayList3.add(new CK_ATTRIBUTE(130L, byteBuffer.array()));
        arrayList3.add(cK_ATTRIBUTE3);
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putInteger(new BigInteger(aSerialNumber));
        }
        catch (Exception exception) {
            logger.warn(c[3], (Throwable)exception);
        }
        byte[] byArray = derOutputStream.toByteArray();
        ArrayList<CK_ATTRIBUTE> arrayList4 = new ArrayList<CK_ATTRIBUTE>();
        arrayList4.add(cK_ATTRIBUTE);
        arrayList4.add(cK_ATTRIBUTE2);
        arrayList4.add(new CK_ATTRIBUTE(130L, byArray));
        arrayList4.add(cK_ATTRIBUTE3);
        list.add(arrayList);
        list.add(arrayList2);
        list.add(arrayList3);
        list.add(arrayList4);
        return list;
    }

    @Override
    public List<CK_ATTRIBUTE> getRSAPublicKeyImportTemplate(String aLabel, RSAPrivateCrtKey aPrivKey, X509Certificate aCert, boolean aIsSign, boolean aIsEncrypt) {
        byte[] byArray = AkisTemplate.toByteArray(aPrivKey.getModulus());
        List<CK_ATTRIBUTE> list = super.getRSAPublicKeyImportTemplate(aLabel, aPrivKey, aCert, aIsSign, aIsEncrypt);
        list.add(new CK_ATTRIBUTE(289L, byArray.length * 8));
        return list;
    }

    @Override
    public void applyTemplate(KeyPairTemplate template) throws SmartCardException {
        if (template instanceof ECKeyPairTemplate) {
            ((ECKeyTemplate)template.getPublicKeyTemplate()).getAsExplicitECParameters();
        }
    }

    @Override
    public String[] getATRHashes() {
        return ATR_HASHES.toArray(new String[0]);
    }

    public static void addATR(String aATR) {
        ATR_HASHES.add(aATR);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string3 = "\u0019u+\u00019nt.\u00008";
        int n3 = -1;
        block50: while (true) {
            char[] cArray;
            block59: {
                int n4;
                int n5;
                char[] cArray2;
                block58: {
                    char[] cArray3 = string3.toCharArray();
                    n = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n6;
                    if (n6 <= 1) break block58;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n) break block59;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n % 5) {
                            case 0: {
                                n8 = 44;
                                break;
                            }
                            case 1: {
                                n8 = 64;
                                break;
                            }
                            case 2: {
                                n8 = 31;
                                break;
                            }
                            case 3: {
                                n8 = 52;
                                break;
                            }
                            default: {
                                n8 = 13;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n7 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n);
            }
            string2 = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string3 = "\u001bu)\u0001;nv.\u00028";
                    n3 = 0;
                    continue block50;
                }
                case 0: {
                    stringArray2[n2] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string3 = "{!mZdB'?]c\f\u0001t]~x%rDaM4z";
                    n3 = 1;
                    continue block50;
                }
                case 1: {
                    stringArray2[n2] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string3 = "{!mZdB'?]c\f\u0001t]~x%rDaM4z";
                    n3 = 2;
                    continue block50;
                }
                case 2: {
                    stringArray2[n2] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string3 = "e\u0013P\u00195\u0014u&\u0019<";
                    n3 = 3;
                    continue block50;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string2.intern();
        c = stringArray3;
        logger = LoggerFactory.getLogger(AkisTemplate.class);
        ATR_HASHES = new ArrayList<String>();
        HISTORICAL_BYTE_REGEXES = new ArrayList<String>();
        List<String> list = ATR_HASHES;
        String string4 = "\u001f\u0002]u<\u001dp/\f<\u001fqYq9hu*\u00008\u0018\u0002+\u00059\u0019r/\u0001;\u001fq-q>\u001c\u0001Z";
        int n9 = -1;
        block53: while (true) {
            char[] cArray;
            block61: {
                int n10;
                int n11;
                char[] cArray6;
                block60: {
                    char[] cArray7 = string4.toCharArray();
                    n = 0;
                    int n12 = cArray7.length;
                    cArray6 = cArray7;
                    n11 = n12;
                    if (n12 <= 1) break block60;
                    cArray = cArray6;
                    n10 = n11;
                    if (n11 <= n) break block61;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n13 = n;
                    while (true) {
                        int n14;
                        char c = cArray8[n13];
                        switch (n % 5) {
                            case 0: {
                                n14 = 44;
                                break;
                            }
                            case 1: {
                                n14 = 64;
                                break;
                            }
                            case 2: {
                                n14 = 31;
                                break;
                            }
                            case 3: {
                                n14 = 52;
                                break;
                            }
                            default: {
                                n14 = 13;
                            }
                        }
                        cArray8[n13] = (char)(c ^ n14);
                        ++n;
                        cArray6 = cArray9;
                        n11 = n11;
                        if (n11 != 0) break;
                        cArray9 = cArray6;
                        n10 = n11;
                        n13 = n11;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n10 = n11;
                } while (n11 > n);
            }
            string = new String(cArray).intern();
            switch (n9) {
                default: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005<\u001dr,\u00055\u001cw,v>mq'\u0004H\u0015";
                    n9 = 0;
                    continue block53;
                }
                case 0: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001dr,\u00055\u001cw,v>mq'\u0004Hm";
                    n9 = 1;
                    continue block53;
                }
                case 1: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001ds,\u00055\u001cw,v>mq'\u0004Hn";
                    n9 = 2;
                    continue block53;
                }
                case 2: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u0019r,\u00055\u001cw,v>mq'\u0004Lm";
                    n9 = 3;
                    continue block53;
                }
                case 3: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u0019s,\u00055\u001cw,v>mq'\u0004Ln";
                    n9 = 4;
                    continue block53;
                }
                case 4: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r<\u0019x.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001eq,\u00055\u001cw,v>mq'\u00048m";
                    n9 = 5;
                    continue block53;
                }
                case 5: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001eq,\u00055\u001cw,v>mq'\u0004I\u0015";
                    n9 = 6;
                    continue block53;
                }
                case 6: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r<\u001fx.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001eq,\u00055\u001cw,v>mq'\u00048o";
                    n9 = 7;
                    continue block53;
                }
                case 7: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r<\u001fx.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001aq,\u00055\u001cw,v>mq'\u0004<o";
                    n9 = 8;
                    continue block53;
                }
                case 8: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r<\u0019x.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001aq,\u00055\u001cw,v>mq'\u0004<m";
                    n9 = 9;
                    continue block53;
                }
                case 9: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u001aq,\u00055\u001cw,v>mq'\u00044\u0015";
                    n9 = 10;
                    continue block53;
                }
                case 10: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s-\u0004?\u001cq-\u0007<op(\u0007K\u001ar.\f=\u0014q/\u0001O\u001f";
                    n9 = 11;
                    continue block53;
                }
                case 11: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u0015r,\u00055\u001cw,v>mq'\u0004;m";
                    n9 = 12;
                    continue block53;
                }
                case 12: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?\u0015s,\u00055\u001cw,v>mq'\u0004;n";
                    n9 = 13;
                    continue block53;
                }
                case 13: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005>\u001dr,\u00055\u001cw,v>mq'\u0004Hn";
                    n9 = 14;
                    continue block53;
                }
                case 14: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?mt,\u00055\u001cw,v>mq'\u00048o";
                    n9 = 15;
                    continue block53;
                }
                case 15: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv(\u00018\u0018u+v9\u001dt*\u0005?mu,\u00055\u001cw,v>mq'\u00048h";
                    n9 = 16;
                    continue block53;
                }
                case 16: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s.\u0006?\u001dp/\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00014\u001f";
                    n9 = 17;
                    continue block53;
                }
                case 17: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s.\u0006?\u001dp(\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00014\u0018";
                    n9 = 18;
                    continue block53;
                }
                case 18: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s.\u0006?\u001dp(\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00014\u0019";
                    n9 = 19;
                    continue block53;
                }
                case 19: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s[\u0006?\u001dp'\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00058j";
                    n9 = 20;
                    continue block53;
                }
                case 20: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s.\u0006?\u001dp'\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00054j";
                    n9 = 21;
                    continue block53;
                }
                case 21: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s[\u0006?\u001dp'\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00018n";
                    n9 = 22;
                    continue block53;
                }
                case 22: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018sZ\u0000?\u001dp'\u0007<op(\u0007K\u001ar.\f=\u0014q/\u0001;h";
                    n9 = 23;
                    continue block53;
                }
                case 23: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s[\u0007?\u001dp'\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00018n";
                    n9 = 24;
                    continue block53;
                }
                case 24: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001ax.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s[\u0006?\u001dp'\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00018m";
                    n9 = 25;
                    continue block53;
                }
                case 25: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s.\u0006?\u001dp'\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00014n";
                    n9 = 26;
                    continue block53;
                }
                case 26: {
                    list.add(string);
                    list = ATR_HASHES;
                    string4 = "\u001f\u0002&r4\u001bx.\u0007<j\u0005+\u00015\u001cv*\u00019\u0018s*\u0007?\u001ex-\u0007<op(\u0007K\u001ar.\f=\u0014q/\u00018\u001f";
                    n9 = 27;
                    continue block53;
                }
                case 27: {
                    list.add(string);
                    list = HISTORICAL_BYTE_REGEXES;
                    string4 = "\u0014p)\u00038\u0019t*\u0000O\u0018q+\u0001#\u0002n1\u0007<\u0014p(\u0007O\u001f\u0001.\f=";
                    n9 = 28;
                    continue block53;
                }
                case 28: {
                    list.add(string);
                    list = HISTORICAL_BYTE_REGEXES;
                    string4 = "\u0014p)\u00018\u0018t,\u001a#\u0002n1\u001a>\u001d\u0003/\u0003>jv-\u00055\u001cx.\u001a#";
                    n9 = 29;
                    continue block53;
                }
                case 29: 
            }
            break;
        }
        list.add(string);
    }
}

