/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.NamedCurve;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.ATIKHSMOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.AkisOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.DirakHSMOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.ESYAPKCS11;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PKCS11Ops
implements IPKCS11Ops {
    private Logger a = LoggerFactory.getLogger(PKCS11Ops.class);
    private static List<String> b;
    protected PKCS11 mPKCS11;
    private CardType c;
    protected MessageDigest OZET_ALICI;
    protected ESYAPKCS11 mESYAPKCS11 = null;
    protected static String JAVA_VERSION;
    public static int d;
    private static final String[] e;

    public PKCS11Ops(CardType aKartTip) {
        try {
            this.OZET_ALICI = MessageDigest.getInstance(e[49]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.a.warn(e[50], (Throwable)noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        this.c = aKartTip;
    }

    @Override
    public void initialize() throws PKCS11Exception, IOException {
        block7: {
            try {
                Method method;
                CK_C_INITIALIZE_ARGS cK_C_INITIALIZE_ARGS = this.a();
                String string = this.a(this.c.getLibName());
                Class<?> clazz = Class.forName(e[20]);
                if (JAVA_VERSION.equals(e[21])) {
                    method = clazz.getMethod(e[23], String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
                    this.mPKCS11 = (PKCS11)method.invoke(null, string, cK_C_INITIALIZE_ARGS, false);
                    if (d == 0) break block7;
                }
                method = clazz.getMethod(e[22], String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
                this.mPKCS11 = (PKCS11)method.invoke(null, string, e[24], cK_C_INITIALIZE_ARGS, false);
            }
            catch (Exception exception) {
                if (!(exception instanceof PKCS11Exception)) {
                    throw new IOException(e[19] + exception.getCause().getMessage());
                }
            }
        }
    }

    CK_C_INITIALIZE_ARGS a() {
        return null;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(true);
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        int n = d;
        long[] lArray = this.getTokenPresentSlotList();
        ArrayList<Pair<Long, String>> arrayList = new ArrayList<Pair<Long, String>>();
        for (long l : lArray) {
            String string = "";
            try {
                string = string + " " + new String(this.getSlotInfo((long)l).slotDescription).trim();
            }
            catch (Exception exception) {
                this.a.info(e[78] + exception.getMessage(), (Throwable)exception);
            }
            try {
                string = string + " " + new String(this.getTokenInfo((long)l).label).trim().split("\u0000")[0];
            }
            catch (Exception exception) {
                this.a.info(e[77] + exception.getMessage(), (Throwable)exception);
            }
            arrayList.add((Pair<Long, String>)new Pair((Object)l, (Object)string));
            if (n == 0) continue;
        }
        return arrayList;
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(false);
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        CK_SLOT_INFO cK_SLOT_INFO = this.mPKCS11.C_GetSlotInfo(aSlotID);
        long l = cK_SLOT_INFO.flags;
        if ((l & 1L) != 0L) {
            return true;
        }
        return false;
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetMechanismList(aSlotID);
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_OpenSession(aSlotID, 6L, null, null);
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_CloseSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mPKCS11.C_Login(aSessionID, 1L, aCardPIN.toCharArray());
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_Logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            return false;
        }
        return true;
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aSertifika);
        this.mPKCS11.C_CreateObject(aSessionID, list.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAKeyGenParameterSpec rSAKeyGenParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM;
        block8: {
            block7: {
                cK_MECHANISM = new CK_MECHANISM(0L);
                cK_MECHANISM.mechanism = 10L;
                cK_MECHANISM.pParameter = null;
                if (this instanceof AkisOps || this instanceof ATIKHSMOps) break block7;
                if (!(this instanceof DirakHSMOps)) break block8;
            }
            cK_MECHANISM.mechanism = 0L;
        }
        int n = rSAKeyGenParameterSpec.getKeysize();
        BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
        if (bigInteger == null) {
            bigInteger = RSAKeyGenParameterSpec.F4;
        }
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = iCardTemplate.getRSAPublicKeyCreateTemplate(string, n, bigInteger, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = iCardTemplate.getRSAPrivateKeyCreateTemplate(string, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        this.a(l, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        int n;
        block14: {
            n = d;
            if (aParamSpec instanceof RSAKeyGenParameterSpec) {
                this.a(aSessionID, aKeyLabel, (RSAKeyGenParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
                if (n == 0) return;
            }
            if (!(aParamSpec instanceof ECParameterSpec)) break block14;
            this.a(aSessionID, aKeyLabel, (ECParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
            if (n == 0) return;
        }
        if (!(aParamSpec instanceof ECGenParameterSpec)) throw new SmartCardException(e[71]);
        ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)aParamSpec;
        ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(eCGenParameterSpec.getName());
        if (eCParameterSpec == null) {
            throw new SmartCardException(e[70]);
        }
        this.a(aSessionID, aKeyLabel, eCParameterSpec, aIsSign, aIsEncrypt);
        if (n == 0) return;
        throw new SmartCardException(e[71]);
    }

    private void a(long l, String string, ECParameterSpec eCParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception, SmartCardException, IOException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        byte[] byArray = ECParameters.encodeParameters(eCParameterSpec);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, bl2), new CK_ATTRIBUTE(266L, bl), new CK_ATTRIBUTE(384L, byArray), new CK_ATTRIBUTE(3L, string)};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(261L, bl2), new CK_ATTRIBUTE(264L, bl), new CK_ATTRIBUTE(3L, string)};
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray4 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray4);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray4[0].pValue;
        byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray5 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string)};
        long[] lArray2 = this.objeAra(l, cK_ATTRIBUTEArray5);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray6 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray4)};
        this.mPKCS11.C_SetAttributeValue(l, lArray2[0], cK_ATTRIBUTEArray6);
        this.mPKCS11.C_SetAttributeValue(l, lArray2[1], cK_ATTRIBUTEArray6);
    }

    @Override
    public void createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyCreateTemplate(aKey);
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aKey.getGenerationMechanism();
        cK_MECHANISM.pParameter = null;
        this.mPKCS11.C_GenerateKey(aSessionID, cK_MECHANISM, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyImportTemplate(aKey);
        this.mPKCS11.C_CreateObject(aSessionId, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(aKeyTemplate);
        this.mPKCS11.C_CreateObject(aSessionId, aKeyTemplate.getAttributesAsArr());
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception {
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, aKeyID);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(e[34]);
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray2;
    }

    private byte[] a(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        long[] lArray;
        block8: {
            int n = d;
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            lArray = null;
            for (List<CK_ATTRIBUTE> object2 : list) {
                lArray = this.objeAra(l, object2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (n == 0) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(e[3]);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[0].pValue;
        return byArray2;
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aData);
        byte[] byArray2 = this.b(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(e[2]);
        }
        byte[] byArray3 = new byte[1024];
        this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, lArray[0]);
        int n = this.a(aSessionID, byArray, 0, byArray.length, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        return byArray4;
    }

    private int a(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block17: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(e[54])) break block17;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(e[53]);
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(e[56]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SmartCardException(e[55], invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(e[52], illegalAccessException);
        }
    }

    private byte[] b(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        long[] lArray;
        block8: {
            int n = d;
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            lArray = null;
            for (List<CK_ATTRIBUTE> list2 : list) {
                lArray = this.objeAra(l, list2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (n == 0) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(e[58]);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, true);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, false);
    }

    private List<byte[]> a(long l, boolean bl) throws PKCS11Exception, SmartCardException {
        int n = d;
        List<byte[]> list = this.getCertificates(l);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (byte[] byArray : list) {
            block15: {
                block17: {
                    Object object;
                    block16: {
                        X509Certificate x509Certificate = null;
                        try {
                            object = new ByteArrayInputStream(byArray);
                            CertificateFactory certificateFactory = CertificateFactory.getInstance(e[36]);
                            x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {
                            throw new SmartCardException(e[35] + StringUtil.toHexString((byte[])byArray), exception);
                        }
                        object = x509Certificate.getKeyUsage();
                        if (object == null) break block15;
                        if (!bl) break block16;
                        if (object[0] == false) break block15;
                        arrayList.add(byArray);
                        if (n == 0) break block15;
                    }
                    if (object[3] != false) break block17;
                    if (object[2] == false) break block15;
                }
                arrayList.add(byArray);
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        int n = d;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        for (long l : lArray) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (n == 0) continue;
        }
        return arrayList;
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(264L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(262L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(263L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    public String[] getLabels(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception, SmartCardException {
        int n = d;
        long[] lArray = this.objeAra(aSessionID, aTemplate);
        ArrayList<String> arrayList = new ArrayList<String>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
        for (long l : lArray) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray);
            String string = new String((char[])cK_ATTRIBUTEArray[0].pValue);
            arrayList.add(string);
            if (n == 0) continue;
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private boolean a(long l, String string, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, l2)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private void a(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(17L, byArray), new CK_ATTRIBUTE(2L, bl)};
        this.mPKCS11.C_CreateObject(l, cK_ATTRIBUTEArray);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, true);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, false);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, long aDataType) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, aIsPrivate, true, aDataType);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIstoken, long aDataType) throws PKCS11Exception, SmartCardException {
        int n = d;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, aDataType), new CK_ATTRIBUTE(1L, aIstoken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n2 = lArray.length;
        if (n2 == 0) {
            throw new SmartCardException(aLabel + e[68]);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i < n2; ++i) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (n == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, true, 0L);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 0L);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 3L);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 2L);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 1L);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 1L);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(130L, aCertSerialNo)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(e[48]);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[0], cK_ATTRIBUTEArray2);
        return (byte[])cK_ATTRIBUTEArray2[0].pValue;
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + e[39]);
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(Arrays.toString(byArray) + e[25]);
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(Arrays.toString(byArray) + e[81]);
        }
        return lArray[0];
    }

    private KeySpec a(long l, long l2) throws SmartCardException, PKCS11Exception {
        Long l3;
        block7: {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
            this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
            l3 = (Long)cK_ATTRIBUTEArray[0].pValue;
            if (l3 == 0L) {
                return this.b(l, l2);
            }
            if (l3 != 3L && l3 != 3L) break block7;
            return this._readECPublicKeySpec(l, l2);
        }
        throw new SmartCardException(e[60], l3);
    }

    private RSAPublicKeySpec b(long l, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(288L)};
        this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        return new RSAPublicKeySpec(bigInteger2, bigInteger);
    }

    protected ECPublicKeySpec _readECPublicKeySpec(long aSessionID, long aKeyId) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L), new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, aKeyId, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        try {
            ECParameterSpec eCParameterSpec = ECParameters.decodeParameters(byArray);
            byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
            ECPoint eCPoint = ECParameters.decodePoint(byArray3, eCParameterSpec.getCurve());
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            return eCPublicKeySpec;
        }
        catch (IOException iOException) {
            throw new SmartCardException(e[76], iOException);
        }
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, true);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, false);
    }

    private void b(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + e[83]);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L, byArray)};
        this.mPKCS11.C_SetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray2);
    }

    protected void _deleteObject(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIsToken) throws PKCS11Exception, SmartCardException {
        int n = d;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, aIsToken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + e[51]);
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
            if (n == 0) continue;
        }
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, true, true);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, false, true);
    }

    private void a(long l, String string, boolean bl) throws PKCS11Exception, SmartCardException {
        int n = d;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + e[40]);
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(l, lArray[i]);
            if (n == 0) continue;
        }
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, true);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, false);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        byte[] byArray = new byte[aDataLength];
        this.mPKCS11.C_GenerateRandom(aSessionID, byArray);
        return byArray;
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        char[] cArray = this.mPKCS11.C_GetTokenInfo((long)aSlotID).serialNumber;
        String string = new String(cArray);
        return string.trim().getBytes();
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + e[80]);
            }
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + e[37]);
            }
        }
        byte[] byArray = null;
        this.mPKCS11.C_SignRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = new byte[1024];
        int n = this.mPKCS11.C_SignRecover(aSessionID, aImzalanacak, 0, aImzalanacak.length, byArray2, 0, byArray2.length);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + e[66]);
            }
        }
        byte[] byArray = null;
        this.mPKCS11.C_VerifyRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = new byte[1024];
        int n = this.mPKCS11.C_VerifyRecover(aSessionID, aSignature, 0, aSignature.length, byArray2, 0, byArray2.length);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + e[72]);
            }
        }
        this.mPKCS11.C_VerifyInit(aSessionID, aMechanism, lArray[0]);
        this.mPKCS11.C_Verify(aSessionID, aData, aImza);
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        this.verifyData(aSessionID, aKeyLabel, aData, aImza, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + e[0]);
            }
        }
        byte[] byArray = new byte[512];
        this.mPKCS11.C_EncryptInit(aSessionID, aMechanism, lArray[0]);
        int n = this.b(aSessionID, aData, 0, aData.length, byArray, 0, 512);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private int b(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException, PKCS11Exception {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block20: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(e[61])) break block20;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(e[65]);
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(e[63]);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof PKCS11Exception) {
                throw (PKCS11Exception)invocationTargetException.getTargetException();
            }
            throw new SmartCardException(e[64], invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(e[62], illegalAccessException);
        }
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aData);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + e[41]);
            }
        }
        byte[] byArray2 = new byte[1024];
        this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, lArray[0]);
        int n = this.a(aSessionID, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private byte[] a(byte[] byArray) {
        int n;
        block3: {
            n = byArray.length % 8;
            if (n != 1 || byArray[0] != 0) break block3;
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        if (n == 7) {
            byte[] byArray3 = new byte[byArray.length + 1];
            byArray3[0] = 0;
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        Object object;
        block14: {
            block15: {
                byte[] byArray;
                boolean bl;
                boolean bl2;
                int n;
                block13: {
                    boolean[] blArray;
                    n = d;
                    bl2 = false;
                    bl = false;
                    if (aCert != null && (blArray = aCert.getKeyUsage()) != null) {
                        bl2 = blArray[0];
                        bl = blArray[2] || blArray[3] || blArray[4];
                    }
                    byArray = aCert.getSubjectX500Principal().getEncoded();
                    if (!(aPrivKey instanceof RSAPrivateCrtKey)) break block13;
                    object = (RSAPrivateCrtKey)aPrivKey;
                    this.a(aSessionID, aKeyLabel, (RSAPrivateCrtKey)object, byArray, bl2, bl);
                    if (n == 0) break block14;
                }
                if (!(aPrivKey instanceof ECPrivateKey)) break block15;
                object = (ECPrivateKey)aPrivKey;
                ECPublicKey eCPublicKey = null;
                try {
                    eCPublicKey = (ECPublicKey)aCert.getPublicKey();
                }
                catch (ClassCastException classCastException) {
                    try {
                        PublicKey publicKey = aCert.getPublicKey();
                        Class<?> clazz = Class.forName(e[46]);
                        Constructor<?> constructor = clazz.getConstructor(byte[].class);
                        eCPublicKey = (ECPublicKey)constructor.newInstance(new Object[]{publicKey.getEncoded()});
                    }
                    catch (Exception exception) {
                        this.a.warn(e[47], (Throwable)exception);
                        throw classCastException;
                    }
                }
                this.a(aSessionID, aKeyLabel, (ECPrivateKey)object, eCPublicKey, byArray, bl2, bl);
                if (n == 0) break block14;
            }
            throw new SmartCardException(e[45]);
        }
        object = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aCert);
        this.mPKCS11.C_CreateObject(aSessionID, object.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAPrivateCrtKey rSAPrivateCrtKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getRSAPrivateKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        List<CK_ATTRIBUTE> list2 = this.c.getCardTemplate().getRSAPublicKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        if (byArray != null) {
            list.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, list.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, list2.toArray(new CK_ATTRIBUTE[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(long l, String string, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        Object object;
        byte[] byArray2;
        ECParameterSpec eCParameterSpec;
        int n;
        block18: {
            block17: {
                n = d;
                eCParameterSpec = eCPrivateKey.getParams();
                if (this.c != CardType.AKIS) break block17;
                byArray2 = ECParameters.encodeECParameterSpec(eCParameterSpec);
                if (n == 0) break block18;
            }
            byArray2 = ECParameters.encodeParameters(eCParameterSpec);
        }
        ECPoint eCPoint = eCPublicKey.getW();
        byte[] byArray3 = ECParameters.encodePoint(eCPoint, eCParameterSpec.getCurve());
        DerValue derValue = new DerValue(4, byArray3);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(256L, 3L));
        arrayList.add(new CK_ATTRIBUTE(384L, byArray2));
        arrayList.add(new CK_ATTRIBUTE(385L, derValue.toByteArray()));
        arrayList.add(new CK_ATTRIBUTE(3L, string));
        arrayList.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            arrayList.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            arrayList.add(new CK_ATTRIBUTE(266L, bl));
        }
        boolean bl3 = false;
        ECParameterSpec eCParameterSpec2 = eCPublicKey.getParams();
        if (eCParameterSpec2 instanceof NamedCurve) {
            bl3 = true;
            object = NamedCurve.getNameCurves();
            ObjectIdentifier objectIdentifier = ((NamedCurve)eCParameterSpec2).getObjectIdentifier();
            for (NamedCurve namedCurve : object.values()) {
                if (namedCurve.getObjectIdentifier().toString().equals(objectIdentifier.toString())) {
                    bl3 = false;
                    if (n == 0) break;
                }
                if (n == 0) continue;
            }
        }
        arrayList.add(new CK_ATTRIBUTE(2L, bl3));
        object = new ArrayList();
        object.add(new CK_ATTRIBUTE(1L, true));
        object.add(new CK_ATTRIBUTE(2L, true));
        object.add(new CK_ATTRIBUTE(0L, 3L));
        object.add(new CK_ATTRIBUTE(256L, 3L));
        object.add(new CK_ATTRIBUTE(3L, string));
        object.add(new CK_ATTRIBUTE(17L, eCPrivateKey.getS()));
        object.add(new CK_ATTRIBUTE(384L, byArray2));
        object.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            object.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            object.add(new CK_ATTRIBUTE(264L, bl));
        }
        if (byArray != null) {
            object.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, arrayList.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, object.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    @Deprecated
    public void importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        block13: {
            block14: {
                PublicKey publicKey;
                PrivateKey privateKey;
                int n;
                block12: {
                    n = d;
                    privateKey = aKeyPair.getPrivate();
                    publicKey = aKeyPair.getPublic();
                    if (!(privateKey instanceof RSAPrivateCrtKey) || !(publicKey instanceof RSAPublicKey)) break block12;
                    this.a(aSessionID, aLabel, (RSAPrivateCrtKey)privateKey, aSubject, aIsSign, aIsEncrypt);
                    if (n == 0) break block13;
                }
                if (!(privateKey instanceof ECPrivateKey)) break block14;
                if (!(publicKey instanceof ECPublicKey)) break block14;
                this.a(aSessionID, aLabel, (ECPrivateKey)privateKey, (ECPublicKey)publicKey, aSubject, aIsSign, aIsEncrypt);
                if (n == 0) break block13;
            }
            throw new SmartCardException(e[74]);
        }
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changePassword(aOldPass, aNewPass, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.formatToken(aSOpin, aNewPIN, aLabel, slotID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.setSOPin(aSOPin, aSOPin.length, aNewSOPin, aNewSOPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changeUserPin(aSOPin, aSOPin.length, aUserPin, aUserPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionID) {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.setContainer(aContainerLabel, aContainerLabel.length, (int)aSessionID, string);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarCifti.length, aAnahtarLen, aScfname, aScfname.length(), aContextName, aContextName.length(), aPbCertData, aSignOrEnc);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        byte[] byArray = null;
        try {
            byArray = aPbCertificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.a.warn(e[43], (Throwable)certificateEncodingException);
            return false;
        }
        return this.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, byArray, aSignOrEnc);
    }

    protected void changePUK(byte[] aOldPUK, byte[] aNewPUK, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.ChangePUK(aOldPUK, aOldPUK.length, aNewPUK, aNewPUK.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    protected void unBlockPIN(byte[] aPUK, byte[] aUserPIN, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.UnBlockPIN(aPUK, aPUK.length, aUserPIN, aUserPIN.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long l = 200L;
        this.mPKCS11.C_FindObjectsInit(aSessionID, aTemplate);
        long[] lArray = this.mPKCS11.C_FindObjects(aSessionID, l);
        this.mPKCS11.C_FindObjectsFinal(aSessionID);
        return lArray;
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mPKCS11.C_GetAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        int n = d;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aOldLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aOldLabel + e[38]);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aNewLabel)};
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_SetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            if (n == 0) continue;
        }
    }

    private String a(String string) {
        int n = d;
        String string2 = System.getProperty(e[11]);
        this.a.debug(e[9] + string2);
        this.a.debug(e[15] + string2);
        if (new File(string).exists()) {
            this.a.info(string + e[16]);
            return string;
        }
        String string3 = System.getProperty(e[14]);
        String string4 = System.getProperty(e[6]);
        String[] stringArray = string3.split(string4);
        for (String string5 : stringArray) {
            String string6 = string5 + System.getProperty(e[5]) + System.mapLibraryName(string);
            this.a.debug(e[8] + string6);
            if (!new File(string6).exists()) continue;
            this.a.info(e[13] + string6);
            return string6;
        }
        for (String string7 : b) {
            String string8 = string7 + System.mapLibraryName(string);
            this.a.debug(e[7] + string8);
            if (new File(string8).exists()) {
                this.a.info(e[4] + string8);
                return string8;
            }
            this.a.debug(e[10] + string8);
            if (n == 0) continue;
        }
        this.a.info(e[12] + System.mapLibraryName(string));
        return System.mapLibraryName(string);
    }

    protected byte[] toByteArray(BigInteger aX) {
        byte[] byArray = aX.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        throw new RuntimeException(e[73]);
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        throw new RuntimeException(e[57]);
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
        this.getAttributeValue(aSessionID, aObjID, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private long b(long l, String string, long l2) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, l2), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(l, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(string + e[69]);
            }
        }
        return lArray[0];
    }

    @Override
    public long getObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.b(aSessionID, aLabel, 2L);
    }

    @Override
    public long getObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aLabel + e[59]);
            }
        }
        return lArray[0];
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, String aKeyLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, wrapperKeyLabel), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(wrapperKeyLabel + e[17]);
            }
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(2L, true)};
        long[] lArray2 = this.objeAra(aSessionID, cK_ATTRIBUTEArray2);
        if (lArray2.length == 0) {
            throw new SmartCardException(aKeyLabel + e[18]);
        }
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, lArray[0], lArray2[0]);
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate aToBeExportedKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, wrapperKeyTemplate, aToBeExportedKeyTemplate);
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, wrapperKeyTemplate.getKeyId(), aToBeExportedKeyTemplate.getKeyId());
    }

    private void a(long l, KeyTemplate ... keyTemplateArray) throws PKCS11Exception {
        int n = d;
        for (KeyTemplate keyTemplate : keyTemplateArray) {
            if (keyTemplate.getKeyId() > 0L) continue;
            this.a(l, keyTemplate);
        }
    }

    private void a(long l, KeyTemplate keyTemplate) throws PKCS11Exception {
        long[] lArray;
        block7: {
            lArray = this.objeAra(l, keyTemplate.getAttributesAsArr());
            if (lArray != null && lArray.length != 0) break block7;
            return;
        }
        if (lArray.length > 1) {
            this.a.warn(e[1] + keyTemplate);
        }
        keyTemplate.setKeyId(lArray[0]);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, String unwrapperKeyLabel, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, unwrapperKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(unwrapperKeyLabel + e[75]);
            }
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = aUnwrappedKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate unwrapperKeyTemplate, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        this.a(aUnwrappedKeyTemplate);
        this.a(aSessionID, new KeyTemplate[]{unwrapperKeyTemplate});
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, unwrapperKeyTemplate.getKeyId(), byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = unwrapperKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    private void a(KeyTemplate keyTemplate) throws SmartCardException {
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        if (keyTemplate instanceof SecretKeyTemplate) {
            iCardTemplate.applyTemplate((SecretKeyTemplate)keyTemplate);
        }
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, byte[] certSerialNumber, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        byte[] byArray2 = this.b(aSessionID, certSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toString((byte[])certSerialNumber) + e[67]);
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
    }

    public PKCS11 getmPKCS11() {
        return this.mPKCS11;
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, IOException, SmartCardException {
        if (this.a.isDebugEnabled()) {
            this.a(((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr());
            this.a(((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr());
        }
        if (template instanceof RSAKeyPairTemplate) {
            return this.createKeyPair(aSessionID, (RSAKeyPairTemplate)template);
        }
        if (template instanceof ECKeyPairTemplate) {
            return this.a(aSessionID, (ECKeyPairTemplate)template);
        }
        throw new ESYARuntimeException(e[82] + template);
    }

    public KeySpec createKeyPair(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        long[] lArray = this.createKeyPairWithOutRead(aSessionID, template);
        RSAPublicKeySpec rSAPublicKeySpec = this.b(aSessionID, lArray[0]);
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        this.a(aSessionID, string);
        ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(lArray[0]);
        ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(lArray[1]);
        return rSAPublicKeySpec;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 0L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
        if (this.a.isDebugEnabled()) {
            this.a(cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        }
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, ECKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)template.getPublicKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = eCPublicKeyTemplate.getAttributesAsArr();
        ECPrivateKeyTemplate eCPrivateKeyTemplate = (ECPrivateKeyTemplate)template.getPrivateKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = eCPrivateKeyTemplate.getAttributesAsArr();
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    private void a(long l, String string) throws PKCS11Exception {
        int n = d;
        try {
            long[] lArray;
            block5: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(1L, true)};
                lArray = this.objeAra(l, cK_ATTRIBUTEArray);
                if (lArray != null && lArray.length >= 1) break block5;
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
            this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
            this.OZET_ALICI.update(byArray);
            byte[] byArray2 = this.OZET_ALICI.digest();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2)};
            for (long l2 : lArray) {
                this.mPKCS11.C_SetAttributeValue(l, l2, cK_ATTRIBUTEArray2);
                if (n == 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            this.a.warn(e[44], (Throwable)exception);
        }
    }

    private KeySpec a(long l, ECKeyPairTemplate eCKeyPairTemplate) throws SmartCardException, IOException, PKCS11Exception {
        this.createKeyPairWithOutRead(l, eCKeyPairTemplate);
        String string = ((KeyTemplate)eCKeyPairTemplate.getPublicKeyTemplate()).getLabel();
        this.b(l, string);
        return this.readPublicKeySpec(l, string);
    }

    private long[] b(long l, String string) throws PKCS11Exception, IOException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray2);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
        byte[] byArray2 = this.c.getCardTemplate().getPointValue(byArray);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string)};
        long[] lArray2 = this.objeAra(l, cK_ATTRIBUTEArray3);
        byte[] byArray3 = this.OZET_ALICI.digest(byArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray4 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray3)};
        this.mPKCS11.C_SetAttributeValue(l, lArray2[0], cK_ATTRIBUTEArray4);
        this.mPKCS11.C_SetAttributeValue(l, lArray2[1], cK_ATTRIBUTEArray4);
        return lArray2;
    }

    @Override
    public void importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        block9: {
            block10: {
                int n;
                block8: {
                    n = d;
                    this.c.getCardTemplate().applyTemplate(template);
                    if (!(template instanceof RSAKeyPairTemplate)) break block8;
                    this.importKeyPair(sessionID, (RSAKeyPairTemplate)template);
                    if (n == 0) break block9;
                }
                if (!(template instanceof ECKeyPairTemplate)) break block10;
                this.importKeyPair(sessionID, (ECKeyPairTemplate)template);
                if (n == 0) break block9;
            }
            throw new ESYARuntimeException(e[42] + template);
        }
    }

    public void importKeyPair(long sessionID, RSAKeyPairTemplate template) throws PKCS11Exception {
        long l;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        if (template.getPublicKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        if (template.getPrivateKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l);
        }
        this.a(sessionID, string);
    }

    public void importKeyPair(long sessionID, ECKeyPairTemplate template) throws PKCS11Exception {
        long l;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        if (template.getPublicKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        if (template.getPrivateKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l);
        }
        cK_ATTRIBUTEArray = ((KeyTemplate)template.getPublicKeyTemplate()).getLabel();
        try {
            this.b(sessionID, (String)cK_ATTRIBUTEArray);
        }
        catch (IOException iOException) {
            this.a.error(e[79], (Throwable)iOException);
            throw new PKCS11Exception(0x80000000L);
        }
    }

    @Override
    public void createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = template.getAttributesAsArr();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(template.getGenerationMechanism());
        long l = this.mPKCS11.C_GenerateKey(sessionID, cK_MECHANISM, cK_ATTRIBUTEArray);
        template.setKeyId(l);
    }

    @Override
    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        int n = d;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n2 = 0;
        if (lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
                ++n2;
                if (n == 0) continue;
            }
        }
        return n2;
    }

    private void a(CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
        block4: {
            block5: {
                if (!this.a.isDebugEnabled()) break block4;
                this.a.debug(e[27]);
                this.a.debug(e[30] + cK_MECHANISM.mechanism);
                this.a.debug(e[32]);
                if (cK_MECHANISM.pParameter != null) break block5;
                this.a.debug(e[29]);
            }
            this.a.debug("\n");
            this.a.debug(e[33]);
            this.a(cK_ATTRIBUTEArray2);
            this.a.debug(e[28]);
            this.a.debug(e[31]);
            this.a(cK_ATTRIBUTEArray);
            this.a.debug(e[26]);
        }
    }

    private void a(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        int n = d;
        for (CK_ATTRIBUTE cK_ATTRIBUTE : cK_ATTRIBUTEArray) {
            this.a.debug(cK_ATTRIBUTE.toString());
            System.out.println(cK_ATTRIBUTE.toString());
            if (n == 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    static {
        block118: {
            block119: {
                block120: {
                    v0 = new String[84];
                    v1 = v0;
                    v2 = v0;
                    v3 = 0;
                    v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\";
                    v5 = -1;
                    block112: while (true) {
                        switch (v5) {
                            default: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 1;
                                v4 = "c\u0012\u001a\u000fY\u0017\u001b\r\u0018\u001cZ\u0015\r\u0018\u001cC\u0012\u001e\u0013\u001c\u0006Z4\u0018E\u0017\b\u001a\u0011YV\u000e\u001a\u000e\u001c@\u0013\u000b\u0015\u001cc\u001f\u0012\rPV\u000e\u001aG";
                                v5 = 0;
                                continue block112;
                            }
                            case 0: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 2;
                                v4 = "a\u001f\r\u0014PR\u0014_\u000eYE\u0013_\u0013IZ\u001b\r\u001cO^\u0014\u001e]OV\u0012\u0016\r\u001cD\u001f\r\tUQ\u0013\u0014\u001cE[\u001b_\u001cEY\u0013_4x\u0017\u0003\u001a]OV\u0012\u0016\r\u001cX\u0000\u001a\u0011\u001cV\u0014\u001e\u0015HV\b_\u0016]E\u000e\u000b\u001c\u001cU\u000f\u0013\bRV\u0017\u001e\u0019U\u0019";
                                v5 = 1;
                                continue block112;
                            }
                            case 1: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 3;
                                v4 = "a\u001f\r\u0014PR\u0014_\u000eYE\u0013_\u0013IZ\u001b\r\u001cP^Z\f\u0018NC\u0013\u0019\u0014WVZ\u0014\u001cNC\u000e\u001e]^B\u0016\n\u0013]Z\u001b\u001b\u0014\u0012";
                                v5 = 2;
                                continue block112;
                            }
                            case 2: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 4;
                                v4 = "`\u0013\u0013\u0011\u001c@\u0015\r\u0016\u001c@\u0013\u000b\u0015\u001c[\u0013\u001d\u000f]E\u0003_\r]C\u0012_G";
                                v5 = 3;
                                continue block112;
                            }
                            case 3: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 5;
                                v4 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v5 = 4;
                                continue block112;
                            }
                            case 4: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 6;
                                v4 = "G\u001b\u000b\u0015\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v5 = 5;
                                continue block112;
                            }
                            case 5: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 7;
                                v4 = "{\u0015\u0010\u0016UY\u001d_\u001bSEZ\u000f\u0016_DKN]P^\u0018\r\u001cNNZ\u0016\u0013\u001cG\u001b\u000b\u0015\u0006";
                                v5 = 6;
                                continue block112;
                            }
                            case 6: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 8;
                                v4 = "{\u0015\u0010\u0016UY\u001d_\u001bSEZ\u000f\u0016_DKN]P^\u0018\r\u001cNNZ\u0016\u0013\u001cG\u001b\u000b\u0015\u0006";
                                v5 = 7;
                                continue block112;
                            }
                            case 7: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 9;
                                v4 = "`\u0015\r\u0016UY\u001d_\u0019UEZE";
                                v5 = 8;
                                continue block112;
                            }
                            case 8: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 10;
                                v4 = "t\u001b\u0011]RX\u000e_\u001bUY\u001e_\u0011UU\b\u001e\u000fE\u0017\u001b\u000b]LV\u000e\u0017]\u0006";
                                v5 = 9;
                                continue block112;
                            }
                            case 9: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 11;
                                v4 = "B\t\u001a\u000f\u0012S\u0013\r";
                                v5 = 10;
                                continue block112;
                            }
                            case 10: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 12;
                                v4 = "`\u0013\u0013\u0011\u001c@\u0015\r\u0016\u001c@\u0013\u000b\u0015\u001c[\u0013\u001d\u000f]E\u0003_\r]C\u0012_G";
                                v5 = 11;
                                continue block112;
                            }
                            case 11: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 13;
                                v4 = "`\u0013\u0013\u0011\u001c@\u0015\r\u0016\u001c@\u0013\u000b\u0015\u001c[\u0013\u001d\u000f]E\u0003_\r]C\u0012_G";
                                v5 = 12;
                                continue block112;
                            }
                            case 12: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 14;
                                v4 = "]\u001b\t\u001c\u0012[\u0013\u001d\u000f]E\u0003Q\r]C\u0012";
                                v5 = 13;
                                continue block112;
                            }
                            case 13: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 15;
                                v4 = "{\u0015\u0010\u0016UY\u001d_\u001bSEZ\u000f\u0016_DKN]P^\u0018\r\u001cNNZ\u0016\u0013\u001cG\u001b\u000b\u0015\u0006";
                                v5 = 14;
                                continue block112;
                            }
                            case 14: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 16;
                                v4 = "\u0017\u001c\u0010\bRSZ\u0016\u0013\u001c@\u0015\r\u0016UY\u001d_\u0019UE\u001f\u001c\tSE\u0003";
                                v5 = 15;
                                continue block112;
                            }
                            case 15: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 17;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u001fI[\u000f\u0011\u001cQV\u001e\u0016";
                                v5 = 16;
                                continue block112;
                            }
                            case 16: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 18;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u001fI[\u000f\u0011\u001cQV\u001e\u0016";
                                v5 = 17;
                                continue block112;
                            }
                            case 17: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 19;
                                v4 = "g1<.\r\u0006Z\b\u000f]G\n\u001a\u000f\u001cX\u0018\u0015\u0018O^Z\u0010\u0011ID\u000e\n\u000fI[\u001b\u0012\u001cX^";
                                v5 = 18;
                                continue block112;
                            }
                            case 18: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 20;
                                v4 = "D\u000f\u0011SOR\u0019\n\u000fUC\u0003Q\rWT\tNL\u0012@\b\u001e\rLR\bQ-wt)NL";
                                v5 = 19;
                                continue block112;
                            }
                            case 19: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 21;
                                v4 = "\u0006TJ";
                                v5 = 20;
                                continue block112;
                            }
                            case 20: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 22;
                                v4 = "P\u001f\u000b4RD\u000e\u001e\u0013_R";
                                v5 = 21;
                                continue block112;
                            }
                            case 21: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 23;
                                v4 = "P\u001f\u000b4RD\u000e\u001e\u0013_R";
                                v5 = 22;
                                continue block112;
                            }
                            case 22: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 24;
                                v4 = "t%8\u0018Hq\u000f\u0011\u001eH^\u0015\u00111UD\u000e";
                                v5 = 23;
                                continue block112;
                            }
                            case 23: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 25;
                                v4 = "\u0017\u0013\u001b]P^Z\u001e\u0013]_\u000e\u001e\u000f\u001c\\\u001b\r\tHVZ\u0006\u0012W\u0019";
                                v5 = 24;
                                continue block112;
                            }
                            case 24: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 26;
                                v4 = "\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP";
                                v5 = 25;
                                continue block112;
                            }
                            case 25: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 27;
                                v4 = "\u0017PUW\u0016\u001dPUW\u0016\u001dPUW\u0016\u001dPUW\u001cG\u0011\u001c\u000e\r\u0006Z\u000f\u001cNV\u0017\u001a\tYE\t_\r]E\u001b\u0012\u0018HE\u001f\u0013\u0018N^ZUW\u0016\u001dPUW\u0016\u001dPUW\u0016\u001dPUW\u0016\u001dP";
                                v5 = 26;
                                continue block112;
                            }
                            case 26: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 28;
                                v4 = "\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001aWRP\u0011\u001a";
                                v5 = 27;
                                continue block112;
                            }
                            case 27: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 29;
                                v4 = "Y\u000f\u0013\u0011";
                                v5 = 28;
                                continue block112;
                            }
                            case 28: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 30;
                                v4 = "\u00177\u001a\u001eTV\u0014\u0016\u000eQ\rZ";
                                v5 = 29;
                                continue block112;
                            }
                            case 29: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 31;
                                v4 = "\u001aWRP\u0011\u001aWRP\u001cg\u000f\u001d\u0011UTZ4\u0018E\u0017;\u000b\tN^\u0018\n\tYDZRP\u0011\u001aWRP\u0011\u001aWRP\u0011";
                                v5 = 30;
                                continue block112;
                            }
                            case 30: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 32;
                                v4 = "\u00177\u001a\u001eTV\u0014\u0016\u000eQ\u0017*\u001e\u000f]Z\u001f\u000b\u0018NDZE]";
                                v5 = 31;
                                continue block112;
                            }
                            case 31: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 33;
                                v4 = "\u001aWRP\u0011\u001aWRP\u001cg\b\u0016\u000b]C\u001f_6YNZ>\tHE\u0013\u001d\bHR\t_P\u0011\u001aWRP\u0011\u001aWRP\u0011\u001a";
                                v5 = 32;
                                continue block112;
                            }
                            case 32: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 34;
                                v4 = "a\u001f\r\u0014PR\u0014_\u000eYE\u0013_\u0013IZ\u001b\r\u001cO^\u0014\u001e]OV\u0012\u0016\r\u001cD\u001f\r\tUQ\u0013\u0014\u001cE[\u001b_\u001cEY\u0013_4x\u0017\u0003\u001a]OV\u0012\u0016\r\u001cX\u0000\u001a\u0011\u001cV\u0014\u001e\u0015HV\b_\u0016]E\u000e\u000b\u001c\u001cU\u000f\u0013\bRV\u0017\u001e\u0019U\u0019";
                                v5 = 33;
                                continue block112;
                            }
                            case 33: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 35;
                                v4 = "d\u001f\r\tUQ\u0013\u0014\u001c\u001cR\u0014\u001c\u0012XRZ\u001a\u0019U[\u0013\r\u0016YYZ\u0017\u001cHVZ\u0010\u0011ID\u000e\nS\u001ct\u001f\r\t\u001cu\u0003\u000b\u0018O\rZ";
                                v5 = 34;
                                continue block112;
                            }
                            case 34: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 36;
                                v4 = "oTJM\u0005";
                                v5 = 35;
                                continue block112;
                            }
                            case 35: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 37;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\";
                                v5 = 36;
                                continue block112;
                            }
                            case 36: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 38;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u0013YD\u0014\u001a]WV\b\u000b\t]\u0017\u0018\n\u0011IY\u001b\u0012\u001cX^T";
                                v5 = 37;
                                continue block112;
                            }
                            case 37: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 39;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\T";
                                v5 = 38;
                                continue block112;
                            }
                            case 38: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 40;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u0013YD\u0014\u001a]WV\b\u000b\t]\u0017\u0018\n\u0011IY\u001b\u0012\u001cX^T";
                                v5 = 39;
                                continue block112;
                            }
                            case 39: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 41;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\";
                                v5 = 40;
                                continue block112;
                            }
                            case 40: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 42;
                                v4 = "y\u0015\u000b]UZ\n\u0013\u0018QR\u0014\u000b\u0018X\u0017#\u001a\t\u001cQ\u0015\rG";
                                v5 = 41;
                                continue block112;
                            }
                            case 41: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 43;
                                v4 = "`\u001b\r\u0013UY\u001d_\u0014R\u0017*4>o\u0006K0\rO";
                                v5 = 42;
                                continue block112;
                            }
                            case 42: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 44;
                                v4 = "t\u001b\u0011]RX\u000e_\bLS\u001b\u000b\u0018\u001c\\\u001f\u0006]US";
                                v5 = 43;
                                continue block112;
                            }
                            case 43: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 45;
                                v4 = "a\u001f\r\u0014PR\u0014_\u0012FR\u0016_\u001cRV\u0012\u000b\u001cN\u0017\u000e\u0016\rU\u0017\u001e\u001a\u000eHR\u0011\u0013\u0018RZ\u0013\u0006\u0012N";
                                v5 = 44;
                                continue block112;
                            }
                            case 44: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 46;
                                v4 = "D\u000f\u0011SOR\u0019\n\u000fUC\u0003Q\u0018_\u0019?<-IU\u0016\u0016\u001ewR\u00036\u0010L[";
                                v5 = 45;
                                continue block112;
                            }
                            case 45: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 47;
                                v4 = "`\u001b\r\u0013UY\u001d_\u0014R\u0017*4>o\u0006K0\rO";
                                v5 = 46;
                                continue block112;
                            }
                            case 46: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 48;
                                v4 = "|\u001b\r\tHVZ\u001d\b\u001cD\u001f\r\u0014\u001cY\u000f\u0012\u001cNV\u0016\u0016]OR\b\u000b\u0014Z^\u0011\u001e]^B\u0016\n\u0013]Z\u001b\u001b\u0014";
                                v5 = 47;
                                continue block112;
                            }
                            case 47: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 49;
                                v4 = "d2>P\r";
                                v5 = 48;
                                continue block112;
                            }
                            case 48: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 50;
                                v4 = "`\u001b\r\u0013UY\u001d_\u0014R\u0017*4>o\u0006K0\rO";
                                v5 = 49;
                                continue block112;
                            }
                            case 49: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 51;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u0013YD\u0014\u001a]WV\b\u000b\t]\u0017\u0018\n\u0011IY\u001b\u0012\u001cX^T";
                                v5 = 50;
                                continue block112;
                            }
                            case 50: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 52;
                                v4 = "t%;\u0018_E\u0003\u000f\t\u001cE\u001f\u0019\u0011YT\u000e\u0016\u0012R\u0017\u001f\r\u000fSE";
                                v5 = 51;
                                continue block112;
                            }
                            case 51: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 53;
                                v4 = "t%;\u0018_E\u0003\u000f\tqR\u000e\u0017\u0012X\u0017\u0019\u0010\bPSZ\u0011\u0012H\u0017\u0018\u001a]ZX\u000f\u0011\u0019";
                                v5 = 52;
                                continue block112;
                            }
                            case 52: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 54;
                                v4 = "t%;\u0018_E\u0003\u000f\t";
                                v5 = 53;
                                continue block112;
                            }
                            case 53: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 55;
                                v4 = "t%;\u0018_E\u0003\u000f\t\u001cE\u001f\u0019\u0011YT\u000e\u0016\u0012R\u0017\u001f\r\u000fSE";
                                v5 = 54;
                                continue block112;
                            }
                            case 54: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 56;
                                v4 = "t\u0015\u0011\u000bYY\u0013\u001a\u0013H\u00179 9YT\b\u0006\rHz\u001f\u000b\u0015SSZ\u001c\u0012I[\u001e_\u0013SCZ\u001d\u0018\u001cQ\u0015\n\u0013X";
                                v5 = 55;
                                continue block112;
                            }
                            case 55: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 57;
                                v4 = "r(-2n\u00175\u000f\u0018NV\u000e\u0016\u0012R\r5\u000f\u0018NV\u000e\u0016\u0012R\u0017\u0013\f]RX\u000e_\u000eIG\n\u0010\u000fHR\u001e_\u0014R\u0017*4>o\u0006K0\rO\u0019";
                                v5 = 56;
                                continue block112;
                            }
                            case 56: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 58;
                                v4 = "a\u001f\r\u0014PR\u0014_\u000eYE\u0013_\u0013IZ\u001b\r\u001cP^Z\f\u0018NC\u0013\u0019\u0014WVZ\u0014\u001cNC\u000e\u001e]^B\u0016\n\u0013]Z\u001b\u001b\u0014\u0012";
                                v5 = 57;
                                continue block112;
                            }
                            case 57: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 59;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\";
                                v5 = 58;
                                continue block112;
                            }
                            case 58: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 60;
                                v4 = "v\u0014\u001e\u0015HV\b_\tUG\u0013_U\u0019SS_\u0019YD\u000e\u001a\u0016PR\u0014\u0012\u0014EX\bQ]xR\t\u000b\u0018W[\u001f\u0011\u0018R\u0017\u001b\u0013\u001aSE\u0013\u000b\u0010][\u001b\r]nd;_\u000bY\u0017?<9ovT";
                                v5 = 59;
                                continue block112;
                            }
                            case 59: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 61;
                                v4 = "t%:\u0013_E\u0003\u000f\t";
                                v5 = 60;
                                continue block112;
                            }
                            case 60: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 62;
                                v4 = "t%:\u0013_E\u0003\u000f\tqR\u000e\u0017\u0012X\u0017\b\u001a\u001bPR\u0019\u000b\u0014SYZ\u001a\u000fNX\b";
                                v5 = 61;
                                continue block112;
                            }
                            case 61: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 63;
                                v4 = "t\u0015\u0011\u000bYY\u0013\u001a\u0013H\u00179 8RT\b\u0006\rHz\u001f\u000b\u0015SSZ\u001c\u0012I[\u001e_\u0013SCZ\u001d\u0018\u001cQ\u0015\n\u0013X";
                                v5 = 62;
                                continue block112;
                            }
                            case 62: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 64;
                                v4 = "t%:\u0013_E\u0003\u000f\tqR\u000e\u0017\u0012X\u0017\b\u001a\u001bPR\u0019\u000b\u0014SYZ\u001a\u000fNX\b";
                                v5 = 63;
                                continue block112;
                            }
                            case 63: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 65;
                                v4 = "t%:\u0013_E\u0003\u000f\tqR\u000e\u0017\u0012X\u0017\u0019\u0010\bPSZ\u0011\u0012H\u0017\u0018\u001a]ZX\u000f\u0011\u0019";
                                v5 = 64;
                                continue block112;
                            }
                            case 64: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 66;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\";
                                v5 = 65;
                                continue block112;
                            }
                            case 65: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 67;
                                v4 = "\u0017)\u001a\u000fH^\u001c\u0016\u0016]\u0017)\u001a\u000fU\u00174\u0010\u0011I\u0017=\u0016\u0007P^Z>\u0013]_\u000e\u001e\u000f\u001c|\u001b\r\tHVZ=\bPB\u0014\u001e\u0010]S\u014b";
                                v5 = 66;
                                continue block112;
                            }
                            case 66: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 68;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u0013YD\u0014\u001a]WV\b\u000b\t]\u0017\u0018\n\u0011IY\u001b\u0012\u001cX^T";
                                v5 = 67;
                                continue block112;
                            }
                            case 67: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 69;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\";
                                v5 = 68;
                                continue block112;
                            }
                            case 68: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 70;
                                v4 = "a\u001f\r\u0014PR\u0014_<PP\u0015\r\u0014H_\u0017/\u001cNV\u0017\u001a\tYE)\u000f\u0018_\u0017\u001e\u001a\u000eHR\u0011\u0013\u0018RZ\u0013\u0006\u0012N";
                                v5 = 69;
                                continue block112;
                            }
                            case 69: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 71;
                                v4 = "a\u001f\r\u0014PR\u0014_<PP\u0015\r\u0014H_\u0017/\u001cNV\u0017\u001a\tYE)\u000f\u0018_\u0017\u001e\u001a\u000eHR\u0011\u0013\u0018RZ\u0013\u0006\u0012N";
                                v5 = 70;
                                continue block112;
                            }
                            case 70: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 72;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\T";
                                v5 = 71;
                                continue block112;
                            }
                            case 71: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 73;
                                v4 = "r(-2n\u00175\u000f\u0018NV\u000e\u0016\u0012R\r5\u000f\u0018NV\u000e\u0016\u0012R\u0017\u0013\f]RX\u000e_\u000eIG\n\u0010\u000fHR\u001e_\u0014R\u0017*4>o\u0006K0\rO\u0019Z*\u000eY\u0017\u0019\r\u0018HR(,<wR\u0003/\u001cUE";
                                v5 = 72;
                                continue block112;
                            }
                            case 72: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 74;
                                v4 = "a\u001f\r\u0014PR\u0014_6YN*\u001e\u0014N\u0017\u001e\u001e\u0016U\u0017\u001b\u0011\u001cTC\u001b\r]H^\n\u0013\u0018N^Z\u001b\u0018OC\u001f\u0014\u0011YY\u0017\u0016\u0004SE";
                                v5 = 73;
                                continue block112;
                            }
                            case 73: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 75;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u001fI[\u000f\u0011\u001cQV\u001e\u0016";
                                v5 = 74;
                                continue block112;
                            }
                            case 74: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 76;
                                v4 = "r9_\rIU\u0016\u0016\u001eWR\u0003_\u0012PB\t\u000b\bNB\u0016\n\u000fWR\u0014_\u0014S\u0017\u0012\u001e\t]D\u0013_\u0012PB\t\u000b\b";
                                v5 = 75;
                                continue block112;
                            }
                            case 75: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 77;
                                v4 = "d\u0016\u0010\t\u001cu\u0013\u0013\u001aUD\u0013_<P\u0106\b\u0014\u0018R\u00172\u001e\t]\r";
                                v5 = 76;
                                continue block112;
                            }
                            case 76: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 78;
                                v4 = "d\u0016\u0010\t\u001cu\u0013\u0013\u001aUD\u0013_<P\u0106\b\u0014\u0018R\u00172\u001e\t]\r";
                                v5 = 77;
                                continue block112;
                            }
                            case 77: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 79;
                                v4 = "r\b\r\u0012N\u0017\r\u0017\u0014PRZ\n\rXV\u000e\u0016\u0013[\u0017\u0011\u001a\u0004\u001c^\u001e\f";
                                v5 = 78;
                                continue block112;
                            }
                            case 78: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 80;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u001cRV\u0012\u000b\u001cN\u0017\u0011\u001e\u000fHC\u001b_\u0004S\\";
                                v5 = 79;
                                continue block112;
                            }
                            case 79: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 81;
                                v4 = "\u0017\u0013\u001b]P^Z\u001e\u0013]_\u000e\u001e\u000f\u001c\\\u001b\r\tHVZ\u0006\u0012W\u0019Z4\u001cNC\u000e\u001e]OR\b\u000b\u0014Z^\u0011\u001e]^B\u0016\n\u0013XBA_\u0004][\u0014\u014e\u0007\u001c\u00c1\u0000\u001a\u0011\u001cV\u0014\u001e\u0015HV\b_\u001fI[\u000f\u0011\u001cQV\u001e\u014e\\";
                                v5 = 80;
                                continue block112;
                            }
                            case 80: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 82;
                                v4 = "y\u0015\u000b]UZ\n\u0013\u0018QR\u0014\u000b\u0018X\u0017#\u001a\t\u001cQ\u0015\rG";
                                v5 = 81;
                                continue block112;
                            }
                            case 81: {
                                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                                v1 = v2;
                                v2 = v2;
                                v3 = 83;
                                v4 = "\u0017\u0013\f\u0014Q[\u0013_\u0013YD\u0014\u001a]WV\b\u000b\t]\u0017\u0018\n\u0011IY\u001b\u0012\u001cX^T";
                                v5 = 82;
                                continue block112;
                            }
                            case 82: 
                        }
                        break;
                    }
                    break block120;
lbl675:
                    // 3 sources

                    block113: while (true) {
                        v6 = PKCS11Ops.a(PKCS11Ops.a(v7));
                        switch (v8) {
                            default: {
                                v9 = v9.append(System.getenv(v6));
                                v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v8 = 0;
                                continue block113;
                            }
                            case 0: {
                                v9 = v9.append(System.getProperty(v6));
                                v7 = "D\u0003\f\tYZIM";
                                v8 = 1;
                                continue block113;
                            }
                            case 1: {
                                v9 = v9.append(v6);
                                v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v8 = 2;
                                continue block113;
                            }
                            case 2: {
                                var1_2 = v9.append(System.getProperty(v6)).toString();
                                PKCS11Ops.b.add(var1_2);
                                return;
                            }
                            case 3: {
                                v9 = v9.append(System.getProperty(v6));
                                v7 = "B\t\r";
                                v8 = 4;
                                continue block113;
                            }
                            case 4: {
                                v9 = v9.append(v6);
                                v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v8 = 5;
                                continue block113;
                            }
                            case 5: {
                                v9 = v9.append(System.getProperty(v6));
                                v7 = "[\u0015\u001c\u001cP";
                                v8 = 6;
                                continue block113;
                            }
                            case 6: {
                                v9 = v9.append(v6);
                                v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v8 = 7;
                                continue block113;
                            }
                            case 7: {
                                v9 = v9.append(System.getProperty(v6));
                                v7 = "[\u0013\u001d";
                                v8 = 8;
                                continue block113;
                            }
                            case 8: {
                                v9 = v9.append(v6);
                                v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v8 = 9;
                                continue block113;
                            }
                            case 9: {
                                var1_1 = v9.append(System.getProperty(v6)).toString();
                                PKCS11Ops.b.add(var1_1);
                                v10 = new StringBuilder();
                                v11 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v12 = -1;
                                break block118;
                            }
                            case 10: {
                                v9 = v9.append(System.getProperty(v6));
                                v7 = "[\u0013\u001d";
                                v8 = 11;
                                continue block113;
                            }
                            case 11: {
                                v9 = v9.append(v6);
                                v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                                v8 = 12;
                                continue block113;
                            }
                            case 12: {
                                var1_3 = v9.append(System.getProperty(v6)).toString();
                                PKCS11Ops.b.add(var1_3);
                                return;
                            }
                        }
                        break;
                    }
                }
                v1[v3] = PKCS11Ops.a(PKCS11Ops.a(v4));
                PKCS11Ops.e = v2;
                PKCS11Ops.b = new ArrayList<String>();
                PKCS11Ops.JAVA_VERSION = null;
                v13 = "]\u001b\t\u001c\u0012D\n\u001a\u001eUQ\u0013\u001c\u001cH^\u0015\u0011SJR\b\f\u0014SY";
                v14 = -1;
                block114: while (true) {
                    v15 = PKCS11Ops.a(PKCS11Ops.a(v13));
                    switch (v14) {
                        default: {
                            PKCS11Ops.JAVA_VERSION = System.getProperty(v15);
                            v13 = "X\tQ\u0013]Z\u001f";
                            v14 = 0;
                            continue block114;
                        }
                        case 0: 
                    }
                    break;
                }
                v16 = var0 = System.getProperty(v15).toLowerCase();
                v17 = "@\u0013\u0011\u0019S@\t";
                v18 = -1;
                block115: while (true) {
                    v19 = PKCS11Ops.a(PKCS11Ops.a(v17));
                    switch (v18) {
                        default: {
                            if (v16.indexOf(v19) < 0) break;
                            v9 = new StringBuilder();
                            v7 = "d\u0003\f\tYZ(\u0010\u0012H";
                            v8 = -1;
                            ** GOTO lbl675
                        }
                        case 0: {
                            if (v16.indexOf(v19) >= 0) {
                                break block115;
                            }
                            break block119;
                        }
                    }
                    v16 = var0;
                    v17 = "Z\u001b\u001c";
                    v18 = 0;
                }
                v9 = new StringBuilder();
                v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                v8 = 3;
                ** GOTO lbl675
            }
            v9 = new StringBuilder();
            v7 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
            v8 = 10;
            ** while (true)
        }
        block116: while (true) {
            v20 = PKCS11Ops.a(PKCS11Ops.a(v11));
            switch (v12) {
                default: {
                    v10 = v10.append(System.getProperty(v20));
                    v11 = "B\t\r";
                    v12 = 0;
                    continue block116;
                }
                case 0: {
                    v10 = v10.append(v20);
                    v11 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                    v12 = 1;
                    continue block116;
                }
                case 1: {
                    v10 = v10.append(System.getProperty(v20));
                    v11 = "[\u0013\u001d";
                    v12 = 2;
                    continue block116;
                }
                case 2: {
                    v10 = v10.append(v20);
                    v11 = "Q\u0013\u0013\u0018\u0012D\u001f\u000f\u001cNV\u000e\u0010\u000f";
                    v12 = 3;
                    continue block116;
                }
                case 3: 
            }
            break;
        }
        var2_4 = v10.append(System.getProperty(v20)).toString();
        PKCS11Ops.b.add(var2_4);
    }

    private static char[] a(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x3C);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 55;
                            break;
                        }
                        case 1: {
                            n6 = 122;
                            break;
                        }
                        case 2: {
                            n6 = 127;
                            break;
                        }
                        case 3: {
                            n6 = 125;
                            break;
                        }
                        default: {
                            n6 = 60;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

