/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.ModulusFinderFromObjectID;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.PublicKeyFinderWithLabel;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.ISmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.EncryptionSchemeFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.IEncryptionScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.ISignatureScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.SignatureSchemeFactory;

public class SmartOp {
    private long a;
    private CardType b;
    private String c;
    private static Logger d;
    private static final String[] e;

    public SmartOp(long aSlotID, CardType aCardType, String aPassword) {
        this();
        this.initialize(aSlotID, aCardType, aPassword);
    }

    public SmartOp() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
        }
        catch (LE lE) {
            throw new RuntimeException(e[2] + lE.getMessage(), lE);
        }
    }

    public void initialize(long aSlotID, CardType aCardType, String aPassword) {
        this.a = aSlotID;
        this.b = aCardType;
        this.c = aPassword;
    }

    public static boolean _in(long aElement, long[] aList) {
        int n = CardType.b;
        if (aList == null) {
            return false;
        }
        for (int i = 0; i < aList.length; ++i) {
            if (aList[i] != aElement) continue;
            return true;
        }
        return false;
    }

    public static Pair<Long, CardType> findCardTypeAndSlot(Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n = list.size();
            String string = "";
            CardTerminal cardTerminal = null;
            while (true) {
                if (n == 0) {
                    throw new SmartCardException(e[58]);
                }
                if (n == 1) {
                    string = list.get(0).getName();
                    cardTerminal = list.get(0);
                    break;
                }
                int n2 = 0;
                n2 = SmartOp.a(list);
                if (n2 != -1) {
                    string = list.get(n2).getName();
                    cardTerminal = terminalFactory.terminals().getTerminal(string);
                    break;
                }
                list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
                n = list.size();
            }
            Card card = cardTerminal.connect("*");
            String string2 = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string2, aApp);
            if (cardType == CardType.UNKNOWN) {
                return new Pair(null, (Object)cardType);
            }
            Long l = null;
            try {
                l = SmartOp.a(cardType, string);
            }
            catch (Exception exception) {
                d.warn(e[59], (Throwable)exception);
                l = null;
            }
            return new Pair((Object)l, (Object)cardType);
        }
        catch (SmartCardException smartCardException) {
            throw smartCardException;
        }
        catch (Exception exception) {
            throw new SmartCardException(e[57], exception);
        }
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots(Application aApp) throws SmartCardException {
        int n = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n2 = list.size();
            if (n2 == 0) {
                throw new SmartCardException(e[13]);
            }
            ArrayList<Pair<Long, CardType>> arrayList = new ArrayList<Pair<Long, CardType>>();
            for (CardTerminal cardTerminal : list) {
                block11: {
                    CardType cardType;
                    String string;
                    block10: {
                        string = cardTerminal.getName();
                        Card card = cardTerminal.connect("*");
                        String string2 = SmartOp.a(card.getATR().getBytes());
                        card.disconnect(false);
                        cardType = SmartCard.findCardType(string2, aApp);
                        if (cardType != CardType.UNKNOWN) break block10;
                        arrayList.add((Pair<Long, CardType>)new Pair(null, (Object)cardType));
                        if (n == 0) break block11;
                    }
                    Long l = null;
                    try {
                        l = SmartOp.a(cardType, string);
                    }
                    catch (Exception exception) {
                        d.warn(e[14], (Throwable)exception);
                        l = null;
                    }
                    arrayList.add((Pair<Long, CardType>)new Pair((Object)l, (Object)cardType));
                }
                if (n == 0) continue;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new SmartCardException(e[12], exception);
        }
    }

    public static Pair<Long, CardType> findCardTypeAndSlot() throws SmartCardException {
        return SmartOp.findCardTypeAndSlot(Application.ESIGNATURE);
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots() throws SmartCardException {
        return SmartOp.findCardTypesAndSlots(Application.ESIGNATURE);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state) throws CardException {
        return SmartOp.a(terminalFactory, state, true);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state, boolean bl) throws CardException {
        ArrayList<CardTerminal> arrayList = new ArrayList();
        try {
            arrayList = terminalFactory.terminals().list(state);
        }
        catch (CardException cardException) {
            block11: {
                if (!bl || cardException.getCause() == null) break block11;
                if (!e[52].equals(cardException.getCause().getMessage())) break block11;
                SmartOp.a();
                return SmartOp.a(terminalFactory, state, false);
            }
            if (!cardException.getCause().getMessage().contains(e[53])) {
                throw cardException;
            }
        }
        return arrayList;
    }

    private static void a() {
        try {
            d.warn(e[23]);
            Class<?> clazz = Class.forName(e[27]);
            Field field = clazz.getDeclaredField(e[21]);
            field.setAccessible(true);
            if (field.getLong(clazz) != 0L) {
                Class<?> clazz2 = Class.forName(e[28]);
                Method method = clazz2.getDeclaredMethod(e[29], Integer.TYPE);
                method.setAccessible(true);
                Field field2 = clazz2.getDeclaredField(e[25]);
                field2.setAccessible(true);
                long l = (Long)method.invoke(clazz2, field2.getInt(clazz2));
                field.setLong(clazz, l);
                TerminalFactory terminalFactory = TerminalFactory.getDefault();
                CardTerminals cardTerminals = terminalFactory.terminals();
                Field field3 = clazz.getDeclaredField(e[26]);
                field3.setAccessible(true);
                Class<?> clazz3 = Class.forName(e[30]);
                Method method2 = clazz3.getDeclaredMethod(e[31], new Class[0]);
                method2.invoke(field3.get(cardTerminals), new Object[0]);
                Field field4 = clazz.getDeclaredField(e[32]);
                field4.setAccessible(true);
                method2.invoke(field4.get(cardTerminals), new Object[0]);
                d.info(e[24]);
            }
        }
        catch (Exception exception) {
            d.warn(e[22], (Throwable)exception);
        }
    }

    private static int a(List<CardTerminal> list) {
        int n = CardType.b;
        int n2 = list.size();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = list.get(i).getName();
            if (n == 0) continue;
        }
        return SmartOp.secenekSor(null, null, stringArray, e[1], new String[]{SmartCardI18n.getMsg(E_KEYS.OK, null)});
    }

    private static long a(CardType cardType, String string) throws PKCS11Exception, IOException {
        int n = CardType.b;
        SmartCard smartCard = new SmartCard(cardType);
        long[] lArray = smartCard.getTokenPresentSlotList();
        long l = 0L;
        for (long l2 : lArray) {
            String string2 = new String(smartCard.getSlotInfo((long)l2).slotDescription).trim();
            if (!string.contains(string2)) continue;
            l = l2;
            if (n == 0) break;
            if (n == 0) continue;
            break;
        }
        return l;
    }

    private static String a(byte[] byArray) {
        int n = CardType.b;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (byArray == null) {
            return e[35];
        }
        if (byArray.length == 0) {
            return e[36];
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        int n2 = 0;
        for (byte by : byArray) {
            byArray2[n2++] = (byte)cArray[(by & 0xF0) >> 4];
            byArray2[n2++] = (byte)cArray[by & 0xF];
            if (n == 0) continue;
            break;
        }
        return new String(byArray2);
    }

    public static String[] getCardTerminals() throws SmartCardException {
        int n = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).getName();
                if (n == 0) continue;
            }
            return stringArray;
        }
        catch (CardException cardException) {
            throw new SmartCardException(e[49], cardException);
        }
    }

    public static String[] getCardATRs() throws SmartCardException {
        int n = CardType.b;
        String[] stringArray = null;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String string;
                CardTerminal cardTerminal = list.get(i);
                Card card = cardTerminal.connect("*");
                stringArray[i] = string = StringUtil.toHexString((byte[])card.getATR().getBytes());
                if (n == 0) continue;
                break;
            }
        }
        catch (CardException cardException) {
            throw new SmartCardException(e[48], cardException);
        }
        return stringArray;
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal, Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminal cardTerminal = terminalFactory.terminals().getTerminal(terminal);
            Card card = cardTerminal.connect("*");
            String string = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string, aApp);
            Long l = null;
            try {
                if (cardType != CardType.UNKNOWN) {
                    l = SmartOp.a(cardType, terminal);
                }
            }
            catch (Exception exception) {
                d.warn(e[17], (Throwable)exception);
                l = null;
            }
            Pair pair = new Pair((Object)l, (Object)cardType);
            return pair;
        }
        catch (Exception exception) {
            throw new SmartCardException(e[18], exception);
        }
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal) throws SmartCardException {
        return SmartOp.getSlotAndCardType(terminal, Application.ESIGNATURE);
    }

    public String getCardSerialNumber() throws PKCS11Exception, IOException {
        SmartCard smartCard = new SmartCard(this.b);
        return new String(smartCard.getTokenInfo((long)this.a).serialNumber).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importCertificateAndKey(String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.importCertificateAndKey(l, aCertLabel, aKeyLabel, aPrivKey, aCert);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            bl = smartCard.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertData, aSignOrEnc);
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importKeyPair(String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.importKeyPair(l, aLabel, aKeyPair, aSubject, aIsSign, aIsEncrypt);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readCertificate(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.readCertificate(l, aLabel);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getSignCertificates() throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.getSignatureCertificates(l);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getEncryptCertificates() throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.getEncryptionCertificates(l);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importCertificate(String aCertLabel, X509Certificate aCert) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.importCertificate(l, aCertLabel, aCert);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(e[47])) throw pKCS11Exception;
            smartCard.login(l, this.c);
            smartCard.importCertificate(l, aCertLabel, aCert);
            smartCard.logout(l);
            if (CardType.b == 0) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPrivateData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            List<byte[]> list2 = smartCard.readPrivateData(l, aLabel);
            smartCard.logout(l);
            list = list2;
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPublicData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            List<byte[]> list2;
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = list2 = smartCard.readPublicData(l, aLabel);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePrivateData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.writePrivateData(l, aLabel, aData);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePublicData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.writePublicData(l, aLabel, aData);
            smartCard.logout(l);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.warn(e[34], (Throwable)pKCS11Exception);
            if (!pKCS11Exception.getMessage().equals(e[33])) return;
            smartCard.login(l, this.c);
            smartCard.writePublicData(l, aLabel, aData);
            smartCard.logout(l);
            return;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deletePrivateData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.deletePrivateData(l, aLabel);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePublicData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.deletePublicData(l, aLabel);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(e[8])) throw pKCS11Exception;
            smartCard.login(l, this.c);
            smartCard.deletePublicData(l, aLabel);
            smartCard.logout(l);
            if (CardType.b == 0) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isObjectExist(String aLabel, boolean aIsPrivate) throws IOException, PKCS11Exception {
        boolean bl;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            boolean bl2;
            block9: {
                block8: {
                    smartCard = new SmartCard(this.b);
                    l = smartCard.openSession(this.a);
                    if (!aIsPrivate) break block8;
                    smartCard.login(l, this.c);
                    bl2 = smartCard.isObjectExist(l, aLabel);
                    smartCard.logout(l);
                    if (CardType.b == 0) break block9;
                }
                bl2 = smartCard.isObjectExist(l, aLabel);
            }
            bl = bl2;
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCardEmpty() throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            bl = smartCard.isAnyObjectExist(l);
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateKeyPair(String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        int n = CardType.b;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(e[15]);
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            boolean bl = smartCard.isObjectExist(l, aKeyLabel);
            if (bl) {
                throw new SmartCardException(aKeyLabel + e[16]);
            }
            smartCard.createKeyPair(l, aKeyLabel, aParamSpec, aIsSign, aIsEncrypt);
            smartCard.logout(l);
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
        if (n != 0) {
            SmartCardException.b = !SmartCardException.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeySpec getPublicKeySpec(String aKeyLabel) throws PKCS11Exception, IOException, SmartCardException {
        KeySpec keySpec;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            KeySpec keySpec2;
            if (this.b == null) {
                throw new SmartCardException(e[19]);
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            keySpec = keySpec2 = smartCard.readPublicKeySpec(l, aKeyLabel);
            if (smartCard == null) return keySpec;
            if (l == -1L) return keySpec;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return keySpec;
    }

    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, IOException, SmartCardException {
        return this.sign(aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public byte[] sign(String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        return this.sign(aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg, AlgorithmParameterSpec aParams) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(e[20]);
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l, this.a, aCertSerialNo, aToBeSigned, aSigningAlg, aParams);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanacak);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray2 = aSC.signDataWithKeyID(aSessionID, l, cK_MECHANISM, byArray);
            return byArray2;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[11], aSC.getCardType(), aSlotID, StringUtil.toHexString((byte[])aCertSerialNo), aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[10], aSC.getCardType(), aSlotID, StringUtil.toHexString((byte[])aCertSerialNo), aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParams) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        SmartCard smartCard = null;
        long l = -1L;
        if (this.b == null) {
            throw new SmartCardException(e[66]);
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l, this.a, aAnahtarAdi, aImzalanacak, aSigningAlg, aParams);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanacak);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray2 = aSC.signData(aSessionID, aAnahtarAdi, byArray, cK_MECHANISM);
            return byArray2;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[37], aSC.getCardType(), aSlotID, aAnahtarAdi, aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[38], aSC.getCardType(), aSlotID, aAnahtarAdi, aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(String aAnahtarAdi, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        boolean bl;
        ISmartCard iSmartCard = null;
        long l = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(e[5]);
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l = iSmartCard.openSession(this.a);
            iSmartCard.login(l, this.c);
            boolean bl2 = SmartOp.verify(iSmartCard, l, this.a, aAnahtarAdi, aImzalanan, aDogrulanacak, aSigningAlg);
            iSmartCard.logout(l);
            bl = bl2;
            if (iSmartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            iSmartCard.closeSession(l);
            throw throwable;
        }
        iSmartCard.closeSession(l);
        return bl;
    }

    public static boolean verify(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        try {
            PublicKeyFinderWithLabel publicKeyFinderWithLabel = new PublicKeyFinderWithLabel(aSC, aSessionID, aKeyLabel);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(false, aSigningAlg, null, lArray, publicKeyFinderWithLabel);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanan);
            boolean bl = false;
            try {
                aSC.verifyData(aSessionID, aKeyLabel, byArray, aDogrulanacak, cK_MECHANISM.mechanism);
                bl = true;
            }
            catch (PKCS11Exception pKCS11Exception) {
                d.error(e[63], (Throwable)pKCS11Exception);
            }
            return bl;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[62], aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[64], aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encrypt(String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        ISmartCard iSmartCard = null;
        long l = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(e[54]);
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l = iSmartCard.openSession(this.a);
            iSmartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.encrypt(iSmartCard, l, aAnahtarAdi, aSifrelenecek, aAlgoritma, aParametreler);
            iSmartCard.logout(l);
            byArray = byArray2;
            if (iSmartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            iSmartCard.closeSession(l);
            throw throwable;
        }
        iSmartCard.closeSession(l);
        return byArray;
    }

    public static byte[] encrypt(ISmartCard aSC, long aSessionID, String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(true, aAlgoritma, aParametreler, aSC, aSessionID, modulusFinderFromObjectID);
            byte[] byArray = aSC.encryptData(aSessionID, aAnahtarAdi, iEncryptionScheme.getResult(aSifrelenecek), iEncryptionScheme.getMechanism());
            return byArray;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[3], aSC.getCardType(), aAnahtarAdi, aAlgoritma), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[4], aSC.getCardType(), aAnahtarAdi, aAlgoritma), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(String aAnahtarAdi, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(e[65]);
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.decrypt((ISmartCard)smartCard, l, this.a, aAnahtarAdi, aCozulecek, aAlgoritma, aParam);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    @Deprecated
    public byte[] decrypt(String aKeyLabel, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, byte[] aCertSerialNo, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l, aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, String aKeyLabel, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l, aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        int n;
        block11: {
            n = CardType.b;
            if (this.b == null) {
                throw new SmartCardException(e[0]);
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            SmartCard smartCard = null;
            long l = -1L;
            try {
                smartCard = new SmartCard(this.b);
                l = smartCard.openSession(this.a);
                smartCard.login(l, this.c);
                byte[] byArray2 = SmartOp.decrypt((ISmartCard)smartCard, l, this.a, aCertSerialNo, aCozulecek, aAlgoritma, aParam);
                smartCard.logout(l);
                byArray = byArray2;
                if (smartCard == null || l == -1L) break block11;
            }
            catch (Throwable throwable) {
                if (smartCard == null) throw throwable;
                if (l == -1L) throw throwable;
                smartCard.closeSession(l);
                throw throwable;
            }
            smartCard.closeSession(l);
        }
        if (!SmartCardException.b) return byArray;
        CardType.b = ++n;
        return byArray;
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, byte[] aCertSerialNo, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptDataWithCertSerialNo(aSessionID, aCertSerialNo, iEncryptionScheme.getMechanism(), aCozulecek);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[7], aSC.getCardType(), aSlot, StringUtil.toHexString((byte[])aCertSerialNo), aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[6], aSC.getCardType(), aSlot, StringUtil.toHexString((byte[])aCertSerialNo), aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, String aAnahtarAdi, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptData(aSessionID, aAnahtarAdi, aCozulecek, iEncryptionScheme.getMechanism());
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[50], aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[51], aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] wrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String wrapperKeyLabel, String labelOfKeyToWrap, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPublicKeyObjIDFromPublicKeyLabel(aSessionID, wrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.wrapKey(aSessionID, iEncryptionScheme.getMechanism(), wrapperKeyLabel, labelOfKeyToWrap);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[61], aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[60], aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static void unwrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String unwrapperKeyLabel, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, unwrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            aSC.unwrapKey(aSessionID, iEncryptionScheme.getMechanism(), unwrapperKeyLabel, wrappedKey, unwrappedKeyTemplate);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(e[55], aSC.getCardType(), aSlot, unwrapperKeyLabel), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(e[56], aSC.getCardType(), aSlot, unwrapperKeyLabel), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public long getSlot() {
        return this.a;
    }

    public CardType getCardType() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void formatToken(String aSOpin, String aNewPIN, String aLabel) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.formatToken(aSOpin, aNewPIN, aLabel, (int)this.a);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePassword(String aOldPass, String aNewPass) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.changePassword(aOldPass, aNewPass, l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePuk(byte[] aSOPin, byte[] aNewSOPin) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.setSOPin(aSOPin, aNewSOPin, l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    public static long findSlotNumber(CardType aCardType) throws PKCS11Exception, IOException, SmartCardException {
        return SmartOp.findSlotNumber(aCardType, e[9]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long findSlotNumber(CardType aCardType, String message) throws PKCS11Exception, IOException, SmartCardException {
        int n = CardType.b;
        int n2 = 1;
        do {
            Object[] objectArray;
            JComboBox<String> jComboBox;
            SmartCard smartCard;
            long[] lArray;
            int n3;
            if ((n3 = (lArray = (smartCard = new SmartCard(aCardType)).getTokenPresentSlotList()).length) == 0) {
                throw new SmartCardException(e[39]);
            }
            if (n3 == 1) {
                return lArray[0];
            }
            String[] stringArray = new String[n3];
            int n4 = lArray.length;
            for (int i = 0; i < n4; ++i) {
                long l = lArray[i];
                String string = "";
                try {
                    string = string + " " + new String(smartCard.getSlotInfo((long)l).slotDescription).trim();
                }
                catch (Exception exception) {
                    d.warn(e[43], (Throwable)exception);
                }
                try {
                    string = string + " " + new String(smartCard.getTokenInfo((long)l).label).trim().split("\u0000")[0];
                }
                catch (Exception exception) {
                    d.warn(e[42], (Throwable)exception);
                }
                stringArray[i] = string;
                if (n == 0) continue;
            }
            if ((n2 = JOptionPane.showOptionDialog(null, jComboBox = new JComboBox<String>(stringArray), message, 2, -1, null, objectArray = new String[]{e[45], e[41], e[46]}, objectArray[0])) == 0) {
                return lArray[jComboBox.getSelectedIndex()];
            }
            if (n2 != 2) continue;
            throw new SmartCardException(e[44]);
        } while (n2 == 1 && n == 0);
        throw new ESYARuntimeException(e[40] + n2);
    }

    public static int secenekSor(Component aParent, Icon aIcon, String[] aSecenekList, String aBaslik, String[] aOptions) {
        JComboBox<String> jComboBox = new JComboBox<String>(aSecenekList);
        int n = JOptionPane.showOptionDialog(aParent, jComboBox, aBaslik, 2, -1, null, aOptions, aOptions[0]);
        if (n == 1) {
            return -1;
        }
        return jComboBox.getSelectedIndex();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[67];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "l\fR6RV\u001dEro\\MN'jCC";
        int n2 = -1;
        block74: while (true) {
            char[] cArray;
            block79: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block78: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block78;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block79;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 47;
                                break;
                            }
                            case 1: {
                                n8 = 109;
                                break;
                            }
                            case 2: {
                                n8 = 32;
                                break;
                            }
                            case 3: {
                                n8 = 82;
                                break;
                            }
                            default: {
                                n8 = 6;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "`\u0006U+sL\u0018\u0000\u001eo\\\u0019E!o";
                    n2 = 0;
                    continue block74;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "c\u0004S3h\\MK=h[\u001fO>s\u000f\u000fA!g]\u0004S;|\u0001M";
                    n2 = 1;
                    continue block74;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f,N3n[\fRrGK\u015c\u001ar}\u001e\u0010\frGC\nO o[\u0005Mh&T_]";
                    n2 = 2;
                    continue block74;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f,N3n[\fRrGK\u015c\u001ar}\u001e\u0010\frGC\nO o[\u0005Mh&T_]";
                    n2 = 3;
                    continue block74;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "l\fR6RV\u001dEro\\MN'jCC";
                    n2 = 4;
                    continue block74;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mc7t[>E oN\u0001\u001ar}\u001d\u0010\frGC\nO o[\u0005Mh&T^]";
                    n2 = 5;
                    continue block74;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mc7t[>E oN\u0001\u001ar}\u001d\u0010\frGC\nO o[\u0005Mh&T^]";
                    n2 = 6;
                    continue block74;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "l&r\rS|(r\rH`9\u007f\u001eIh*e\u0016Yf#";
                    n2 = 7;
                    continue block74;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "|\u0001O&&c\u0004S&";
                    n2 = 8;
                    continue block74;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mc7t[>E oN\u0001\u001ar}\u001d\u0010\frGC\nO o[\u0005Mh&T^]";
                    n2 = 9;
                    continue block74;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mc7t[>E oN\u0001\u001ar}\u001d\u0010\frGC\nO o[\u0005Mh&T^]";
                    n2 = 10;
                    continue block74;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "n9rrbJ\u0003\u00009g]\u0019\u0000&o_\u0004\u00000sC\u0000Aro\\\u0001E?oA\tErnN\u0019AriC\u0018S&s\u0001";
                    n2 = 11;
                    continue block74;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "d\fR&&[\fK;jFMO9sV\u0018C'&M\u0018L'hN\u0000A6o\u0001";
                    n2 = 12;
                    continue block74;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "x\fR<oA\n\u0000;h\u000f>M3t[\"P";
                    n2 = 13;
                    continue block74;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "l\fR6RV\u001dEro\\MN'jCC";
                    n2 = 14;
                    continue block74;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "\u000f\bX;u[\u001e\u0000;h\u000f\u000eA b\u0001";
                    n2 = 15;
                    continue block74;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "x\fR<oA\n\u0000;h\u000f>M3t[\"P";
                    n2 = 16;
                    continue block74;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "l\fNrh@\u0019\u00003eL\bS!&[\bR?oA\fL";
                    n2 = 17;
                    continue block74;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "l\fR6RV\u001dEro\\MN'jCC";
                    n2 = 18;
                    continue block74;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "l\fR6RV\u001dEro\\MN'jCC";
                    n2 = 19;
                    continue block74;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "L\u0002N&cW\u0019i6";
                    n2 = 20;
                    continue block74;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "z\u0003A0jJMT=&]\bF c\\\u0005\u00001g]\t\u0000&c]\u0000I<gC\u001e";
                    n2 = 21;
                    continue block74;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "|\u0000A r\u000f\u000eA b\u000f\u0019E kF\u0003A>&]\bT oJ\u001bEr`N\u0004L7b\u0001Mt7tB\u0004N3j\u000f\u0000A+&M\b\u0000 cB\u0002V7b\u0001Mt \u007fF\u0003Grr@MR7`]\bS:&L\fR6&[\bR?oA\fLre@\u0003T7~[";
                    n2 = 22;
                    continue block74;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "|\u0018C1c\\\u001eF'jC\u0014\u0000 cI\u001fE!nJ\t\u00001g]\t\u0000&c]\u0000I<gCMC=h[\bX&";
                    n2 = 23;
                    continue block74;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "|.a\u0000Bp>c\u001dVj2u\u0001C}";
                    n2 = 24;
                    continue block74;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "[\bR?oA\fL!";
                    n2 = 25;
                    continue block74;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "\\\u0018N|uJ\u000eU o[\u0014\u000e!kN\u001fT1g]\tI=(\u007f.s\u0011RJ\u001fM;hN\u0001S";
                    n2 = 26;
                    continue block74;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "\\\u0018N|uJ\u000eU o[\u0014\u000e!kN\u001fT1g]\tI=(\u007f.s\u0011";
                    n2 = 27;
                    continue block74;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "|.A bj\u001eT3dC\u0004S:E@\u0003T7~[";
                    n2 = 28;
                    continue block74;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "E\fV3(Z\u0019I>(b\fP";
                    n2 = 29;
                    continue block74;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "L\u0001E3t";
                    n2 = 30;
                    continue block74;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "[\bR?oA\fL!";
                    n2 = 31;
                    continue block74;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "l&r\rS|(r\rH`9\u007f\u001eIh*e\u0016Yf#";
                    n2 = 32;
                    continue block74;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "x\fR<oA\n\u0000;h\u000f>M3t[\"P";
                    n2 = 33;
                    continue block74;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "A\u0018L>";
                    n2 = 34;
                    continue block74;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "J\u0000P&\u007f\u000f\fR gV";
                    n2 = 35;
                    continue block74;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Ma<gG\u0019A &n\t\u0111h&T_]~&n\u0001G=tF\u0019H?<\u000f\u0016\u0013/";
                    n2 = 36;
                    continue block74;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Ma<gG\u0019A &n\t\u0111h&T_]~&n\u0001G=tF\u0019H?<\u000f\u0016\u0013/";
                    n2 = 37;
                    continue block74;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = "a\u0002\u00001g]\t\u0000\"tJ\u001eE<r";
                    n2 = 38;
                    continue block74;
                }
                case 38: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 40;
                    string2 = "z\u0003K<iX\u0003\u0000\u0013h\\\u001aE <";
                    n2 = 39;
                    continue block74;
                }
                case 39: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 41;
                    string2 = "}\bF c\\\u0005";
                    n2 = 40;
                    continue block74;
                }
                case 40: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 42;
                    string2 = "x\fR<oA\n\u0000;h\u000f>M3t[\"P";
                    n2 = 41;
                    continue block74;
                }
                case 41: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 43;
                    string2 = "x\fR<oA\n\u0000;h\u000f>M3t[\"P";
                    n2 = 42;
                    continue block74;
                }
                case 42: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 44;
                    string2 = "z\u001eE &k\u0004DrH@\u0019\u0000\u0011n@\u0002S7&n\u0003YrUC\u0002Tr";
                    n2 = 43;
                    continue block74;
                }
                case 43: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 45;
                    string2 = "`&";
                    n2 = 44;
                    continue block74;
                }
                case 44: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 46;
                    string2 = "l\fN1cC";
                    n2 = 45;
                    continue block74;
                }
                case 45: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 47;
                    string2 = "l&r\rS|(r\rH`9\u007f\u001eIh*e\u0016Yf#";
                    n2 = 46;
                    continue block74;
                }
                case 46: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 48;
                    string2 = "l\fNrh@\u0019\u00003eL\bS!&[\bR?oA\fL!";
                    n2 = 47;
                    continue block74;
                }
                case 47: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 49;
                    string2 = "l\fNrh@\u0019\u00003eL\bS!&[\bR?oA\fL!";
                    n2 = 48;
                    continue block74;
                }
                case 48: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 50;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Ma<gG\u0019A &n\t\u0111h&T_]~&n\u0001G=tF\u0019H?<\u000f\u0016\u0013/";
                    n2 = 49;
                    continue block74;
                }
                case 49: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 51;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Ma<gG\u0019A &n\t\u0111h&T_]~&n\u0001G=tF\u0019H?<\u000f\u0016\u0013/";
                    n2 = 50;
                    continue block74;
                }
                case 50: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 52;
                    string2 = "|.a\u0000Bp(\u007f\u0001C};i\u0011Cp>t\u001dV\u007f(d";
                    n2 = 51;
                    continue block74;
                }
                case 51: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 53;
                    string2 = "|.a\u0000Bp(\u007f\u001cIp?e\u0013Bj?s\rGy,i\u001eGm!e";
                    n2 = 52;
                    continue block74;
                }
                case 52: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 54;
                    string2 = "l\fR6RV\u001dEro\\MN'jCC";
                    n2 = 53;
                    continue block74;
                }
                case 53: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 55;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mu<Q]\fP\"c]Ml3dJ\u0001\u001ar}\u001d\u0010";
                    n2 = 54;
                    continue block74;
                }
                case 54: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 56;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mu<Q]\fP\"c]Ml3dJ\u0001\u001ar}\u001d\u0010";
                    n2 = 55;
                    continue block74;
                }
                case 55: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 57;
                    string2 = "n9rrbJ\u0003\u00009g]\u0019\u0000&o_\u0004\u00000sC\u0000Aro\\\u0001E?oA\tErnN\u0019AriC\u0018S&s\u0001";
                    n2 = 56;
                    continue block74;
                }
                case 56: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 58;
                    string2 = "d\fR&&[\fK;jFMO9sV\u0018C'&M\u0018L'hN\u0000A6o\u0001";
                    n2 = 57;
                    continue block74;
                }
                case 57: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 59;
                    string2 = "x\fR<oA\n\u0000;h\u000f>M3t[\"P";
                    n2 = 58;
                    continue block74;
                }
                case 58: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 60;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mw g_\u001dE &c\fB7j\u0015M[`{\u0003Mt=Q]\fPrJN\u000fE><\u000f\u0016\u0013/*\u000f,L5i]\u0004T:k\u0015M[f{";
                    n2 = 59;
                    continue block74;
                }
                case 59: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 61;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Mw g_\u001dE &c\fB7j\u0015M[`{\u0003Mt=Q]\fPrJN\u000fE><\u000f\u0016\u0013/*\u000f,L5i]\u0004T:k\u0015M[f{";
                    n2 = 60;
                    continue block74;
                }
                case 60: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 62;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Ma<gG\u0019A &n\t\u0111h&T_]~&n\u0001G=tF\u0019H?<\u000f\u0016\u0013/";
                    n2 = 61;
                    continue block74;
                }
                case 61: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 63;
                    string2 = "j\u001fR=t\u000f\u0004NrUB\fR&I_";
                    n2 = 62;
                    continue block74;
                }
                case 62: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 64;
                    string2 = "g\fT3'\u000f&A r{\u0004P;<\u000f\u0016\u0010/*\u000f>L=r\u0015M[c{\u0003Ma<gG\u0019A &n\t\u0111h&T_]~&n\u0001G=tF\u0019H?<\u000f\u0016\u0013/";
                    n2 = 63;
                    continue block74;
                }
                case 63: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 65;
                    string2 = "l\fR6RV\u001dEro\\MN'jCC";
                    n2 = 64;
                    continue block74;
                }
                case 64: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 66;
                    string2 = "l\fR6RV\u001dEro\\MN'jCC";
                    n2 = 65;
                    continue block74;
                }
                case 65: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
        d = LoggerFactory.getLogger(SmartOp.class);
    }
}

