/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.apdu;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.AkisException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.UnrecognizedCardException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.UnsupportedVersionException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands.AbstractAkisCommands;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands.CIFFactory;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.AkisKey;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.Algorithm;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.DF_EF;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.KeyType;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.Version;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.CommandTransmitterPCSC;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.ICommandTransmitter;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.PCTerminalHandler;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.TerminalHandler;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.a;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.BaseSmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.LoginException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.RSAPSSSignature;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.SignatureSchemeFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.APDUSigner;

public class APDUSmartCard
implements BaseSmartCard {
    public static int CERT_FID_START;
    public static int CERT_FID_END;
    protected Hashtable<String, Integer> serialCertIndex;
    protected Hashtable<String, Integer> serialKeyID;
    protected List<byte[]> signingCerts;
    protected List<byte[]> encryptionCerts;
    protected TerminalHandler terminalHandler;
    protected AbstractAkisCommands commands;
    protected ICommandTransmitter pcsc;
    protected Card card;
    protected boolean disableSecureMessaging = false;
    String a;
    private static Logger b;
    private String c;
    private static final String[] d;

    public void setCommandLoggingPath(String commandLoggingPath) {
        this.a = commandLoggingPath;
    }

    public void setDisableSecureMessaging(boolean disableSecureMessaging) {
        this.disableSecureMessaging = disableSecureMessaging;
    }

    public static boolean isSupported(String aTerminalName) {
        CardTerminal cardTerminal = TerminalFactory.getDefault().terminals().getTerminal(aTerminalName);
        return APDUSmartCard.isSupported(cardTerminal);
    }

    public static boolean isSupported(String aTerminalName, TerminalHandler aTerminalHandler) {
        Object object;
        boolean bl = TerminalHandler.b;
        try {
            object = aTerminalHandler.listCardTerminals(CardTerminals.State.CARD_PRESENT);
            Iterator<CardTerminal> iterator = object.iterator();
            while (iterator.hasNext()) {
                CardTerminal cardTerminal = iterator.next();
                if (cardTerminal.getName().equals(aTerminalName)) {
                    return APDUSmartCard.isSupported(cardTerminal, aTerminalHandler);
                }
                if (!bl) continue;
                break;
            }
        }
        catch (CardException cardException) {
            b.warn(d[25], (Throwable)cardException);
            return false;
        }
        object = TerminalFactory.getDefault().terminals().getTerminal(aTerminalName);
        return APDUSmartCard.isSupported((CardTerminal)object);
    }

    public static boolean isSupported(CardTerminal aTerminal, TerminalHandler aTerminalHandler) {
        try {
            ICommandTransmitter iCommandTransmitter = aTerminalHandler.getTransmitter(aTerminal);
            return APDUSmartCard.isSupported(iCommandTransmitter);
        }
        catch (CardException cardException) {
            b.error(d[1], (Throwable)cardException);
            return false;
        }
        catch (Exception exception) {
            b.error(d[0], (Throwable)exception);
            return false;
        }
    }

    public static boolean isSupported(CardTerminal aTerminal) {
        try {
            CommandTransmitterPCSC commandTransmitterPCSC = new CommandTransmitterPCSC(aTerminal, false);
            return APDUSmartCard.isSupported((ICommandTransmitter)commandTransmitterPCSC);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            b.error(d[26], (Throwable)noClassDefFoundError);
            return false;
        }
        catch (Exception exception) {
            b.error(d[27], (Throwable)exception);
            return false;
        }
    }

    protected static boolean isSupported(ICommandTransmitter transmitter) {
        try {
            AbstractAkisCommands abstractAkisCommands = CIFFactory.getAkisCIFInstance((ICommandTransmitter)transmitter);
            return abstractAkisCommands != null;
        }
        catch (Exception exception) {
            b.error(d[2], (Throwable)exception);
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            b.error(d[3], (Throwable)noClassDefFoundError);
            return false;
        }
    }

    public APDUSmartCard(TerminalHandler aTerminalHandler) {
        this.terminalHandler = aTerminalHandler;
        this.initialize();
    }

    public APDUSmartCard() {
        this.terminalHandler = new PCTerminalHandler();
        this.initialize();
    }

    protected void initialize() {
        this.serialKeyID = new Hashtable();
    }

    public long[] getSlotList() throws CardException {
        boolean bl = TerminalHandler.b;
        int n = this.a(CardTerminals.State.ALL).size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = i + 1;
            if (!bl) continue;
        }
        return lArray;
    }

    private List<CardTerminal> a(CardTerminals.State state) throws CardException {
        ArrayList<CardTerminal> arrayList = new ArrayList();
        try {
            arrayList = this.terminalHandler.listCardTerminals(state);
        }
        catch (CardException cardException) {
            if (!cardException.getCause().getMessage().contains(d[4])) {
                throw cardException;
            }
        }
        return arrayList;
    }

    public CardTerminal[] getTerminalList() throws CardException {
        List<CardTerminal> list = this.a(CardTerminals.State.ALL);
        return list.toArray(new CardTerminal[0]);
    }

    public void openSession(ICommandTransmitter iCommandTransmitter) throws SmartCardException {
        this.pcsc = iCommandTransmitter;
        this.a();
    }

    public void openSession(CardTerminal aTerminal) throws SmartCardException {
        try {
            this.pcsc = this.terminalHandler.getTransmitter(aTerminal);
        }
        catch (CardException cardException) {
            throw new SmartCardException(cardException);
        }
        this.a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a() throws SmartCardException {
        try {
            this.commands = CIFFactory.getAkisCIFInstance((ICommandTransmitter)this.pcsc);
            if (this.a != null) {
                this.commands.activateCommandLogging(this.a);
            }
            b.debug(d[23] + this.commands.getVersion());
            if (!this.disableSecureMessaging && this.commands.getVersion() != Version.V10_UEKAE && !APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.activateSecureMsging();
            }
            this.commands.selectMF();
            this.commands.selectDFByName(d[21].getBytes(d[20]));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ESYARuntimeException((Throwable)unsupportedEncodingException);
        }
        catch (CardException cardException) {
            throw new SmartCardException(cardException);
        }
        catch (Exception exception) {
            throw new SmartCardException(d[22], exception);
        }
    }

    @Override
    public boolean isSessionActive() {
        try {
            this.commands.getSerial();
            return true;
        }
        catch (AkisException akisException) {
            b.warn(d[16], (Throwable)akisException);
            return false;
        }
        catch (CardException cardException) {
            b.warn(d[15], (Throwable)cardException);
            return false;
        }
    }

    protected List<X509Certificate> readCertificates() throws SmartCardException {
        int n;
        Object object;
        List<DF_EF> list;
        CertificateFactory certificateFactory;
        boolean bl;
        block23: {
            bl = TerminalHandler.b;
            this.serialCertIndex = new Hashtable();
            certificateFactory = null;
            list = new ArrayList();
            try {
                certificateFactory = CertificateFactory.getInstance(d[9]);
                if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                    object = new byte[]{47, 16};
                    for (n = 0; n < 10; ++n) {
                        DF_EF dF_EF = new DF_EF();
                        dF_EF.FID = new byte[2];
                        dF_EF.FID[0] = (byte)object[0];
                        dF_EF.FID[1] = (byte)object[1];
                        list.add(dF_EF);
                        Object object2 = object;
                        object2[1] = (byte)(object2[1] + true);
                        if (!bl) continue;
                        boolean bl2 = SmartCardException.b = !SmartCardException.b;
                    }
                    if (!bl) break block23;
                }
                list = this.commands.dir();
            }
            catch (CertificateException certificateException) {
                throw new SmartCardException(d[10], certificateException);
            }
            catch (AkisException akisException) {
                throw new SmartCardException((Exception)((Object)akisException));
            }
            catch (CardException cardException) {
                throw new SmartCardException(cardException);
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                throw new SmartCardException((Exception)((Object)unsupportedVersionException));
            }
        }
        object = new ArrayList();
        n = 1;
        for (DF_EF dF_EF : list) {
            block24: {
                int n2 = (dF_EF.FID[0] << 8) + dF_EF.FID[1];
                if (n2 < CERT_FID_START || n2 > CERT_FID_END) break block24;
                try {
                    byte[] byArray = this.commands.readFileBySelectingUnderActiveDF(dF_EF.FID);
                    if (byArray == null) {
                        throw new AkisException(27266L);
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    this.serialCertIndex.put(StringUtil.toString((byte[])x509Certificate.getSerialNumber().toByteArray()), n);
                    ++n;
                    object.add(x509Certificate);
                }
                catch (AkisException akisException) {
                    if (akisException.getErrorCode() != 27266L) {
                        throw new SmartCardException((Exception)((Object)akisException));
                    }
                }
                catch (CardException cardException) {
                    throw new SmartCardException(cardException);
                }
                catch (CertificateException certificateException) {
                    b.error(d[11], (Throwable)certificateException);
                }
            }
            if (!bl) continue;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<byte[]> getSignatureCertificates() throws SmartCardException {
        boolean bl = TerminalHandler.b;
        List<X509Certificate> list = this.readCertificates();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (X509Certificate x509Certificate : list) {
            if (x509Certificate.getKeyUsage()[0]) {
                try {
                    arrayList.add(x509Certificate.getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    b.error(d[24], (Throwable)certificateEncodingException);
                }
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b() {
        if (this.serialCertIndex != null) return;
        try {
            this.readCertificates();
            return;
        }
        catch (SmartCardException smartCardException) {
            b.error(d[34], (Throwable)((Object)smartCardException));
        }
    }

    public byte[] sign(byte[] aData, X509Certificate aCertificate, String aSigningAlg) throws SmartCardException, CardException {
        SmartCard.checkLicense();
        this.b();
        return this.sign(aData, aCertificate, aSigningAlg, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] aData, X509Certificate aCertificate, String aSigningAlg, AlgorithmParameterSpec spec) throws CardException, SmartCardException {
        byte[] byArray;
        Object object;
        SmartCard.checkLicense();
        this.b();
        if (!aSigningAlg.contains(d[7])) {
            throw new SmartCardException(d[8]);
        }
        X509Certificate x509Certificate = aCertificate;
        a a2 = new a(this, x509Certificate);
        long[] lArray = this.commands.getMechanisms();
        try {
            object = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, spec, lArray, a2);
            byArray = object.getSignatureInput(aData);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception);
        }
        object = StringUtil.toString((byte[])aCertificate.getSerialNumber().toByteArray());
        Integer n = this.serialKeyID.get(object);
        if (n != null) {
            return this.a(byArray, (byte)n.intValue(), aData, (String)object, x509Certificate, aSigningAlg, spec);
        }
        Integer n2 = this.serialCertIndex.get(object);
        if (n2 == null) {
            return this.a(byArray, aData, (String)object, aCertificate, aSigningAlg, spec);
        }
        n = n2 * 2 - 1;
        try {
            return this.a(byArray, n.byteValue(), aData, (String)object, aCertificate, aSigningAlg, spec);
        }
        catch (Exception exception) {
            b.debug(d[6], (Throwable)exception);
            return this.a(byArray, aData, (String)object, aCertificate, aSigningAlg, spec);
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2, String string, X509Certificate x509Certificate, String string2, AlgorithmParameterSpec algorithmParameterSpec) throws CardException {
        AkisKey[] akisKeyArray;
        boolean bl;
        block7: {
            bl = TerminalHandler.b;
            try {
                if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                    akisKeyArray = new AkisKey[]{new AkisKey(1, KeyType.PRIVATE_RSA), new AkisKey(2, KeyType.PRIVATE_RSA), new AkisKey(3, KeyType.PRIVATE_RSA), new AkisKey(4, KeyType.PRIVATE_RSA), new AkisKey(5, KeyType.PRIVATE_RSA)};
                    if (!bl) break block7;
                }
                akisKeyArray = this.commands.getKeyInfos();
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                throw new CardException(unsupportedVersionException);
            }
        }
        for (AkisKey akisKey : akisKeyArray) {
            if (akisKey.getKeyType() != KeyType.PRIVATE_RSA) continue;
            try {
                return this.a(byArray, akisKey.getKeyID(), byArray2, string, x509Certificate, string2, algorithmParameterSpec);
            }
            catch (Exception exception) {
                b.warn(d[17], (Throwable)exception);
            }
            if (!bl) continue;
        }
        throw new AkisException(27015L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, byte by, byte[] byArray2, String string, X509Certificate x509Certificate, String string2, AlgorithmParameterSpec algorithmParameterSpec) throws CardException {
        byte[] byArray3;
        block13: {
            byArray3 = null;
            try {
                if (string2 == Algorithms.SIGNATURE_RSA_PSS) {
                    if (!APDUSmartCard._in(13L, this.commands.getMechanisms())) {
                        throw new CardException(d[14]);
                    }
                    PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
                    String string3 = pSSParameterSpec.getDigestAlgorithm();
                    Algorithm algorithm = this.a(string3);
                    if (this.a(by)) {
                        byte by2 = (byte)(0xFFFFFF80 | by);
                        this.commands.verify((byte)1, this.c.getBytes(d[13]), false);
                        byArray3 = this.commands.sign(Algorithm.PKCS_PSS, algorithm, by2, byArray);
                    }
                    break block13;
                }
                if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                    if (this.a(by)) {
                        byte by3 = (byte)(0xFFFFFF80 | by);
                        this.commands.verify((byte)1, this.c.getBytes(d[12]), false);
                        byArray3 = this.commands.sign(Algorithm.PKCS_1_5, null, by3, byArray);
                    }
                    break block13;
                }
                byArray3 = this.commands.sign(byArray, by);
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                throw new ESYARuntimeException((Throwable)unsupportedVersionException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ESYARuntimeException((Throwable)unsupportedEncodingException);
            }
        }
        if (this.a(byArray3, byArray2, x509Certificate, string2, algorithmParameterSpec)) {
            this.serialKeyID.put(string, Integer.valueOf(by));
            return byArray3;
        }
        throw new AkisException(25616L);
    }

    private boolean a(byte by) throws CardException, UnsupportedVersionException {
        byte by2 = by;
        boolean bl = this.commands.queryObject(144, by2);
        if (!bl) {
            by2 = (byte)(0xFFFFFF80 | by2);
            bl = this.commands.queryObject(144, by2);
        }
        return bl;
    }

    private Algorithm a(String string) throws CardException {
        if (string == Algorithms.DIGEST_SHA1) {
            return Algorithm.SHA_1;
        }
        if (string == Algorithms.DIGEST_SHA256) {
            return Algorithm.SHA_256;
        }
        throw new CardException(d[5]);
    }

    private boolean a(Exception exception) {
        block8: {
            if (exception instanceof AkisException) {
                block7: {
                    long l = ((AkisException)((Object)exception)).getErrorCode();
                    if (l == 25616L || l == 25625L) break block7;
                    if (l != 27015L) break block8;
                }
                return true;
            }
        }
        return false;
    }

    private boolean a(byte[] byArray, byte[] byArray2, X509Certificate x509Certificate, String string, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            if (string.equals(Algorithms.SIGNATURE_RSA_PSS)) {
                PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
                RSAPSSSignature rSAPSSSignature = new RSAPSSSignature();
                MessageDigest messageDigest = MessageDigest.getInstance(pSSParameterSpec.getDigestAlgorithm());
                messageDigest.update(byArray2);
                byte[] byArray3 = messageDigest.digest();
                messageDigest.reset();
                PSSParameterSpec pSSParameterSpec2 = (PSSParameterSpec)algorithmParameterSpec;
                return rSAPSSSignature.verifySignature(byArray, x509Certificate.getPublicKey(), byArray3, messageDigest, pSSParameterSpec2.getSaltLength());
            }
            String string2 = Algorithms.getDigestAlgOfSignatureAlg((String)string).replaceAll("-", "");
            String string3 = string2 + d[19];
            Signature signature = Signature.getInstance(string3);
            signature.initVerify(x509Certificate);
            signature.update(byArray2);
            return signature.verify(byArray);
        }
        catch (Exception exception) {
            b.warn(d[18], (Throwable)exception);
            return false;
        }
    }

    @Override
    public void openSession(long aSlotID) throws SmartCardException {
        try {
            List<CardTerminal> list = this.a(CardTerminals.State.ALL);
            this.openSession(list.get((int)(aSlotID - 1L)));
        }
        catch (CardException cardException) {
            b.warn(d[38], (Throwable)cardException);
            throw new SmartCardException(d[37]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<byte[]> getEncryptionCertificates() throws SmartCardException {
        boolean bl = TerminalHandler.b;
        List<X509Certificate> list = this.readCertificates();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (X509Certificate x509Certificate : list) {
            block10: {
                if (!x509Certificate.getKeyUsage()[2]) {
                    if (x509Certificate.getKeyUsage()[3]) {
                    }
                    break block10;
                }
                arrayList.add(x509Certificate.getEncoded());
                catch (SmartCardException smartCardException) {
                    throw smartCardException;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    b.error(d[33], (Throwable)certificateEncodingException);
                }
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void login(String aCardPIN) throws SmartCardException, LoginException {
        try {
            if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.verify((byte)1, aCardPIN.getBytes(d[29]), false);
                this.c = aCardPIN;
                if (!TerminalHandler.b) return;
            }
            this.commands.verify(aCardPIN.getBytes(d[30]), false);
            return;
        }
        catch (AkisException akisException) {
            if (APDUSmartCard.isVersion20(this.commands.getVersion()) ? akisException.getErrorCode() == 27011L : akisException.getErrorCode() == 27012L) {
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.PIN_LOCKED, new String[0]), akisException, false, true);
            }
            if ((akisException.getErrorCode() & 0x63C0L) != 25536L) return;
            if (akisException.getErrorCode() == 25536L) {
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.PIN_LOCKED, new String[0]), akisException, false, true);
            }
            if (akisException.getErrorCode() != 25537L) throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN, new String[0]), akisException, false, false);
            throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN_FINAL_TRY, new String[0]), akisException, true, false);
        }
        catch (CardException cardException) {
            throw new SmartCardException(cardException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ESYARuntimeException((Throwable)unsupportedEncodingException);
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            throw new SmartCardException((Exception)((Object)unsupportedVersionException));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void logout() throws SmartCardException {
        try {
            if (!APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.logout();
                if (!TerminalHandler.b) return;
            }
            this.commands.selectMF();
            this.commands.selectDFByName(d[32].getBytes(d[31]));
            return;
        }
        catch (CardException cardException) {
            throw new SmartCardException(cardException);
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            throw new SmartCardException((Exception)((Object)unsupportedVersionException));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ESYARuntimeException((Throwable)unsupportedEncodingException);
        }
    }

    @Override
    public byte[] getSerial() throws SmartCardException {
        try {
            return this.commands.getSerial();
        }
        catch (CardException cardException) {
            throw new SmartCardException(d[28], cardException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getSerial(long aSlotID) throws SmartCardException {
        byte[] byArray;
        block4: {
            boolean bl;
            boolean bl2 = TerminalHandler.b;
            try {
                List<CardTerminal> list = this.a(CardTerminals.State.ALL);
                this.pcsc = this.terminalHandler.getTransmitter(list.get((int)(aSlotID - 1L)));
                this.commands = CIFFactory.getAkisCIFInstance((ICommandTransmitter)this.pcsc);
                byte[] byArray2 = this.commands.getSerial();
                this.pcsc.closeCardTerminal();
                byArray = byArray2;
                if (!SmartCardException.b) break block4;
                bl = !bl2;
            }
            catch (CardException cardException) {
                throw new SmartCardException(d[35], cardException);
            }
            catch (UnrecognizedCardException unrecognizedCardException) {
                throw new SmartCardException(d[36], unrecognizedCardException);
            }
            TerminalHandler.b = bl;
        }
        return byArray;
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg) throws SmartCardException {
        return new APDUSigner(this, aCert, aSigningAlg);
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg, AlgorithmParameterSpec aParams) throws SmartCardException {
        return new APDUSigner(this, aCert, aSigningAlg, aParams);
    }

    @Override
    public void closeSession() throws SmartCardException {
        this.pcsc.closeCardTerminal();
    }

    public static boolean isVersion20(Version aVersion) {
        block35: {
            block34: {
                if (aVersion == Version.V10_UEKAE || aVersion == Version.V11_UEKAE_INF) break block34;
                if (aVersion == Version.V121_UEKAE_INF) break block34;
                if (aVersion == Version.V121_UEKAE_NXP) break block34;
                if (aVersion == Version.V121_UEKAE_UKiS) break block34;
                if (aVersion == Version.V121_UEKAE_UKIS_HHNEC) break block34;
                if (aVersion == Version.V121_UEKAE_UKiS_SMIC) break block34;
                if (aVersion == Version.V122_UEKAE_INF) break block34;
                if (aVersion == Version.V122_UEKAE_NXP) break block34;
                if (aVersion == Version.V122_UEKAE_UKiS_HHNEC) break block34;
                if (aVersion == Version.V122_UEKAE_UKiS_SMIC) break block34;
                if (aVersion == Version.V12_UEKAE_INF) break block34;
                if (aVersion == Version.V12_UEKAE_NXP) break block34;
                if (aVersion == Version.V12_UEKAE_UKiS) break block34;
                if (aVersion == Version.V13_UEKAE_INF) break block34;
                if (aVersion == Version.V14_UEKAE_INF) break block34;
                if (aVersion != Version.V14_UEKAE_NXP) break block35;
            }
            return false;
        }
        return true;
    }

    public static boolean _in(long aElement, long[] aList) {
        boolean bl = TerminalHandler.b;
        if (aList == null) {
            return false;
        }
        for (int i = 0; i < aList.length; ++i) {
            if (aList[i] != aElement) continue;
            return true;
        }
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[39];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u00045D9\u0001\u001d3e\"\u0014\tfq#\u001f\u0019/x8Q\b4e9\u0003";
        int n2 = -1;
        block46: while (true) {
            char[] cArray;
            block51: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block50: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block50;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block51;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 109;
                                break;
                            }
                            case 1: {
                                n8 = 70;
                                break;
                            }
                            case 2: {
                                n8 = 23;
                                break;
                            }
                            case 3: {
                                n8 = 86;
                                break;
                            }
                            default: {
                                n8 = 113;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u00045D9\u0001\u001d3e\"\u0014\tfq#\u001f\u0019/x8Q\b4e9\u0003";
                    n2 = 0;
                    continue block46;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u00045D#\u0001\u001d)e\"\u0014\tfq#\u001f\u0019/x8Q\b4e9\u0003";
                    n2 = 1;
                    continue block46;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\f-~%\u0012\u0004 9<\u0010\u001ffu#\u001d\u0018(v;\u0010\t\u0177";
                    n2 = 2;
                    continue block46;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = ">\u0005V\u000452\u0003H\u0018>2\u0014R\u00175(\u0014D\t0;\u0007^\u001a0/\nR";
                    n2 = 3;
                    continue block46;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "8(d#\u0001\u001d)e\"\u0014\tfs?\u0016\b5cv\u0010\u0001!";
                    n2 = 4;
                    continue block46;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = ":'e8\u0018\u0003!7?\u001fM\u0007G\u0012$>+v$\u0005.'e2";
                    n2 = 5;
                    continue block46;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "?\u0015V";
                    n2 = 6;
                    continue block46;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\"({/Q?\u0015Vv\u0018\u001efd#\u0001\u001d)e\"\u0014\t";
                    n2 = 7;
                    continue block46;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "5h\"fH";
                    n2 = 8;
                    continue block46;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = ".'yv\u001f\u0002275\u0003\b'c3Q.#e\"\u0018\u000b/t7\u0005\b\u0000v5\u0005\u00024n";
                    n2 = 9;
                    continue block46;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = ".#e\"\u0018\u000b/t7\u0005\bft7\u001fM(x\"Q\t#t9\u0015\b\"9";
                    n2 = 10;
                    continue block46;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = ",\u0015T\u001f8";
                    n2 = 11;
                    continue block46;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = ",\u0015T\u001f8";
                    n2 = 12;
                    continue block46;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "=\u0015Dv\u0001\f\"s?\u001f\nf~%Q\u0003)cv\u0002\u00186g9\u0003\u0019#s";
                    n2 = 13;
                    continue block46;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = ":'e8\u0018\u0003!7?\u001fM\u0007G\u0012$>+v$\u0005.'e2";
                    n2 = 14;
                    continue block46;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = ":'e8\u0018\u0003!7?\u001fM\u0007G\u0012$>+v$\u0005.'e2";
                    n2 = 15;
                    continue block46;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = ":'e8\u0018\u0003!7?\u001fM\u0007G\u0012$>+v$\u0005.'e2";
                    n2 = 16;
                    continue block46;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = ":'e8\u0018\u0003!7?\u001fM\u0007G\u0012$>+v$\u0005.'e2";
                    n2 = 17;
                    continue block46;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "\u001a/c>#>\u0007";
                    n2 = 18;
                    continue block46;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = ",\u0015T\u001f8";
                    n2 = 19;
                    continue block46;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "=\rT\u0005\\\\s";
                    n2 = 20;
                    continue block46;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "8(|8\u001e\u001a(7\u0015\u0010\u001f\"";
                    n2 = 21;
                    continue block46;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = ">#d%\u0018\u0002(79\u0001\b(r2_M\u0005v$\u0015M\u0010r$\u0002\u0004)ylQ";
                    n2 = 22;
                    continue block46;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = ".#e\"\u0018\u000b/t7\u0005\bft7\u001fM(x\"Q\t#t9\u0015\b\"";
                    n2 = 23;
                    continue block46;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = ":'e8\u0018\u0003!7?\u001fM\u0007G\u0012$>+v$\u0005.'e2";
                    n2 = 24;
                    continue block46;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "\f-~%\u0012\u0004 9<\u0010\u001ffu#\u001d\u0018(v;\u0010\t\u0177";
                    n2 = 25;
                    continue block46;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "\u00045D9\u0001\u001d3e\"\u0014\tfq#\u001f\u0019/x8Q\b4e9\u0003";
                    n2 = 26;
                    continue block46;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = ".'yv\u001f\u0002271\u0014\u0019fD3\u0003\u0004'{";
                    n2 = 27;
                    continue block46;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = ",\u0015T\u001f8";
                    n2 = 28;
                    continue block46;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = ",\u0015T\u001f8";
                    n2 = 29;
                    continue block46;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = ",\u0015T\u001f8";
                    n2 = 30;
                    continue block46;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "=\rT\u0005\\\\s";
                    n2 = 31;
                    continue block46;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = ".#e\"\u0018\u000b/t7\u0005\bft7\u001fM(x\"Q\t#t9\u0015\b\"";
                    n2 = 32;
                    continue block46;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "(4e9\u0003M/yv0=\u0002B\u0005\u001c\f4c\u0015\u0010\u001f\"";
                    n2 = 33;
                    continue block46;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = ".'yv\u001f\u0002271\u0014\u0019fD3\u0003\u0004'{";
                    n2 = 34;
                    continue block46;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "8(e3\u0012\u0002!y?\u000b\b\"7\u0015\u0010\u001f\"";
                    n2 = 35;
                    continue block46;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = ".'yv\u001f\u0002277\u0012\u000e#d%Q\u0019#e;\u0018\u0003'{";
                    n2 = 36;
                    continue block46;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = ":'e8\u0018\u0003!7?\u001fM\u0007G\u0012$>+v$\u0005.'e2";
                    n2 = 37;
                    continue block46;
                }
                case 37: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        d = stringArray3;
        CERT_FID_START = 12048;
        CERT_FID_END = 12064;
        b = LoggerFactory.getLogger(APDUSmartCard.class);
    }
}

