/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu;

import gnu.crypto.sig.rsa.EME_OAEP;
import gnu.crypto.sig.rsa.EME_PKCS1_V1_5;
import gnu.crypto.sig.rsa.RSA;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import tr.gov.tubitak.uekae.esya.api.crypto.Cipher;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MGF;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.OAEPPadding;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Padding;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUKeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.c;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;

public class GNUAsymmetricEncryptor
extends Cipher {
    private CipherAlg a;
    private ByteArrayOutputStream b;
    private RSAPublicKey c;
    private AlgorithmParams d;
    private static final String[] e;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GNUAsymmetricEncryptor(CipherAlg aCipherAlg) throws CryptoException {
        block9: {
            Padding padding;
            block8: {
                this.a = aCipherAlg;
                padding = this.a.getPadding();
                if (padding != Padding.PKCS1) break block8;
                break block9;
            }
            if (!(padding instanceof OAEPPadding)) throw new ArgErrorException(e[1] + padding);
            OAEPPadding oAEPPadding = (OAEPPadding)padding;
            MGF mGF = oAEPPadding.getMaskGenerationFunction();
            if (mGF != MGF.MGF1) {
                throw new ArgErrorException(e[0] + mGF);
            }
            if (GNUKeyFactory.b) {
                throw new ArgErrorException(e[1] + padding);
            }
        }
        this.b = new ByteArrayOutputStream();
    }

    public void init(Key aKey, AlgorithmParams aParams) throws CryptoException {
        if (!(aKey instanceof PublicKey)) {
            throw new ArgErrorException(e[2]);
        }
        this.c = (RSAPublicKey)aKey;
    }

    public void init(byte[] aKey, AlgorithmParams aParams) throws CryptoException {
        this.init(new GNUKeyFactory().decodePublicKey(AsymmetricAlg.RSA, aKey), aParams);
    }

    public void reset() throws CryptoException {
        this.b = new ByteArrayOutputStream();
        this.init(this.c, this.d);
    }

    public byte[] process(byte[] aData) throws CryptoException {
        try {
            this.b.write(aData);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public byte[] doFinal(byte[] aData) throws CryptoException {
        block8: {
            try {
                byte[] byArray;
                block9: {
                    this.b.write(aData);
                    byte[] byArray2 = this.b.toByteArray();
                    this.b.reset();
                    byte[] byArray3 = new byte[byArray2.length];
                    Arrays.fill(byArray3, (byte)-52);
                    this.b.write(byArray3);
                    this.b = null;
                    Padding padding = this.a.getPadding();
                    if (padding == Padding.PKCS1) {
                        byte[] byArray4;
                        block7: {
                            EME_PKCS1_V1_5 eME_PKCS1_V1_5 = EME_PKCS1_V1_5.getInstance(this.c);
                            byArray4 = RSA.encrypt(this.c, new BigInteger(eME_PKCS1_V1_5.encode(byArray2))).toByteArray();
                            if (byArray4[0] != 0 || byArray4.length * 8 <= KeyUtil.getKeyLength((PublicKey)this.c)) break block7;
                            byArray4 = Arrays.copyOfRange(byArray4, 1, byArray4.length);
                        }
                        return byArray4;
                    }
                    if (!(padding instanceof OAEPPadding)) break block8;
                    int n = (this.c.getModulus().bitLength() + 7) / 8;
                    OAEPPadding oAEPPadding = (OAEPPadding)padding;
                    String string = tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.c.a(oAEPPadding.getDigestAlg());
                    EME_OAEP eME_OAEP = EME_OAEP.getInstance(string, n);
                    byArray = RSA.encrypt(this.c, new BigInteger(eME_OAEP.encode(byArray2))).toByteArray();
                    if (byArray[0] != 0 || byArray.length * 8 <= KeyUtil.getKeyLength((PublicKey)this.c)) break block9;
                    byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
                }
                return byArray;
            }
            catch (Exception exception) {
                throw new CryptoException(e[3], (Throwable)exception);
            }
        }
        return new byte[0];
    }

    public int getBlockSize() {
        return 0;
    }

    public boolean isEncryptor() {
        return true;
    }

    public CipherAlg getCipherAlgorithm() {
        return this.a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "F\u001ed^Lc\u001fe_YwPzJOxPpNY}\u0002v_U|\u001e7MI}\u0013cBS}Q7";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 19;
                                break;
                            }
                            case 1: {
                                n8 = 112;
                                break;
                            }
                            case 2: {
                                n8 = 23;
                                break;
                            }
                            case 3: {
                                n8 = 43;
                                break;
                            }
                            default: {
                                n8 = 60;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "F\u001ed^Lc\u001fe_YwPgJXw\u0019yL\u001c`\u0013\u007fNQvQ7";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "V\bgN_g\u0015s\u000bLf\u0012{B_3\u001brR\u001d";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "A#V\u000bY}\u0013eRLg\u0019xE\u001cv\u0002eDN";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

