/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.sig.rsa.EME_OAEP;
import gnu.crypto.sig.rsa.EME_PKCS1_V1_5;
import gnu.crypto.sig.rsa.RSA;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import tr.gov.tubitak.uekae.esya.api.crypto.Cipher;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MGF;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.OAEPPadding;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Padding;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUKeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.c;

public class GNUAsymmetricDecryptor
extends Cipher {
    private CipherAlg a;
    private ByteArrayOutputStream b;
    private RSAPrivateKey c;
    private AlgorithmParams d;
    private static final String[] e;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GNUAsymmetricDecryptor(CipherAlg aCipherAlg) throws CryptoException {
        block9: {
            Padding padding;
            block8: {
                this.a = aCipherAlg;
                padding = this.a.getPadding();
                if (padding != Padding.PKCS1) break block8;
                break block9;
            }
            if (!(padding instanceof OAEPPadding)) throw new ArgErrorException(e[2] + padding);
            OAEPPadding oAEPPadding = (OAEPPadding)padding;
            MGF mGF = oAEPPadding.getMaskGenerationFunction();
            if (mGF != MGF.MGF1) {
                throw new ArgErrorException(e[1] + mGF);
            }
            if (GNUKeyFactory.b) {
                throw new ArgErrorException(e[2] + padding);
            }
        }
        this.b = new ByteArrayOutputStream();
    }

    public void init(Key aKey, AlgorithmParams aParams) throws CryptoException {
        if (!(aKey instanceof RSAPrivateKey)) {
            throw new ArgErrorException(e[0]);
        }
        this.c = (RSAPrivateKey)aKey;
        this.d = aParams;
    }

    public void init(byte[] aKey, AlgorithmParams aParams) throws CryptoException {
        this.init(new GNUKeyFactory().decodePrivateKey(AsymmetricAlg.RSA, aKey), aParams);
    }

    public void reset() throws CryptoException {
        this.b = new ByteArrayOutputStream();
        this.init(this.c, this.d);
    }

    public byte[] process(byte[] aData) throws CryptoException {
        try {
            this.b.write(aData);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public byte[] doFinal(byte[] aData) throws CryptoException {
        boolean bl = GNUKeyFactory.b;
        try {
            this.b.write(aData);
            byte[] byArray = this.b.toByteArray();
            this.b = null;
            byte[] byArray2 = RSA.decrypt(this.c, new BigInteger(1, byArray)).toByteArray();
            int n = (this.c.getModulus().bitLength() + 7) / 8;
            int n2 = n - byArray2.length;
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
            Padding padding = this.a.getPadding();
            if (padding == Padding.PKCS1) {
                EME_PKCS1_V1_5 eME_PKCS1_V1_5 = EME_PKCS1_V1_5.getInstance(this.c);
                return eME_PKCS1_V1_5.decode(byArray3);
            }
            if (padding instanceof OAEPPadding) {
                OAEPPadding oAEPPadding = (OAEPPadding)padding;
                String string = tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.c.a(oAEPPadding.getDigestAlg());
                EME_OAEP eME_OAEP = EME_OAEP.getInstance(string, n);
                return eME_OAEP.decode(byArray3);
            }
        }
        catch (Exception exception) {
            throw new CryptoException(e[3], (Throwable)exception);
        }
        byte[] byArray = new byte[]{};
        if (bl) {
            int n = BaseCipher.b;
            BaseCipher.b = ++n;
        }
        return byArray;
    }

    public int getBlockSize() {
        return 0;
    }

    public boolean isEncryptor() {
        return true;
    }

    public CipherAlg getCipherAlgorithm() {
        return this.a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u000b^j\u000bU:C~NF<Ol\u000fB+\u0006q\u000bOo";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 78;
                                break;
                            }
                            case 1: {
                                n8 = 38;
                                break;
                            }
                            case 2: {
                                n8 = 26;
                                break;
                            }
                            case 3: {
                                n8 = 110;
                                break;
                            }
                            default: {
                                n8 = 54;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u001bHi\u001bF>Ih\u001aS*\u0006w\u000fE%\u0006}\u000bS T{\u001a_!H:\bC En\u0007Y \u0007:";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u001bHi\u001bF>Ih\u001aS*\u0006j\u000fR*Ot\t\u0016=Er\u000b[+\u0007:";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u001cu[NS Eh\u0017F:Ou\u0000\u0016+Th\u0001D";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

