/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.sig.BaseSignature;
import gnu.crypto.sig.rsa.EMSA_ISO9796d2;
import gnu.crypto.sig.rsa.RSA;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAISO9796d2Signature
extends BaseSignature {
    private EMSA_ISO9796d2 d;
    private static final String[] e;

    public RSAISO9796d2Signature() {
        this(e[1], false);
    }

    public RSAISO9796d2Signature(String mdName, boolean implicit) {
        super(e[0], HashFactory.getInstance(mdName));
        this.d = EMSA_ISO9796d2.getInstance(mdName, implicit);
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    protected void setupForVerification(PublicKey key) throws IllegalArgumentException {
        if (!(key instanceof RSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = key;
        int n = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        this.d.init(n);
    }

    @Override
    protected void setupForSigning(PrivateKey key) throws IllegalArgumentException {
        if (!(key instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = key;
        int n = ((RSAPrivateKey)this.privateKey).getModulus().bitLength();
        this.d.init(n);
    }

    @Override
    protected Object generateSignature() throws IllegalStateException {
        byte[] byArray = this.d.encode();
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSA.sign(this.privateKey, bigInteger);
        if (((RSAPrivateKey)this.privateKey).getModulus().divide(BigInteger.valueOf(2L)).compareTo(bigInteger2) == -1) {
            bigInteger2 = ((RSAPrivateKey)this.privateKey).getModulus().subtract(bigInteger2);
        }
        this.clearData(byArray);
        this.clearData(bigInteger);
        return RSA.I2OSP(bigInteger2, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean verifySignature(Object sig) throws IllegalStateException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n;
        block13: {
            RSAPublicKey rSAPublicKey;
            block12: {
                byte[] byArray = (byte[])sig;
                rSAPublicKey = (RSAPublicKey)this.publicKey;
                int n2 = rSAPublicKey.getModulus().bitLength();
                n = (n2 + 7) / 8;
                if (byArray.length != n) {
                    return false;
                }
                bigInteger2 = new BigInteger(1, byArray);
                if (rSAPublicKey.getPublicExponent().getLowestSetBit() != 0) break block12;
                if (bigInteger2.remainder(BigInteger.valueOf(16L)) == BigInteger.valueOf(12L)) break block13;
                bigInteger2 = rSAPublicKey.getModulus().subtract(bigInteger2);
                if (!RSA.c) break block13;
            }
            if (bigInteger2.remainder(BigInteger.valueOf(8L)) == BigInteger.valueOf(1L)) {
                bigInteger2 = rSAPublicKey.getModulus().subtract(bigInteger2);
            }
        }
        try {
            bigInteger = RSA.verify(this.publicKey, bigInteger2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        try {
            byte[] byArray = RSA.I2OSP(bigInteger, n);
            return this.d.decode(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void update(byte[] b2, int off, int len) {
        super.update(b2, off, len);
        this.d.update(b2, off, len);
    }

    @Override
    public void update(byte b2) {
        super.update(b2);
        this.d.update(b2);
    }

    public byte[] getRecoveredMessage() {
        return this.d.getRecoveredMessage();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "R+\fHuS7TR%\u0016<_";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 32;
                                break;
                            }
                            case 1: {
                                n8 = 88;
                                break;
                            }
                            case 2: {
                                n8 = 109;
                                break;
                            }
                            case 3: {
                                n8 = 101;
                                break;
                            }
                            default: {
                                n8 = 28;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "S0\fH-\u0016h";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

