/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.RipeMD128;
import gnu.crypto.hash.RipeMD160;
import gnu.crypto.hash.Sha160;
import gnu.crypto.sig.rsa.RSA;

public class EMSA_ISO9796d2 {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    private int a;
    private boolean b;
    private byte[] c;
    private boolean d;
    protected IMessageDigest md;
    protected byte[] mBuf;
    protected int messageLength;
    protected int blockLength;
    protected int modBits;
    private static final String[] e;

    public static final EMSA_ISO9796d2 getInstance(String mdName) {
        return EMSA_ISO9796d2.getInstance(mdName, false);
    }

    public static final EMSA_ISO9796d2 getInstance(String mdName, boolean implicit) {
        IMessageDigest iMessageDigest;
        block8: {
            iMessageDigest = HashFactory.getInstance(mdName);
            String string = iMessageDigest.name();
            if (implicit || string.equals(e[5])) break block8;
            if (string.equals(e[6])) break block8;
            if (string.equals(e[4])) break block8;
            throw new UnsupportedOperationException(e[7]);
        }
        return new EMSA_ISO9796d2(iMessageDigest, implicit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EMSA_ISO9796d2(IMessageDigest hash, boolean implicit) {
        block10: {
            block13: {
                boolean bl;
                block12: {
                    block11: {
                        block9: {
                            bl = RSA.c;
                            this.c = null;
                            this.md = hash;
                            this.messageLength = 0;
                            this.d = implicit;
                            if (!implicit) break block9;
                            this.a = 188;
                            if (!bl) break block10;
                        }
                        if (!(this.md instanceof Sha160)) break block11;
                        this.a = 13260;
                        if (!bl) break block10;
                    }
                    if (!(this.md instanceof RipeMD160)) break block12;
                    this.a = 12748;
                    if (!bl) break block10;
                }
                if (!(this.md instanceof RipeMD128)) break block13;
                this.a = 13004;
                if (!bl) break block10;
            }
            throw new IllegalArgumentException(e[8]);
        }
    }

    public void update(byte[] b2, int off, int len) {
        boolean bl = RSA.c;
        this.md.update(b2, off, len);
        if (this.messageLength < this.mBuf.length) {
            for (int k = 0; k < len; ++k) {
                if (k + this.messageLength >= this.mBuf.length) break;
                this.mBuf[this.messageLength + k] = b2[off + k];
                if (!bl) continue;
                break;
            }
        }
        this.messageLength += len;
    }

    public void update(byte b2) {
        this.md.update(b2);
        if (this.messageLength < this.mBuf.length) {
            this.mBuf[this.messageLength] = b2;
        }
        ++this.messageLength;
    }

    public void init(int modBits) {
        block5: {
            block4: {
                this.modBits = modBits;
                this.blockLength = (modBits + 7) / 8;
                if (this.a != 188) break block4;
                this.mBuf = new byte[this.blockLength - this.md.hashSize() - 2];
                if (!RSA.c) break block5;
            }
            this.mBuf = new byte[this.blockLength - this.md.hashSize() - 3];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encode() {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        boolean bl;
        block12: {
            block11: {
                int n4;
                int n5;
                block10: {
                    byte[] byArray2;
                    block9: {
                        bl = RSA.c;
                        n5 = this.md.hashSize();
                        byArray = new byte[this.blockLength];
                        n4 = 0;
                        n3 = 0;
                        if (this.a != 188) break block9;
                        n4 = 8;
                        n3 = this.blockLength - n5 - 1;
                        byArray2 = this.md.digest();
                        System.arraycopy(byArray2, 0, byArray, n3, n5);
                        byArray[byArray.length - 1] = -68;
                        if (!bl) break block10;
                    }
                    n4 = 16;
                    n3 = byArray.length - n5 - 2;
                    byArray2 = this.md.digest();
                    System.arraycopy(byArray2, 0, byArray, n3, n5);
                    byArray[byArray.length - 2] = (byte)(this.a >>> 8);
                    byArray[byArray.length - 1] = (byte)this.a;
                }
                n2 = 0;
                int n6 = (n5 + this.messageLength) * 8 + n4 + 4 - this.modBits;
                if (n6 <= 0) break block11;
                n = this.messageLength - (n6 + 7) / 8;
                n2 = 96;
                System.arraycopy(this.mBuf, 0, byArray, n3 -= n, n);
                if (!bl) break block12;
            }
            n2 = 64;
            System.arraycopy(this.mBuf, 0, byArray, n3 -= this.messageLength, this.messageLength);
        }
        if (n3 - 1 > 0) {
            for (n = n3 - 1; n != 0; --n) {
                byArray[n] = -69;
                if (!bl) continue;
            }
            int n7 = n3 - 1;
            byArray[n7] = (byte)(byArray[n7] ^ 1);
            byArray[0] = 11;
            byArray[0] = (byte)(byArray[0] | n2);
            if (!bl) return byArray;
        }
        byArray[0] = 10;
        byArray[0] = (byte)(byArray[0] | n2);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decode(byte[] block) {
        block34: {
            int n;
            byte[] byArray;
            int n2;
            int n3;
            block33: {
                int n4;
                boolean bl;
                block32: {
                    block31: {
                        bl = RSA.c;
                        if ((block[0] & 0xC0 ^ 0x40) != 0) {
                            this.a(this.mBuf);
                            this.a(block);
                            return false;
                        }
                        if ((block[block.length - 1] & 0xF ^ 0xC) != 0) {
                            this.a(this.mBuf);
                            this.a(block);
                            return false;
                        }
                        n4 = 0;
                        if ((block[block.length - 1] & 0xFF ^ 0xBC) != 0) break block31;
                        n4 = 1;
                        if (!bl) break block32;
                    }
                    n3 = (block[block.length - 2] & 0xFF) << 8 | block[block.length - 1] & 0xFF;
                    switch (n3) {
                        case 12748: {
                            if (this.md instanceof RipeMD160) break;
                            throw new IllegalStateException(e[2]);
                        }
                        case 13260: {
                            if (this.md instanceof Sha160) break;
                            throw new IllegalStateException(e[3]);
                        }
                        case 13004: {
                            if (this.md instanceof RipeMD128) break;
                            throw new IllegalStateException(e[1]);
                        }
                        default: {
                            throw new IllegalArgumentException(e[0]);
                        }
                    }
                    n4 = 2;
                }
                n3 = 0;
                for (n3 = 0; n3 != block.length && ((block[n3] & 0xF ^ 0xA) != 0 || bl); ++n3) {
                    if (!bl) continue;
                }
                if ((n2 = block.length - n4 - this.md.hashSize()) - ++n3 <= 0) {
                    this.a(this.mBuf);
                    this.a(block);
                    return false;
                }
                if ((block[0] & 0x20) != 0) break block33;
                this.b = true;
                this.md.reset();
                this.md.update(block, n3, n2 - n3);
                byArray = this.md.digest();
                for (n = 0; n != byArray.length; ++n) {
                    int n5 = n2 + n;
                    block[n5] = (byte)(block[n5] ^ byArray[n]);
                    if (block[n2 + n] == 0) continue;
                    this.a(this.mBuf);
                    this.a(block);
                    return false;
                }
                this.c = new byte[n2 - n3];
                System.arraycopy(block, n3, this.c, 0, this.c.length);
                if (!bl) break block34;
            }
            this.b = false;
            byArray = this.md.digest();
            for (n = 0; n != byArray.length; ++n) {
                int n6 = n2 + n;
                block[n6] = (byte)(block[n6] ^ byArray[n]);
                if (block[n2 + n] == 0) continue;
                this.a(this.mBuf);
                this.a(block);
                return false;
            }
            this.c = new byte[n2 - n3];
            System.arraycopy(block, n3, this.c, 0, this.c.length);
        }
        if (this.messageLength != 0 && !this.a(this.mBuf, this.c)) {
            this.a(this.mBuf);
            this.a(block);
            return false;
        }
        this.a(this.mBuf);
        this.a(block);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(byte[] byArray, byte[] byArray2) {
        block14: {
            int n;
            block13: {
                boolean bl = RSA.c;
                if (this.messageLength <= this.mBuf.length) break block13;
                if (this.mBuf.length > byArray2.length) {
                    return false;
                }
                for (n = 0; n != this.mBuf.length; ++n) {
                    if (byArray[n] == byArray2[n]) continue;
                    return false;
                }
                if (!bl) break block14;
            }
            if (this.messageLength != byArray2.length) {
                return false;
            }
            for (n = 0; n != byArray2.length; ++n) {
                if (byArray[n] == byArray2[n]) continue;
                return false;
            }
        }
        return true;
    }

    private void a(byte[] byArray) {
        boolean bl = RSA.c;
        for (int k = 0; k < byArray.length; ++k) {
            byArray[k] = 0;
            if (!bl) continue;
        }
    }

    public Object clone() {
        return EMSA_ISO9796d2.getInstance(this.md.name(), this.d);
    }

    public boolean hasFullMessage() {
        return this.b;
    }

    public byte[] getRecoveredMessage() {
        return this.c;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "hH^8%rAB45xB\f5'nN\f4(=UE:(|RY/#";
        int n2 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block20;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 29;
                                break;
                            }
                            case 1: {
                                n8 = 38;
                                break;
                            }
                            case 2: {
                                n8 = 44;
                                break;
                            }
                            case 3: {
                                n8 = 93;
                                break;
                            }
                            default: {
                                n8 = 70;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "nOK3#o\u0006_5)hJH}$x\u0006E3/iOM1/nCH}1tRD}\u0014Tvi\u0010\u0002,\u0014\u0014";
                    n2 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "nOK3#o\u0006_5)hJH}$x\u0006E3/iOM1/nCH}1tRD}\u0014Tvi\u0010\u0002,\u0010\u001c";
                    n2 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "nOK3#o\u0006_5)hJH}$x\u0006E3/iOM1/nCH}1tRD}\u0015Ug\u001d";
                    n2 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "nNMpw+\u0016";
                    n2 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "oO\\8+y\u0017\u001ee";
                    n2 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "oO\\8+y\u0017\u001am";
                    n2 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "HH_(6mII/2xB\f5'nN\f<*zI^42uK";
                    n2 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "sI\f+'qOH}2oGE1#o\u0006J24=BE:#nR";
                    n2 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

