/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.curve.ElementF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;

public abstract class ECGNUPoint
extends ECPoint {
    static Chronometer a;
    public static final int COMPRESSED = 0;
    public static final int UNCOMPRESSED = 1;
    public static final int HYBRID = 2;
    protected static final BigInteger TWO;
    protected static final BigInteger THREE;
    protected static final BigInteger FOUR;
    protected static final BigInteger EIGHT;
    protected final Curve mCurve;
    protected final Field mField;
    public static int b;
    private static final String[] c;

    public static void sifirla() {
        a.reset();
    }

    public static void yaz() {
        System.out.println(a.toString(c[5]));
        a.reset();
    }

    public ECGNUPoint(Curve aCurve) {
        super(TWO, TWO);
        this.mCurve = aCurve;
        this.mField = this.mCurve.mField;
    }

    protected BigInteger[] fromOctetString(byte[] aOctet) throws EllipticCurveException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        block25: {
            block22: {
                boolean bl;
                byte by;
                block24: {
                    block20: {
                        by = aOctet[0];
                        if (by != 2 && by != 3) break block20;
                        bl = false;
                        break block24;
                    }
                    if (by == 4) {
                        bl = true;
                    } else {
                        throw new EllipticCurveException(c[0]);
                    }
                }
                if (!bl) {
                    block21: {
                        byte[] byArray = new byte[aOctet.length - 1];
                        System.arraycopy(aOctet, 1, byArray, 0, byArray.length);
                        bigInteger2 = this.mField.fromOctetToFieldElement(byArray);
                        if (by == 2 || by == 3) break block21;
                        throw new EllipticCurveException(c[1]);
                    }
                    bigInteger = this._convert(bigInteger2, by - 2);
                } else {
                    block23: {
                        if (!bl) break block22;
                        if (by == 4) break block23;
                        throw new EllipticCurveException(c[2]);
                    }
                    int n = aOctet.length - 1;
                    if ((n & 1) == 1) {
                        throw new EllipticCurveException(c[3]);
                    }
                    byte[] byArray = new byte[n >>= 1];
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(aOctet, 1, byArray, 0, byArray.length);
                    bigInteger2 = this.mField.fromOctetToFieldElement(byArray);
                    System.arraycopy(aOctet, byArray.length + 1, byArray2, 0, byArray2.length);
                    bigInteger = this.mField.fromOctetToFieldElement(byArray2);
                }
                break block25;
            }
            throw new EllipticCurveException();
        }
        if (!this.mCurve.onCurve(bigInteger2, bigInteger)) {
            throw new EllipticCurveException(c[4]);
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public final ECGNUPoint add(ECGNUPoint aElem) throws EllipticCurveException {
        block10: {
            block9: {
                if (!this.getClass().isInstance(aElem)) {
                    throw new EllipticCurveException(c[8]);
                }
                if (this.mCurve == aElem.mCurve) break block9;
                if (!this.mField.equals(aElem.mField)) break block10;
                if (!this.mCurve.onCurve(aElem.getAffineX(), aElem.getAffineY())) break block10;
            }
            return this._add(aElem);
        }
        throw new EllipticCurveException(c[9]);
    }

    protected abstract ECGNUPoint _add(ECGNUPoint var1);

    public void addToThis(ECGNUPoint aElem) throws EllipticCurveException {
        block13: {
            block12: {
                block11: {
                    if (!this.getClass().isInstance(aElem)) {
                        throw new EllipticCurveException(c[7]);
                    }
                    if (this.mCurve == aElem.mCurve) break block11;
                    if (!this.mField.equals(aElem.mField)) break block12;
                    if (!this.mCurve.onCurve(aElem.getAffineX(), aElem.getAffineY())) break block12;
                }
                this._addToThis(aElem);
                if (b == 0) break block13;
            }
            throw new EllipticCurveException(c[6]);
        }
    }

    protected abstract void _addToThis(ECGNUPoint var1);

    public abstract ECGNUPoint negate();

    public abstract void negateThis();

    public ECGNUPoint multiply(BigInteger aKatsayi) {
        ECGNUPoint eCGNUPoint;
        int n = b;
        int n2 = 5;
        ECGNUPoint[] eCGNUPointArray = new ECGNUPoint[1 << n2 - 1];
        eCGNUPointArray[0] = eCGNUPoint = (ECGNUPoint)this.clone();
        ECGNUPoint eCGNUPoint2 = eCGNUPoint.multiplyBy2();
        for (int k = 1; k < eCGNUPointArray.length; ++k) {
            eCGNUPointArray[k] = eCGNUPointArray[k - 1]._add(eCGNUPoint2);
            if (n == 0) continue;
        }
        return this.multiply(aKatsayi, eCGNUPointArray);
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, BigInteger aN) {
        BigInteger bigInteger;
        int n;
        block15: {
            block14: {
                n = b;
                if (aN != null) break block14;
                bigInteger = aKatsayi;
                if (n == 0) break block15;
            }
            bigInteger = aKatsayi.mod(aN);
        }
        BigInteger bigInteger2 = bigInteger.add(bigInteger).add(bigInteger);
        ECGNUPoint eCGNUPoint = (ECGNUPoint)this.clone();
        ECGNUPoint eCGNUPoint2 = this.negate();
        for (int k = bigInteger2.bitLength() - 2; k > 0; --k) {
            block13: {
                eCGNUPoint.multiplyThisBy2();
                if (!bigInteger2.testBit(k) || bigInteger.testBit(k)) break block13;
                eCGNUPoint._addToThis(this);
                if (n == 0) continue;
            }
            if (bigInteger2.testBit(k)) continue;
            if (!bigInteger.testBit(k)) continue;
            eCGNUPoint._addToThis(eCGNUPoint2);
            continue;
        }
        return eCGNUPoint;
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, ECGNUPoint[][] aPreComputation) {
        int n = b;
        byte[] byArray = this.a(aKatsayi);
        int n2 = 0;
        while (byArray[n2] == 0) {
            ++n2;
            if (n == 0) continue;
        }
        ECGNUPoint eCGNUPoint = (ECGNUPoint)aPreComputation[n2][byArray[n2] - 1].clone();
        ++n2;
        while (n2 < byArray.length) {
            if (byArray[n2] != 0) {
                eCGNUPoint._addToThis(aPreComputation[n2][byArray[n2] - 1]);
            }
            ++n2;
            if (n == 0) continue;
        }
        return eCGNUPoint;
    }

    private byte[] a(BigInteger bigInteger) {
        int n = b;
        int n2 = bigInteger.bitLength() / 4 + 1;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int k = 0; k < byArray.length; ++k) {
            int n4;
            int n5 = n4 = bigInteger.testBit(n3++) ? 1 : 0;
            if (bigInteger.testBit(n3++)) {
                n4 = (byte)(n4 + 2);
            }
            if (bigInteger.testBit(n3++)) {
                n4 = (byte)(n4 + 4);
            }
            if (bigInteger.testBit(n3++)) {
                n4 = (byte)(n4 + 8);
            }
            byArray[k] = n4;
            if (n == 0) continue;
        }
        return byArray;
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, ECGNUPoint[] aOddPowers) {
        ECGNUPoint eCGNUPoint;
        int n;
        int[] nArray;
        int n2;
        block13: {
            block12: {
                n2 = b;
                int n3 = aKatsayi.bitLength();
                nArray = new int[n3 + 1];
                ECGNUPoint.determineNAF(nArray, aKatsayi, 5);
                n = n3;
                while (nArray[n] == 0) {
                    --n;
                    if (n2 == 0) continue;
                }
                if (nArray[n] <= 0) break block12;
                eCGNUPoint = (ECGNUPoint)aOddPowers[nArray[n] - 1 >> 1].clone();
                if (n2 == 0) break block13;
            }
            eCGNUPoint = aOddPowers[0 - nArray[n] - 1 >> 1].negate();
        }
        --n;
        while (n >= 0) {
            block11: {
                block10: {
                    eCGNUPoint.multiplyThisBy2();
                    if (nArray[n] <= 0) break block10;
                    eCGNUPoint._addToThis(aOddPowers[nArray[n] - 1 >> 1]);
                    if (n2 == 0) break block11;
                }
                if (nArray[n] >= 0) break block11;
                eCGNUPoint._addToThis(aOddPowers[0 - nArray[n] - 1 >> 1].negate());
            }
            --n;
            if (n2 == 0) continue;
        }
        return eCGNUPoint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ECGNUPoint multiplyAndAdd(BigInteger aKatsayi, ECGNUPoint[] aOddPowers, ECGNUPoint aQ, BigInteger aKatsayi2) {
        ECGNUPoint eCGNUPoint;
        int n;
        int[] nArray;
        int[] nArray2;
        ECGNUPoint[] eCGNUPointArray;
        int n2;
        block33: {
            ECGNUPoint eCGNUPoint2;
            block32: {
                ECGNUPoint eCGNUPoint3;
                n2 = b;
                int n3 = 5;
                eCGNUPointArray = new ECGNUPoint[1 << n3 - 1];
                eCGNUPointArray[0] = eCGNUPoint3 = (ECGNUPoint)aQ.clone();
                ECGNUPoint eCGNUPoint4 = eCGNUPoint3.multiplyBy2();
                for (int k = 1; k < eCGNUPointArray.length; ++k) {
                    eCGNUPointArray[k] = eCGNUPointArray[k - 1]._add(eCGNUPoint4);
                    if (n2 == 0) continue;
                }
                int n4 = aKatsayi.bitLength();
                int n5 = aKatsayi2.bitLength();
                if (n5 > n4) {
                    n4 = n5;
                }
                nArray2 = new int[n4 + 1];
                nArray = new int[n4 + 1];
                ECGNUPoint.determineNAF(nArray2, aKatsayi, n3);
                ECGNUPoint.determineNAF(nArray, aKatsayi2, n3);
                n = n4;
                while (nArray2[n] == 0 && nArray[n] == 0) {
                    --n;
                    if (n2 == 0) continue;
                }
                eCGNUPoint = null;
                eCGNUPoint2 = null;
                if (nArray2[n] > 0) {
                    eCGNUPoint = (ECGNUPoint)aOddPowers[nArray2[n] - 1 >> 1].clone();
                } else if (nArray2[n] < 0) {
                    eCGNUPoint = aOddPowers[0 - nArray2[n] - 1 >> 1].negate();
                }
                if (nArray[n] > 0) {
                    eCGNUPoint2 = (ECGNUPoint)eCGNUPointArray[nArray[n] - 1 >> 1].clone();
                } else if (nArray[n] < 0) {
                    eCGNUPoint2 = eCGNUPointArray[0 - nArray[n] - 1 >> 1].negate();
                }
                if (eCGNUPoint != null) break block32;
                eCGNUPoint = eCGNUPoint2;
                if (n2 == 0) break block33;
            }
            if (eCGNUPoint2 != null) {
                eCGNUPoint._addToThis(eCGNUPoint2);
            }
        }
        --n;
        while (n >= 0) {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            ElementF2mPolynomial.say = true;
                            eCGNUPoint.multiplyThisBy2();
                            ElementF2mPolynomial.say = false;
                            if (nArray2[n] <= 0) break block34;
                            eCGNUPoint._addToThis(aOddPowers[nArray2[n] - 1 >> 1]);
                            if (n2 == 0) break block35;
                        }
                        if (nArray2[n] < 0) {
                            eCGNUPoint._addToThis(aOddPowers[0 - nArray2[n] - 1 >> 1].negate());
                        }
                    }
                    if (nArray[n] <= 0) break block36;
                    eCGNUPoint._addToThis(eCGNUPointArray[nArray[n] - 1 >> 1]);
                    if (n2 == 0) break block37;
                }
                if (nArray[n] < 0) {
                    eCGNUPoint._addToThis(eCGNUPointArray[0 - nArray[n] - 1 >> 1].negate());
                }
            }
            --n;
            if (n2 == 0) continue;
        }
        if (BaseCipher.b == 0) return eCGNUPoint;
        b = ++n2;
        return eCGNUPoint;
    }

    public void multiplyThisBy(BigInteger aKatsayi) {
        throw new RuntimeException();
    }

    public void multiplyThisBy(BigInteger aKatsayi, BigInteger aN) {
        throw new RuntimeException();
    }

    public ECGNUPoint multiplyBy2() {
        return this._add(this);
    }

    public void multiplyThisBy2() {
        this._addToThis(this);
    }

    @Override
    public abstract boolean equals(Object var1);

    public abstract Object clone();

    @Override
    public abstract BigInteger getAffineX();

    @Override
    public abstract BigInteger getAffineY();

    protected abstract boolean _ypTilda();

    protected abstract BigInteger _convert(BigInteger var1, int var2) throws EllipticCurveException;

    public byte[] toOctetString(int aCompressionMode) {
        byte[] byArray = this.b(this.getAffineX());
        if (aCompressionMode == 0) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byte[] byArray3 = byArray2;
            int n = 0;
            int n2 = this._ypTilda() ? 3 : 2;
            byArray3[n] = n2;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        if (aCompressionMode == 1) {
            byte[] byArray4 = this.b(this.getAffineY());
            byte[] byArray5 = new byte[byArray.length + byArray4.length + 1];
            byArray5[0] = 4;
            System.arraycopy(byArray, 0, byArray5, 1, byArray.length);
            System.arraycopy(byArray4, 0, byArray5, byArray.length + 1, byArray4.length);
            return byArray5;
        }
        if (aCompressionMode == 2) {
            byte[] byArray6 = this.b(this.getAffineY());
            byte[] byArray7 = new byte[byArray.length + byArray6.length + 1];
            byte[] byArray8 = byArray7;
            int n = 0;
            int n3 = this._ypTilda() ? 7 : 6;
            byArray8[n] = n3;
            System.arraycopy(byArray, 0, byArray7, 1, byArray.length);
            System.arraycopy(byArray6, 0, byArray7, byArray.length + 1, byArray6.length);
            return byArray7;
        }
        throw new RuntimeException();
    }

    private byte[] b(BigInteger bigInteger) {
        byte[] byArray;
        int n = (this.mCurve.getField().getFieldSize() + 7) / 8;
        if (n < (byArray = bigInteger.toByteArray()).length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
            return byArray2;
        }
        if (n > byArray.length) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    protected static final void determineNAF(int[] N, BigInteger e2, int wi) {
        int n = b;
        int n2 = 1 << wi;
        BigInteger bigInteger = e2.abs();
        int n3 = e2.signum();
        int n4 = 0;
        while (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            int n5;
            block11: {
                block10: {
                    if (!bigInteger.testBit(0)) break block10;
                    n5 = bigInteger.intValue() & (n2 << 1) - 1;
                    if ((n5 & n2) != 0) {
                        n5 -= n2 << 1;
                    }
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(n5));
                    if (n == 0) break block11;
                }
                n5 = 0;
            }
            try {
                int[] nArray = N;
                int n6 = n4++;
                int n7 = n3 > 0 ? n5 : -n5;
                nArray[n6] = n7;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ArrayIndexOutOfBoundsException(c[10] + n4);
            }
            bigInteger = bigInteger.shiftRight(1);
            if (n == 0) continue;
        }
        while (n4 < N.length) {
            N[n4++] = 0;
            if (n == 0) continue;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "1;1?J\u0013\u0017cz\u0007^";
        int n2 = -1;
        block19: while (true) {
            char[] cArray;
            block24: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block23: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block23;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block24;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 97;
                                break;
                            }
                            case 1: {
                                n8 = 120;
                                break;
                            }
                            case 2: {
                                n8 = 17;
                                break;
                            }
                            case 3: {
                                n8 = 90;
                                break;
                            }
                            default: {
                                n8 = 56;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "1;1?J\u0013\u0017c";
                    n2 = 0;
                    continue block19;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "1;1?J\u0013\u0017c";
                    n2 = 1;
                    continue block19;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "-\u001d\u007f=L\tXx)\u0018\u0016\n~4_";
                    n2 = 2;
                    continue block19;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "1\u0017x4LA\u0016~.\u0018\u000e\u00161\u0019M\u0013\u000et";
                    n2 = 3;
                    continue block19;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "1\u0017x4LA\u0011r3V\u0005\u001d1";
                    n2 = 4;
                    continue block19;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "1\u0017x4LA\u0016~.\u0018\u000e\u001619M\u0013\u000et";
                    n2 = 5;
                    continue block19;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "/\u0017ezK\u0000\u0015tzL\u0018\btzH\u000e\u0011\u007f.";
                    n2 = 6;
                    continue block19;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "/\u0017ezK\u0000\u0015tzL\u0018\btzH\u000e\u0011\u007f.";
                    n2 = 7;
                    continue block19;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "1\u0017x4LA\u0016~.\u0018\u000e\u001619M\u0013\u000et";
                    n2 = 8;
                    continue block19;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "1\u0017x4LO\u001ct.]\u0013\u0015x4]/9WrQ\u000f\fJ\u0007\u0018/T1\u0018Q\u00061\u007f.]\u0006\u001dcz]MXx4LA\u000fxs\u0002A\bc5Z\r\u001d|zY\u0015Xx4\\\u0004\u00001";
                    n2 = 9;
                    continue block19;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "LU<w\u0015LXT\u0019\u007f/-^\nW\b\u0016e";
                    n2 = 10;
                    continue block19;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
        a = new Chronometer(c[11]);
        TWO = new BigInteger("2");
        THREE = new BigInteger("3");
        FOUR = new BigInteger("4");
        EIGHT = new BigInteger("8");
    }
}

