/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.Registry;
import gnu.crypto.mac.HMacFactory;
import gnu.crypto.mac.IMac;
import gnu.crypto.mac.MacFactory;
import gnu.crypto.prng.ARCFour;
import gnu.crypto.prng.DGKGF;
import gnu.crypto.prng.ICMGenerator;
import gnu.crypto.prng.MDGenerator;
import gnu.crypto.prng.PBKDF2;
import gnu.crypto.prng.UEKAECryptoCardGenerator;
import gnu.crypto.prng.UMacGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BasePRNG;
import tr.gov.tubitak.uekae.esya.api.common.crypto.IRandom;

public class PRNGFactory
implements Registry {
    private static final String[] a;

    private PRNGFactory() {
    }

    public static final IRandom getInstance(String prng) {
        BasePRNG basePRNG;
        block24: {
            block23: {
                if (prng == null) {
                    return null;
                }
                prng = prng.trim();
                basePRNG = null;
                if (!prng.equalsIgnoreCase(a[10]) && !prng.equalsIgnoreCase(a[5])) break block23;
                basePRNG = new ARCFour();
                break block24;
            }
            if (prng.equalsIgnoreCase(a[6])) {
                basePRNG = new ICMGenerator();
            } else if (prng.equalsIgnoreCase(a[11])) {
                basePRNG = new MDGenerator();
            } else if (prng.equalsIgnoreCase(a[12])) {
                basePRNG = new UMacGenerator();
            } else if (prng.equalsIgnoreCase(a[8])) {
                basePRNG = new DGKGF();
            } else if (prng.equalsIgnoreCase(a[4])) {
                basePRNG = new UEKAECryptoCardGenerator();
            } else if (prng.equalsIgnoreCase(a[13])) {
                try {
                    basePRNG = (IRandom)Class.forName(a[7]).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (prng.toLowerCase().startsWith(a[9])) {
                String string = prng.substring(a[14].length());
                IMac iMac = MacFactory.getInstance(string);
                if (iMac == null) {
                    return null;
                }
                basePRNG = new PBKDF2(iMac);
            }
        }
        return basePRNG;
    }

    public static final Set getNames() {
        boolean bl = UMacGenerator.b;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(a[3]);
        hashSet.add(a[0]);
        hashSet.add(a[1]);
        Iterator iterator = HMacFactory.getNames().iterator();
        while (iterator.hasNext()) {
            hashSet.add(a[2] + (String)iterator.next());
            if (!bl) continue;
        }
        return Collections.unmodifiableSet(hashSet);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "w_";
        int n2 = -1;
        block22: while (true) {
            char[] cArray;
            block27: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block26: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block26;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block27;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 26;
                                break;
                            }
                            case 1: {
                                n8 = 59;
                                break;
                            }
                            case 2: {
                                n8 = 48;
                                break;
                            }
                            case 3: {
                                n8 = 123;
                                break;
                            }
                            default: {
                                n8 = 103;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "oVQ\u0018Jq_V";
                    n2 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "jY[\u001f\u0001(\u0016";
                    n2 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "sX]";
                    n2 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "o^[\u001a\u0002EXB\u0002\u0017nTo\u0018\u0006h_";
                    n2 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "hX\u0004";
                    n2 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "sX]";
                    n2 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "nI\u001e\u001c\bl\u0015D\u000e\u0005sOQ\u0010Io^[\u001a\u00024^C\u0002\u00064Z@\u0012IiVQ\t\u0013yZB\u001fIoOY\u0017IIVQ\t\u0013YZB\u001f5{UT\u0014\n";
                    n2 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "~\\[\u001c\u0001";
                    n2 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "jY[\u001f\u0001(\u0016";
                    n2 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "{IS\u001d\boI";
                    n2 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "w_";
                    n2 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "oVQ\u0018Jq_V";
                    n2 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "iVQ\t\u0013yZB\u001f8jI^\u001c";
                    n2 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "jY[\u001f\u0001(\u0016";
                    n2 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

