/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mode;

import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.mode.BaseMode;

public class CBC
extends BaseMode
implements Cloneable {
    private byte[] a;
    private byte[] c;
    private static final String d;

    CBC(IBlockCipher iBlockCipher, int n) {
        super(d, iBlockCipher, n);
    }

    private CBC(CBC cBC) {
        this((IBlockCipher)cBC.cipher.clone(), cBC.cipherBlockSize);
    }

    @Override
    public Object clone() {
        return new CBC(this);
    }

    @Override
    public void setup() {
        int n = BaseMode.b;
        if (this.modeBlockSize != this.cipherBlockSize) {
            throw new IllegalArgumentException();
        }
        this.c = new byte[this.cipherBlockSize];
        this.a = new byte[this.cipherBlockSize];
        for (int k = 0; k < this.a.length; ++k) {
            if (k >= this.iv.length) break;
            this.a[k] = this.iv[k];
            if (n == 0) continue;
            break;
        }
    }

    @Override
    public void teardown() {
        this.a = null;
        this.c = null;
    }

    @Override
    public void encryptBlock(byte[] in, int i2, byte[] out, int o) {
        int n = BaseMode.b;
        for (int k = 0; k < this.c.length; ++k) {
            this.c[k] = (byte)(this.a[k] ^ in[k + i2]);
            if (n == 0) continue;
        }
        this.cipher.encryptBlock(this.c, 0, out, o);
        System.arraycopy(out, o, this.a, 0, this.cipherBlockSize);
    }

    @Override
    public void decryptBlock(byte[] in, int i2, byte[] out, int o) {
        int n = BaseMode.b;
        byte[] byArray = new byte[this.cipherBlockSize];
        System.arraycopy(in, i2, byArray, 0, this.cipherBlockSize);
        this.cipher.decryptBlock(in, i2, this.c, 0);
        for (int k = 0; k < this.c.length; ++k) {
            out[o + k] = (byte)(this.a[k] ^ this.c[k]);
            if (n == 0) continue;
        }
        System.arraycopy(byArray, 0, this.a, 0, this.cipherBlockSize);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                char[] cArray3 = "\u001f=|".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 124;
                            break;
                        }
                        case 1: {
                            n6 = 95;
                            break;
                        }
                        case 2: {
                            n6 = 31;
                            break;
                        }
                        case 3: {
                            n6 = 114;
                            break;
                        }
                        default: {
                            n6 = 94;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        d = new String(cArray).intern();
    }
}

