/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mode;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;

public abstract class BaseMode
implements IMode {
    protected String name;
    protected int state;
    protected IBlockCipher cipher;
    protected int cipherBlockSize;
    protected int modeBlockSize;
    protected byte[] iv;
    protected AlgorithmParams algorithmParams;
    protected Object lock = new Object();
    public static int b;
    private static final String[] a;

    protected BaseMode(String name, IBlockCipher underlyingCipher, int cipherBlockSize) {
        this.name = name;
        this.cipher = underlyingCipher;
        this.cipherBlockSize = cipherBlockSize;
        this.state = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(byte[] in, int inOffset, byte[] out, int outOffset) throws IllegalStateException {
        int n = b;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 1: {
                    this.encryptBlock(in, inOffset, out, outOffset);
                    if (n == 0) return;
                }
                case 2: {
                    this.decryptBlock(in, inOffset, out, outOffset);
                    if (n == 0) return;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public String name() {
        return new StringBuffer().append(this.name).append('(').append(this.cipher.name()).append(')').toString();
    }

    @Override
    public int defaultBlockSize() {
        return this.cipherBlockSize;
    }

    @Override
    public int defaultKeySize() {
        return this.cipher.defaultKeySize();
    }

    @Override
    public Iterator blockSizes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(this.cipherBlockSize));
        return Collections.unmodifiableList(arrayList).iterator();
    }

    @Override
    public Iterator keySizes() {
        return this.cipher.keySizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(Map attributes) throws InvalidKeyException, IllegalStateException {
        int n = b;
        Object object = this.lock;
        synchronized (object) {
            block20: {
                block19: {
                    Integer n2;
                    if (this.state != -1) {
                        throw new IllegalStateException();
                    }
                    Integer n3 = (Integer)attributes.get(a[8]);
                    if (n3 != null) {
                        switch (n3) {
                            case 1: {
                                this.state = 1;
                                if (n == 0) break;
                            }
                            case 2: {
                                this.state = 2;
                                if (n == 0) break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    this.modeBlockSize = (n2 = (Integer)attributes.get(a[6])) == null ? this.cipherBlockSize : n2;
                    byte[] byArray = (byte[])attributes.get(a[7]);
                    if (byArray == null) break block19;
                    this.iv = (byte[])byArray.clone();
                    if (n == 0) break block20;
                }
                this.iv = new byte[this.modeBlockSize];
            }
            this.algorithmParams = (AlgorithmParams)attributes.get(a[9]);
            this.cipher.init(attributes);
            this.setup();
        }
        if (BaseCipher.b == 0) return;
        b = ++n;
    }

    @Override
    public int currentBlockSize() {
        if (this.state == -1) {
            throw new IllegalStateException();
        }
        return this.modeBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.state = -1;
            this.iv = null;
            this.cipher.reset();
            this.teardown();
        }
    }

    @Override
    public boolean selfTest() {
        Iterator iterator = this.keySizes();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = this.blockSizes();
            while (iterator2.hasNext()) {
                if (this.a(n, (Integer)iterator2.next())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public abstract Object clone();

    public abstract void setup();

    public abstract void teardown();

    @Override
    public abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    @Override
    public abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    private boolean a(int n, int n2) {
        int n3 = b;
        try {
            int n4;
            IMode iMode = (IMode)this.clone();
            byte[] byArray = new byte[this.cipherBlockSize];
            byte[] byArray2 = new byte[n];
            for (n4 = 0; n4 < n; ++n4) {
                byArray2[n4] = (byte)n4;
                if (n3 == 0) continue;
            }
            int n5 = 5;
            int n6 = n5 * n2;
            byte[] byArray3 = new byte[n6];
            for (n4 = 0; n4 < n6; ++n4) {
                byArray3[n4] = (byte)n4;
                if (n3 == 0) continue;
            }
            byte[] byArray4 = new byte[n6];
            byte[] byArray5 = new byte[n6];
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(a[3], byArray2);
            hashMap.put(a[5], new Integer(n2));
            hashMap.put(a[4], new Integer(1));
            hashMap.put(a[0], byArray);
            hashMap.put(a[2], new Integer(n2));
            iMode.reset();
            iMode.init(hashMap);
            for (n4 = 0; n4 < n5; ++n4) {
                iMode.update(byArray3, n4 * n2, byArray4, n4 * n2);
                if (n3 == 0) continue;
            }
            iMode.reset();
            hashMap.put(a[1], new Integer(2));
            iMode.init(hashMap);
            for (n4 = 0; n4 < n5; ++n4) {
                iMode.update(byArray4, n4 * n2, byArray5, n4 * n2);
                if (n3 == 0) continue;
            }
            return Arrays.equals(byArray3, byArray5);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6f\u0011";
        int n2 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block21;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 24;
                                break;
                            }
                            case 1: {
                                n8 = 15;
                                break;
                            }
                            case 2: {
                                n8 = 103;
                                break;
                            }
                            case 3: {
                                n8 = 7;
                                break;
                            }
                            default: {
                                n8 = 17;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6|\u0013fe}";
                    n2 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6m\u000bhrs!\u0014nk}";
                    n2 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u007fa\u0012)rjv\u0017s~6l\u000ewy}}Ilta!\nfe}}\u000ef}";
                    n2 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6|\u0013fe}";
                    n2 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u007fa\u0012)rjv\u0017s~6l\u000ewy}}Ie}wl\f)bqu\u0002";
                    n2 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6m\u000bhrs!\u0014nk}";
                    n2 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6f\u0011";
                    n2 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6|\u0013fe}";
                    n2 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u007fa\u0012)rjv\u0017s~6b\bct6n\u000b`?hn\u0015f|k";
                    n2 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

