/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mac;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.mac.IMac;
import java.security.InvalidKeyException;
import java.util.Map;

public abstract class BaseMac
implements IMac {
    protected String name;
    protected IMessageDigest underlyingHash;
    protected int truncatedSize;
    public static boolean b;

    protected BaseMac(String name) {
        this.name = name;
    }

    protected BaseMac(String name, IMessageDigest underlyingHash) {
        this(name);
        if (underlyingHash != null) {
            this.truncatedSize = underlyingHash.hashSize();
        }
        this.underlyingHash = underlyingHash;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int macSize() {
        return this.truncatedSize;
    }

    @Override
    public void update(byte b2) {
        this.underlyingHash.update(b2);
    }

    @Override
    public void update(byte[] b2, int offset, int len) {
        this.underlyingHash.update(b2, offset, len);
    }

    @Override
    public void reset() {
        this.underlyingHash.reset();
    }

    @Override
    public abstract Object clone();

    @Override
    public abstract void init(Map var1) throws InvalidKeyException, IllegalStateException;

    @Override
    public abstract byte[] digest();

    @Override
    public abstract boolean selfTest();
}

