/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.key.rsa;

import gnu.crypto.Registry;
import gnu.crypto.key.rsa.GnuRSAKey;
import gnu.crypto.key.rsa.RSAKeyPairRawCodec;
import gnu.crypto.key.rsa.RSAKeyPairX509Codec;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public class GnuRSAPrivateKey
extends GnuRSAKey
implements PrivateKey,
RSAPrivateCrtKey {
    private final BigInteger d;
    private final BigInteger e;
    private final BigInteger f;
    private final BigInteger g;
    private final BigInteger h;
    private final BigInteger i;
    private static final String[] j;

    public GnuRSAPrivateKey(BigInteger p, BigInteger q, BigInteger e2, BigInteger d2) {
        super(p.multiply(q), e2);
        this.d = p;
        this.e = q;
        this.f = d2;
        this.g = e2.modInverse(p.subtract(BigInteger.ONE));
        this.h = e2.modInverse(q.subtract(BigInteger.ONE));
        this.i = q.modInverse(p);
    }

    public static GnuRSAPrivateKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_RSA_PRIVATE_KEY[0]) {
            RSAKeyPairRawCodec rSAKeyPairRawCodec = new RSAKeyPairRawCodec();
            return (GnuRSAPrivateKey)rSAKeyPairRawCodec.decodePrivateKey(k);
        }
        throw new IllegalArgumentException(j[0]);
    }

    @Override
    public BigInteger getPrimeP() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.e;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.g;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.h;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.i;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.f;
    }

    @Override
    public byte[] getEncoded(int format) {
        byte[] byArray = null;
        switch (format) {
            case 1: {
                byArray = new RSAKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            case 2: {
                byArray = new RSAKeyPairX509Codec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException(j[1]);
            }
        }
        return byArray;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof RSAPrivateKey) {
            boolean bl;
            block22: {
                block21: {
                    RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)obj;
                    if (!super.equals(rSAPrivateKey) || !this.f.equals(rSAPrivateKey.getPrivateExponent())) break block21;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
            return bl;
        }
        if (obj instanceof RSAPrivateCrtKey) {
            boolean bl;
            block24: {
                block23: {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)obj;
                    if (!super.equals(rSAPrivateCrtKey) || !this.d.equals(rSAPrivateCrtKey.getPrimeP())) break block23;
                    if (!this.e.equals(rSAPrivateCrtKey.getPrimeQ())) break block23;
                    if (!this.g.equals(rSAPrivateCrtKey.getPrimeExponentP())) break block23;
                    if (!this.h.equals(rSAPrivateCrtKey.getPrimeExponentQ())) break block23;
                    if (!this.i.equals(rSAPrivateCrtKey.getCrtCoefficient())) break block23;
                    bl = true;
                    break block24;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "f}06C";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 11;
                                break;
                            }
                            case 1: {
                                n8 = 28;
                                break;
                            }
                            case 2: {
                                n8 = 87;
                                break;
                            }
                            case 3: {
                                n8 = 95;
                                break;
                            }
                            default: {
                                n8 = 32;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "ms%2A\u007f";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        j = stringArray3;
    }
}

