/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.key.dss;

import gnu.crypto.Registry;
import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.key.IKeyPairCodec;
import gnu.crypto.key.dss.DSSKey;
import gnu.crypto.key.dss.DSSPrivateKey;
import gnu.crypto.key.dss.DSSPublicKey;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class DSSKeyPairRawCodec
implements IKeyPairCodec {
    private static final String[] a;

    @Override
    public int getFormatID() {
        return 1;
    }

    @Override
    public byte[] encodePublicKey(PublicKey key) {
        if (!(key instanceof DSSPublicKey)) {
            throw new IllegalArgumentException(a[0]);
        }
        DSSPublicKey dSSPublicKey = (DSSPublicKey)key;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PUBLIC_KEY[0]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PUBLIC_KEY[1]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PUBLIC_KEY[2]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PUBLIC_KEY[3]);
        byteArrayOutputStream.write(1);
        byte[] byArray = dSSPublicKey.getParams().getP().toByteArray();
        int n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = dSSPublicKey.getParams().getQ().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = dSSPublicKey.getParams().getG().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = dSSPublicKey.getY().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public PublicKey decodePublicKey(byte[] k) {
        block12: {
            block11: {
                if (k[0] != Registry.MAGIC_RAW_DSS_PUBLIC_KEY[0] || k[1] != Registry.MAGIC_RAW_DSS_PUBLIC_KEY[1]) break block11;
                if (k[2] != Registry.MAGIC_RAW_DSS_PUBLIC_KEY[2]) break block11;
                if (k[3] == Registry.MAGIC_RAW_DSS_PUBLIC_KEY[3]) break block12;
            }
            throw new IllegalArgumentException(a[2]);
        }
        if (k[4] != 1) {
            throw new IllegalArgumentException(a[1]);
        }
        int n = 5;
        int n2 = k[n++] << 24 | (k[n++] & 0xFF) << 16 | (k[n++] & 0xFF) << 8 | k[n++] & 0xFF;
        byte[] byArray = new byte[n2];
        System.arraycopy(k, n, byArray, 0, n2);
        n += n2;
        BigInteger bigInteger = new BigInteger(1, byArray);
        n2 = k[n++] << 24 | (k[n++] & 0xFF) << 16 | (k[n++] & 0xFF) << 8 | k[n++] & 0xFF;
        byArray = new byte[n2];
        System.arraycopy(k, n, byArray, 0, n2);
        n += n2;
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        n2 = k[n++] << 24 | (k[n++] & 0xFF) << 16 | (k[n++] & 0xFF) << 8 | k[n++] & 0xFF;
        byArray = new byte[n2];
        System.arraycopy(k, n, byArray, 0, n2);
        n += n2;
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        n2 = k[n++] << 24 | (k[n++] & 0xFF) << 16 | (k[n++] & 0xFF) << 8 | k[n++] & 0xFF;
        byArray = new byte[n2];
        System.arraycopy(k, n, byArray, 0, n2);
        n += n2;
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        return new DSSPublicKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    @Override
    public byte[] encodePrivateKey(PrivateKey key) {
        if (!(key instanceof DSSPrivateKey)) {
            throw new IllegalArgumentException(a[3]);
        }
        DSSPrivateKey dSSPrivateKey = (DSSPrivateKey)key;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PRIVATE_KEY[0]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PRIVATE_KEY[1]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PRIVATE_KEY[2]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_DSS_PRIVATE_KEY[3]);
        byteArrayOutputStream.write(1);
        byte[] byArray = dSSPrivateKey.getParams().getP().toByteArray();
        int n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = dSSPrivateKey.getParams().getQ().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = dSSPrivateKey.getParams().getG().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = dSSPrivateKey.getX().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public PrivateKey decodePrivateKey(byte[] k) {
        int n;
        block15: {
            block14: {
                n = DSSKey.b;
                if (k[0] != Registry.MAGIC_RAW_DSS_PRIVATE_KEY[0] || k[1] != Registry.MAGIC_RAW_DSS_PRIVATE_KEY[1]) break block14;
                if (k[2] != Registry.MAGIC_RAW_DSS_PRIVATE_KEY[2]) break block14;
                if (k[3] == Registry.MAGIC_RAW_DSS_PRIVATE_KEY[3]) break block15;
            }
            throw new IllegalArgumentException(a[5]);
        }
        if (k[4] != 1) {
            throw new IllegalArgumentException(a[4]);
        }
        int n2 = 5;
        int n3 = k[n2++] << 24 | (k[n2++] & 0xFF) << 16 | (k[n2++] & 0xFF) << 8 | k[n2++] & 0xFF;
        byte[] byArray = new byte[n3];
        System.arraycopy(k, n2, byArray, 0, n3);
        n2 += n3;
        BigInteger bigInteger = new BigInteger(1, byArray);
        n3 = k[n2++] << 24 | (k[n2++] & 0xFF) << 16 | (k[n2++] & 0xFF) << 8 | k[n2++] & 0xFF;
        byArray = new byte[n3];
        System.arraycopy(k, n2, byArray, 0, n3);
        n2 += n3;
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        n3 = k[n2++] << 24 | (k[n2++] & 0xFF) << 16 | (k[n2++] & 0xFF) << 8 | k[n2++] & 0xFF;
        byArray = new byte[n3];
        System.arraycopy(k, n2, byArray, 0, n3);
        n2 += n3;
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        n3 = k[n2++] << 24 | (k[n2++] & 0xFF) << 16 | (k[n2++] & 0xFF) << 8 | k[n2++] & 0xFF;
        byArray = new byte[n3];
        System.arraycopy(k, n2, byArray, 0, n3);
        n2 += n3;
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        DSSPrivateKey dSSPrivateKey = new DSSPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        if (BaseCipher.b != 0) {
            DSSKey.b = ++n;
        }
        return dSSPrivateKey;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0015Qu";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 126;
                                break;
                            }
                            case 1: {
                                n8 = 52;
                                break;
                            }
                            case 2: {
                                n8 = 12;
                                break;
                            }
                            case 3: {
                                n8 = 5;
                                break;
                            }
                            default: {
                                n8 = 81;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\bQ~v8\u0011Z";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0013Ukl2";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0015Qu";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\bQ~v8\u0011Z";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0013Ukl2";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

