/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.hash.BaseHash;
import gnu.crypto.util.Util;

public class Haval
extends BaseHash {
    public static final int HAVAL_VERSION = 1;
    public static final int HAVAL_128_BIT = 16;
    public static final int HAVAL_160_BIT = 20;
    public static final int HAVAL_192_BIT = 24;
    public static final int HAVAL_224_BIT = 28;
    public static final int HAVAL_256_BIT = 32;
    public static final int HAVAL_3_ROUND = 3;
    public static final int HAVAL_4_ROUND = 4;
    public static final int HAVAL_5_ROUND = 5;
    private static final int a = 128;
    private static final String c;
    private static Boolean d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;
    private int l;
    private int m;
    private static final String[] n;

    public Haval() {
        this(16, 3);
    }

    public Haval(int size) {
        this(size, 3);
    }

    public Haval(int size, int rounds) {
        block16: {
            block15: {
                super(n[3], size, 128);
                this.e = 3;
                if (size != 16) {
                    if (size == 20 || size == 24) break block15;
                    if (size == 28) break block15;
                    if (size == 32) break block15;
                    throw new IllegalArgumentException(n[1]);
                }
            }
            if (rounds == 3 || rounds == 4) break block16;
            if (rounds == 5) break block16;
            throw new IllegalArgumentException(n[2]);
        }
        this.e = rounds;
    }

    private Haval(Haval haval) {
        this(haval.hashSize, haval.e);
        this.f = haval.f;
        this.g = haval.g;
        this.h = haval.h;
        this.i = haval.i;
        this.j = haval.j;
        this.k = haval.k;
        this.l = haval.l;
        this.m = haval.m;
        this.count = haval.count;
        this.buffer = (byte[])haval.buffer.clone();
    }

    @Override
    public Object clone() {
        return new Haval(this);
    }

    @Override
    protected synchronized void transform(byte[] in, int i2) {
        block6: {
            boolean bl;
            block8: {
                block7: {
                    boolean bl2 = BaseHash.b;
                    int n = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n2 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n3 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n4 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n5 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n6 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n7 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n8 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n9 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n10 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n11 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n12 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n13 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n14 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n15 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n16 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n17 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n18 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n19 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n20 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n21 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n22 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n23 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n24 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n25 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n26 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n27 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n28 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n29 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n30 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n31 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n32 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8 | (in[i2++] & 0xFF) << 16 | (in[i2++] & 0xFF) << 24;
                    int n33 = this.f;
                    int n34 = this.g;
                    int n35 = this.h;
                    int n36 = this.i;
                    int n37 = this.j;
                    int n38 = this.k;
                    int n39 = this.l;
                    int n40 = this.m;
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n2);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n3);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n4);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n5);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n6);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n7);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n8);
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n9);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n10);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n11);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n12);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n13);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n14);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n15);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n16);
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n17);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n18);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n19);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n20);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n21);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n22);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n23);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n24);
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n25);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n26);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n27);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n28);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n29);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n30);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n31);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n32);
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n6, 1160258022);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n15, 953160567);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n27, -1101764913);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n19, 887688300);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n12, -1062458953);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n29, -914599715);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n8, 1065670069);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n17, -1253635817);
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n, -1843997223);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n24, -1988494565);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n21, -785314906);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n23, -1730169428);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n2, 805139163);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n11, -803545161);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n5, -1193168915);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n9, 1780907670);
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n31, -1166241723);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n4, -248741991);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n22, 614570311);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n10, -1282315017);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n18, 134345442);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n25, -2054226922);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n30, 1667834072);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n7, 1901547113);
                    n40 = this.a(n40, n39, n38, n37, n36, n35, n34, n33, n20, -1537671517);
                    n39 = this.a(n39, n38, n37, n36, n35, n34, n33, n40, n13, -191677058);
                    n38 = this.a(n38, n37, n36, n35, n34, n33, n40, n39, n16, 227898511);
                    n37 = this.a(n37, n36, n35, n34, n33, n40, n39, n38, n14, 1921955416);
                    n36 = this.a(n36, n35, n34, n33, n40, n39, n38, n37, n3, 1904987480);
                    n35 = this.a(n35, n34, n33, n40, n39, n38, n37, n36, n26, -2112533778);
                    n34 = this.a(n34, n33, n40, n39, n38, n37, n36, n35, n32, 2069144605);
                    n33 = this.a(n33, n40, n39, n38, n37, n36, n35, n34, n28, -1034266187);
                    n40 = this.b(n40, n39, n38, n37, n36, n35, n34, n33, n20, -1674521287);
                    n39 = this.b(n39, n38, n37, n36, n35, n34, n33, n40, n10, 720527379);
                    n38 = this.b(n38, n37, n36, n35, n34, n33, n40, n39, n5, -976113629);
                    n37 = this.b(n37, n36, n35, n34, n33, n40, n39, n38, n21, 677414384);
                    n36 = this.b(n36, n35, n34, n33, n40, n39, n38, n37, n29, -901678824);
                    n35 = this.b(n35, n34, n33, n40, n39, n38, n37, n36, n18, -1193592593);
                    n34 = this.b(n34, n33, n40, n39, n38, n37, n36, n35, n9, -1904616272);
                    n33 = this.b(n33, n40, n39, n38, n37, n36, n35, n34, n23, 1614419982);
                    n40 = this.b(n40, n39, n38, n37, n36, n35, n34, n33, n30, 1822297739);
                    n39 = this.b(n39, n38, n37, n36, n35, n34, n33, n40, n15, -1340175810);
                    n38 = this.b(n38, n37, n36, n35, n34, n33, n40, n39, n26, -686458943);
                    n37 = this.b(n37, n36, n35, n34, n33, n40, n39, n38, n13, -1120842969);
                    n36 = this.b(n36, n35, n34, n33, n40, n39, n38, n37, n25, 2024746970);
                    n35 = this.b(n35, n34, n33, n40, n39, n38, n37, n36, n31, 1432378464);
                    n34 = this.b(n34, n33, n40, n39, n38, n37, n36, n35, n17, -430627341);
                    n33 = this.b(n33, n40, n39, n38, n37, n36, n35, n34, n27, -1437226092);
                    n40 = this.b(n40, n39, n38, n37, n36, n35, n34, n33, n32, 1464375394);
                    n39 = this.b(n39, n38, n37, n36, n35, n34, n33, n40, n16, 1676153920);
                    n38 = this.b(n38, n37, n36, n35, n34, n33, n40, n39, n8, 1439316330);
                    n37 = this.b(n37, n36, n35, n34, n33, n40, n39, n38, n4, 715854006);
                    n36 = this.b(n36, n35, n34, n33, n40, n39, n38, n37, n2, -1261675468);
                    n35 = this.b(n35, n34, n33, n40, n39, n38, n37, n36, n, 289532110);
                    n34 = this.b(n34, n33, n40, n39, n38, n37, n36, n35, n19, -1588296017);
                    n33 = this.b(n33, n40, n39, n38, n37, n36, n35, n34, n28, 2087905683);
                    n40 = this.b(n40, n39, n38, n37, n36, n35, n34, n33, n14, -1276242927);
                    n39 = this.b(n39, n38, n37, n36, n35, n34, n33, n40, n7, 1668267050);
                    n38 = this.b(n38, n37, n36, n35, n34, n33, n40, n39, n22, 732546397);
                    n37 = this.b(n37, n36, n35, n34, n33, n40, n39, n38, n11, 1947742710);
                    n36 = this.b(n36, n35, n34, n33, n40, n39, n38, n37, n24, -832815594);
                    n35 = this.b(n35, n34, n33, n40, n39, n38, n37, n36, n12, -1685613794);
                    n34 = this.b(n34, n33, n40, n39, n38, n37, n36, n35, n6, -1344882125);
                    n33 = this.b(n33, n40, n39, n38, n37, n36, n35, n34, n3, 1814351708);
                    if (this.e >= 4) {
                        n40 = this.c(n40, n39, n38, n37, n36, n35, n34, n33, n25, 2050118529);
                        n39 = this.c(n39, n38, n37, n36, n35, n34, n33, n40, n5, 680887927);
                        n38 = this.c(n38, n37, n36, n35, n34, n33, n40, n39, n, 999245976);
                        n37 = this.c(n37, n36, n35, n34, n33, n40, n39, n38, n15, 1800124847);
                        n36 = this.c(n36, n35, n34, n33, n40, n39, n38, n37, n3, -994056165);
                        n35 = this.c(n35, n34, n33, n40, n39, n38, n37, n36, n8, 1713906067);
                        n34 = this.c(n34, n33, n40, n39, n38, n37, n36, n35, n29, 1641548236);
                        n33 = this.c(n33, n40, n39, n38, n37, n36, n35, n34, n24, -81679983);
                        n40 = this.c(n40, n39, n38, n37, n36, n35, n34, n33, n27, 1216130144);
                        n39 = this.c(n39, n38, n37, n36, n35, n34, n33, n40, n7, 1575780402);
                        n38 = this.c(n38, n37, n36, n35, n34, n33, n40, n39, n31, -276538019);
                        n37 = this.c(n37, n36, n35, n34, n33, n40, n39, n38, n21, -377129551);
                        n36 = this.c(n36, n35, n34, n33, n40, n39, n38, n37, n19, -601480446);
                        n35 = this.c(n35, n34, n33, n40, n39, n38, n37, n36, n26, -345695352);
                        n34 = this.c(n34, n33, n40, n39, n38, n37, n36, n35, n20, 596196993);
                        n33 = this.c(n33, n40, n39, n38, n37, n36, n35, n34, n4, -745100091);
                        n40 = this.c(n40, n39, n38, n37, n36, n35, n34, n33, n23, 258830323);
                        n39 = this.c(n39, n38, n37, n36, n35, n34, n33, n40, n12, -2081144263);
                        n38 = this.c(n38, n37, n36, n35, n34, n33, n40, n39, n32, 772490370);
                        n37 = this.c(n37, n36, n35, n34, n33, n40, n39, n38, n22, -1534844924);
                        n36 = this.c(n36, n35, n34, n33, n40, n39, n38, n37, n9, 1774776394);
                        n35 = this.c(n35, n34, n33, n40, n39, n38, n37, n36, n28, -1642095778);
                        n34 = this.c(n34, n33, n40, n39, n38, n37, n36, n35, n13, 566650946);
                        n33 = this.c(n33, n40, n39, n38, n37, n36, n35, n34, n10, -152474470);
                        n40 = this.c(n40, n39, n38, n37, n36, n35, n34, n33, n2, 1728879713);
                        n39 = this.c(n39, n38, n37, n36, n35, n34, n33, n40, n30, -1412200208);
                        n38 = this.c(n38, n37, n36, n35, n34, n33, n40, n39, n6, 1783734482);
                        n37 = this.c(n37, n36, n35, n34, n33, n40, n39, n38, n16, -665571480);
                        n36 = this.c(n36, n35, n34, n33, n40, n39, n38, n37, n18, -1777359064);
                        n35 = this.c(n35, n34, n33, n40, n39, n38, n37, n36, n11, -1420741725);
                        n34 = this.c(n34, n33, n40, n39, n38, n37, n36, n35, n17, 1861159788);
                        n33 = this.c(n33, n40, n39, n38, n37, n36, n35, n34, n14, 326777828);
                        if (this.e == 5) {
                            n40 = this.d(n40, n39, n38, n37, n36, n35, n34, n33, n28, -1170476976);
                            n39 = this.d(n39, n38, n37, n36, n35, n34, n33, n40, n4, 2130389656);
                            n38 = this.d(n38, n37, n36, n35, n34, n33, n40, n39, n22, -1578015459);
                            n37 = this.d(n37, n36, n35, n34, n33, n40, n39, n38, n27, 967770486);
                            n36 = this.d(n36, n35, n34, n33, n40, n39, n38, n37, n18, 1724537150);
                            n35 = this.d(n35, n34, n33, n40, n39, n38, n37, n36, n12, -2109534584);
                            n34 = this.d(n34, n33, n40, n39, n38, n37, n36, n35, n21, -1930525159);
                            n33 = this.d(n33, n40, n39, n38, n37, n36, n35, n34, n30, 1164943284);
                            n40 = this.d(n40, n39, n38, n37, n36, n35, n34, n33, n20, 2105845187);
                            n39 = this.d(n39, n38, n37, n36, n35, n34, n33, n40, n, 998989502);
                            n38 = this.d(n38, n37, n36, n35, n34, n33, n40, n39, n13, -529566248);
                            n37 = this.d(n37, n36, n35, n34, n33, n40, n39, n38, n8, -2050940813);
                            n36 = this.d(n36, n35, n34, n33, n40, n39, n38, n37, n14, 1075463327);
                            n35 = this.d(n35, n34, n33, n40, n39, n38, n37, n36, n9, 1455516326);
                            n34 = this.d(n34, n33, n40, n39, n38, n37, n36, n35, n32, 1322494562);
                            n33 = this.d(n33, n40, n39, n38, n37, n36, n35, n34, n11, 910128902);
                            n40 = this.d(n40, n39, n38, n37, n36, n35, n34, n33, n6, 469688178);
                            n39 = this.d(n39, n38, n37, n36, n35, n34, n33, n40, n10, 1117454909);
                            n38 = this.d(n38, n37, n36, n35, n34, n33, n40, n39, n15, 936433444);
                            n37 = this.d(n37, n36, n35, n34, n33, n40, n39, n38, n31, -804646328);
                            n36 = this.d(n36, n35, n34, n33, n40, n39, n38, n37, n19, -619713837);
                            n35 = this.d(n35, n34, n33, n40, n39, n38, n37, n36, n7, 1240580251);
                            n34 = this.d(n34, n33, n40, n39, n38, n37, n36, n35, n29, 122909385);
                            n33 = this.d(n33, n40, n39, n38, n37, n36, n35, n34, n25, -2137449605);
                            n40 = this.d(n40, n39, n38, n37, n36, n35, n34, n33, n3, 634681816);
                            n39 = this.d(n39, n38, n37, n36, n35, n34, n33, n40, n24, -152510729);
                            n38 = this.d(n38, n37, n36, n35, n34, n33, n40, n39, n17, -469872614);
                            n37 = this.d(n37, n36, n35, n34, n33, n40, n39, n38, n23, -1233564613);
                            n36 = this.d(n36, n35, n34, n33, n40, n39, n38, n37, n5, -1754472259);
                            n35 = this.d(n35, n34, n33, n40, n39, n38, n37, n36, n2, 79693498);
                            n34 = this.d(n34, n33, n40, n39, n38, n37, n36, n35, n26, -1045868618);
                            n33 = this.d(n33, n40, n39, n38, n37, n36, n35, n34, n16, 1084186820);
                        }
                    }
                    this.m += n40;
                    this.l += n39;
                    this.k += n38;
                    this.j += n37;
                    this.i += n36;
                    this.h += n35;
                    this.g += n34;
                    this.f += n33;
                    if (BaseCipher.b == 0) break block6;
                    if (!bl2) break block7;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            BaseHash.b = bl;
        }
    }

    @Override
    protected byte[] padBuffer() {
        int n = (int)(this.count % 128L);
        int n2 = n < 118 ? 118 - n : 246 - n;
        int n3 = n2;
        byte[] byArray = new byte[n3 + 10];
        byArray[0] = 1;
        int n4 = this.hashSize * 8;
        byArray[n3++] = (byte)((n4 & 3) << 6 | (this.e & 7) << 3 | 1);
        byArray[n3++] = (byte)(n4 >>> 2);
        long l = this.count << 3;
        byArray[n3++] = (byte)l;
        byArray[n3++] = (byte)(l >>> 8);
        byArray[n3++] = (byte)(l >>> 16);
        byArray[n3++] = (byte)(l >>> 24);
        byArray[n3++] = (byte)(l >>> 32);
        byArray[n3++] = (byte)(l >>> 40);
        byArray[n3++] = (byte)(l >>> 48);
        byArray[n3] = (byte)(l >>> 56);
        return byArray;
    }

    @Override
    protected byte[] getResult() {
        this.a();
        byte[] byArray = new byte[this.hashSize];
        if (this.hashSize >= 32) {
            byArray[31] = (byte)(this.m >>> 24);
            byArray[30] = (byte)(this.m >>> 16);
            byArray[29] = (byte)(this.m >>> 8);
            byArray[28] = (byte)this.m;
        }
        if (this.hashSize >= 28) {
            byArray[27] = (byte)(this.l >>> 24);
            byArray[26] = (byte)(this.l >>> 16);
            byArray[25] = (byte)(this.l >>> 8);
            byArray[24] = (byte)this.l;
        }
        if (this.hashSize >= 24) {
            byArray[23] = (byte)(this.k >>> 24);
            byArray[22] = (byte)(this.k >>> 16);
            byArray[21] = (byte)(this.k >>> 8);
            byArray[20] = (byte)this.k;
        }
        if (this.hashSize >= 20) {
            byArray[19] = (byte)(this.j >>> 24);
            byArray[18] = (byte)(this.j >>> 16);
            byArray[17] = (byte)(this.j >>> 8);
            byArray[16] = (byte)this.j;
        }
        byArray[15] = (byte)(this.i >>> 24);
        byArray[14] = (byte)(this.i >>> 16);
        byArray[13] = (byte)(this.i >>> 8);
        byArray[12] = (byte)this.i;
        byArray[11] = (byte)(this.h >>> 24);
        byArray[10] = (byte)(this.h >>> 16);
        byArray[9] = (byte)(this.h >>> 8);
        byArray[8] = (byte)this.h;
        byArray[7] = (byte)(this.g >>> 24);
        byArray[6] = (byte)(this.g >>> 16);
        byArray[5] = (byte)(this.g >>> 8);
        byArray[4] = (byte)this.g;
        byArray[3] = (byte)(this.f >>> 24);
        byArray[2] = (byte)(this.f >>> 16);
        byArray[1] = (byte)(this.f >>> 8);
        byArray[0] = (byte)this.f;
        return byArray;
    }

    @Override
    protected void resetContext() {
        this.f = 608135816;
        this.g = -2052912941;
        this.h = 320440878;
        this.i = 57701188;
        this.j = -1542899678;
        this.k = 698298832;
        this.l = 137296536;
        this.m = -330404727;
    }

    @Override
    public boolean selfTest() {
        if (d == null) {
            d = new Boolean(n[0].equals(Util.toString(new Haval().digest())));
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a() {
        boolean bl = BaseHash.b;
        switch (this.hashSize) {
            case 16: {
                int n = this.m & 0xFF | this.l & 0xFF000000 | this.k & 0xFF0000 | this.j & 0xFF00;
                this.f += n >>> 8 | n << 24;
                n = this.m & 0xFF00 | this.l & 0xFF | this.k & 0xFF000000 | this.j & 0xFF0000;
                this.g += n >>> 16 | n << 16;
                n = this.m & 0xFF0000 | this.l & 0xFF00 | this.k & 0xFF | this.j & 0xFF000000;
                this.h += n >>> 24 | n << 8;
                n = this.m & 0xFF000000 | this.l & 0xFF0000 | this.k & 0xFF00 | this.j & 0xFF;
                this.i += n;
                if (!bl) return;
            }
            case 20: {
                int n = this.m & 0x3F | this.l & 0xFE000000 | this.k & 0x1F80000;
                this.f += n >>> 19 | n << 13;
                n = this.m & 0xFC0 | this.l & 0x3F | this.k & 0xFE000000;
                this.g += n >>> 25 | n << 7;
                n = this.m & 0x7F000 | this.l & 0xFC0 | this.k & 0x3F;
                this.h += n;
                n = this.m & 0x1F80000 | this.l & 0x7F000 | this.k & 0xFC0;
                this.i += n >>> 6;
                n = this.m & 0xFE000000 | this.l & 0x1F80000 | this.k & 0x7F000;
                this.j += n >>> 12;
                if (!bl) return;
            }
            case 24: {
                int n = this.m & 0x1F | this.l & 0xFC000000;
                this.f += n >>> 26 | n << 6;
                n = this.m & 0x3E0 | this.l & 0x1F;
                this.g += n;
                n = this.m & 0xFC00 | this.l & 0x3E0;
                this.h += n >>> 5;
                n = this.m & 0x1F0000 | this.l & 0xFC00;
                this.i += n >>> 10;
                n = this.m & 0x3E00000 | this.l & 0x1F0000;
                this.j += n >>> 16;
                n = this.m & 0xFC000000 | this.l & 0x3E00000;
                this.k += n >>> 21;
                if (!bl) return;
            }
            case 28: {
                this.f += this.m >>> 27 & 0x1F;
                this.g += this.m >>> 22 & 0x1F;
                this.h += this.m >>> 18 & 0xF;
                this.i += this.m >>> 13 & 0x1F;
                this.j += this.m >>> 9 & 0xF;
                this.k += this.m >>> 4 & 0x1F;
                this.l += this.m & 0xF;
                return;
            }
        }
    }

    private int a(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        boolean bl = BaseHash.b;
        switch (this.e) {
            case 3: {
                n10 = this.a(n7, n8, n5, n3, n2, n6, n4);
                if (!bl) break;
            }
            case 4: {
                n10 = this.a(n6, n2, n7, n4, n3, n5, n8);
                if (!bl) break;
            }
            default: {
                n10 = this.a(n5, n4, n7, n8, n3, n6, n2);
            }
        }
        return (n10 >>> 7 | n10 << 25) + (n >>> 11 | n << 21) + n9;
    }

    private int a(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        boolean bl = BaseHash.b;
        switch (this.e) {
            case 3: {
                n11 = this.b(n4, n6, n7, n8, n3, n5, n2);
                if (!bl) break;
            }
            case 4: {
                n11 = this.b(n5, n3, n6, n8, n7, n2, n4);
                if (!bl) break;
            }
            default: {
                n11 = this.b(n2, n6, n7, n8, n5, n4, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int b(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        boolean bl = BaseHash.b;
        switch (this.e) {
            case 3: {
                n11 = this.c(n2, n7, n6, n5, n4, n3, n8);
                if (!bl) break;
            }
            case 4: {
                n11 = this.c(n7, n4, n5, n2, n8, n6, n3);
                if (!bl) break;
            }
            default: {
                n11 = this.c(n6, n2, n8, n4, n5, n7, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int c(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.e) {
            case 4: {
                n11 = this.d(n2, n4, n8, n3, n6, n7, n5);
                if (!BaseHash.b) break;
            }
            default: {
                n11 = this.d(n7, n3, n5, n6, n8, n4, n2);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int d(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11 = this.e(n6, n3, n8, n2, n4, n5, n7);
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int a(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n6 & (n7 ^ n3) ^ n5 & n2 ^ n4 & n ^ n7;
    }

    private int b(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n5 & (n6 & ~n4 ^ n3 & n2 ^ n ^ n7) ^ n3 & (n6 ^ n2) ^ n4 & n2 ^ n7;
    }

    private int c(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n4 & (n6 & n5 ^ n ^ n7) ^ n6 & n3 ^ n5 & n2 ^ n7;
    }

    private int d(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n3 & (n2 & ~n5 ^ n4 & ~n ^ n6 ^ n ^ n7) ^ n4 & (n6 & n5 ^ n2 ^ n) ^ n5 & n ^ n7;
    }

    private int e(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n7 & (n6 & n5 & n4 ^ ~n2) ^ n6 & n3 ^ n5 & n2 ^ n4 & n;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "5\f\u0010J\u001fO\u0003\u0019?jO\n\u0019J\u001f2~n8\u00185\r\u0018;\u001fC\ri;hA\n";
        int n2 = 3;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block16;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 118;
                                break;
                            }
                            case 1: {
                                n8 = 58;
                                break;
                            }
                            case 2: {
                                n8 = 40;
                                break;
                            }
                            case 3: {
                                n8 = 12;
                                break;
                            }
                            default: {
                                n8 = 44;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                case 3: {
                    c = string.intern();
                    string2 = "5\f\u0010J\u001fO\u0003\u0019?jO\n\u0019J\u001f2~n8\u00185\r\u0018;\u001fC\ri;hA\n";
                    n2 = -1;
                    continue block12;
                }
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "?T^m@\u001f^\bDm {d,C\u0003NXyXVIAvI";
                    n2 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "?T^m@\u001f^\bDm {d,B\u0003WJi^VUN,^\u0019OFh_";
                    n2 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u001e[^m@";
                    n2 = 2;
                    continue block12;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        Haval.n = stringArray3;
    }
}

