/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.GuvenlikSeviyesi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SertifikaTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CertificateSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.KeyUsageSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNEklenecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImzalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifikalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNRawImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;

public class CertStoreRootCertificateOps {
    private static Logger a;
    private final CertStore b;
    public static int c;
    private static final String[] d;

    public CertStoreRootCertificateOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(d[1]);
            throw new ESYARuntimeException(d[0] + lE.getMessage());
        }
        this.b = aDepo;
    }

    public void deleteRootCertificate(long aKokNo) throws CertStoreException {
        if (aKokNo <= 0L) {
            throw new CertStoreException(d[2]);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.kokSertifikaSil(aKokNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aKokNo + d[3], certStoreException);
        }
    }

    public byte[] createRootCertificatesTobeSigned(List<Certificate> aEklenecekList, List<SertifikaTipi> aTipler, List<GuvenlikSeviyesi> aSeviyeler, List<Certificate> aSilinecekList) throws CertStoreException, Asn1Exception {
        DepoASNKokSertifika depoASNKokSertifika;
        int n;
        int n2;
        int n3;
        int n4;
        block8: {
            n4 = c;
            n3 = 0;
            int n5 = 0;
            int n6 = 0;
            n2 = 0;
            if (aEklenecekList != null) {
                n3 = aEklenecekList.size();
                n5 = aTipler.size();
                n6 = aSeviyeler.size();
            }
            if (aSilinecekList != null) {
                n2 = aSilinecekList.size();
            }
            if (n3 == n5 && n5 == n6) break block8;
            throw new CertStoreException(d[7]);
        }
        DepoASNKokSertifikalar depoASNKokSertifikalar = new DepoASNKokSertifikalar();
        depoASNKokSertifikalar.elements = new DepoASNKokSertifika[n3 + n2];
        for (n = 0; n < n3; ++n) {
            DepoASNKokSertifika depoASNKokSertifika2 = new DepoASNKokSertifika();
            depoASNKokSertifika = CertStoreUtil.asnCertTOAsnEklenecek(aEklenecekList.get(n), aTipler.get(n), aSeviyeler.get(n));
            depoASNKokSertifika2.set_eklenecekSertifika((DepoASNEklenecekKokSertifika)depoASNKokSertifika);
            depoASNKokSertifikalar.elements[n] = depoASNKokSertifika2;
            if (n4 == 0) continue;
        }
        for (int i = 0; i < n2; ++i) {
            depoASNKokSertifika = new DepoASNKokSertifika();
            DepoASNSilinecekKokSertifika depoASNSilinecekKokSertifika = CertStoreUtil.asnCertTOAsnSilinecek(aSilinecekList.get(i));
            depoASNKokSertifika.set_silinecekSertifika(depoASNSilinecekKokSertifika);
            depoASNKokSertifikalar.elements[n] = depoASNKokSertifika;
            ++n;
            if (n4 == 0) continue;
        }
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        depoASNKokSertifikalar.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    public void addPersonalRootCertificate(Certificate aCert, SertifikaTipi aTip) throws CertStoreException {
        DepoKokSertifika depoKokSertifika = CertStoreUtil.asnCertTODepoEklenecek(aCert);
        depoKokSertifika.setKokTipi(aTip);
        depoKokSertifika.setKokGuvenSeviyesi(GuvenlikSeviyesi.PERSONAL);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoKokSertifika.getValue(), OzneTipi.KOK_SERTIFIKA);
            depoVEN.kokSertifikaYaz(depoKokSertifika, list);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(d[4], certStoreException);
        }
    }

    public boolean verifySignature(DepoKokSertifika aKok) throws CertStoreException {
        boolean bl = CertStoreUtil.verifyDepoKokSertifika(aKok);
        if (!bl) {
            this.deleteRootCertificate(aKok.getKokSertifikaNo());
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates() throws CertStoreException {
        int n = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List list = ((RsItemSource)depoVEN.kokSertifikaListele()).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list) {
                block9: {
                    try {
                        boolean bl = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika);
                        if (bl) {
                            arrayList.add(depoKokSertifika);
                            if (n == 0) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(d[19], (Throwable)exception);
                    }
                }
                if (n == 0) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(d[20], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates(CertificateSearchTemplate aSAS, SertifikaTipi[] aTipler, GuvenlikSeviyesi[] aSeviyeler) throws CertStoreException {
        int n = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler, aSeviyeler);
            String string = (String)pair.first();
            List list = (List)pair.second();
            List list2 = ((RsItemSource)depoVEN.kokSertifikaListele(string, list.toArray())).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list2) {
                block9: {
                    try {
                        boolean bl = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika);
                        if (bl) {
                            arrayList.add(depoKokSertifika);
                            if (n == 0) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(d[6], (Throwable)exception);
                    }
                }
                if (n == 0) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(d[5], certStoreException);
        }
    }

    public void addSignedRootCertificates(byte[] aImzaliKokSertifikalar) throws CertStoreException {
        int n = c;
        try {
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aImzaliKokSertifikalar);
            DepoASNImzalar depoASNImzalar = new DepoASNImzalar();
            depoASNImzalar.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            DepoASNImza[] depoASNImzaArray = depoASNImzalar.elements;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            for (DepoASNImza depoASNImza : depoASNImzaArray) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                int n2;
                DepoASNKokSertifika depoASNKokSertifika;
                block23: {
                    byte[] byArray = null;
                    depoASNKokSertifika = depoASNImza.imzalanan;
                    n2 = depoASNKokSertifika.getChoiceID();
                    DepoASNRawImza depoASNRawImza = depoASNImza.imza;
                    object6 = new Asn1DerEncodeBuffer();
                    depoASNRawImza.encode((Asn1BerEncodeBuffer)object6);
                    object5 = object6.getMsgCopy();
                    object4 = new Asn1DerEncodeBuffer();
                    depoASNKokSertifika.encode((Asn1BerEncodeBuffer)object4);
                    byArray = object4.getMsgCopy();
                    boolean bl = false;
                    try {
                        bl = CertStoreUtil.verifyEncodedRootCertificate(byArray, depoASNRawImza);
                    }
                    catch (Exception exception) {
                        a.error(d[10], (Throwable)exception);
                        if (n == 0) continue;
                    }
                    if (bl) break block23;
                    try {
                        object3 = null;
                        if (n2 == 1) {
                            object2 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNEklenecekKokSertifika)object2).kokSertifikaValue.value;
                        } else if (n2 == 2) {
                            object2 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNSilinecekKokSertifika)object2).kokSertifikaValue.value;
                        }
                        object2 = new ECertificate((byte[])object3);
                        object = object2.getSerialNumberHex();
                        String string = object2.getSubject().stringValue();
                        a.error(d[12] + (String)object + d[18] + string + d[15]);
                        continue;
                    }
                    catch (Exception exception) {
                        a.error(d[14], (Throwable)exception);
                        if (n == 0) continue;
                    }
                }
                try {
                    if (n2 == 1) {
                        object3 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                        object2 = CertStoreUtil.asnEklenecekTODepoKok(object3);
                        ((DepoKokSertifika)object2).setSatirImzasi((byte[])object5);
                        object = CertStoreUtil.convertToDepoOzet(((DepoKokSertifika)object2).getValue(), OzneTipi.KOK_SERTIFIKA);
                        depoVEN.kokSertifikaYaz((DepoKokSertifika)object2, (List<DepoOzet>)object);
                    }
                    if (n2 != 2) continue;
                    object3 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                    object2 = CertStoreUtil.asnSilinecekToDepoSilinecek((DepoASNSilinecekKokSertifika)object3);
                    ((DepoSilinecekKokSertifika)object2).setSatirImzasi((byte[])object5);
                    depoVEN.silinecekKokSertifikaYaz((DepoSilinecekKokSertifika)object2);
                    continue;
                }
                catch (Exception exception) {
                    try {
                        object6 = null;
                        if (n2 == 1) {
                            object5 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = object5.kokSertifikaValue.value;
                        } else if (n2 == 2) {
                            object5 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = object5.kokSertifikaValue.value;
                        }
                        object5 = new ECertificate((byte[])object6);
                        object4 = object5.getSerialNumberHex();
                        String string = object5.getSubject().stringValue();
                        a.error(d[16] + (String)object4 + d[8] + string + d[11], (Throwable)exception);
                        continue;
                    }
                    catch (Exception exception2) {
                        a.error(d[9], (Throwable)exception2);
                    }
                }
                if (n == 0) continue;
            }
            JDBCUtil.commit(this.b.getConn());
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            a.error(d[13], (Throwable)exception);
            throw new CertStoreException(d[17], exception);
        }
    }

    private Pair<String, List<Object>> a(CertificateSearchTemplate certificateSearchTemplate, SertifikaTipi[] sertifikaTipiArray, GuvenlikSeviyesi[] guvenlikSeviyesiArray) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block39: {
            int n;
            block38: {
                n = c;
                stringBuffer = new StringBuffer("");
                arrayList = new ArrayList<Object>();
                stringBuffer.append(d[37]);
                if (certificateSearchTemplate != null) {
                    block37: {
                        OzetTipi ozetTipi;
                        block35: {
                            block36: {
                                byte[] byArray = certificateSearchTemplate.getValue();
                                if (byArray != null) {
                                    stringBuffer.append(d[26]);
                                    arrayList.add(byArray);
                                }
                                byte[] byArray2 = certificateSearchTemplate.getHash();
                                ozetTipi = certificateSearchTemplate.getHashType();
                                if (byArray2 == null) break block35;
                                stringBuffer.append(d[29]);
                                arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                                arrayList.add(byArray2);
                                if (ozetTipi == null) break block36;
                                stringBuffer.append(d[28]);
                                arrayList.add(ozetTipi.getIntValue());
                                if (n == 0) break block37;
                            }
                            stringBuffer.append(d[39]);
                            if (n == 0) break block37;
                        }
                        if (ozetTipi == null) break block37;
                        stringBuffer.append(d[27]);
                        arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                        arrayList.add(ozetTipi.getIntValue());
                    }
                    byte[] byArray = certificateSearchTemplate.getIssuer();
                    if (byArray != null) {
                        stringBuffer.append(d[38]);
                        arrayList.add(byArray);
                    }
                    byte[] byArray3 = certificateSearchTemplate.getSubject();
                    if (byArray3 != null) {
                        stringBuffer.append(d[30]);
                        arrayList.add(byArray3);
                    }
                    byte[] byArray4 = certificateSearchTemplate.getSerialNumber();
                    if (byArray4 != null) {
                        stringBuffer.append(d[22]);
                        arrayList.add(byArray4);
                    }
                    byte[] byArray5 = certificateSearchTemplate.getSubjectKeyID();
                    if (byArray5 != null) {
                        stringBuffer.append(d[34]);
                        arrayList.add(byArray5);
                    }
                    KeyUsageSearchTemplate keyUsageSearchTemplate = certificateSearchTemplate.getAnahtarKullanim();
                    if (keyUsageSearchTemplate != null) {
                        stringBuffer.append(d[31]);
                        arrayList.add(keyUsageSearchTemplate.sorguOlustur());
                    }
                }
                if (sertifikaTipiArray == null || sertifikaTipiArray.length == 0) break block38;
                stringBuffer.append(d[21]);
                stringBuffer.append(d[35]);
                for (int i = 0; i < sertifikaTipiArray.length - 1; ++i) {
                    stringBuffer.append(sertifikaTipiArray[i].getIntValue() + d[24]);
                    if (n == 0) continue;
                }
                stringBuffer.append(sertifikaTipiArray[sertifikaTipiArray.length - 1].getIntValue() + d[33]);
            }
            if (guvenlikSeviyesiArray == null || guvenlikSeviyesiArray.length == 0) break block39;
            stringBuffer.append(d[23]);
            stringBuffer.append(d[32]);
            for (int i = 0; i < guvenlikSeviyesiArray.length - 1; ++i) {
                stringBuffer.append(guvenlikSeviyesiArray[i].getIntValue() + d[36]);
                if (n == 0) continue;
            }
            stringBuffer.append(guvenlikSeviyesiArray[guvenlikSeviyesiArray.length - 1].getIntValue() + d[25]);
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[40];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "&\n7Cu\u0019C/Mu\u001e\u0011+NnJ\u0001%Qz\u0018\n7KaDC";
        int n2 = -1;
        block47: while (true) {
            char[] cArray;
            block52: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block51: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block51;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block52;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 106;
                                break;
                            }
                            case 1: {
                                n8 = 99;
                                break;
                            }
                            case 2: {
                                n8 = 68;
                                break;
                            }
                            case 3: {
                                n8 = 34;
                                break;
                            }
                            default: {
                                n8 = 27;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "&\n7Cu\u0019C/Mu\u001e\u0011+NnJ\u0001%Qz\u0018\n7KaD";
                    n2 = 0;
                    continue block47;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "$\u00067L~J*\u0000\u0002w\u000f\u0011-\u0002+J\u0007%L;\b\u0016=WpJ\f(Oz\u0001C>Mi\u001f\r C\u007f\u0003\u0011";
                    n2 = 1;
                    continue block47;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "J\r+NnJ\b+Ih\u000f\u00110K}\u0003\b%\u0002h\u0003\u000f-Lr\u0018\b!L;<7djz\u001e\u00027K;%\u000f1Qo\u001fM\u001dCk\u0003\u000f%L;<7dKh\u0006\u0006)N~\u0018\ndE~\u0018\ndCw\u0003\r K5";
                    n2 = 2;
                    continue block47;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "!\f/q~\u0018\u0017-Dr\u0001\u0002d[z\u0010\n(Ki\u0001\u0006*\u0002M>C,Co\u000b\u0010-\u0002t\u0006\u00167VnD:%Rr\u0006\u0002*\u0002M>C-Qw\u000f\u000e(Gi\u0003C#Gi\u0003C%Nr\u0004\u0007-\f";
                    n2 = 3;
                    continue block47;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "9\u0002&Nt\u0004\u0002dEt\u0018\u0006dIt\u0001\u0010!Po\u0003\u0005-IzJ\u000f-Qo\u000f\u000f!Lr\u0018\b!L;<7dJz\u001e\u00027K;\u0005\u000f1Qo\u001fM";
                    n2 = 4;
                    continue block47;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "!\f/\u0002h\u000f\u00110K}\u0003\b%\u0002\u007f\u0005\u00046Ww\u000b\u000e%FzJ\u000b%Vz";
                    n2 = 5;
                    continue block47;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "/\b(Gu\u000f\u0000!I;\u0019\u00066Vr\f\n/Cw\u000b\u0011dKx\u0003\rdNr\u0019\u0017!\u0002y\u0005\u001a1Vw\u000b\u0011-\u0002z\u0013\r-\u0002t\u0006\u000e%I;\u0010\f6Wu\u000e\u0002 Ki";
                    n2 = 6;
                    continue block47;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "J\u0010!PrJ\r+NnJ";
                    n2 = 7;
                    continue block47;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "#\u000e>Cw\u0003C Mh\u0013\u0002 Cp\u0003C/MpJ\u0010!Po\u0003\u0005-Iz\u0006\u00026Fz\u0004C&Ki\u0003C!Iw\u000f\r!O~\u000e\njq~\u0018\u0017-Dr\u0001\u0002d@r\u0006\u0004-N~\u0018\ndCw\u0003\r%Or\u0013\f6";
                    n2 = 8;
                    continue block47;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "#\u000e>Cw\u0003C Mh\u0013\u0002 Cp\u0003C/MpJ\u0010!Po\u0003\u0005-Iz\u0006\u00026Fz\u0004C&Ki\u0003C M|\u0018\u0016(Cu\u000b\u000e%FrD";
                    n2 = 9;
                    continue block47;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "J\u00101@q\u000f\u00000NrJ\b+I;\u0019\u00066Vr\f\n/C;\u000f\b(Gu\u000f\u000e!FrD";
                    n2 = 10;
                    continue block47;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "#\u000e>Cw\u0003C\u0000Mh\u0013\u0002 CuJ";
                    n2 = 11;
                    continue block47;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "#\u000e>Cw\u0003C/MpJ\u0010!Po\u0003\u0005-Iz\u0006\u00026\u0002m\u000f\u0011-Vz\b\u0002*Ku\u000bC%Io\u000b\u0011-Nr\u0018\b!L;\u0002\u00020C;\u0005\u000f1Qo\u001fM\u001dCk\u0003\u000f%L;<7dKh\u0006\u0006)N~\u0018\ndE~\u0018\ndCw\u0003\r%Az\u0001M";
                    n2 = 12;
                    continue block47;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "#\u000e>Cw\u0003C Mh\u0013\u0002 Cp\u0003C/MpJ\u0010!Po\u0003\u0005-Iz\u0006\u00026Fz\u0004C&Ki\u0003C M|\u0018\u0016(Cu\u000b\u000e%FrD0!Po\u0003\u0005-IzJ\u0001-N|\u0003\u000f!PrJ\u0002(Ku\u000b\u000e-[t\u0018";
                    n2 = 13;
                    continue block47;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "J\u00101@q\u000f\u00000NrJ\b+I;\u0019\u00066Vr\f\n/C;\u000e\f#Pn\u0006\u0002*Cv\u000b\u0007-\f";
                    n2 = 14;
                    continue block47;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "#\u000e>Cw\u0003C\u0000Mh\u0013\u0002 CuJ";
                    n2 = 15;
                    continue block47;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "#\u000e>Cw\u0003C/MpJ\u0010!Po\u0003\u0005-Iz\u0006\u00026\u0002m\u000f\u0011-Vz\b\u0002*Ku\u000bC%Io\u000b\u0011-Nr\u0018\b!L;\u0002\u00020C;\u0005\u000f1Qo\u001fM\u001dCk\u0003\u000f%L;<7dKh\u0006\u0006)N~\u0018\ndE~\u0018\ndCw\u0003\r%Az\u0001M";
                    n2 = 16;
                    continue block47;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "J\u0010!PrJ\r+NnJ";
                    n2 = 17;
                    continue block47;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "!\f/\u0002h\u000f\u00110K}\u0003\b%\u0002\u007f\u0005\u00046Ww\u000b\u000e%FzJ\u000b%Vz";
                    n2 = 18;
                    continue block47;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = ">\u0016)\u0002p\u0005\b7Gi\u001e\n\"Kp\u000b\u000f%P;\u0006\n7V~\u0006\u0006*Ki\u0001\u0006*\u0002M>C,Co\u000b\u0010-\u0002t\u0006\u00167VnD";
                    n2 = 19;
                    continue block47;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "J\"\nf;";
                    n2 = 20;
                    continue block47;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "J\"\nf;!,\u000fq~\u0018\n%NU\u001f\u000e&GiJ^d\u001d;";
                    n2 = 21;
                    continue block47;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "J\"\nf;";
                    n2 = 22;
                    continue block47;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "JOd";
                    n2 = 23;
                    continue block47;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "JJ";
                    n2 = 24;
                    continue block47;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "J\"\nf;!,\u000fq~\u0018\u0017-Dr\u0001\u0002\u0012Cw\u001f\u0006d\u001f;UC";
                    n2 = 25;
                    continue block47;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "J\"\nf;!,\u000fq~\u0018\u0017-Dr\u0001\u0002\nM;#-d\nH//\u0001aOJ,&H~\t\u0017\nM;,1\u000bo;\"\"\u0017j;=+\u0001p^JKdmy\u0000\u0006'VO\u0013\u0013!\u0002&J\\dcU.C\fCh\u00027=R~J^d\u001d;CJ";
                    n2 = 26;
                    continue block47;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "J\"\nf;\"\u00027JO\u0013\u0013!\u0002&J\\d\u000b2";
                    n2 = 27;
                    continue block47;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "J\"\nf;!,\u000fq~\u0018\u0017-Dr\u0001\u0002\nM;#-d\nH//\u0001aOJ,&H~\t\u0017\nM;,1\u000bo;\"\"\u0017j;=+\u0001p^JKdmy\u0000\u0006'VO\u0013\u0013!\u0002&J\\dcU.C\fCh\u00025%Nn\u000fCy\u0002$J";
                    n2 = 28;
                    continue block47;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "J\"\nf;!,\u000fqn\b\t!Ao$\u0002)G;WC{";
                    n2 = 29;
                    continue block47;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "J\"\nf;!,\u000fi~\u001367C|\u000f00P;&*\u000fg;U";
                    n2 = 30;
                    continue block47;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "!,\u000fen\u001c\u0006*q~\u001c\n=Gh\u0003C\rl;B";
                    n2 = 31;
                    continue block47;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "JJ";
                    n2 = 32;
                    continue block47;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "J\"\nf;!,\u000fqn\b\t!Ao!\u0006=k\u007f\u000f\r0K}\u0003\u00066\u0002&J\\";
                    n2 = 33;
                    continue block47;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "!,\u000fq~\u0018\u0017-Dr\u0001\u0002\u0010Kk\u0003C\rl;B";
                    n2 = 34;
                    continue block47;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "JOd";
                    n2 = 35;
                    continue block47;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = "[^u";
                    n2 = 36;
                    continue block47;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = "J\"\nf;!,\u000fkh\u0019\u0016!PU\u000b\u000e!\u0002&J\\d";
                    n2 = 37;
                    continue block47;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = "JJm";
                    n2 = 38;
                    continue block47;
                }
                case 38: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        d = stringArray3;
        a = LoggerFactory.getLogger(CertStoreRootCertificateOps.class);
    }
}

