/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.DizinYardimci;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;

public class CertStoreDirectoryOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;

    public CertStoreDirectoryOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(c[19]);
            throw new ESYARuntimeException(c[18] + lE.getMessage());
        }
        this.b = aDepo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoDizin readDirectory(long aDizinNo) throws CertStoreException {
        DepoDizin depoDizin;
        if (aDizinNo <= 0L) {
            throw new CertStoreException(c[4]);
        }
        try {
            DepoDizin depoDizin2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoDizin = depoDizin2 = depoVEN.dizinOku(aDizinNo);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aDizinNo + c[5], notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinNo + c[6], certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinNo + c[3], certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoDizin;
            JDBCUtil.commit(this.b.getConn());
            return depoDizin;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aDizinNo + c[2], certStoreException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoDizin findDirectory(String aDizinAdi) throws CertStoreException {
        DepoDizin depoDizin;
        try {
            DepoDizin depoDizin2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoDizin = depoDizin2 = depoVEN.dizinBul(aDizinAdi);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aDizinAdi + c[15] + notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinAdi + c[13] + certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinAdi + c[16], certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoDizin;
            JDBCUtil.commit(this.b.getConn());
            return depoDizin;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aDizinAdi + c[14], certStoreException);
        }
    }

    public void renameDirectory(long aDizinNo, String aYeniAd) throws CertStoreException {
        if (aDizinNo <= 0L) {
            throw new CertStoreException(c[10]);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinAdiDegistir(aDizinNo, aYeniAd);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinNo + c[12] + aYeniAd + c[11], certStoreException);
        }
    }

    public void writeDirectory(String aDizinAdi) throws CertStoreException {
        DepoDizin depoDizin = new DepoDizin();
        depoDizin.setDizinAdi(aDizinAdi);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinYaz(depoDizin);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinAdi + c[17], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listDirectory() throws CertStoreException {
        ArrayList<DepoDizin> arrayList2;
        int n = CertStoreRootCertificateOps.c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            ArrayList<DepoDizin> arrayList = new ArrayList<DepoDizin>();
            ItemSource<DepoDizin> itemSource = depoVEN.dizinListele();
            DepoDizin depoDizin = (DepoDizin)itemSource.nextItem();
            while (depoDizin != null) {
                arrayList.add(depoDizin);
                depoDizin = (DepoDizin)itemSource.nextItem();
                if (n == 0) continue;
            }
            arrayList2 = arrayList;
        }
        catch (Exception exception) {
            try {
                throw new CertStoreException(c[7], exception);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(c[8], certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return arrayList2;
            JDBCUtil.commit(this.b.getConn());
            return arrayList2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(c[9], certStoreException);
        }
    }

    public void deleteDirectory(long aDizinNo) throws CertStoreException {
        if (aDizinNo == DizinYardimci.getDefaultDizinNo()) {
            throw new CertStoreException(c[0]);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinSil(aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinNo + c[1], certStoreException);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[20];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "*Ah\t%nAb\u000f3r\u000f&\u0002,}\u0000s\n=;\u0005o\u001c uAi\n-n\u0006sF x\bhF:r\ro\b,v\u0004|H";
        int n2 = -1;
        block27: while (true) {
            char[] cArray;
            block32: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block31: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block31;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block32;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 27;
                                break;
                            }
                            case 1: {
                                n8 = 97;
                                break;
                            }
                            case 2: {
                                n8 = 6;
                                break;
                            }
                            case 3: {
                                n8 = 102;
                                break;
                            }
                            default: {
                                n8 = 73;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = ";\u000fi\n<;\u0005o\u001c uAu\u000f%r\u000fo\u0014\"~\u000f&0\u001d;\tg\u0012(h\b&\t%n\u0012r\u0013gB\u0000v\u000f%z\u000f&0\u001d;\bu\n,v\rc\u0014 ;\u0006c\u0014 ;\u0000j\u000f'\u007f\b(";
                    n2 = 0;
                    continue block27;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = ";\u000fi\n<;\u0005o\u001c uAi\r<u\u0014t\r,uAP2is\u0000r\u0007:rAi\n<h\u0015sH";
                    n2 = 1;
                    continue block27;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = ";\u000fi\n<;\u0005o\u001c uAi\r<u\u0014t\r,uAP2is\u0000r\u0007:rAi\n<h\u0015sH";
                    n2 = 2;
                    continue block27;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "U\u0004u\b,;(BF%~\u0013oFy;\u0005g\biy\u0014\u007f\u0013\";\u000ej\u000b(pA|\t;n\u000fb\u0007-r\u0013";
                    n2 = 3;
                    continue block27;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = ";\u000fi\n<;\u0005o\u001c uAp\u0003;r\u0015g\u0004(u\bh\u0002(;\u0003s\n<u\u0000k\u0007-rO";
                    n2 = 4;
                    continue block27;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = ";\u000fi\n<;\u0005o\u001c uAi\r<u\u0014t\r,uAP2is\u0000r\u0007:rAi\n<h\u0015sH";
                    n2 = 5;
                    continue block27;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "O\u0014kF-r\u001bo\b%~\u0013&\n h\u0015c\n,u\bt\r,uAP2is\u0000r\u0007:rAi\n<h\u0015sH";
                    n2 = 6;
                    continue block27;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "O\u0014kF-r\u001bo\b%~\u0013&\n h\u0015c\n,u\bt\r,uAP2is\u0000r\u0007:rAi\n<h\u0015sH";
                    n2 = 7;
                    continue block27;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "O\u0014kF-r\u001bo\b%~\u0013&\n h\u0015c\n,u\bt\r,uAP2is\u0000r\u0007:rAi\n<h\u0015sH";
                    n2 = 8;
                    continue block27;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "U\u0004u\b,;(BF%~\u0013oFy;\u0005g\biy\u0014\u007f\u0013\";\u000ej\u000b(pA|\t;n\u000fb\u0007-r\u0013";
                    n2 = 9;
                    continue block27;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = ";\u000ej\u0007;z\n&\u0002,|\bu\u0012 i\bt\r,uAP2is\u0000r\u0007:rAi\n<h\u0015sH\u0010z\u0011o\n(uAP2ir\u0012j\u0003$w\u0004t\u000fi|\u0004t\u000fiz\ro\b-rO";
                    n2 = 10;
                    continue block27;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = ";\u000fi\n<;\u0005o\u001c u\bhF(\u007f\bh\u000fi";
                    n2 = 11;
                    continue block27;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = ";\u0000b\n ;\u0005o\u001c uAd\u0013%n\u000fs\u0014\"~\u000f&0\u001d;\tg\u0012(h\b&\t%n\u0012r\u0013g";
                    n2 = 12;
                    continue block27;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = ";\u0000b\n ;\u0005o\u001c uAd\u0013%n\u000fs\u0014\"~\u000f&0\u001d;\tg\u0012(h\b&\t%n\u0012r\u0013g";
                    n2 = 13;
                    continue block27;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = ";\u0000b\n ;\u0005o\u001c uAp\u0003;r\u0015g\u0004(u\bh\u0002(;\u0003s\n<u\u0000k\u0007-rO";
                    n2 = 14;
                    continue block27;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = ";\u0000b\n ;\u0005o\u001c uAd\u0013%n\u000fs\u0014\"~\u000f&0\u001d;\tg\u0012(h\b&\t%n\u0012r\u0013g";
                    n2 = 15;
                    continue block27;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = ";\u0000b\n ;\u0005o\u001c uA\u007f\u00073r\ro\u0014\"~\u000f&0\u001d;\tg\u0012(h\b&\t%n\u0012r\u0013gB\u0000v\u000f%z\u000f&0\u001d;\bu\n,v\rc\u0014 ;\u0006c\u0014 ;\u0000j\u000f'\u007f\b(";
                    n2 = 16;
                    continue block27;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "W\bu\u0007'hAm\t'o\u0013i\n<;\u0003g\u0015(i\bu\u000f35A";
                    n2 = 17;
                    continue block27;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "W\bu\u0007'hAm\t'o\u0013i\n<;\u0003g\u0015(i\bu\u000f35";
                    n2 = 18;
                    continue block27;
                }
                case 18: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
        a = LoggerFactory.getLogger(CertStoreDirectoryOps.class);
    }
}

