/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CertificateSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.KeyUsageSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreCertificateOps {
    private static Logger a;
    private final CertStore b;
    private static final Locale c;
    private static final String[] d;

    public CertStoreCertificateOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(d[9], (Throwable)lE);
            throw new ESYARuntimeException(d[8] + lE.getMessage(), (Throwable)lE);
        }
        this.b = aDepo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoSertifika readStoreCertificate(long aSertifikaNo) throws CertStoreException {
        DepoSertifika depoSertifika;
        if (aSertifikaNo <= 0L) {
            throw new CertStoreException(d[39]);
        }
        try {
            DepoSertifika depoSertifika2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoSertifika = depoSertifika2 = depoVEN.sertifikaOku(aSertifikaNo);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aSertifikaNo + d[41], notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aSertifikaNo + d[40], certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aSertifikaNo + d[42], certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoSertifika;
            JDBCUtil.commit(this.b.getConn());
            return depoSertifika;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSertifikaNo + d[38], certStoreException);
        }
    }

    public List<ECertificate> listCertificates() throws CertStoreException {
        int n = CertStoreRootCertificateOps.c;
        ItemSource<DepoSertifika> itemSource = this.listStoreCertificates();
        List list = ((RsItemSource)itemSource).toList();
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        for (DepoSertifika depoSertifika : list) {
            try {
                ECertificate eCertificate = new ECertificate(depoSertifika.getValue());
                arrayList.add(eCertificate);
            }
            catch (Exception exception) {
                throw new CertStoreException(depoSertifika.getSertifikaNo() + d[37], exception);
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSertifika> listStoreCertificates() throws CertStoreException {
        ItemSource<DepoSertifika> itemSource2;
        try {
            ItemSource<DepoSertifika> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            itemSource2 = itemSource = depoVEN.sertifikaListele();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(d[50], certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(d[48], certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(d[49], certStoreException);
        }
    }

    public List<ECertificate> listCertificates(CertificateSearchTemplate aSAS) throws CertStoreException {
        int n = CertStoreRootCertificateOps.c;
        ItemSource<DepoSertifika> itemSource = this.listStoreCertificate(aSAS);
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        try {
            DepoSertifika depoSertifika = (DepoSertifika)itemSource.nextItem();
            while (depoSertifika != null) {
                ECertificate eCertificate = new ECertificate(depoSertifika.getValue());
                arrayList.add(eCertificate);
                depoSertifika = (DepoSertifika)itemSource.nextItem();
                if (n == 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new CertStoreException(exception);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSertifika> listStoreCertificate(CertificateSearchTemplate aSAS) throws CertStoreException {
        ItemSource<DepoSertifika> itemSource2;
        try {
            ItemSource<DepoSertifika> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, false);
            String string = (String)pair.first();
            List list = (List)pair.second();
            itemSource2 = itemSource = depoVEN.sertifikaListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(d[6], certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(d[5], certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(d[7], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSertifika> findFreshestCertificate(CertificateSearchTemplate aSAS) throws CertStoreException {
        ItemSource<DepoSertifika> itemSource2;
        try {
            ItemSource<DepoSertifika> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, true);
            String string = (String)pair.first();
            List list = (List)pair.second();
            itemSource2 = itemSource = depoVEN.sertifikaListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(d[16], certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(d[18], certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(d[17], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sertifikaTasi(long aSertifikaNo, long aEskiDizinNo, long aYeniDizinNo) throws CertStoreException {
        try {
            if (aSertifikaNo <= 0L) throw new CertStoreException(d[2]);
            if (aEskiDizinNo <= 0L) throw new CertStoreException(d[2]);
            if (aYeniDizinNo <= 0L) {
                throw new CertStoreException(d[2]);
            }
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sertifikaTasi(aSertifikaNo, aEskiDizinNo, aYeniDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSertifikaNo + d[3] + aEskiDizinNo + d[1] + aYeniDizinNo + d[4], certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSertifikaNo + d[3] + aEskiDizinNo + d[1] + aYeniDizinNo + d[4], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listCertificateDirectories(long aSertifikaNo) throws CertStoreException {
        List<DepoDizin> list2;
        if (aSertifikaNo <= 0L) {
            throw new CertStoreException(d[11]);
        }
        try {
            List<DepoDizin> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            list2 = list = ((RsItemSource)depoVEN.sertifikaDizinleriniListele(aSertifikaNo)).toList();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(aSertifikaNo + d[12], certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(aSertifikaNo + d[10], certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSertifikaNo + d[13], certStoreException);
        }
    }

    public void deleteCertificate(long aSertifikaNo) throws CertStoreException {
        try {
            if (aSertifikaNo <= 0L) {
                throw new CertStoreException(d[15]);
            }
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sertifikaSil(aSertifikaNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aSertifikaNo + d[14], certStoreException);
        }
    }

    public int deleteCertificate(CertificateSearchTemplate aSAS) throws CertStoreException {
        int n = CertStoreRootCertificateOps.c;
        Long l = aSAS.getDizinNo();
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, false);
            String string = (String)pair.first();
            List list = (List)pair.second();
            ItemSource<DepoSertifika> itemSource = depoVEN.sertifikaListele(string, list.toArray());
            int n2 = 0;
            DepoSertifika depoSertifika = (DepoSertifika)itemSource.nextItem();
            while (depoSertifika != null) {
                block11: {
                    block10: {
                        if (l != null) break block10;
                        n2 += depoVEN.sertifikaSil(depoSertifika.getSertifikaNo());
                        if (n == 0) break block11;
                    }
                    n2 += depoVEN.dizindenSertifikaSil(depoSertifika.getSertifikaNo(), l);
                }
                depoSertifika = (DepoSertifika)itemSource.nextItem();
                if (n == 0) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return n2;
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(d[0], exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCertificateFromDirectory(long aSertifikaNo, long aDizinNo) throws CertStoreException {
        try {
            if (aSertifikaNo <= 0L) throw new CertStoreException(d[47]);
            if (aDizinNo <= 0L) {
                throw new CertStoreException(d[47]);
            }
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizindenSertifikaSil(aSertifikaNo, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSertifikaNo + d[45] + aDizinNo + d[46], certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSertifikaNo + d[45] + aDizinNo + d[46], certStoreException);
        }
    }

    public void writeCertificate(byte[] aCert, long aDizinNo) throws CertStoreException {
        this.a(aCert, null, null, null, null, (Long)aDizinNo, null);
    }

    public void writeCertificate(byte[] aCert, long aDizinNo, String aX400Address) throws CertStoreException {
        this.a(aCert, null, null, null, null, (Long)aDizinNo, aX400Address);
    }

    public void writeCertificate(ECertificate aCert, long aDizinNo) throws CertStoreException {
        this.a(aCert, null, null, null, null, aDizinNo, null);
    }

    public void writeCertificate(byte[] aCert, String aPKCS11Lib, byte[] aPKCS11ID, Long aDizinNo) throws CertStoreException {
        this.a(aCert, aPKCS11Lib, aPKCS11ID, null, null, aDizinNo, null);
    }

    public void writeCertificate(ECertificate aCert, String aPKCS11Lib, byte[] aPKCS11ID, Long aDizinNo) throws CertStoreException {
        this.a(aCert, aPKCS11Lib, aPKCS11ID, null, null, (long)aDizinNo, null);
    }

    public void writeCertificate(byte[] aCert, byte[] aPrivateKey, String aDepoParola, Long aDizinNo) throws CertStoreException {
        this.a(aCert, null, null, aPrivateKey, aDepoParola, aDizinNo, null);
    }

    public void writeCertificate(ECertificate aCert, byte[] aPrivateKey, String aDepoParola, Long aDizinNo) throws CertStoreException {
        this.a(aCert, null, null, aPrivateKey, aDepoParola, (long)aDizinNo, null);
    }

    private void a(byte[] byArray, String string, byte[] byArray2, byte[] byArray3, String string2, Long l, String string3) throws CertStoreException {
        try {
            Object object;
            Object object2;
            DepoSertifika depoSertifika = null;
            try {
                block18: {
                    object2 = new ECertificate(byArray);
                    depoSertifika = CertStoreUtil.eSYASertifikaTODepoSertifika((ECertificate)object2);
                    if (string != null) {
                        depoSertifika.setPKCS11Lib(string);
                    }
                    if (byArray2 != null) {
                        depoSertifika.setPKCS11ID(byArray2);
                    }
                    if (byArray3 == null || string2 == null) break block18;
                    object = this.b.encryptWithPassword(byArray3, string2);
                    depoSertifika.setPrivateKey((byte[])object);
                }
                if (string3 != null) {
                    depoSertifika.setX400Address(string3);
                }
            }
            catch (Exception exception) {
                throw new CertStoreException(d[44], exception);
            }
            object2 = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            object = CertStoreUtil.convertToDepoOzet(depoSertifika.getValue(), OzneTipi.SERTIFIKA);
            object2.sertifikaYaz(depoSertifika, (List<DepoOzet>)object, l);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(d[43], certStoreException);
        }
    }

    private void a(ECertificate eCertificate, String string, byte[] byArray, byte[] byArray2, String string2, long l, String string3) throws CertStoreException {
        byte[] byArray3 = null;
        try {
            byArray3 = eCertificate.getEncoded();
        }
        catch (Exception exception) {
            throw new CertStoreException(d[19], exception);
        }
        this.a(byArray3, string, byArray, byArray2, string2, (Long)l, null);
    }

    private Pair<String, List<Object>> a(CertificateSearchTemplate certificateSearchTemplate, boolean bl) {
        int n = CertStoreRootCertificateOps.c;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(d[20]);
        if (certificateSearchTemplate != null) {
            Object object;
            block47: {
                OzetTipi ozetTipi;
                block45: {
                    block46: {
                        Long l = certificateSearchTemplate.getDizinNo();
                        if (l != null) {
                            stringBuffer.append(d[21]);
                            arrayList.add(l);
                        }
                        byte[] byArray = certificateSearchTemplate.getHash();
                        ozetTipi = certificateSearchTemplate.getHashType();
                        if (byArray == null) break block45;
                        stringBuffer.append(d[22]);
                        arrayList.add(OzneTipi.SERTIFIKA.getIntValue());
                        arrayList.add(byArray);
                        if (ozetTipi == null) break block46;
                        stringBuffer.append(d[31]);
                        arrayList.add(ozetTipi.getIntValue());
                        if (n == 0) break block47;
                    }
                    stringBuffer.append(d[30]);
                    if (n == 0) break block47;
                }
                if (ozetTipi == null) break block47;
                stringBuffer.append(d[26]);
                arrayList.add(OzneTipi.SERTIFIKA.getIntValue());
                arrayList.add(ozetTipi.getIntValue());
            }
            byte[] byArray = certificateSearchTemplate.getValue();
            if (byArray != null) {
                stringBuffer.append(d[36]);
                arrayList.add(byArray);
            }
            byte[] byArray2 = certificateSearchTemplate.getIssuer();
            if (byArray2 != null) {
                stringBuffer.append(d[32]);
                arrayList.add(byArray2);
            }
            Date date = certificateSearchTemplate.getStartDate();
            if (date != null) {
                stringBuffer.append(d[27]);
                arrayList.add(date);
            }
            Date date2 = certificateSearchTemplate.getEndDate();
            if (date2 != null) {
                stringBuffer.append(d[25]);
                arrayList.add(date2);
            }
            byte[] byArray3 = certificateSearchTemplate.getSerialNumber();
            if (byArray3 != null) {
                stringBuffer.append(d[24]);
                arrayList.add(byArray3);
            }
            byte[] byArray4 = certificateSearchTemplate.getSubject();
            if (byArray4 != null) {
                stringBuffer.append(d[28]);
                arrayList.add(byArray4);
            }
            String string = certificateSearchTemplate.getEPosta();
            if (string != null) {
                object = string.toLowerCase(c);
                stringBuffer.append(d[33]);
                arrayList.add(object);
            }
            object = certificateSearchTemplate.getSubjectKeyID();
            if (object != null) {
                stringBuffer.append(d[29]);
                arrayList.add(object);
            }
            KeyUsageSearchTemplate keyUsageSearchTemplate = certificateSearchTemplate.getAnahtarKullanim();
            if (keyUsageSearchTemplate != null) {
                stringBuffer.append(d[34]);
                arrayList.add(keyUsageSearchTemplate.sorguOlustur());
            }
            String string2 = certificateSearchTemplate.getX400Address();
            if (string2 != null) {
                stringBuffer.append(d[35]);
                arrayList.add(string2);
            }
            if (bl) {
                stringBuffer.append(d[23]);
            }
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[52];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "7N\\\u007fZ\nN\u001etZ\u0016J\u001e`P\u0016[Wu\\\u000fN\u001e`\\\bFPzG\u000fJP3c0\u000fVrA\u0005\\W3Z\bZMg@Jv_c\\\bNP3c0\u000fW`Y\u0001BRvG\r\u000fYvG\r\u000f_\u007f\\\nKW=";
        int n2 = -1;
        block59: while (true) {
            char[] cArray;
            block64: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block63: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block63;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block64;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 100;
                                break;
                            }
                            case 1: {
                                n8 = 47;
                                break;
                            }
                            case 2: {
                                n8 = 62;
                                break;
                            }
                            case 3: {
                                n8 = 19;
                                break;
                            }
                            default: {
                                n8 = 53;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "DAQ\u007f@DKWi\\\nK[}\u0015";
                    n2 = 0;
                    continue block59;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "*JM}PDfz3Y\u0001]W3\u0005DK_}\u0015\u0006ZGf^D@R~T\u000f\u000fD|G\u0011AZrQ\r]";
                    n2 = 1;
                    continue block59;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "DAQ\u007f@D\\[aA\rIWxT\u001dF\u001e";
                    n2 = 2;
                    continue block59;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "DAQ\u007f@DKWi\\\nJ\u001egT\u0017FLxP\n\u000fhG\u0015\fNJrF\r\u000fQ\u007f@\u0017[K=";
                    n2 = 3;
                    continue block59;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "7N\\\u007fZ\nN\u001etZ\u0016J\u001e`P\u0016[Wu\\\u000fN\u001e\u007f\\\u0017[[\u007fP\tJ\u001e`\\\u0016NMz[\u0000N\u001eEaDG_gT\u0017F\u001e|Y\u0011\\Jf\u001b";
                    n2 = 4;
                    continue block59;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "7N\\\u007fZ\nN\u001etZ\u0016J\u001e`P\u0016[Wu\\\u000fN\u001e\u007f\\\u0017[[\u007fP\tJ\u001e`\\\u0016NMz[\u0000N\u001eEaDG_gT\u0017F\u001e|Y\u0011\\Jf\u001b";
                    n2 = 5;
                    continue block59;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "7N\\\u007fZ\nN\u001etZ\u0016J\u001e`P\u0016[Wu\\\u000fN\u001e\u007f\\\u0017[[\u007fP\tJ\u001e`\\\u0016NMz[\u0000N\u001eEaDG_gT\u0017F\u001e|Y\u0011\\Jf\u001b";
                    n2 = 6;
                    continue block59;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "(FMr[\u0017\u000fU|[\u0010]Q\u007f@DM_`T\u0016FMzOJ\u000f";
                    n2 = 7;
                    continue block59;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "(FMr[\u0017\u000fU|[\u0010]Q\u007f@DM_`T\u0016FMzOJ";
                    n2 = 8;
                    continue block59;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "DAQ\u007f@D\\[aA\rIWxT\nFP3Q\rUW}Y\u0001]W3Y\r\\JvY\u0001AWa^\u0001A\u001eeP\u0016FJrW\u0005AW3]\u0005[_`\\D@RfF\u0010Z";
                    n2 = 9;
                    continue block59;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "*JM}PDfz3Y\u0001]W3\u0005DK_}\u0015\u0006ZGf^D@R~T\u000f\u000fD|G\u0011AZrQ\r]";
                    n2 = 10;
                    continue block59;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "DAQ\u007f@D\\[aA\rIWxT\nFP3Q\rUW}Y\u0001]W3Y\r\\JvY\u0001AWa^\u0001A\u001eeP\u0016FJrW\u0005AW3]\u0005[_`\\D@RfF\u0010Z";
                    n2 = 11;
                    continue block59;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "DAQ\u007f@D\\[aA\rIWxT\nFP3Q\rUW}Y\u0001]W3Y\r\\JvY\u0001AWa^\u0001A\u001eeP\u0016FJrW\u0005AW3]\u0005[_`\\D@RfF\u0010Z";
                    n2 = 12;
                    continue block59;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "DAQ\u007f@D\\[aA\rIWxT\nFP3F\rCW}\\\u0016D[}\u00152{\u001e{T\u0010NMz\u0015\u000bCK`A\u0011\u0001grE\rC_}\u00152{\u001ezF\bJS\u007fP\u0016F\u001etP\u0016F\u001erY\rAZz\u001b";
                    n2 = 13;
                    continue block59;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "*JM}PDfz3Y\u0001]W3\u0005DK_}\u0015\u0006ZGf^D@R~T\u000f\u000fD|G\u0011AZrQ\r]";
                    n2 = 14;
                    continue block59;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "7N\\\u007fZ\nN\u001etZ\u0016J\u001ev[DHK}V\u0001C\u001e`P\u0016[Wu\\\u000fN\u001eq@\bB_3F\r]_`\\\nK_3c0\u000fVrA\u0005\\W3Z\bZMg@J";
                    n2 = 15;
                    continue block59;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "7N\\\u007fZ\nN\u001etZ\u0016J\u001ev[DHK}V\u0001C\u001e`P\u0016[Wu\\\u000fN\u001eq@\bB_3F\r]_`\\\nK_3c0\u000fVrA\u0005\\W3Z\bZMg@J";
                    n2 = 16;
                    continue block59;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "7N\\\u007fZ\nN\u001etZ\u0016J\u001ev[DHK}V\u0001C\u001e`P\u0016[Wu\\\u000fN\u001eq@\bB_3F\r]_`\\\nK_3c0\u000fVrA\u0005\\W3Z\bZMg@J";
                    n2 = 17;
                    continue block59;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "7JLg\\\u0002FUr\u0015\u0001A]|Q\u0001\u000f[w\\\bFLxP\n\u000fVrA\u0005\u000fQ\u007f@\u0017[K=";
                    n2 = 18;
                    continue block59;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "U\u0012\u000f";
                    n2 = 19;
                    continue block59;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "DnpW\u00157JLg\\\u0002FUr{\u000b\u000fw]\u0015L|{_p'{\u001e@P\u0016[Wu\\\u000fNp|\u0015\"}q^\u0015 fdZ{7jlG|\"fuR\u00153g{ApDkWi\\\naQ3\bD\u0010\u001e:";
                    n2 = 20;
                    continue block59;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "DnpW\u00157JLg\\\u0002FUr{\u000b\u000fw]\u0015L|{_p'{\u001e\\W\u000eJ]g{\u000b\u000fxAz)\u000fvRf,\u000fi[p6j\u001e;z\u0006E[pA0VNv\u0015Y\u000f\u00013t*k\u001e[T\u0017GhrY\u0011J\u001e.\u0015[\u000f";
                    n2 = 21;
                    continue block59;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "D`lWp6\u000f|J\u0015!AZWT\u0010J\u001eWp7l\u001e";
                    n2 = 22;
                    continue block59;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "DnpW\u00157JLzT\baK~W\u0001]\u001e.\u0015[\u000f";
                    n2 = 23;
                    continue block59;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "DnpW\u0015!AZWT\u0010J\u001e-\bD\u0010\u001e";
                    n2 = 24;
                    continue block59;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "DnpW\u00157JLg\\\u0002FUr{\u000b\u000fw]\u0015L|{_p'{\u001e\\W\u000eJ]g{\u000b\u000fxAz)\u000fvRf,\u000fi[p6j\u001e;z\u0006E[pA0VNv\u0015Y\u000f\u00013t*k\u001e[T\u0017GjjE\u0001\u000f\u00033\nD\u0006\u0017";
                    n2 = 25;
                    continue block59;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "DnpW\u00157[_aA NJv\u0015X\u0012\u001e,\u0015";
                    n2 = 26;
                    continue block59;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "DnpW\u00157Z\\yP\u0007[prX\u0001\u000f\u00033\nD";
                    n2 = 27;
                    continue block59;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "DnpW\u00157Z\\yP\u0007[uvL-K[}A\rIWvGD\u0012\u001e,";
                    n2 = 28;
                    continue block59;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "D\u0006\u0017";
                    n2 = 29;
                    continue block59;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "DnpW\u0015,NM{a\u001d_[3\bD\u0010\u001e:\u001c";
                    n2 = 30;
                    continue block59;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "DnpW\u0015-\\MfP\u0016a_~PD\u0012\u001e,\u0015";
                    n2 = 31;
                    continue block59;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "DnpW\u0015!\u007fQ`A\u0005\u000f\u00033\n";
                    n2 = 32;
                    continue block59;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "DnpW\u0015/JGFF\u0005H[@A\u0016\u000frZ~!\u000f\u0001";
                    n2 = 33;
                    continue block59;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "DnpW\u0015<\u001b\u000e#t\u0000KLvF\u0017\u000frZ~!\u000f\u0001";
                    n2 = 34;
                    continue block59;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "DnpW\u00157JLg\\\u0002FUrc\u0005CKv\u0015Y\u000f\u00013";
                    n2 = 35;
                    continue block59;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = "DAQ\u007f@D\\[aA\rIWxTDNM}\u0015\u0007JLg\\\u0002F]rA\u0001\u000fJzE\rA[3V\u0001YLzY\r]Uv[DG_gTD@RfF\u0010Z\u0010";
                    n2 = 36;
                    continue block59;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = "DAQ\u007f@D\\[aA\rIWxTD@Uf[\u0011]Uv[DY[a\\\u0010N\\r[\r\u000fVrA\u0005\\W3Z\bZMg@J";
                    n2 = 37;
                    continue block59;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = "*JM}PDfz3Y\u0001]W3\u0005DK_}\u0015\u0006ZGf^D@R~T\u000f\u000fD|G\u0011AZrQ\r]";
                    n2 = 38;
                    continue block59;
                }
                case 38: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 40;
                    string2 = "DAQ\u007f@D\\[aA\rIWxTD@Uf[\u0011]Uv[DY[a\\\u0010N\\r[\r\u000fVrA\u0005\\W3Z\bZMg@J";
                    n2 = 39;
                    continue block59;
                }
                case 39: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 41;
                    string2 = "DAQ\u007f@D\\[aA\rIWxTDY[a\\\u0010N\\r[\rAZr\u0015\u0006ZRf[\u0005B_w\\J";
                    n2 = 40;
                    continue block59;
                }
                case 40: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 42;
                    string2 = "DAQ\u007f@D\\[aA\rIWxTD@Uf[\u0011]Uv[DY[a\\\u0010N\\r[\r\u000fVrA\u0005\\W3Z\bZMg@J";
                    n2 = 41;
                    continue block59;
                }
                case 41: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 43;
                    string2 = "7JLg\\\u0002FUr\u0015\u001dNDzY\r]Uv[Dyj3]\u0005[_`\\D@RfF\u0010Z\u0010JT\u0014FRr[Dyj3\\\u0017C[~Y\u0001]W3R\u0001]W3T\bFPw\\J";
                    n2 = 42;
                    continue block59;
                }
                case 42: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 44;
                    string2 = "7JLg\\\u0002FUr\u0015\u001dNDzY\r]Uv[HK[cZD\\[aA\rIWxTDA[`[\u0001\\W}PDL[eG\rB\u001e`\\\u0016NMz[\u0000N\u001e{T\u0010N\u001e|Y\u0011\\Jf";
                    n2 = 43;
                    continue block59;
                }
                case 43: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 45;
                    string2 = "DAQ\u007f@D\\[aA\rIWxTD";
                    n2 = 44;
                    continue block59;
                }
                case 44: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 46;
                    string2 = "DAQ\u007f@DKWi\\\nK[}\u0015\u0017FRz[\r]Uv[Dyj3]\u0005[_`\\D@RfF\u0010Z\u0010JT\u0014FRr[Dyj3\\\u0017C[~Y\u0001]W3R\u0001]W3T\bFPw\\J";
                    n2 = 45;
                    continue block59;
                }
                case 45: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 47;
                    string2 = "*JM}PDfz3Y\u0001]W3\u0005DK_}\u0015\u0006ZGf^D@R~T\u000f\u000fD|G\u0011AZrQ\r]";
                    n2 = 46;
                    continue block59;
                }
                case 46: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 48;
                    string2 = "0ZS3F\u0001]JzS\rD_\u007fT\u0016\u000fRzF\u0010JRv[\r]Uv[Dyj3]\u0005[_`\\D@RfF\u0010Z";
                    n2 = 47;
                    continue block59;
                }
                case 47: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 49;
                    string2 = "0ZS3F\u0001]JzS\rD_\u007fT\u0016\u000fRzF\u0010JRv[\r]Uv[Dyj3]\u0005[_`\\D@RfF\u0010Z";
                    n2 = 48;
                    continue block59;
                }
                case 48: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 50;
                    string2 = "0ZS3F\u0001]JzS\rD_\u007fT\u0016\u000fRzF\u0010JRv[\r]Uv[Dyj3]\u0005[_`\\D@RfF\u0010Z";
                    n2 = 49;
                    continue block59;
                }
                case 49: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 51;
                    string2 = "\u0001A";
                    n2 = 50;
                    continue block59;
                }
                case 50: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        d = stringArray3;
        a = LoggerFactory.getLogger(CertStoreCertificateOps.class);
        c = new Locale(d[51]);
    }
}

