/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.signature.certval.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EName;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SILTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSIL;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreCRLOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CRLSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureException;
import tr.gov.tubitak.uekae.esya.api.signature.certval.CRLSearchCriteria;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ReferencedCRLFinder;
import tr.gov.tubitak.uekae.esya.api.signature.certval.impl.ReferencedOCSPResponseFinderFromCertStore;
import tr.gov.tubitak.uekae.esya.asn.util.UtilName;
import tr.gov.tubitak.uekae.esya.asn.x509.Name;

public class ReferencedCRLFinderFromCertStore
implements ReferencedCRLFinder {
    private static final Logger a;
    private static final String[] b;

    public CRLSearchTemplate createSearchTemplate(CRLSearchCriteria aCriteria) {
        CRLSearchTemplate cRLSearchTemplate;
        int n;
        block13: {
            BigInteger bigInteger;
            block14: {
                block12: {
                    n = ReferencedOCSPResponseFinderFromCertStore.b;
                    cRLSearchTemplate = new CRLSearchTemplate();
                    if (aCriteria.getDigestAlg() == null) break block12;
                    cRLSearchTemplate.setHashType(OzetTipi.fromDigestAlg((DigestAlg)aCriteria.getDigestAlg()));
                    cRLSearchTemplate.setHash(aCriteria.getDigestValue());
                    if (n == 0) break block13;
                }
                String string = aCriteria.getIssuer();
                if (string == null || string.length() <= 0) break block14;
                try {
                    bigInteger = UtilName.string2Name((String)string, (boolean)true);
                    cRLSearchTemplate.setIssuer(new EName((Name)bigInteger));
                }
                catch (Exception exception) {
                    a.error(b[9]);
                }
            }
            bigInteger = aCriteria.getNumber();
            if (bigInteger != null) {
                cRLSearchTemplate.setSILNumber(bigInteger.toByteArray());
            }
        }
        CRLSearchTemplate cRLSearchTemplate2 = cRLSearchTemplate;
        if (SignatureException.b) {
            ReferencedOCSPResponseFinderFromCertStore.b = ++n;
        }
        return cRLSearchTemplate2;
    }

    @Override
    public List<ECRL> find(CRLSearchCriteria aCriteria) throws ESYAException {
        if (aCriteria == null) {
            throw new ArgErrorException(b[8]);
        }
        CRLSearchTemplate cRLSearchTemplate = this.createSearchTemplate(aCriteria);
        return this.locate(cRLSearchTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<ECRL> locate(CRLSearchTemplate aSearchTemplate) {
        ArrayList<ECRL> arrayList;
        block43: {
            CertStore certStore;
            int n = ReferencedOCSPResponseFinderFromCertStore.b;
            try {
                certStore = new CertStore();
            }
            catch (CertStoreException certStoreException) {
                a.error(b[1], (Throwable)certStoreException);
                return null;
            }
            CertStoreCRLOps certStoreCRLOps = new CertStoreCRLOps(certStore);
            ItemSource itemSource = null;
            arrayList = new ArrayList<ECRL>();
            itemSource = certStoreCRLOps.listStoreCRL(aSearchTemplate, new SILTipi[]{SILTipi.BASE});
            DepoSIL depoSIL = (DepoSIL)itemSource.nextItem();
            while (depoSIL != null) {
                try {
                    ECRL eCRL = new ECRL(depoSIL.getValue());
                    arrayList.add(eCRL);
                }
                catch (Exception exception) {
                    a.warn(b[5], (Throwable)exception);
                }
                depoSIL = (DepoSIL)itemSource.nextItem();
                if (n == 0) continue;
            }
            try {
                if (itemSource != null) {
                    itemSource.close();
                }
                if (certStore != null) {
                    certStore.closeConnection();
                }
                break block43;
            }
            catch (CertStoreException certStoreException) {
                a.error(b[7], (Throwable)certStoreException);
            }
            break block43;
            catch (CertStoreException certStoreException) {
                a.error(b[2], (Throwable)certStoreException);
                List<ECRL> list = null;
                try {
                    if (itemSource != null) {
                        itemSource.close();
                    }
                    if (certStore != null) {
                        certStore.closeConnection();
                    }
                }
                catch (CertStoreException certStoreException2) {
                    a.error(b[6], (Throwable)certStoreException2);
                }
                return list;
            }
            catch (ESYAException eSYAException) {
                a.error(b[4], (Throwable)eSYAException);
                List<ECRL> list = null;
                {
                    catch (Throwable throwable) {
                        try {
                            if (itemSource != null) {
                                itemSource.close();
                            }
                            if (certStore != null) {
                                certStore.closeConnection();
                            }
                        }
                        catch (CertStoreException certStoreException2) {
                            a.error(b[3], (Throwable)certStoreException2);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (itemSource != null) {
                        itemSource.close();
                    }
                    if (certStore != null) {
                        certStore.closeConnection();
                    }
                }
                catch (CertStoreException certStoreException3) {
                    a.error(b[0], (Throwable)certStoreException3);
                }
                return list;
            }
        }
        return arrayList;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0001=?\u0000@!&8\u0001Kb1>\u001bI&<v\u001a\u0005!>>\u001d@&";
        int n2 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block21;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 66;
                                break;
                            }
                            case 1: {
                                n8 = 82;
                                break;
                            }
                            case 2: {
                                n8 = 81;
                                break;
                            }
                            case 3: {
                                n8 = 110;
                                break;
                            }
                            default: {
                                n8 = 37;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u00117#\u001aL$;:\u000f\u0005&7!\u0001V7<0NP.3\u010e\u015fI#?0\n\u0114";
                    n2 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0011;=II' q\u0002L1&4\u0002@,;#\u0005@,r9\u000fQ#r>\u0002P1&$";
                    n2 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0001=?\u0000@!&8\u0001Kb1>\u001bI&<v\u001a\u0005!>>\u001d@&";
                    n2 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u000b>:NA'\">NV+>q\u0000@1<4\u001dLb3=\u0007K+ :\u000bKb:0\u001aDb==\u001bV6'";
                    n2 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u00067!\u0001A#<q\u000fI+<0\u0000\u00051;=NJ.'\"\u001aP0'=\u001bW)7?NM#&0NJ.'\"\u001aP";
                    n2 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0001=?\u0000@!&8\u0001Kb1>\u001bI&<v\u001a\u0005!>>\u001d@&";
                    n2 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0001=?\u0000@!&8\u0001Kb1>\u001bI&<v\u001a\u0005!>>\u001d@&";
                    n2 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0007*!\u000bF675NV'3#\rMb1#\u0007Q' 8\u000f";
                    n2 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u0007 #\u0001Wb64\rJ&;?\t\u0005\u0001\u0000\u001dNL1!$\u000bW";
                    n2 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        b = stringArray3;
        a = LoggerFactory.getLogger(ReferencedCRLFinderFromCertStore.class);
    }
}

