/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.asn.util.UtilTime;
import tr.gov.tubitak.uekae.esya.asn.x509.Time;

public class SigningTimeChecker
extends BaseChecker {
    public static final int MAX_SIGNING_TIME_TOLERANCE_IN_SECONDS = 86340;
    public static final int MIN_SIGNING_TIME_TOLERANCE_IN_SECONDS = 0;
    public static final int MILLIS_IN_SECOND = 1000;
    private static Logger e;
    private ESignedData f = null;
    private static final String[] g;

    public SigningTimeChecker(ESignedData aSignedData) {
        this.f = aSignedData;
    }

    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_TIME_CHECKER, new String[0]), SigningTimeChecker.class);
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_signingTime);
        if (!list.isEmpty()) {
            Integer n;
            Calendar calendar;
            Calendar calendar2;
            block12: {
                EAttribute eAttribute = list.get(0);
                Time time = new Time();
                Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
                try {
                    time.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
                }
                catch (Exception exception) {
                    aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_TIME_ATTRIBUTE_DECODE_ERROR, new String[0]), exception));
                    return false;
                }
                calendar2 = UtilTime.timeToCalendar((Time)time);
                ETSTInfo eTSTInfo = null;
                try {
                    eTSTInfo = new ETSTInfo(this.f.getEncapsulatedContentInfo().getContent());
                }
                catch (Exception exception) {
                    aCheckerResult.addMessage(new ValidationMessage(g[2], exception));
                    return false;
                }
                calendar = null;
                try {
                    calendar = eTSTInfo.getTime();
                }
                catch (Exception exception) {
                    aCheckerResult.addMessage(new ValidationMessage(g[3], exception));
                    return false;
                }
                n = (Integer)this.getParameters().get(g[0]);
                if (n >= 0 && n <= 86340) break block12;
                String string = g[1];
                e.error(string);
                throw new IllegalArgumentException(string);
            }
            long l = calendar.getTimeInMillis();
            long l2 = calendar2.getTimeInMillis();
            int n2 = n * 1000;
            long l3 = Math.abs(l - l2);
            if (l3 > (long)n2) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_TIME_CHECKER_UNSUCCESSFUL, new String[0])));
                return false;
            }
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_TIME_CHECKER_SUCCESSFUL, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
            return true;
        }
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.NO_SIGNING_TIME_ATTRIBUTE, new String[0])));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "9n\t+D,c\u001c0M6b\u0014#F \u007f\u001a;\\ |\u0018;J0n\u000e!K&\u007f\u00197";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 105;
                                break;
                            }
                            case 1: {
                                n8 = 49;
                                break;
                            }
                            case 2: {
                                n8 = 93;
                                break;
                            }
                            case 3: {
                                n8 = 100;
                                break;
                            }
                            default: {
                                n8 = 8;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = ":X:\na\u0007V}\u0010a\u0004T}\u0010g\u0005T/\u0005f\nT}\u0012i\u0005D8De\u001cB)Dj\f\u0011?\u0001|\u001eT8\n(\u001dY8D~\b](\u0001{Y\u0011<\nlI\tkW<Y\u0010\t\fmIG<\b}\f\tkW<YR2\u0016z\fB-\u000bf\rB}\u0010gI\u0000}\u0000i\u0010\u0010";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = ",C/\u000bzIX3Dl\fR2\u0000a\u0007V}\u0010{\u001dX3\u0002g";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = ",C/\u000bzIX3Do\fE)\rf\u000e\u0011)\re\f\u00114\nn\u0006C0\u0005|\u0000^3Dn\u001b^0D|\u001aE4\nn\u0006";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        g = stringArray3;
        e = LoggerFactory.getLogger(SigningTimeChecker.class);
    }
}

