/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicy;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicyId;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.asn.signaturepolicies.SignaturePolicy;

public class SignaturePolicyChecker
extends BaseChecker {
    protected static Logger logger;
    private static final String[] e;

    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        ESignaturePolicy eSignaturePolicy;
        aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.SIGNATURE_POLICY_ATTRIBUTE_CHECKER, new String[0]), SignaturePolicyChecker.class);
        try {
            eSignaturePolicy = aSigner.getSignerInfo().getPolicyAttr();
        }
        catch (ESYAException eSYAException) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNATURE_POLICY_ATTRIBUTE_DECODE_ERROR, new String[0]), eSYAException));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
            return false;
        }
        ESignaturePolicyId eSignaturePolicyId = eSignaturePolicy.getSignaturePolicyId();
        if (eSignaturePolicyId != null) {
            boolean bl = false;
            byte[] byArray = null;
            DigestAlg digestAlg = DigestAlg.fromOID((int[])eSignaturePolicyId.getHashInfo().getHashAlg().getAlgorithm().value);
            byte[] byArray2 = eSignaturePolicyId.getHashInfo().getHashValue();
            try {
                TurkishESigProfile turkishESigProfile = TurkishESigProfile.getSignatureProfileFromOid((int[])eSignaturePolicyId.getPolicyObjectIdentifier().value);
                if (turkishESigProfile != null) {
                    byArray = turkishESigProfile.getDigestofProfile(digestAlg.getOID());
                } else {
                    byte[] byArray3 = (byte[])this.getParameters().get(e[2]);
                    if (byArray3 == null) {
                        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNATURE_POLICY_VALUE_NOT_FOUND, new String[0])));
                        aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
                        return false;
                    }
                    byte[] byArray4 = this.a(byArray3);
                    if (byArray4 != null) {
                        byArray3 = byArray4;
                    }
                    byArray = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray3);
                }
            }
            catch (Exception exception) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNATURE_POLICY_ATTRIBUTE_DIGEST_CALCULATION_ERROR, new String[0]), exception));
                aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
                return false;
            }
            bl = Arrays.equals(byArray2, byArray);
            if (bl) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNATURE_POLICY_ATTRIBUTE_CHECKER_SUCCESSFUL, new String[0])));
                aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
                return true;
            }
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNATURE_POLICY_ATTRIBUTE_CHECKER_UNSUCCESSFUL, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
            return false;
        }
        aCheckerResult.addMessage(new ValidationMessage(e[1]));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
        return false;
    }

    private byte[] a(byte[] byArray) throws ESYAException {
        Asn1DerEncodeBuffer asn1DerEncodeBuffer;
        SignaturePolicy signaturePolicy;
        Object object;
        byte[] byArray2 = null;
        try {
            object = new Asn1DerDecodeBuffer(byArray);
            signaturePolicy = new SignaturePolicy();
            signaturePolicy.decode((Asn1BerDecodeBuffer)object);
            asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            signaturePolicy.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer, false);
            byArray2 = asn1DerEncodeBuffer.getMsgCopy();
        }
        catch (Exception exception) {
            logger.warn(e[0], (Throwable)exception);
            return null;
        }
        if (signaturePolicy.signPolicyHash != null) {
            object = signaturePolicy.signPolicyHash.value;
            asn1DerEncodeBuffer = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)new EAlgorithmIdentifier(signaturePolicy.signPolicyHashAlg));
            byte[] byArray3 = DigestUtil.digest((DigestAlg)asn1DerEncodeBuffer, (byte[])byArray2);
            if (!Arrays.equals((byte[])object, byArray3)) {
                throw new ESYAException();
            }
        }
        return byArray2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "v_|'COY. D\u0001mg.D@J{;OqQb IX}f,IJ[|";
        int n2 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block14;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 33;
                                break;
                            }
                            case 1: {
                                n8 = 62;
                                break;
                            }
                            case 2: {
                                n8 = 14;
                                break;
                            }
                            case 3: {
                                n8 = 73;
                                break;
                            }
                            default: {
                                n8 = 42;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "hSt(N@UgiYHY`(^TLkiZNRg*S\u0001Qt,FMWi DHP.=CQW.\u0016yhy@\b~tlK\u0019emwM\u0010ce\u001ej,MHR";
                    n2 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "qa^\u0006fh}W\u0016|`r[\f";
                    n2 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
        logger = LoggerFactory.getLogger(SignaturePolicyChecker.class);
    }
}

