/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.signature;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1IA5String;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EATSHashIndex;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECertificateChoices;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EIssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EOtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ERevocationInfoChoice;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESigPolicyQualifierInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicy;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerInfo;
import tr.gov.tubitak.uekae.esya.api.asn.esya.EESYAOID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CertRevocationInfoFinder;
import tr.gov.tubitak.uekae.esya.api.cmssignature.SignableByteArray;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.IAttribute;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MessageDigestAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MimeTypeAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignaturePolicyIdentifierAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignatureTimeStampAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.provider.CMSSigProviderUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.SignatureParser;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.c;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.CertificateValidationException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ProfileRevocationValueMatcherChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TurkishProfileAttributesChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;
import tr.gov.tubitak.uekae.esya.api.crypto.HashInfo;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.MobileSigner;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureRuntimeException;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.TimestampInfo;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolverFromCertStore;
import tr.gov.tubitak.uekae.esya.api.signature.impl.TimestampInfoImp;
import tr.gov.tubitak.uekae.esya.asn.cms.SPUserNotice;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.cms._etsi101733Values;
import tr.gov.tubitak.uekae.esya.asn.etsiqc._etsiqcValues;
import tr.gov.tubitak.uekae.esya.asn.x509.Attribute;

public abstract class Signer {
    protected EAttribute mParentCounterSignatureAttribute;
    protected Signer mParent;
    protected boolean mIsCounterSignature;
    protected int mCSIndex = -1;
    protected ESignerInfo mSignerInfo;
    protected ESignatureType mSignatureType;
    protected BaseSignedData mSignedData;
    private static final DigestAlg a;
    private static final Boolean b;
    private static final int c = 1;
    private static final Boolean d;
    private static final Long e;
    private static final int f = 300;
    private static final Boolean g;
    private static final Boolean h;
    static Asn1ObjectIdentifier i;
    static Asn1ObjectIdentifier j;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static boolean k;
    private static final String[] l;

    Signer() {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(l[38] + lE.getMessage(), (Throwable)lE);
        }
    }

    Signer(BaseSignedData baseSignedData) {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(l[43] + lE.getMessage(), (Throwable)lE);
        }
        this.mSignedData = baseSignedData;
        this.mSignerInfo = new ESignerInfo(new SignerInfo());
    }

    public ESignerInfo getSignerInfo() {
        return this.mSignerInfo;
    }

    public BaseSignedData getBaseSignedData() {
        return this.mSignedData;
    }

    public ECertificate getSignerCertificate() {
        List list = this.mSignedData.getSignedData().getCertificates();
        return this.mSignerInfo.getSignerCertificate(list);
    }

    public HashInfo getContentHashInfo() throws ESYAException {
        List list = this.mSignerInfo.getSignedAttribute(MessageDigestAttr.OID);
        if (!list.isEmpty()) {
            EAttribute eAttribute = (EAttribute)list.get(0);
            byte[] byArray = MessageDigestAttr.toMessageDigest(eAttribute).getHash();
            DigestAlg digestAlg = DigestAlg.fromOID((int[])this.mSignerInfo.getDigestAlgorithm().getAlgorithm().value);
            return new HashInfo(digestAlg, byArray);
        }
        return null;
    }

    public void convert(ESignatureType aType, Map<String, Object> aParameters) throws CMSSignatureException {
        this.a(null, aType);
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        this._convert(aType, this.mIsCounterSignature, hashMap);
        this.c();
        this.mSignatureType = aType;
    }

    private boolean a() {
        boolean bl = k;
        Signer signer = this.mParent;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                return true;
            }
            signer = signer.mParent;
            if (!bl) continue;
        }
        return false;
    }

    public Calendar getESAv2Time() throws ESYAException {
        boolean bl = k;
        Signer signer = this.mParent;
        Calendar calendar = null;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                calendar = SignatureTimeStampAttr.toTime(list.get(0));
                return calendar;
            }
            signer = signer.mParent;
            if (!bl) continue;
        }
        return calendar;
    }

    public List<TimestampInfo> getAllTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_contentTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_escTimeStamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_signatureTimeStampToken);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_certCRLTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        Collections.sort(arrayList, new c(this));
        return arrayList;
    }

    private void a(List<TimestampInfo> list, List<TimestampInfo> list2) {
        boolean bl = k;
        for (TimestampInfo timestampInfo : list) {
            list2.add(timestampInfo);
            if (!bl) continue;
        }
    }

    private List<TimestampInfo> a(Asn1ObjectIdentifier asn1ObjectIdentifier) throws ESYAException {
        List list;
        boolean bl;
        block5: {
            bl = k;
            list = this.mSignerInfo.getUnsignedAttribute(asn1ObjectIdentifier);
            if (list != null || !list.isEmpty()) break block5;
            return null;
        }
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>(list.size());
        for (EAttribute eAttribute : list) {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            ETSTInfo eTSTInfo = new ETSTInfo(eSignedData.getEncapsulatedContentInfo().getContent());
            TimestampInfoImp timestampInfoImp = new TimestampInfoImp(CMSSigProviderUtil.convertTimestampType(asn1ObjectIdentifier), eSignedData, eTSTInfo);
            arrayList.add((TimestampInfo)timestampInfoImp);
            if (!bl) continue;
        }
        return arrayList;
    }

    public boolean _checkIfSignerIsESAV3() {
        block4: {
            List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
            if (list == null || list.size() <= 0) break block4;
            return true;
        }
        return false;
    }

    public boolean _checkIfSignerIsESAV2() {
        block9: {
            List list;
            block8: {
                List list2 = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestamp);
                list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                if (list2 == null || list2.size() <= 0) break block8;
                return true;
            }
            if (list == null || list.size() <= 0) break block9;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _convert(ESignatureType aType, boolean aIsCounterSignature, Map<String, Object> aParameters) throws CMSSignatureException {
        ECertificate eCertificate;
        ESignatureType eSignatureType = SignatureParser.parse(this.mSignerInfo, aIsCounterSignature);
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        arrayList.addAll(this.mSignedData.getSignedData().getCertificates());
        Object object = aParameters.get(l[14]);
        ECertificate eCertificate2 = null;
        if (object != null && object instanceof ECertificate) {
            eCertificate2 = (ECertificate)object;
            arrayList.add(eCertificate2);
        }
        if ((eCertificate = this.getSignerCertificate()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(l[13]);
            }
            throw new CMSSignatureException(l[11]);
        }
        aParameters.put(l[12], eCertificate);
        Signer signer = null;
        try {
            signer = ESignatureType.createSigner(aType, this.mSignedData, this.mSignerInfo);
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(l[10], (Throwable)exception);
            }
            throw new CMSSignatureException(l[15], exception);
        }
        this.a(aIsCounterSignature, eCertificate, null, aParameters);
        signer._convert(eSignatureType, aParameters);
    }

    public boolean remove() throws CMSSignatureException {
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        if (!this.mIsCounterSignature) {
            return this.mSignedData.removeSigner(this.mSignerInfo);
        }
        return this.mParent.removeUnSignedAttribute(this.mParentCounterSignatureAttribute);
    }

    private boolean b() throws CMSSignatureException {
        boolean bl = k;
        Signer signer = this.mParent;
        Signer signer2 = this;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                return true;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new CMSSignatureException(l[18], eSYAException);
                    }
                    if (!bl) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (!bl) continue;
        }
        return false;
    }

    public Calendar getESAv3Time() throws ESYAException {
        boolean bl = k;
        Signer signer = this.mParent;
        Signer signer2 = this;
        Calendar calendar = null;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                int n = this.a(list, eAttribute);
                                calendar = SignatureTimeStampAttr.toTime(list.get(n));
                                return calendar;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new ESYAException(l[50], (Throwable)eSYAException);
                    }
                    if (!bl) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (!bl) continue;
        }
        return calendar;
    }

    private int a(List<EAttribute> list, EAttribute eAttribute) throws CryptoException {
        boolean bl = k;
        for (int i = 0; i < list.size() - 1; ++i) {
            EATSHashIndex eATSHashIndex = this.a(list.get(i));
            List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
            asn1DerEncodeBuffer.reset();
            if (!list2.contains(asn1OctetString)) continue;
            return i;
        }
        return list.size() - 1;
    }

    private EATSHashIndex a(EAttribute eAttribute) {
        try {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            EAttribute eAttribute2 = (EAttribute)eSignedData.getSignerInfo(0).getUnsignedAttribute(AttributeOIDs.id_aa_ATSHashIndex).get(0);
            return new EATSHashIndex(eAttribute2.getValue(0));
        }
        catch (ESYAException eSYAException) {
            throw new ESYARuntimeException(l[16], (Throwable)eSYAException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(ESignatureType aType, ECertificate aCer, BaseSigner aSignerInterface, List<IAttribute> aOptionalAttributes, Map<String, Object> aParameters) throws CertificateValidationException, CMSSignatureException {
        boolean bl2 = k;
        this.a(aCer, aType);
        if (this.mSignedData.checkIfAnyESAv2Exist() && this.b()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(l[4]);
            }
            throw new CMSSignatureException(l[6]);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(l[7] + aCer + l[5]);
        }
        Signer signer = null;
        SignatureAlg signatureAlg = null;
        try {
            signatureAlg = SignatureAlg.fromName((String)aSignerInterface.getSignatureAlgorithmStr());
            signer = ESignatureType.createSigner(aType, this.mSignedData);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(l[3], argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(l[9], exception);
        }
        DigestAlg digestAlg = signatureAlg.getDigestAlg();
        AlgorithmParameterSpec algorithmParameterSpec = aSignerInterface.getAlgorithmParameterSpec();
        digestAlg = CMSSignatureUtil.getDigestAlgFromParameters(digestAlg, algorithmParameterSpec);
        hashMap.put(l[8], new SignableByteArray(this.mSignerInfo.getSignature()));
        signer.a(true, aCer, aSignerInterface, aOptionalAttributes, hashMap, digestAlg);
        EAttribute eAttribute = new EAttribute(new Attribute());
        eAttribute.setType(AttributeOIDs.id_countersignature);
        eAttribute.addValue(signer.getSignerInfo().getEncoded());
        this.mSignerInfo.addUnsignedAttribute(eAttribute);
        if (digestAlg != null) {
            CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), digestAlg.toAlgorithmIdentifier());
        }
        this.c();
        if (BaseChecker.d) {
            k = !bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(Signer signer) {
        if (this.checkSignerMessageDigest(signer, this.mSignerInfo.getSignature())) {
            EAttribute eAttribute = new EAttribute(new Attribute());
            eAttribute.setType(AttributeOIDs.id_countersignature);
            eAttribute.addValue(signer.getSignerInfo().getEncoded());
            this.mSignerInfo.addUnsignedAttribute(eAttribute);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), signer.getSignerCertificate());
            EAlgorithmIdentifier eAlgorithmIdentifier = signer.getSignerInfo().getDigestAlgorithm();
            if (eAlgorithmIdentifier != null) {
                CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), eAlgorithmIdentifier);
            }
            this.c();
            if (!k) return;
        }
        this.logger.error(l[35]);
    }

    public boolean checkSignerMessageDigest(Signer aSigner, byte[] aContent) {
        Object object;
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_messageDigest);
        if (list.isEmpty()) {
            this.logger.error(l[46]);
            return false;
        }
        EAttribute eAttribute = list.get(0);
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        try {
            object = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
            asn1OctetString.decode((Asn1BerDecodeBuffer)object);
        }
        catch (Exception exception) {
            this.logger.error(l[48], (Throwable)exception);
            return false;
        }
        DigestAlg digestAlg = DigestAlg.fromOID((int[])aSigner.getSignerInfo().getDigestAlgorithm().getAlgorithm().value);
        if (digestAlg == null) {
            this.logger.error(l[49]);
            return false;
        }
        try {
            object = DigestUtil.digest((DigestAlg)digestAlg, (byte[])aContent);
        }
        catch (CryptoException cryptoException) {
            this.logger.error(l[47], (Throwable)cryptoException);
            return false;
        }
        boolean bl = Arrays.equals(asn1OctetString.value, (byte[])object);
        if (!bl) {
            this.logger.error(l[44]);
            return false;
        }
        this.logger.error(l[45]);
        return true;
    }

    public List<Signer> getCounterSigners() throws CMSSignatureException {
        boolean bl = k;
        List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_countersignature);
        ArrayList<Signer> arrayList = new ArrayList<Signer>();
        for (EAttribute eAttribute : list) {
            try {
                for (int i = 0; i < eAttribute.getValueCount(); ++i) {
                    ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(i));
                    ESignatureType eSignatureType = SignatureParser.parse(eSignerInfo, true);
                    Signer signer = ESignatureType.createSigner(eSignatureType, this.mSignedData, eSignerInfo);
                    signer.setParent(this, eAttribute, i);
                    arrayList.add(signer);
                    if (!bl) continue;
                    break;
                }
            }
            catch (Exception exception) {
                throw new CMSSignatureException(l[34], exception);
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    public ESignatureType getType() {
        return this.mSignatureType;
    }

    protected void setParent(Signer aParent, EAttribute aAttr, int aIndex) {
        this.mParent = aParent;
        this.mParentCounterSignatureAttribute = aAttr;
        this.mCSIndex = aIndex;
        if (this.mParent != null) {
            this.mIsCounterSignature = true;
        }
    }

    public boolean isCounterSignature() {
        return this.mIsCounterSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(boolean bl, ECertificate eCertificate, BaseSigner baseSigner, List<IAttribute> list, Map<String, Object> map, DigestAlg digestAlg) throws CMSSignatureException {
        Object object2;
        List<IAttribute> list2;
        HashMap<String, Object> hashMap;
        boolean bl2;
        block35: {
            block32: {
                block34: {
                    block33: {
                        bl2 = k;
                        if (bl && this.b(list)) {
                            throw new CMSSignatureException(l[25]);
                        }
                        hashMap = new HashMap<String, Object>();
                        if (map != null) {
                            hashMap.putAll(map);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(l[23] + digestAlg);
                        }
                        this.a(bl, eCertificate, digestAlg, hashMap);
                        DigestAlg digestAlg2 = (DigestAlg)hashMap.get(l[30]);
                        if (this.mSignatureType == ESignatureType.TYPE_EPES && !this.a(list)) {
                            throw new CMSSignatureException(l[31]);
                        }
                        list2 = this._getMandatorySignedAttributes(bl, digestAlg2);
                        this.mSignerInfo.setVersion(1);
                        if (eCertificate != null || !(baseSigner instanceof MobileSigner)) break block32;
                        object2 = ((MobileSigner)baseSigner).getSignerIdentifier();
                        if (object2 == null) {
                            throw new CMSSignatureException(l[28]);
                        }
                        this.mSignerInfo.setSignerIdentifier(object2);
                        DigestAlg object3 = ((MobileSigner)baseSigner).getDigestAlg();
                        list2 = this._getMandatorySignedAttributes(bl, object3);
                        if (!object3.equals((Object)DigestAlg.SHA1)) break block33;
                        hashMap.put(l[22], ((MobileSigner)baseSigner).getSigningCertAttr());
                        if (!bl2) break block34;
                        BaseChecker.d = !BaseChecker.d;
                    }
                    hashMap.put(l[27], ((MobileSigner)baseSigner).getSigningCertAttrv2());
                }
                if (!bl2) break block35;
            }
            object2 = new ESignerIdentifier(new SignerIdentifier());
            object2.setIssuerAndSerialNumber(new EIssuerAndSerialNumber(eCertificate));
            this.mSignerInfo.setSignerIdentifier(object2);
        }
        if (list != null) {
            list2.addAll(list);
        }
        this.mSignerInfo.setDigestAlgorithm(digestAlg.toAlgorithmIdentifier());
        for (IAttribute exception : list2) {
            if (exception.isSigned()) {
                exception.setParameters(hashMap);
                exception.setValue();
                this.mSignerInfo.addSignedAttribute(exception.getAttribute());
            }
            if (!bl2) continue;
        }
        this.a(hashMap);
        object2 = null;
        try {
            SignatureAlg signatureAlg = SignatureAlg.fromName((String)baseSigner.getSignatureAlgorithmStr());
            AlgorithmParameterSpec algorithmParameterSpec = baseSigner.getAlgorithmParameterSpec();
            EAlgorithmIdentifier eAlgorithmIdentifier = signatureAlg.toAlgorithmIdentifierFromSpec(algorithmParameterSpec);
            this.mSignerInfo.setSignatureAlgorithm(eAlgorithmIdentifier);
            Chronometer chronometer = new Chronometer(l[26]);
            chronometer.start();
            byte[] byArray = this.mSignerInfo.getSignedAttributes().getEncoded();
            object2 = baseSigner.sign(byArray);
            if (eCertificate == null && baseSigner instanceof MobileSigner) {
                eCertificate = ((MobileSigner)baseSigner).getSigningCert();
                hashMap.put(l[29], eCertificate);
            }
            this.logger.info(chronometer.stopSingleRun());
            this.mSignerInfo.setSignature((byte[])object2);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), eCertificate);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(l[32], argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(l[24], exception);
        }
        this._addUnsignedAttributes(hashMap);
    }

    private boolean a(List<IAttribute> list) {
        boolean bl = k;
        for (IAttribute iAttribute : list) {
            if (iAttribute instanceof SignaturePolicyIdentifierAttr) {
                return true;
            }
            if (!bl) continue;
        }
        return false;
    }

    private boolean b(List<IAttribute> list) {
        boolean bl = k;
        if (list != null) {
            for (IAttribute iAttribute : list) {
                if (iAttribute instanceof MimeTypeAttr) {
                    return true;
                }
                if (!bl) continue;
            }
        }
        return false;
    }

    protected CertificateStatusInfo _validateCertificate(ECertificate aCer, Map<String, Object> aParams, Calendar aDate, boolean gelismis) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        block8: {
            boolean bl = k;
            CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(gelismis);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(aCer, aParams, aDate);
            List<CertRevocationInfoFinder.CertRevocationInfo> list = certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
            aParams.put(l[39], list);
            try {
                boolean bl2 = Boolean.TRUE.equals(aParams.get(l[40]));
                if (!this.isTurkishProfile() || bl2) break block8;
                ArrayList<BaseChecker> arrayList = new ArrayList<BaseChecker>();
                ProfileRevocationValueMatcherChecker profileRevocationValueMatcherChecker = new ProfileRevocationValueMatcherChecker(certificateStatusInfo, true);
                TurkishProfileAttributesChecker turkishProfileAttributesChecker = new TurkishProfileAttributesChecker(true);
                arrayList.add(profileRevocationValueMatcherChecker);
                arrayList.add(turkishProfileAttributesChecker);
                for (Checker checker : arrayList) {
                    CheckerResult checkerResult = new CheckerResult();
                    checker.setParameters(aParams);
                    boolean bl3 = checker.check(this, checkerResult);
                    if (!bl3) {
                        throw new CMSSignatureException(checkerResult.getCheckResult());
                    }
                    if (!bl) continue;
                    break;
                }
            }
            catch (Exception exception) {
                this.logger.error(l[41] + exception.getMessage());
                throw new SignatureRuntimeException((Throwable)exception);
            }
        }
        return certificateStatusInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, ECertificate eCertificate, DigestAlg digestAlg, Map<String, Object> map) {
        boolean bl2;
        block87: {
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block80: {
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        block74: {
                                                            block75: {
                                                                bl2 = k;
                                                                if (digestAlg != null) {
                                                                    map.put(l[52], digestAlg);
                                                                    map.put(l[71], digestAlg);
                                                                }
                                                                if (eCertificate != null) {
                                                                    map.put(l[105], eCertificate);
                                                                }
                                                                map.put(l[60], this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContentType());
                                                                if (bl) break block74;
                                                                if (this.mSignedData.a() != null) break block75;
                                                                byte[] byArray = this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContent();
                                                                if (byArray != null) {
                                                                    map.put(l[56], new SignableByteArray(byArray));
                                                                }
                                                                if (!bl2) break block74;
                                                            }
                                                            map.put(l[51], this.mSignedData.a());
                                                        }
                                                        if (map.containsKey(l[58])) break block76;
                                                        map.put(l[87], a);
                                                        if (!this.logger.isDebugEnabled()) break block77;
                                                        this.logger.debug(l[103] + digestAlg + l[76]);
                                                        if (!bl2) break block77;
                                                    }
                                                    if (!(map.get(l[101]) instanceof DigestAlg)) {
                                                        map.put(l[100], a);
                                                        this.logger.debug(l[62] + digestAlg + l[106]);
                                                    }
                                                }
                                                if (map.containsKey(l[89])) break block78;
                                                map.put(l[57], b);
                                                if (!this.logger.isDebugEnabled()) break block79;
                                                this.logger.debug(l[93]);
                                                if (!bl2) break block79;
                                            }
                                            if (!(map.get(l[82]) instanceof Boolean)) {
                                                map.put(l[61], b);
                                                this.logger.debug(l[98]);
                                            }
                                        }
                                        if (!map.containsKey(l[95])) {
                                            map.put(l[54], new ValidationInfoResolverFromCertStore());
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(l[77]);
                                            }
                                        }
                                        ValidationInfoResolver validationInfoResolver = (ValidationInfoResolver)map.get(l[81]);
                                        List list = (List)map.get(l[74]);
                                        List list2 = (List)map.get(l[88]);
                                        List list3 = (List)map.get(l[94]);
                                        if (list != null) {
                                            validationInfoResolver.addCertificates(list);
                                        }
                                        if (list2 != null) {
                                            validationInfoResolver.addCRLs(list2);
                                        }
                                        if (list3 != null) {
                                            validationInfoResolver.addOCSPResponses(list3);
                                        }
                                        if (map.containsKey(l[86])) break block80;
                                        map.put(l[96], d);
                                        if (!this.logger.isDebugEnabled()) break block81;
                                        this.logger.debug(l[78]);
                                        if (!bl2) break block81;
                                    }
                                    if (!(map.get(l[67]) instanceof Boolean)) {
                                        map.put(l[79], d);
                                        this.logger.debug(l[69]);
                                    }
                                }
                                if (map.containsKey(l[80])) break block82;
                                map.put(l[55], e);
                                if (!this.logger.isDebugEnabled()) break block83;
                                this.logger.debug(l[53] + e + ".");
                                if (!bl2) break block83;
                            }
                            if (!(map.get(l[68]) instanceof Long)) {
                                map.put(l[73], e);
                                this.logger.debug(l[85] + e + ".");
                            }
                        }
                        if (map.containsKey(l[91])) break block84;
                        map.put(l[65], 300);
                        if (!this.logger.isDebugEnabled()) break block85;
                        this.logger.debug(l[66]);
                        if (!bl2) break block85;
                    }
                    if (!(map.get(l[83]) instanceof Integer)) {
                        map.put(l[97], 300);
                        this.logger.debug(l[104]);
                    }
                }
                if (map.containsKey(l[99])) break block86;
                map.put(l[72], g);
                if (!this.logger.isDebugEnabled()) break block87;
                this.logger.debug(l[102] + e + ".");
                if (!bl2) break block87;
            }
            if (!(map.get(l[70]) instanceof Boolean)) {
                map.put(l[92], g);
                this.logger.debug(l[64] + g + ".");
            }
        }
        if (!map.containsKey(l[107])) {
            map.put(l[75], h);
            if (!this.logger.isDebugEnabled()) return;
            this.logger.debug(l[84]);
            if (!bl2) return;
        }
        if (map.get(l[63]) instanceof Boolean) return;
        map.put(l[90], h);
        this.logger.debug(l[59]);
    }

    public List<EAttribute> getSignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getSignedAttribute(aOID);
    }

    public List<EAttribute> getUnsignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getUnsignedAttribute(aOID);
    }

    public List<EAttribute> getAttribute(Asn1ObjectIdentifier aOID) {
        List list = this.mSignerInfo.getUnsignedAttribute(aOID);
        List list2 = this.mSignerInfo.getSignedAttribute(aOID);
        list.addAll(list2);
        return list;
    }

    public boolean removeUnSignedAttribute(EAttribute aAttribute) {
        boolean bl = this.mSignerInfo.removeUnSignedAttribute(aAttribute);
        this.c();
        return bl;
    }

    private void c() {
        boolean bl = k;
        Signer signer = this.mParent;
        EAttribute eAttribute = this.mParentCounterSignatureAttribute;
        ESignerInfo eSignerInfo = this.mSignerInfo;
        while (signer != null) {
            eAttribute.setValue(this.mCSIndex, eSignerInfo.getEncoded());
            eAttribute = signer.mParentCounterSignatureAttribute;
            eSignerInfo = signer.mSignerInfo;
            signer = signer.mParent;
            if (!bl) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate, ESignatureType eSignatureType) {
        try {
            block11: {
                block10: {
                    if (eSignatureType != ESignatureType.TYPE_BES && eSignatureType != ESignatureType.TYPE_EPES) break block10;
                    LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
                    if (!k) break block11;
                }
                LV.getInstance().checkLD(LV.Urunler.CMSIMZAGELISMIS);
            }
            boolean bl = LV.getInstance().isTL(LV.Urunler.CMSIMZA);
            if (eCertificate == null) return;
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(l[1])) return;
            throw new ESYARuntimeException(l[2]);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(l[0] + lE.getMessage(), (Throwable)lE);
        }
    }

    public boolean isTurkishProfile() {
        try {
            TurkishESigProfile turkishESigProfile = this.mSignerInfo.getProfile();
            if (turkishESigProfile == null) {
                return false;
            }
        }
        catch (Exception exception) {
            this.logger.warn(l[33], (Throwable)exception);
            return false;
        }
        return true;
    }

    protected void _addCertRevocationValuesToSignedData(List<CertRevocationInfoFinder.CertRevocationInfo> aList) throws CMSSignatureException {
        this.a(aList, this.mSignedData.getSignedData());
    }

    protected void _addCertRevocationValuesToSignedData(List<ECertificate> aCerts, List<ECRL> aCrls, List<EOCSPResponse> aOCSPResponses) throws CMSSignatureException {
        this.a(aCerts, aCrls, aOCSPResponses, this.mSignedData.getSignedData());
    }

    public List<CertRevocationInfoFinder.CertRevocationInfo> findTSCertificateRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap) throws CMSSignatureException {
        return this.a(aTSAttr, aParamMap);
    }

    private List<CertRevocationInfoFinder.CertRevocationInfo> a(EAttribute eAttribute, Map<String, Object> map) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        Calendar calendar = null;
        EContentInfo eContentInfo = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
        }
        catch (Exception exception) {
            throw new CMSSignatureException(l[20], exception);
        }
        BaseSignedData baseSignedData = new BaseSignedData(eContentInfo);
        ECertificate eCertificate = baseSignedData.getSignerList().get(0).getSignerCertificate();
        if (eCertificate == null) {
            throw new CMSSignatureException(l[21]);
        }
        calendar = Calendar.getInstance();
        CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(true);
        try {
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        catch (CertificateValidationException certificateValidationException) {
            try {
                calendar = SignatureTimeStampAttr.toTime(eAttribute);
            }
            catch (ESYAException eSYAException) {
                this.logger.warn(l[19], (Throwable)eSYAException);
                throw certificateValidationException;
            }
            certRevocationInfoFinder = new CertRevocationInfoFinder(true);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        return certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
    }

    protected void _addTSCertRevocationValues(Map<String, Object> aParameters, Asn1ObjectIdentifier aTSOID, boolean intoTimestamp) throws CMSSignatureException {
        boolean bl = k;
        List list = this.mSignerInfo.getUnsignedAttribute(aTSOID);
        if (list.isEmpty()) {
            list = this.mSignerInfo.getSignedAttribute(aTSOID);
            if (list.isEmpty()) {
                throw new CMSSignatureException(l[42] + aTSOID);
            }
        }
        for (EAttribute eAttribute : list) {
            this._addTSCertRevocationValues(eAttribute, aParameters, intoTimestamp);
            if (!bl) continue;
        }
    }

    protected void _addTSCertRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap, boolean intoTimestamp) throws CMSSignatureException {
        block5: {
            List<CertRevocationInfoFinder.CertRevocationInfo> list;
            block4: {
                list = this.a(aTSAttr, aParamMap);
                if (!intoTimestamp) break block4;
                this.b(list, aTSAttr);
                if (!k) break block5;
            }
            this._addCertRevocationValuesToSignedData(list);
        }
    }

    private void b(List<CertRevocationInfoFinder.CertRevocationInfo> list, EAttribute eAttribute) throws CMSSignatureException {
        EContentInfo eContentInfo = null;
        ESignedData eSignedData = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
            eSignedData = new ESignedData(eContentInfo.getContent());
        }
        catch (Exception exception) {
            throw new CMSSignatureException(l[17], exception);
        }
        this.a(list, eSignedData);
        eContentInfo.setContent(eSignedData.getEncoded());
        eAttribute.setValue(0, eContentInfo.getEncoded());
    }

    private void a(List<CertRevocationInfoFinder.CertRevocationInfo> list, ESignedData eSignedData) throws CMSSignatureException {
        List<ECertificate> list2 = AttributeUtil.getCertificates(list);
        List<ECRL> list3 = AttributeUtil.getCRLs(list);
        List<EOCSPResponse> list4 = AttributeUtil.getOCSPResponses(list);
        this.a(list2, list3, list4, eSignedData);
    }

    /*
     * WARNING - void declaration
     */
    private void a(List<ECertificate> list, List<ECRL> list2, List<EOCSPResponse> list3, ESignedData eSignedData) throws CMSSignatureException {
        boolean bl = k;
        List<Object> list4 = new ArrayList();
        if (eSignedData.getCertificateSet() != null) {
            list4 = Arrays.asList(eSignedData.getCertificateSet().getCertificates());
        }
        for (ECertificate object2 : list) {
            if (!list4.contains(object2)) {
                eSignedData.addCertificateChoices(new ECertificateChoices(object2));
            }
            if (!bl) continue;
        }
        Object object3 = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            object3 = eSignedData.getRevocationInfoChoices().getCRLs();
        }
        for (ECRL eCRL : list2) {
            if (!object3.contains(eCRL)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eCRL));
            }
            if (!bl) continue;
        }
        ArrayList arrayList = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            List list5 = eSignedData.getOSCPResponses();
        }
        for (EOCSPResponse eOCSPResponse : list3) {
            void var7_12;
            if (!var7_12.contains(eOCSPResponse)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eOCSPResponse));
            }
            if (!bl) continue;
        }
    }

    private void a(Map<String, Object> map) throws CMSSignatureException {
        Asn1ObjectIdentifier asn1ObjectIdentifier = AttributeOIDs.id_aa_ets_contentTimestamp;
        if (this.mSignerInfo.getSignedAttribute(asn1ObjectIdentifier).size() > 0) {
            this._addTSCertRevocationValues(map, asn1ObjectIdentifier, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignaturePolicyIdentifier getSignaturePolicy() {
        boolean bl = k;
        if (this.getType() == ESignatureType.TYPE_BES) {
            return null;
        }
        ESignaturePolicy eSignaturePolicy = null;
        try {
            eSignaturePolicy = this.getSignerInfo().getPolicyAttr();
        }
        catch (Exception exception) {
            this.logger.warn(l[37], (Throwable)exception);
            throw new SignatureRuntimeException();
        }
        if (eSignaturePolicy == null) {
            return null;
        }
        OID oID = new OID(eSignaturePolicy.getSignaturePolicyId().getPolicyObjectIdentifier().value);
        EOtherHashAlgAndValue eOtherHashAlgAndValue = eSignaturePolicy.getSignaturePolicyId().getHashInfo();
        SignaturePolicyIdentifier signaturePolicyIdentifier = eSignaturePolicy.getSignaturePolicyId().getPolicyQualifiers();
        String string = null;
        String string2 = null;
        SignaturePolicyIdentifier signaturePolicyIdentifier2 = signaturePolicyIdentifier;
        int n = ((ESigPolicyQualifierInfo[])signaturePolicyIdentifier2).length;
        int n2 = 0;
        do {
            block13: {
                ESigPolicyQualifierInfo eSigPolicyQualifierInfo;
                block14: {
                    Asn1IA5String asn1IA5String;
                    block12: {
                        if (n2 >= n) return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
                        eSigPolicyQualifierInfo = signaturePolicyIdentifier2[n2];
                        if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_uri)) break block12;
                        asn1IA5String = new Asn1IA5String();
                        eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                        string = asn1IA5String.value;
                        if (!bl) break block13;
                    }
                    if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_unotice)) break block14;
                    asn1IA5String = new SPUserNotice();
                    eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                    string2 = ((Asn1UTF8String)asn1IA5String.explicitText.getElement()).value;
                    if (!bl) break block13;
                }
                this.logger.warn(l[36] + eSigPolicyQualifierInfo.getObjectIdentifier());
            }
            ++n2;
        } while (!bl);
        return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
    }

    protected abstract List<IAttribute> _getMandatorySignedAttributes(boolean var1, DigestAlg var2);

    protected abstract void _addUnsignedAttributes(Map<String, Object> var1) throws CMSSignatureException;

    protected abstract void _convert(ESignatureType var1, Map<String, Object> var2) throws CMSSignatureException;

    public abstract Calendar getTime() throws ESYAException;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[108];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "bjZ/_]#B!_ZqF\"D\u000eaH=P\\jZ'K\u0000#";
        int n2 = -1;
        block115: while (true) {
            char[] cArray;
            block120: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block119: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block119;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block120;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 46;
                                break;
                            }
                            case 1: {
                                n8 = 3;
                                break;
                            }
                            case 2: {
                                n8 = 41;
                                break;
                            }
                            case 3: {
                                n8 = 78;
                                break;
                            }
                            default: {
                                n8 = 49;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "ZfZ:";
                    n2 = 0;
                    continue block115;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "wl\\nYOuLnEKp]n]G`L BK/\t7^[#J/_\u000elG\"H\u000evZ+\u0011Mf[:XHjJ/EKp\t:YOw\t-^@wH'_]#\u000b:T]w\u000bnBZq@ V\u000ejGnRAnD!_\u000emH#T\u000elOnRKq]'WG`H:T";
                    n2 = 1;
                    continue block115;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "}jN PZv[+\u0011OoN!CGwA#\u0011Gp\t ^Z#B ^Ym";
                    n2 = 2;
                    continue block115;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "mbGn_Aw\t/UJ#H ^ZkL<\u0011]jN T\\#Z'_Mf\t:YK#L6X]w@ V\u000eFz\u000f\u0011]jN PZv[+B\u000et@\"]\u000eaLnRAq[;AZfM";
                    n2 = 3;
                    continue block115;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0004)\u00039XBo\t,T\u000ebM*TJ#]!\u0011}jN T\\";
                    n2 = 4;
                    continue block115;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "mbGn_Aw\t/UJ#H ^ZkL<\u0011]jN T\\#Z'_Mf\t:YK#L6X]w@ V\u000eFz\u000f\u0011]jN PZv[+B\u000et@\"]\u000eaLnRAq[;AZfM";
                    n2 = 5;
                    continue block115;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "ml\\ EKq\t\u001dXImL<\u0011Yj]&\u0011ZkLnRKq]'WG`H:T\u0004)\u0003";
                    n2 = 6;
                    continue block115;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "~\\j\u0001\u007fzFg\u001a";
                    n2 = 7;
                    continue block115;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "kq[!C\u000ejGnBGdG+C\u000e`[+PZjF ";
                    n2 = 8;
                    continue block115;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "}jN T\\#J/_@l]nSK#J<TOwL*";
                    n2 = 9;
                    continue block115;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "}jN T\\#j+CZjO'ROwLnRAvE*\u0011@l]nSK#O!D@g";
                    n2 = 10;
                    continue block115;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "~\\z\u0007v`Jg\tnmF{\u001axhJj\u000fek";
                    n2 = 11;
                    continue block115;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "}jN T\\#J+CZjO'ROwLnROmG!E\u000eaLnWAvG*";
                    n2 = 12;
                    continue block115;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "~\\l\u0016ekQg\u000f}qP`\t\u007fgMn\u0011rkQ}\u0007wg@h\u001at";
                    n2 = 13;
                    continue block115;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "kq[!C\u000ejGnBGdG+C\u000e`[+PZjF ";
                    n2 = 14;
                    continue block115;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "kq[!C\u000etA']K#N+EZjG)\u0011OwZcYOpAcX@gL6\u0011Ow]<XLv]+";
                    n2 = 15;
                    continue block115;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "ZjD+BZbD>\u0011JfJ!UK#L<CAq";
                    n2 = 16;
                    continue block115;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "kq[!C\u000elJ-D\\qL*\u0011Yk@\"T\u000e`A+REjG)\u0011Zk@=\u0011]jN T\\#Y<^ZfJ:TJ#K7\u0011OmPnpzP\t8\u0002\u000el[n_Aw";
                    n2 = 17;
                    continue block115;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "yb[ X@d\t'_\u000eP@)_Kq";
                    n2 = 18;
                    continue block115;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "kq[!C\u000elJ-D\\qL*\u0011Yk@\"T\u000edL:EGmNnEGnL=EOnYnRKq]'WG`H:T\u000ebG*\u0011\\f_!ROw@!_\u000eqL(T\\fG-T]";
                    n2 = 19;
                    continue block115;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "zjD+BZbD>\u0011Mf[:XHjJ/EK#M!T]#G!E\u000efQ'BZ#@ \u0011ZjD+BZbD>";
                    n2 = 20;
                    continue block115;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "~\\d\u0001sgOl\u0011bgDg\u000bcqP`\t\u007fgMn\u0011rkQ}\u0011pzW{";
                    n2 = 21;
                    continue block115;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "}jN T\\$ZnUGdL=E\u000ebE)^\\j]&\\\u0014";
                    n2 = 22;
                    continue block115;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "mqP>EA#l<CAq\t'_\u000ep@)_GmN";
                    n2 = 23;
                    continue block115;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "cjD+\u0011ZzY+\u0011Ow]<XLv]+\u0011MbG ^Z#K+\u0011[pL*\u0011Gm\t-^[m]+C\u000ep@)_Ow\\<T]";
                    n2 = 24;
                    continue block115;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "}jN T\\-Z'V@";
                    n2 = 25;
                    continue block115;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "~\\d\u0001sgOl\u0011bgDg\u000bcqP`\t\u007fgMn\u0011rkQ}\u0011pzW{8\u0003";
                    n2 = 26;
                    continue block115;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "clK']\u000ejD4PJb\t&PZb\t!][p];\u001f";
                    n2 = 27;
                    continue block115;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "~\\z\u0007v`Jg\tnmF{\u001axhJj\u000fek";
                    n2 = 28;
                    continue block115;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD";
                    n2 = 29;
                    continue block115;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "kSl\u001d\u0011ZzY+\u0011]jN PZv[+\u0011CvZ:\u0011MlG:PGm\t\u001dXImH:D\\fy!]G`P\u0007UKm]'WGf[\u000fEZq";
                    n2 = 30;
                    continue block115;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "{mB ^Ym\t=XImH:D\\f\t/]Il['EFn";
                    n2 = 31;
                    continue block115;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "yb[ X@d\t'_\u000eP@)_Kq";
                    n2 = 32;
                    continue block115;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "mbGn_Aw\t)TZ#J!D@wL<\u0011]jN PZv[+B";
                    n2 = 33;
                    continue block115;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "ml\\ EKq\t=XImL<\u0011MbG ^Z#K+\u0011OgM+U";
                    n2 = 34;
                    continue block115;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "{mB ^Ym\t>^BjJ7\u0011_vH\"XHjL<\u0011\u0014#";
                    n2 = 35;
                    continue block115;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = "yb[ X@d\t'_\u000e@d\u001dbGdG/E[qL\u0007\\^o";
                    n2 = 36;
                    continue block115;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = "bjZ/_]#B!_ZqF\"D\u000eaH=P\\jZ'K\u0000#";
                    n2 = 37;
                    continue block115;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = "~\\j\u000bczJo\u0007roWl\u0011ckUf\rpzJf\u0000nbJz\u001a";
                    n2 = 38;
                    continue block115;
                }
                case 38: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 40;
                    string2 = "~\\y\u000fukPv\u001dxiMh\u001ad|F";
                    n2 = 39;
                    continue block115;
                }
                case 39: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 41;
                    string2 = "kq[!C\u000etA']K#_/]GgH:X@d\t-T\\w@(XMb]+\u000b\u000e";
                    n2 = 40;
                    continue block115;
                }
                case 40: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 42;
                    string2 = "ZjD+BZbD>\u0011JlL=\u0011@l]nTVjZ:\u001f\u000eL`\n\u000b\u000e";
                    n2 = 41;
                    continue block115;
                }
                case 41: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 43;
                    string2 = "bjZ/_]#B!_ZqF\"D\u000eaH=P\\jZ'K\u0000#";
                    n2 = 42;
                    continue block115;
                }
                case 42: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 44;
                    string2 = "jjN+BZ#J&TMh\t;_]vJ-T]pO;]B";
                    n2 = 43;
                    continue block115;
                }
                case 43: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 45;
                    string2 = "jjN+BZ#J&TMh\t=DM`L=BHvE\"";
                    n2 = 44;
                    continue block115;
                }
                case 44: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 46;
                    string2 = "}jN T\\#M!T]#G!E\u000ekH8T\u000enL=BOdLnUGdL=E\u000eb]:CGa\\:T";
                    n2 = 45;
                    continue block115;
                }
                case 45: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 47;
                    string2 = "jjN+BZ#J&TMh\t(PGoL*";
                    n2 = 46;
                    continue block115;
                }
                case 46: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 48;
                    string2 = "}jN T\\#D+B]bN+\u0011JjN+BZ#J/_@l]nSK#M+RAgL*";
                    n2 = 47;
                    continue block115;
                }
                case 47: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 49;
                    string2 = "}jN T\\#H\"VAq@:YC#\\ Z@l^ ";
                    n2 = 48;
                    continue block115;
                }
                case 48: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 50;
                    string2 = "kq[!C\u000elJ-D\\qL*\u0011Yk@\"T\u000e`A+REjG)\u0011Zk@=\u0011]jN T\\#Y<^ZfJ:TJ#K7\u0011OmPnpzP\t8\u0002\u000el[n_Aw";
                    n2 = 49;
                    continue block115;
                }
                case 49: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 51;
                    string2 = "~\\j\u0001\u007fzFg\u001a";
                    n2 = 50;
                    continue block115;
                }
                case 50: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 52;
                    string2 = "~\\m\u0007vkP}\u0011pbDf\u001cxzKd";
                    n2 = 51;
                    continue block115;
                }
                case 51: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 53;
                    string2 = "~\\n\u001cpmFv\u001et|Jf\n\u0011^b[/\\KwL<\u0011Gp\t ^Z#Z+E\u000eaPnD]f[`aqD{\u000frk\\y\u000bcgLmnX]#Z+E\u000ewFn";
                    n2 = 52;
                    continue block115;
                }
                case 52: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 54;
                    string2 = "~\\\u007f\u000f}gGh\u001axaMv\u0007\u007fhLv\u001ct}Le\u0018t|";
                    n2 = 53;
                    continue block115;
                }
                case 53: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 55;
                    string2 = "~\\n\u001cpmFv\u001et|Jf\n";
                    n2 = 54;
                    continue block115;
                }
                case 54: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 56;
                    string2 = "~\\j\u0001\u007fzFg\u001a";
                    n2 = 55;
                    continue block115;
                }
                case 55: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 57;
                    string2 = "~\\\u007f\u000f}gGh\u001atq@l\u001cegE`\rpzFv\fthL{\u000bn}Jn\u0000x`D";
                    n2 = 56;
                    continue block115;
                }
                case 56: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 58;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD";
                    n2 = 57;
                    continue block115;
                }
                case 57: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 59;
                    string2 = "~\\\u007f\u000f}gGh\u001atqW`\u0003t}Wh\u0003aqTa\u0007}k\\z\u0007v`Jg\t\u0011^b[/\\KwL<\u0011FbZnF\\lG)\u0011ZzY+\u001f~\\\u007f\u000f}gGh\u001atqW`\u0003t}Wh\u0003aqTa\u0007}k\\z\u0007v`Jg\t\u0011Gp\t=TZ#]!\u0011HbE=T\u0000";
                    n2 = 58;
                    continue block115;
                }
                case 58: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 60;
                    string2 = "~\\j\u0001\u007fzFg\u001anzZy\u000b";
                    n2 = 59;
                    continue block115;
                }
                case 59: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 61;
                    string2 = "~\\\u007f\u000f}gGh\u001atq@l\u001cegE`\rpzFv\fthL{\u000bn}Jn\u0000x`D";
                    n2 = 60;
                    continue block115;
                }
                case 60: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 62;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD\t>P\\bD+EKq\t&P]#^<^@d\t:H^f\u0007";
                    n2 = 61;
                    continue block115;
                }
                case 61: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 63;
                    string2 = "~\\\u007f\u000f}gGh\u001atqW`\u0003t}Wh\u0003aqTa\u0007}k\\z\u0007v`Jg\t";
                    n2 = 62;
                    continue block115;
                }
                case 62: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 64;
                    string2 = "jFo\u000fdbWv\u0007v`L{\u000bniQh\rt\u000esH<PCf]+C\u000ekH=\u0011YqF V\u000eGl\bp{O}\u0011xiMf\u001ctqD{\u000frk#@=\u0011]f]nEA#";
                    n2 = 63;
                    continue block115;
                }
                case 63: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 65;
                    string2 = "~\\}\u0001}kQh\u001atqP`\t\u007fgMn\u0011egNl\u0011sw\\z\u000braMm\u001d";
                    n2 = 64;
                    continue block115;
                }
                case 64: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 66;
                    string2 = "~\\}\u0001}kQh\u001atqP`\t\u007fgMn\u0011egNl\u0011sw\\z\u000braMm\u001d\u0011^b[/\\KwL<\u0011Gp\t ^Z#Z+E\u000eaPnD]f[`aqWf\u0002t|B}\u000bn}Jn\u0000x`Dv\u001axcFv\fhqPl\r~`GznX]#Z+E\u000ewFn\u0002\u001e3\u0007";
                    n2 = 65;
                    continue block115;
                }
                case 65: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 67;
                    string2 = "~\\}\u001cd}Wv\u001dxiM`\u0000vzJd\u000bpzW{";
                    n2 = 66;
                    continue block115;
                }
                case 66: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 68;
                    string2 = "~\\n\u001cpmFv\u001et|Jf\n";
                    n2 = 67;
                    continue block115;
                }
                case 67: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 69;
                    string2 = "~\\}\u001cd}Wv\u001dxiM`\u0000vzJd\u000bpzW{nAOqH#TZf[nYOp\t9CAmNnEWsL`aqW{\u001bbz\\z\u0007v`Jg\tegNl\u000fezQ\t'B\u000epL:\u0011Zl\t:C[f\u0007";
                    n2 = 68;
                    continue block115;
                }
                case 68: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 70;
                    string2 = "~\\`\t\u007faQl\u0011v|Bj\u000b";
                    n2 = 69;
                    continue block115;
                }
                case 69: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 71;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD";
                    n2 = 70;
                    continue block115;
                }
                case 70: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 72;
                    string2 = "~\\`\t\u007faQl\u0011v|Bj\u000b";
                    n2 = 71;
                    continue block115;
                }
                case 71: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 73;
                    string2 = "~\\n\u001cpmFv\u001et|Jf\n";
                    n2 = 72;
                    continue block115;
                }
                case 72: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 74;
                    string2 = "~\\`\u0000xzJh\u0002nmF{\u001axhJj\u000fekP";
                    n2 = 73;
                    continue block115;
                }
                case 73: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 75;
                    string2 = "~\\\u007f\u000f}gGh\u001atqW`\u0003t}Wh\u0003aqTa\u0007}k\\z\u0007v`Jg\t";
                    n2 = 74;
                    continue block115;
                }
                case 74: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 76;
                    string2 = "\u000et@\"]\u000eaLnD]fM`";
                    n2 = 75;
                    continue block115;
                }
                case 75: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 77;
                    string2 = "~\\\u007f\u000f}gGh\u001axaMv\u0007\u007fhLv\u001ct}Le\u0018t|#Y/COnL:T\\#@=\u0011@l]nBKw\t,H\u000evZ+C\u0000#\u007f/]GgH:XAm` WAQL=^BuL<w\\lD\rT\\wz:^\\f\t'B\u000evZ+U\u000eaPnUKeH;]Z-";
                    n2 = 76;
                    continue block115;
                }
                case 76: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 78;
                    string2 = "~\\}\u001cd}Wv\u001dxiM`\u0000vzJd\u000bpzW{nAOqH#TZf[nX]#G!E\u000epL:\u0011Lz\t;BKq\u0007\u001enzQ|\u001deqP`\t\u007fgMn\u001axcFh\u001ae|#@=\u0011]f]nEA#O/]]f\u0007";
                    n2 = 77;
                    continue block115;
                }
                case 77: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 79;
                    string2 = "~\\}\u001cd}Wv\u001dxiM`\u0000vzJd\u000bpzW{";
                    n2 = 78;
                    continue block115;
                }
                case 78: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 80;
                    string2 = "~\\n\u001cpmFv\u001et|Jf\n";
                    n2 = 79;
                    continue block115;
                }
                case 79: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 81;
                    string2 = "~\\\u007f\u000f}gGh\u001axaMv\u0007\u007fhLv\u001ct}Le\u0018t|";
                    n2 = 80;
                    continue block115;
                }
                case 80: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 82;
                    string2 = "~\\\u007f\u000f}gGh\u001atq@l\u001cegE`\rpzFv\fthL{\u000bn}Jn\u0000x`D";
                    n2 = 81;
                    continue block115;
                }
                case 81: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 83;
                    string2 = "~\\}\u0001}kQh\u001atqP`\t\u007fgMn\u0011egNl\u0011sw\\z\u000braMm\u001d";
                    n2 = 82;
                    continue block115;
                }
                case 82: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 84;
                    string2 = "~\\\u007f\u000f}gGh\u001atqW`\u0003t}Wh\u0003aqTa\u0007}k\\z\u0007v`Jg\t\u0011^b[/\\KwL<\u0011Gp\t ^Z#Z+E\u000eaPnD]f[`aqUh\u0002xjB}\u000bnzJd\u000bbzBd\u001enyK`\u0002tqP`\t\u007fgMnnX]#Z+E\u000ewFnWOoZ+\u001f";
                    n2 = 83;
                    continue block115;
                }
                case 83: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 85;
                    string2 = "jFo\u000fdbWv\tco@l\u0011akQ`\u0001u\u000esH<PCf]+C\u000ekH=\u0011YqF V\u000eGl\bp{O}\u0011v|Bj\u000bn~F{\u0007~j#@=\u0011]f]nEA#";
                    n2 = 84;
                    continue block115;
                }
                case 84: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 86;
                    string2 = "~\\}\u001cd}Wv\u001dxiM`\u0000vzJd\u000bpzW{";
                    n2 = 85;
                    continue block115;
                }
                case 85: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 87;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD";
                    n2 = 86;
                    continue block115;
                }
                case 86: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 88;
                    string2 = "~\\`\u0000xzJh\u0002nmQe\u001d";
                    n2 = 87;
                    continue block115;
                }
                case 87: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 89;
                    string2 = "~\\\u007f\u000f}gGh\u001atq@l\u001cegE`\rpzFv\fthL{\u000bn}Jn\u0000x`D";
                    n2 = 88;
                    continue block115;
                }
                case 88: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 90;
                    string2 = "~\\\u007f\u000f}gGh\u001atqW`\u0003t}Wh\u0003aqTa\u0007}k\\z\u0007v`Jg\t";
                    n2 = 89;
                    continue block115;
                }
                case 89: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 91;
                    string2 = "~\\}\u0001}kQh\u001atqP`\t\u007fgMn\u0011egNl\u0011sw\\z\u000braMm\u001d";
                    n2 = 90;
                    continue block115;
                }
                case 90: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 92;
                    string2 = "~\\`\t\u007faQl\u0011v|Bj\u000b";
                    n2 = 91;
                    continue block115;
                }
                case 91: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 93;
                    string2 = "~\\\u007f\u000f}gGh\u001atq@l\u001cegE`\rpzFv\fthL{\u000bn}Jn\u0000x`D\t>P\\bD+EKq\t'B\u000emF:\u0011]f]nSW#\\=T\\-j+CZjO'ROwLnFGoEnSK#_/]GgH:TJ#K7\u0011JfO/DBw\u0007";
                    n2 = 92;
                    continue block115;
                }
                case 92: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 94;
                    string2 = "~\\`\u0000xzJh\u0002na@z\u001en|Fz\u001e~`Pl\u001d";
                    n2 = 93;
                    continue block115;
                }
                case 93: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 95;
                    string2 = "~\\\u007f\u000f}gGh\u001axaMv\u0007\u007fhLv\u001ct}Le\u0018t|";
                    n2 = 94;
                    continue block115;
                }
                case 94: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 96;
                    string2 = "~\\}\u001cd}Wv\u001dxiM`\u0000vzJd\u000bpzW{";
                    n2 = 95;
                    continue block115;
                }
                case 95: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 97;
                    string2 = "~\\}\u0001}kQh\u001atqP`\t\u007fgMn\u0011egNl\u0011sw\\z\u000braMm\u001d";
                    n2 = 96;
                    continue block115;
                }
                case 96: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 98;
                    string2 = "~\\\u007f\u000f}gGh\u001atq@l\u001cegE`\rpzFv\fthL{\u000bn}Jn\u0000x`D\t>P\\bD+EKq\t&P]#^<^@d\t:H^f\u0007\rT\\w@(XMb]+\u0011YjE\"\u0011Lf\t8PBjM/EKg\t,H\u000egL(P[o]`";
                    n2 = 97;
                    continue block115;
                }
                case 97: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 99;
                    string2 = "~\\`\t\u007faQl\u0011v|Bj\u000b";
                    n2 = 98;
                    continue block115;
                }
                case 98: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 100;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD";
                    n2 = 99;
                    continue block115;
                }
                case 99: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 101;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD";
                    n2 = 100;
                    continue block115;
                }
                case 100: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 102;
                    string2 = "~\\n\u001cpmFv\u001et|Jf\n\u0011^b[/\\KwL<\u0011Gp\t ^Z#Z+E\u000eaPnD]f[`aqD{\u000frk\\y\u000bcgLmnX]#Z+E\u000ewFn";
                    n2 = 101;
                    continue block115;
                }
                case 101: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 103;
                    string2 = "~\\{\u000bwkQl\u0000rk\\m\u0007vkP}\u0011pbD\t>P\\bD+EKq\t'B\u000emF:\u0011]f]nSW#\\=T\\-";
                    n2 = 102;
                    continue block115;
                }
                case 102: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 104;
                    string2 = "zkLnEWsLn^H#]&T\u000eSv\u001a~bF{\u000fek\\z\u0007v`Jg\tnzJd\u000bnlZv\u001dtmLg\nb\u000esH<PCf]+C\u000ejZnXCs[!AKq\u0007neFf\t>P\\bD+EKq\t9XBo\t,T\u000epL:\u0011Zl\t}\u0001\u001e-";
                    n2 = 103;
                    continue block115;
                }
                case 103: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 105;
                    string2 = "~\\z\u0007v`Jg\tnmF{\u001axhJj\u000fek";
                    n2 = 104;
                    continue block115;
                }
                case 104: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 106;
                    string2 = "\u000et@\"]\u000eaLnD]fM`";
                    n2 = 105;
                    continue block115;
                }
                case 105: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 107;
                    string2 = "~\\\u007f\u000f}gGh\u001atqW`\u0003t}Wh\u0003aqTa\u0007}k\\z\u0007v`Jg\t";
                    n2 = 106;
                    continue block115;
                }
                case 106: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        l = stringArray3;
        a = DigestAlg.SHA256;
        b = true;
        d = false;
        e = 86400L;
        g = false;
        h = true;
        i = new Asn1ObjectIdentifier(_etsiqcValues.id_etsi_qcs_QcCompliance);
        j = EESYAOID.oid_TK_nesoid;
    }
}

