/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.attribute;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1GeneralizedTime;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1UTCTime;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECertificateValues;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ERevocationValues;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CertRevocationInfoFinder;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeValue;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.ContentTypeAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignatureTimeStampAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SigningTimeAttr;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.asn.cms.CRLListID;
import tr.gov.tubitak.uekae.esya.asn.cms.CertificateValues;
import tr.gov.tubitak.uekae.esya.asn.cms.CompleteCertificateRefs;
import tr.gov.tubitak.uekae.esya.asn.cms.CompleteRevocationRefs;
import tr.gov.tubitak.uekae.esya.asn.cms.CrlIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.CrlOcspRef;
import tr.gov.tubitak.uekae.esya.asn.cms.CrlValidatedID;
import tr.gov.tubitak.uekae.esya.asn.cms.IssuerSerial;
import tr.gov.tubitak.uekae.esya.asn.cms.OcspIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.OcspListID;
import tr.gov.tubitak.uekae.esya.asn.cms.OcspResponsesID;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherCertID;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherHash;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherRevVals;
import tr.gov.tubitak.uekae.esya.asn.cms.RevocationValues;
import tr.gov.tubitak.uekae.esya.asn.cms._SeqOfBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.cms._SeqOfCertificateList;
import tr.gov.tubitak.uekae.esya.asn.cms._SeqOfCrlValidatedID;
import tr.gov.tubitak.uekae.esya.asn.cms._SeqOfOcspResponsesID;
import tr.gov.tubitak.uekae.esya.asn.ocsp.BasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.ResponderID;
import tr.gov.tubitak.uekae.esya.asn.ocsp.ResponseData;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;
import tr.gov.tubitak.uekae.esya.asn.x509.CertificateList;
import tr.gov.tubitak.uekae.esya.asn.x509.GeneralName;
import tr.gov.tubitak.uekae.esya.asn.x509.GeneralNames;
import tr.gov.tubitak.uekae.esya.asn.x509.Name;

public class AttributeUtil {
    private static Logger a;
    protected static final Asn1ObjectIdentifier[] timeStampArray;
    private static final String[] b;

    public static CompleteRevocationRefs createRevocationReferences(List<CertRevocationInfoFinder.CertRevocationInfo> aCertRevInfos, DigestAlg aDigestAlg) throws CMSSignatureException {
        boolean bl = AttributeValue.b;
        CrlOcspRef[] crlOcspRefArray = new CrlOcspRef[aCertRevInfos.size()];
        for (int i = 0; i < aCertRevInfos.size(); ++i) {
            CertRevocationInfoFinder.CertRevocationInfo certRevocationInfo = aCertRevInfos.get(i);
            ECRL[] eCRLArray = certRevocationInfo.getCRLs();
            EBasicOCSPResponse[] eBasicOCSPResponseArray = certRevocationInfo.getOCSPResponses();
            CRLListID cRLListID = null;
            OcspListID ocspListID = null;
            if (eCRLArray != null) {
                cRLListID = AttributeUtil.createCRLListID(eCRLArray, aDigestAlg);
            }
            if (eBasicOCSPResponseArray != null) {
                ocspListID = AttributeUtil.createOCSPListID(eBasicOCSPResponseArray, aDigestAlg);
            }
            crlOcspRefArray[i] = new CrlOcspRef(cRLListID, ocspListID, null);
            if (!bl) continue;
        }
        CompleteRevocationRefs completeRevocationRefs = new CompleteRevocationRefs(crlOcspRefArray);
        return completeRevocationRefs;
    }

    public static OcspListID createOCSPListID(EBasicOCSPResponse[] aOCSPResp, DigestAlg aDigestAlg) throws CMSSignatureException {
        boolean bl = AttributeValue.b;
        OcspResponsesID[] ocspResponsesIDArray = new OcspResponsesID[aOCSPResp.length];
        for (int i = 0; i < aOCSPResp.length; ++i) {
            ocspResponsesIDArray[i] = AttributeUtil.createOCSPResponsesID(aOCSPResp[i], aDigestAlg);
            if (!bl) continue;
        }
        return new OcspListID(new _SeqOfOcspResponsesID(ocspResponsesIDArray));
    }

    public static OcspResponsesID createOCSPResponsesID(EBasicOCSPResponse aOCSPResp, DigestAlg aDigestAlg) throws CMSSignatureException {
        OtherHash otherHash = AttributeUtil.createOtherHash(aOCSPResp.getEncoded(), aDigestAlg);
        OcspIdentifier ocspIdentifier = AttributeUtil.createOCSPIdentifier(aOCSPResp);
        return new OcspResponsesID(ocspIdentifier, otherHash);
    }

    public static OcspIdentifier createOCSPIdentifier(EBasicOCSPResponse aOCSPResp) {
        ResponderID responderID = ((ResponseData)aOCSPResp.getTbsResponseData().getObject()).responderID;
        Asn1GeneralizedTime asn1GeneralizedTime = ((ResponseData)aOCSPResp.getTbsResponseData().getObject()).producedAt;
        return new OcspIdentifier(responderID, asn1GeneralizedTime);
    }

    public static CRLListID createCRLListID(ECRL[] aCRLs, DigestAlg aDigestAlg) throws CMSSignatureException {
        boolean bl;
        block5: {
            bl = AttributeValue.b;
            if (aCRLs != null && aCRLs.length != 0) break block5;
            return null;
        }
        CrlValidatedID[] crlValidatedIDArray = new CrlValidatedID[aCRLs.length];
        for (int i = 0; i < aCRLs.length; ++i) {
            crlValidatedIDArray[i] = AttributeUtil.createCRLValidatedID(aCRLs[i], aDigestAlg);
            if (!bl) continue;
        }
        return new CRLListID(new _SeqOfCrlValidatedID(crlValidatedIDArray));
    }

    public static CrlValidatedID createCRLValidatedID(ECRL aCRL, DigestAlg aDigestAlg) throws CMSSignatureException {
        OtherHash otherHash = AttributeUtil.createOtherHash(aCRL.getEncoded(), aDigestAlg);
        CrlIdentifier crlIdentifier = AttributeUtil.createCRLIdentifier(aCRL);
        return new CrlValidatedID(otherHash, crlIdentifier);
    }

    public static CrlIdentifier createCRLIdentifier(ECRL aCRL) {
        Name name = ((CertificateList)aCRL.getObject()).tbsCertList.issuer;
        Asn1UTCTime asn1UTCTime = (Asn1UTCTime)((CertificateList)aCRL.getObject()).tbsCertList.thisUpdate.getElement();
        BigInteger bigInteger = aCRL.getCRLNumber();
        if (bigInteger != null) {
            return new CrlIdentifier(name, asn1UTCTime, new Asn1BigInteger(bigInteger));
        }
        return new CrlIdentifier(name, asn1UTCTime);
    }

    public static CompleteCertificateRefs createCertificateReferences(List<CertRevocationInfoFinder.CertRevocationInfo> aCertRevInfos, DigestAlg aDigestAlg) throws CMSSignatureException {
        boolean bl = AttributeValue.b;
        ArrayList<OtherCertID> arrayList = new ArrayList<OtherCertID>();
        for (int i = 1; i < aCertRevInfos.size(); ++i) {
            arrayList.add(AttributeUtil.createOtherCertID(aCertRevInfos.get(i).getCertificate(), aDigestAlg));
            if (!bl) continue;
        }
        return new CompleteCertificateRefs(arrayList.toArray(new OtherCertID[0]));
    }

    public static OtherHash createOtherHash(byte[] aData, DigestAlg aDigestAlg) throws CMSSignatureException {
        OtherHash otherHash;
        block3: {
            Object object;
            block2: {
                otherHash = new OtherHash();
                if (!aDigestAlg.equals((Object)DigestAlg.SHA1)) break block2;
                object = AttributeUtil.createOtherHashValue(aData, DigestAlg.SHA1);
                otherHash.set_sha1Hash(new Asn1OctetString(object));
                if (!AttributeValue.b) break block3;
            }
            object = AttributeUtil.createOtherHashAlgAndValue(aData, aDigestAlg);
            otherHash.set_otherHash((OtherHashAlgAndValue)object);
        }
        return otherHash;
    }

    public static byte[] createOtherHashValue(byte[] aData, DigestAlg aDigestAlg) throws CMSSignatureException {
        try {
            byte[] byArray = DigestUtil.digest((DigestAlg)aDigestAlg, (byte[])aData);
            return byArray;
        }
        catch (Exception exception) {
            throw new CMSSignatureException(b[1], exception);
        }
    }

    public static OtherHashAlgAndValue createOtherHashAlgAndValue(byte[] aData, DigestAlg aDigestAlg) throws CMSSignatureException {
        byte[] byArray = AttributeUtil.createOtherHashValue(aData, aDigestAlg);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aDigestAlg.getOID(), null);
        OtherHashAlgAndValue otherHashAlgAndValue = new OtherHashAlgAndValue(algorithmIdentifier, new Asn1OctetString(byArray));
        return otherHashAlgAndValue;
    }

    public static OtherCertID createOtherCertID(ECertificate aCer, DigestAlg aDigestAlg) throws CMSSignatureException {
        OtherHash otherHash = AttributeUtil.createOtherHash(aCer.getEncoded(), aDigestAlg);
        IssuerSerial issuerSerial = AttributeUtil.createIssuerSerial(aCer);
        return new OtherCertID(otherHash, issuerSerial);
    }

    public static IssuerSerial createIssuerSerial(ECertificate aCer) {
        GeneralName generalName = new GeneralName();
        generalName.set_directoryName(((Certificate)aCer.getObject()).tbsCertificate.issuer);
        GeneralNames generalNames = new GeneralNames(1);
        generalNames.elements[0] = generalName;
        IssuerSerial issuerSerial = new IssuerSerial(generalNames, ((Certificate)aCer.getObject()).tbsCertificate.serialNumber);
        return issuerSerial;
    }

    public static CertificateValues createCertificateValues(List<CertRevocationInfoFinder.CertRevocationInfo> aList) {
        boolean bl = AttributeValue.b;
        ArrayList<Asn1Type> arrayList = new ArrayList<Asn1Type>();
        for (int i = 1; i < aList.size(); ++i) {
            arrayList.add(aList.get(i).getCertificate().getObject());
            if (!bl) continue;
        }
        return new CertificateValues(arrayList.toArray(new Certificate[0]));
    }

    public static RevocationValues createRevocationValues(List<CertRevocationInfoFinder.CertRevocationInfo> aList) {
        CertRevocationInfoFinder.CertRevocationInfo certRevocationInfo;
        boolean bl = AttributeValue.b;
        ArrayList<Asn1Type> arrayList = new ArrayList<Asn1Type>();
        ArrayList<Asn1Type> arrayList2 = new ArrayList<Asn1Type>();
        for (int i = 0; i < aList.size(); ++i) {
            certRevocationInfo = aList.get(i);
            if (certRevocationInfo.getCRLs() != null) {
                for (ECRL eCRL : certRevocationInfo.getCRLs()) {
                    arrayList.add(eCRL.getObject());
                    if (!bl) continue;
                }
            }
            if (certRevocationInfo.getOCSPResponses() == null) continue;
            for (ECRL eCRL : certRevocationInfo.getOCSPResponses()) {
                arrayList2.add(eCRL.getObject());
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        _SeqOfCertificateList _SeqOfCertificateList2 = null;
        certRevocationInfo = null;
        ECRL[] eCRLArray = null;
        if (arrayList.size() > 0) {
            _SeqOfCertificateList2 = new _SeqOfCertificateList(arrayList.toArray(new CertificateList[0]));
        }
        if (arrayList2.size() > 0) {
            certRevocationInfo = new _SeqOfBasicOCSPResponse(arrayList2.toArray(new BasicOCSPResponse[0]));
        }
        return new RevocationValues(_SeqOfCertificateList2, (_SeqOfBasicOCSPResponse)certRevocationInfo, (OtherRevVals)eCRLArray);
    }

    public static List<ECRL> getCRLs(List<CertRevocationInfoFinder.CertRevocationInfo> aList) {
        boolean bl = AttributeValue.b;
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        for (int i = 0; i < aList.size(); ++i) {
            CertRevocationInfoFinder.CertRevocationInfo certRevocationInfo = aList.get(i);
            if (certRevocationInfo.getCRLs() == null) continue;
            for (ECRL eCRL : certRevocationInfo.getCRLs()) {
                arrayList.add(eCRL);
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    public static List<EOCSPResponse> getOCSPResponses(List<CertRevocationInfoFinder.CertRevocationInfo> aList) {
        boolean bl = AttributeValue.b;
        ArrayList<EOCSPResponse> arrayList = new ArrayList<EOCSPResponse>();
        for (int i = 0; i < aList.size(); ++i) {
            CertRevocationInfoFinder.CertRevocationInfo certRevocationInfo = aList.get(i);
            if (certRevocationInfo.getOCSPResponses() == null) continue;
            for (EBasicOCSPResponse eBasicOCSPResponse : certRevocationInfo.getOCSPResponses()) {
                arrayList.add(EOCSPResponse.getEOCSPResponse((EBasicOCSPResponse)eBasicOCSPResponse));
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    public static List<ECertificate> getCertificates(List<CertRevocationInfoFinder.CertRevocationInfo> aList) {
        boolean bl = AttributeValue.b;
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        for (int i = 1; i < aList.size(); ++i) {
            arrayList.add(aList.get(i).getCertificate());
            if (!bl) continue;
        }
        return arrayList;
    }

    public static Calendar getTimeFromTimestamp(EContentInfo aCI) throws CMSSignatureException {
        try {
            ESignedData eSignedData = new ESignedData(aCI.getContent());
            return AttributeUtil.getTimeFromTimestamp(eSignedData);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(b[7], exception);
        }
    }

    public static Calendar getTimeFromTimestamp(ESignedData aSD) throws CMSSignatureException {
        try {
            ETSTInfo eTSTInfo = new ETSTInfo(aSD.getEncapsulatedContentInfo().getContent());
            return eTSTInfo.getTime();
        }
        catch (Exception exception) {
            throw new CMSSignatureException(b[0], exception);
        }
    }

    public static String getAttributeMemberName(Asn1ObjectIdentifier objIden) {
        Field[] fieldArray;
        boolean bl = AttributeValue.b;
        for (Field field : fieldArray = AttributeOIDs.class.getFields()) {
            if (!field.getType().equals(Asn1ObjectIdentifier.class)) continue;
            Asn1ObjectIdentifier asn1ObjectIdentifier = null;
            try {
                asn1ObjectIdentifier = (Asn1ObjectIdentifier)field.get(asn1ObjectIdentifier);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                a.warn(b[4], (Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                a.warn(b[2], (Throwable)illegalAccessException);
            }
            if (asn1ObjectIdentifier == null) {
                a.error(b[3]);
                return null;
            }
            if (!asn1ObjectIdentifier.equals((Asn1Type)objIden)) continue;
            return field.getName();
        }
        return null;
    }

    public static Asn1ObjectIdentifier toContentType(EAttribute aAttribute) throws ESYAException {
        try {
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aAttribute.getValue(0));
            Asn1ObjectIdentifier asn1ObjectIdentifier = new Asn1ObjectIdentifier();
            asn1ObjectIdentifier.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            return asn1ObjectIdentifier;
        }
        catch (Asn1Exception asn1Exception) {
            throw new ESYAException(b[6], (Throwable)asn1Exception);
        }
        catch (IOException iOException) {
            throw new ESYAException(b[5], (Throwable)iOException);
        }
    }

    public static String getAttributeString(EAttribute attr) throws ESYAException {
        ECertificateValues eCertificateValues;
        boolean bl = AttributeValue.b;
        Asn1ObjectIdentifier asn1ObjectIdentifier = attr.getType();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : timeStampArray) {
            if (!object.equals((Asn1Type)asn1ObjectIdentifier)) continue;
            return SignatureTimeStampAttr.toTime(attr).getTime().toString();
        }
        if (asn1ObjectIdentifier.equals((Asn1Type)AttributeOIDs.id_signingTime)) {
            return SigningTimeAttr.toTime(attr).getTime().toString();
        }
        if (asn1ObjectIdentifier.equals((Asn1Type)AttributeOIDs.id_contentType)) {
            return ContentTypeAttr.toContentType(attr).toString();
        }
        if (asn1ObjectIdentifier.equals((Asn1Type)AttributeOIDs.id_aa_ets_certValues)) {
            eCertificateValues = new ECertificateValues(attr.getValue(0));
            List list = eCertificateValues.getCertificates();
            if (list != null) {
                for (Object object : list) {
                    stringBuilder.append(object.toString());
                    if (!bl) continue;
                }
            }
            return stringBuilder.toString();
        }
        if (asn1ObjectIdentifier.equals((Asn1Type)AttributeOIDs.id_aa_ets_revocationValues)) {
            List list;
            eCertificateValues = new ERevocationValues(attr.getValue(0));
            List list2 = eCertificateValues.getCRLs();
            if (list2 != null) {
                for (Object object : list2) {
                    stringBuilder.append(object.toString());
                    if (!bl) continue;
                }
            }
            if ((list = eCertificateValues.getBasicOCSPResponses()) != null) {
                for (EBasicOCSPResponse eBasicOCSPResponse : list) {
                    stringBuilder.append(eBasicOCSPResponse.toString());
                    if (!bl) continue;
                }
            }
            return stringBuilder.toString();
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "m\u0006{A\u0000\b\u001dg\u000e\u0000M\u0000{G\u0017^\u001dgIR\\\u001ddKRN\u0006fCR[\u001dn@\u0017L\u0010hZ\u0013";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 40;
                                break;
                            }
                            case 1: {
                                n8 = 116;
                                break;
                            }
                            case 2: {
                                n8 = 9;
                                break;
                            }
                            case 3: {
                                n8 = 46;
                                break;
                            }
                            default: {
                                n8 = 114;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "g\u0000aK\u0000`\u0015zFRL\u0011nK\u0000ATfB\u0007[\u0000|\\\u001fI\u001f)G\u0011A\u001a)A\bM\u0000)O\u001eA\u001a`\\\u0019M\u001a)F\u0013\\\u0015)A\u001e]\u0007}[\\";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u007f\u0015{@\u001bF\u0013)G\u001c\b5}Z\u0000A\u0016|Z\u0017}\u0000`B";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "N\u001dlB\u0016g\u0016cg\u0016M\u001a)G\u0001\b\u001a|B\u001e";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u007f\u0015{@\u001bF\u0013)G\u001c\b5}Z\u0000A\u0016|Z\u0017}\u0000`B";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "a;LV\u0011M\u0004}G\u001dF";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "i\u0007g\u001fRL\u0011jA\u0016MTl\\\u0000G\u0006";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "m\u0006{A\u0000\b\u001dg\u000e\u0000M\u0000{G\u0017^\u001dgIR\\\u001ddKRN\u0006fCRK\u001bgZ\u0017F\u0000`@\u0014G";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        b = stringArray3;
        a = LoggerFactory.getLogger(CertStoreUtil.class);
        timeStampArray = new Asn1ObjectIdentifier[]{AttributeOIDs.id_aa_ets_contentTimestamp, AttributeOIDs.id_aa_signatureTimeStampToken, AttributeOIDs.id_aa_ets_escTimeStamp, AttributeOIDs.id_aa_ets_certCRLTimestamp, AttributeOIDs.id_aa_ets_archiveTimestamp, AttributeOIDs.id_aa_ets_archiveTimestampV2, AttributeOIDs.id_aa_ets_archiveTimestampV3};
    }
}

