/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.self;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EKeyUsage;
import tr.gov.tubitak.uekae.esya.api.certificate.i18n.CertI18n;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.CertificateKeyUsageChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.self.CertificateSelfChecker;

public class EncryptionCertificateKeyUsageChecker
extends CertificateSelfChecker {
    private static Logger e;
    private static final String[] f;

    @Override
    protected PathValidationResult _check(CertificateStatusInfo aCertStatusInfo) {
        e.debug(f[4]);
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        if (eCertificate.isCACertificate()) {
            e.debug(f[2]);
            aCertStatusInfo.addDetail(this, CertificateKeyUsageChecker.KeyUsageCheckStatus.KEY_USAGE_CHECK_ENCRYPTION_OK, true);
            return PathValidationResult.SUCCESS;
        }
        if (eCertificate.isOCSPSigningCertificate()) {
            e.debug(f[3]);
            aCertStatusInfo.addDetail(this, CertificateKeyUsageChecker.KeyUsageCheckStatus.KEY_USAGE_CHECK_ENCRYPTION_OK, true);
            return PathValidationResult.SUCCESS;
        }
        if (eCertificate.isTimeStampingCertificate()) {
            e.debug(f[1]);
            aCertStatusInfo.addDetail(this, CertificateKeyUsageChecker.KeyUsageCheckStatus.KEY_USAGE_CHECK_ENCRYPTION_OK, true);
            return PathValidationResult.SUCCESS;
        }
        EKeyUsage eKeyUsage = eCertificate.getExtensions().getKeyUsage();
        if (eKeyUsage.isKeyEncipherment()) {
            e.debug(f[5]);
            aCertStatusInfo.addDetail(this, CertificateKeyUsageChecker.KeyUsageCheckStatus.KEY_USAGE_CHECK_ENCRYPTION_OK, true);
            return PathValidationResult.SUCCESS;
        }
        e.debug(f[6]);
        aCertStatusInfo.addDetail(this, CertificateKeyUsageChecker.KeyUsageCheckStatus.INVALID_KEY_USAGE, false);
        return PathValidationResult.KEYUSAGE_CONTROL_FAILURE;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message(f[0]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u000e\u001dN|3\u0011\u0011Ek)\u000e\u0011Zz?\u001b\u001dCo%\u0014\u000bCk/\u0002\u0001[o1\u0018\u000bCa8\t\u0006Gb#";
        int n2 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block18;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 93;
                                break;
                            }
                            case 1: {
                                n8 = 84;
                                break;
                            }
                            case 2: {
                                n8 = 8;
                                break;
                            }
                            case 3: {
                                n8 = 46;
                                break;
                            }
                            default: {
                                n8 = 118;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\t=eK%)5e^\u001f33(M\u0013/ aH\u001f>5|KX";
                    n2 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u001e\u0015(M\u0013/ aH\u001f>5|KX";
                    n2 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0012\u0017[~V\u000e=o@\u001f33(M\u0013/ aH\u001f>5|KX";
                    n2 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u000e1zZ\u001f;=cOV61q\u000e\u0003.5oKV<8i@\u0147}\u010baH\u000488mC\u0013}=\u0157B\u00130=(G\u00914:([\u000f:!f\u000e\u001b(tcA\u0018)&gB\u008a}-i^\u014715kO\u001d";
                    n2 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u000e1zZ\u001f;=cOV\u00161qk\u0018>=xF\u0013/9m@\u0002}\u00a2rK\u001a1=\u0117GV+5z";
                    n2 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u000e1zZ\u001f;=cOV\u00161qk\u0018>=xF\u0013/9m@\u0002}\u00a2rK\u001a1=\u0117GV$;c\u0002V55|O";
                    n2 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        f = stringArray3;
        e = LoggerFactory.getLogger(EncryptionCertificateKeyUsageChecker.class);
    }
}

