/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ValidationSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.b;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevocationCheckResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevokeCheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.FinderOCSPResponseSource;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.OCSPResponseFinderIteration;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;

public class RevocationFromOCSPChecker
extends RevocationChecker {
    private static final Logger e = LoggerFactory.getLogger(RevocationFromOCSPChecker.class);

    public static RevokeCheckStatus checkFromOCSP(ValidationSystem aParentSystem, CertificateStatusInfo aCertificateStatusInfo, EOCSPResponse ocspResp) throws ESYAException {
        block15: {
            ESingleResponse eSingleResponse;
            block16: {
                if (aCertificateStatusInfo == null) {
                    return RevokeCheckStatus.CANT_CHECK;
                }
                ECertificate eCertificate = aCertificateStatusInfo.getCertificate();
                OCSPResponseController oCSPResponseController = new OCSPResponseController();
                OCSPResponseStatusInfo oCSPResponseStatusInfo = oCSPResponseController.check(aParentSystem, ocspResp);
                aCertificateStatusInfo.addOCSPResponseInfo(oCSPResponseStatusInfo);
                if (ocspResp.getResponseStatus() != 0) {
                    return RevokeCheckStatus.CANT_CHECK;
                }
                if (ocspResp.getSingleResponseCount() == 0) {
                    return RevokeCheckStatus.CANT_CHECK;
                }
                eSingleResponse = ocspResp.getSingleResponse(0);
                if (oCSPResponseStatusInfo.getOCSPResponseStatus() != OCSPResponseStatusInfo.OCSPResponseStatus.VALID) break block15;
                if (eSingleResponse.getCertificateStatus() != 1) break block16;
                aCertificateStatusInfo.addRevocationCheckDetail(new RevocationCheckResult(CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU), RevocationFromOCSPCheckStatus.CERTIFICATE_VALID.getText(), (CheckStatus)RevocationFromOCSPCheckStatus.CERTIFICATE_VALID, RevokeCheckStatus.NOT_REVOKED));
                return RevokeCheckStatus.NOT_REVOKED;
            }
            if (eSingleResponse.getCertificateStatus() == 2) {
                Calendar calendar = eSingleResponse.getRevocationTime();
                Calendar calendar2 = aParentSystem.getBaseValidationTime();
                if (calendar2.after(calendar)) {
                    RevocationStatusInfo revocationStatusInfo = new RevocationStatusInfo();
                    revocationStatusInfo.setRevocationDate(eSingleResponse.getRevocationTime().getTime());
                    revocationStatusInfo.setRevocationCause(eSingleResponse.getRevokationReason());
                    aCertificateStatusInfo.setRevocationInfo(revocationStatusInfo);
                    aCertificateStatusInfo.addRevocationCheckDetail(new RevocationCheckResult(CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU), RevocationFromOCSPCheckStatus.CERTIFICATE_INVALID.getText(), (CheckStatus)RevocationFromOCSPCheckStatus.CERTIFICATE_INVALID, RevokeCheckStatus.REVOKED));
                    return RevokeCheckStatus.REVOKED;
                }
                aCertificateStatusInfo.addRevocationCheckDetail(new RevocationCheckResult(CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU), RevocationFromOCSPCheckStatus.CERTIFICATE_VALID.getText(), (CheckStatus)RevocationFromOCSPCheckStatus.CERTIFICATE_VALID, RevokeCheckStatus.NOT_REVOKED));
                return RevokeCheckStatus.NOT_REVOKED;
            }
            return RevokeCheckStatus.CANT_CHECK;
        }
        return RevokeCheckStatus.CANT_CHECK;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected RevokeCheckStatus _check(ECertificate aIssuerCertificate, CertificateStatusInfo aCertificateStatusInfo) throws ESYAException {
        var7_3 = RevocationChecker.d;
        if (this.mParentSystem == null) {
            return RevokeCheckStatus.CANT_CHECK;
        }
        var3_4 = aCertificateStatusInfo.getCertificate();
        var4_5 = new OCSPResponseFinderIteration(var3_4, aIssuerCertificate, this.mParentSystem);
        var4_5.addItemSource(new FinderOCSPResponseSource(var3_4, aIssuerCertificate, this.mFinders));
        while (var4_5.nextIteration(this.mParentSystem)) {
            var6_7 = (EOCSPResponse)var4_5.getCurrentItem();
            var5_6 = RevocationFromOCSPChecker.checkFromOCSP(this.mParentSystem, aCertificateStatusInfo, var6_7);
            switch (b.b[var5_6.ordinal()]) {
                case 1: {
                    return RevokeCheckStatus.REVOKED;
                }
                case 2: {
                    return RevokeCheckStatus.NOT_REVOKED;
                }
                case 3: {
                    if (!var7_3) ** break;
                    break;
                }
            }
            if (!var7_3) continue;
        }
        aCertificateStatusInfo.addRevocationCheckDetail(this, RevocationFromOCSPCheckStatus.OCSP_RESPONSE_NOT_FOUND, RevokeCheckStatus.CANT_CHECK);
        return RevokeCheckStatus.CANT_CHECK;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU);
    }

    public static final class RevocationFromOCSPCheckStatus
    extends Enum<RevocationFromOCSPCheckStatus>
    implements CheckStatus {
        public static final /* enum */ RevocationFromOCSPCheckStatus INVALID_OCSP_RESPONSE;
        public static final /* enum */ RevocationFromOCSPCheckStatus OCSP_RESPONSE_NOT_FOUND;
        public static final /* enum */ RevocationFromOCSPCheckStatus ISSUER_CERTIFICATE_NOT_FOUND;
        public static final /* enum */ RevocationFromOCSPCheckStatus CERTIFICATE_VALID;
        public static final /* enum */ RevocationFromOCSPCheckStatus CERTIFICATE_INVALID;
        private static final /* synthetic */ RevocationFromOCSPCheckStatus[] a;
        private static final String[] b;

        public static RevocationFromOCSPCheckStatus[] values() {
            return (RevocationFromOCSPCheckStatus[])a.clone();
        }

        public static RevocationFromOCSPCheckStatus valueOf(String name) {
            return Enum.valueOf(RevocationFromOCSPCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case INVALID_OCSP_RESPONSE: {
                    return CertI18n.message((String)CertI18n.OCSP_CEVABI_GECERSIZ);
                }
                case OCSP_RESPONSE_NOT_FOUND: {
                    return CertI18n.message((String)CertI18n.OCSP_CEVABI_BULUNAMADI);
                }
                case ISSUER_CERTIFICATE_NOT_FOUND: {
                    return CertI18n.message((String)CertI18n.SM_SERTIFIKASI_BULUNAMADI);
                }
                case CERTIFICATE_VALID: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_OCSPDE_GECERLI);
                }
                case CERTIFICATE_INVALID: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_OCSPDE_GECERLI_DEGIL);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[5];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = ">\u001e\"(=>\u0014+&2$\u0000+;4$\u0000;'\"2";
            int n2 = -1;
            block12: while (true) {
                char[] cArray;
                block17: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block16: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block16;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block17;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 119;
                                    break;
                                }
                                case 1: {
                                    n8 = 80;
                                    break;
                                }
                                case 2: {
                                    n8 = 116;
                                    break;
                                }
                                case 3: {
                                    n8 = 105;
                                    break;
                                }
                                default: {
                                    n8 = 113;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = ">\u0003'<4%\u000f7,##\u00192 26\u000416?8\u0004+/>\"\u001e0";
                        n2 = 0;
                        continue block12;
                    }
                    case 0: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 2;
                        string2 = "8\u0013'9.%\u0015'9>9\u000316?8\u0004+/>\"\u001e0";
                        n2 = 1;
                        continue block12;
                    }
                    case 1: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 3;
                        string2 = "4\u0015&=81\u00197(%2\u000f=''6\u001c=-";
                        n2 = 2;
                        continue block12;
                    }
                    case 2: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 4;
                        string2 = "4\u0015&=81\u00197(%2\u000f\"(=>\u0014";
                        n2 = 3;
                        continue block12;
                    }
                    case 3: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            b = stringArray3;
            INVALID_OCSP_RESPONSE = new RevocationFromOCSPCheckStatus();
            OCSP_RESPONSE_NOT_FOUND = new RevocationFromOCSPCheckStatus();
            ISSUER_CERTIFICATE_NOT_FOUND = new RevocationFromOCSPCheckStatus();
            CERTIFICATE_VALID = new RevocationFromOCSPCheckStatus();
            CERTIFICATE_INVALID = new RevocationFromOCSPCheckStatus();
            a = new RevocationFromOCSPCheckStatus[]{INVALID_OCSP_RESPONSE, OCSP_RESPONSE_NOT_FOUND, ISSUER_CERTIFICATE_NOT_FOUND, CERTIFICATE_VALID, CERTIFICATE_INVALID};
        }
    }
}

