/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer;

import com.objsys.asn1j.runtime.Asn1OpenType;
import java.security.PublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CheckResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerChecker;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;

public class CertificateSignatureChecker
extends IssuerChecker {
    private static Logger e;
    private static final String[] f;

    @Override
    protected PathValidationResult _check(IssuerCheckParameters aConstraint, ECertificate aIssuerCertificate, ECertificate aCertificate, CertificateStatusInfo aCertStatusInfo) {
        int n = IssuerChecker.d;
        String string = aCertificate.getSubject().stringValue();
        e.debug(f[0] + string);
        PathValidationResult pathValidationResult = CertificateSignatureChecker.checkSignature(aIssuerCertificate, aCertificate, aConstraint, aCertStatusInfo);
        if (n != 0) {
            int n2 = Checker.c;
            Checker.c = ++n2;
        }
        return pathValidationResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PathValidationResult checkSignature(ECertificate aIssuerCertificate, ECertificate aCertificate, IssuerCheckParameters aConstraint, CertificateStatusInfo aCertStatusInfo) {
        boolean bl;
        PublicKey publicKey;
        Asn1OpenType asn1OpenType;
        byte[] byArray = aCertificate.getSignatureValue();
        if (byArray.length == 0) {
            e.error(f[5]);
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.CERTIFICATE_NOT_SIGNED.getText(), CertificateSignatureCheckStatus.CERTIFICATE_NOT_SIGNED, false));
            return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
        }
        byte[] byArray2 = aCertificate.getTBSEncodedBytes();
        ESubjectPublicKeyInfo eSubjectPublicKeyInfo = aIssuerCertificate.getSubjectPublicKeyInfo();
        EAlgorithmIdentifier eAlgorithmIdentifier = eSubjectPublicKeyInfo.getAlgorithm();
        try {
            byte[] byArray3;
            block19: {
                block20: {
                    byte[] byArray4;
                    if (!Arrays.equals(eAlgorithmIdentifier.getAlgorithm().value, AsymmetricAlg.DSA.getOID())) break block19;
                    asn1OpenType = eAlgorithmIdentifier.getParameters();
                    byte[] byArray5 = byArray4 = asn1OpenType != null ? asn1OpenType.value : null;
                    if (byArray4 != null && asn1OpenType.getLength() > 0 && !Arrays.equals(byArray4, EAlgorithmIdentifier.ASN_NULL)) break block20;
                    Asn1OpenType asn1OpenType2 = aConstraint.getPreviousDSAParams();
                    if (asn1OpenType2 == null || asn1OpenType2.value.length <= 0 || Arrays.equals(asn1OpenType2.value, EAlgorithmIdentifier.ASN_NULL)) {
                        e.error(f[1]);
                        aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION.getText(), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, false));
                        return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
                    }
                    eSubjectPublicKeyInfo.getAlgorithm().setParameters(aConstraint.getPreviousDSAParams());
                    if (IssuerChecker.d == 0) break block19;
                }
                aConstraint.setPreviousDSAParams(eAlgorithmIdentifier.getParameters());
            }
            if ((byArray3 = eSubjectPublicKeyInfo.getEncoded()).length == 0) {
                e.error(f[3]);
                aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.NO_PUBLIC_KEY_IN_CERTIFICATE.getText(), CertificateSignatureCheckStatus.NO_PUBLIC_KEY_IN_CERTIFICATE, false));
                return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
            }
            asn1OpenType = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eSubjectPublicKeyInfo.getAlgorithm());
            AsymmetricAlg asymmetricAlg = ((SignatureAlg)asn1OpenType.first()).getAsymmetricAlg();
            publicKey = KeyUtil.decodePublicKey((AsymmetricAlg)asymmetricAlg, (byte[])byArray3);
        }
        catch (Exception exception) {
            e.error(f[7], (Throwable)exception);
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.INVALID_PUBLIC_KEY_IN_CERTIFICATE.getText(), CertificateSignatureCheckStatus.INVALID_PUBLIC_KEY_IN_CERTIFICATE, false));
            return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
        }
        try {
            asn1OpenType = aCertificate.getSignatureAlgorithm();
            Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)asn1OpenType);
            bl = SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray2, (byte[])byArray, (PublicKey)publicKey);
        }
        catch (Exception exception) {
            e.error(f[6], (Throwable)exception);
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION.getText(), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, false));
            return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
        }
        if (bl) {
            e.debug(f[4]);
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.SIGNATURE_VERIFIED.getText(), CertificateSignatureCheckStatus.SIGNATURE_VERIFIED, true));
            return PathValidationResult.SUCCESS;
        }
        e.error(f[2]);
        aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.SIGNATURE_NOT_VERIFIED.getText(), CertificateSignatureCheckStatus.SIGNATURE_NOT_VERIFIED, false));
        return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "h<T\u00003]0M\u00154\u010a7\u0006\u001d7A8U\u0145zP6H\u0000(T5\u0006\u0011>R5C\u0017?PyU\u00018Q<E\u0000`\u001b";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 59;
                                break;
                            }
                            case 1: {
                                n8 = 89;
                                break;
                            }
                            case 2: {
                                n8 = 38;
                                break;
                            }
                            case 3: {
                                n8 = 116;
                                break;
                            }
                            default: {
                                n8 = 90;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u007f\ngT\nZ+G\u0019?O+C\u0018?I0\u0006\u0016/W,H\u00157Z=\u0117";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "h<T\u00003]0M\u0015zR4\\\u0015z_6\u0139\u0006/W8H\u00157Z=\u0117Z";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "h<T\u00003]0M\u0015zK,D\u00183XyM\u0011#\u001b8J\u00154\u010ayH\u00016Ww";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "h<T\u00003]0M\u0015zR4\\\u0015z_6\u0139\u0006/W8H\u0010\u016b\u0015";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "h<T\u00003]0M\u0015zR4\\\u0015z_<\u0139\u0011(RyH\u00016W";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "h<T\u00003]0M\u0015zR4\\\u0015)\u010ayB\u001b\u0145I,J\u00154\u010a+M\u00114\u001b1G\u0000;\u001b6J\u0001\u0105O,\b";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "h<T\u00003]0M\u0015zK,D\u00183XyM\u0011#\u001b=C\u016b?I0\u0006\u00156\u010a7\u0117\u00061^7\u0006\u001c;O8\u0006\u001b6N\u0106R\u0001t";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        f = stringArray3;
        e = LoggerFactory.getLogger(CertificateSignatureChecker.class);
    }

    public static final class CertificateSignatureCheckStatus
    extends Enum<CertificateSignatureCheckStatus>
    implements CheckStatus {
        public static final /* enum */ CertificateSignatureCheckStatus CERTIFICATE_NOT_SIGNED;
        public static final /* enum */ CertificateSignatureCheckStatus CERTIFICATE_INVALID_STRUCTURE;
        public static final /* enum */ CertificateSignatureCheckStatus NO_PUBLIC_KEY_IN_CERTIFICATE;
        public static final /* enum */ CertificateSignatureCheckStatus INVALID_PUBLIC_KEY_IN_CERTIFICATE;
        public static final /* enum */ CertificateSignatureCheckStatus KRIPTO_ERROR_ON_VERIFICATION;
        public static final /* enum */ CertificateSignatureCheckStatus SIGNATURE_NOT_VERIFIED;
        public static final /* enum */ CertificateSignatureCheckStatus SIGNATURE_VERIFIED;
        private static final /* synthetic */ CertificateSignatureCheckStatus[] a;
        private static final String[] b;

        public static CertificateSignatureCheckStatus[] values() {
            return (CertificateSignatureCheckStatus[])a.clone();
        }

        public static CertificateSignatureCheckStatus valueOf(String name) {
            return Enum.valueOf(CertificateSignatureCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case CERTIFICATE_NOT_SIGNED: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_IMZALI_DEGIL);
                }
                case CERTIFICATE_INVALID_STRUCTURE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_YAPISI_BOZUK);
                }
                case NO_PUBLIC_KEY_IN_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKADA_ACIK_ANAHTAR_YOK);
                }
                case INVALID_PUBLIC_KEY_IN_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKADA_ACIK_ANAHTAR_BOZUK);
                }
                case KRIPTO_ERROR_ON_VERIFICATION: {
                    return CertI18n.message((String)CertI18n.DOGRULAMA_KRIPTO_HATASI);
                }
                case SIGNATURE_NOT_VERIFIED: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_DOGRULANAMADI);
                }
                case SIGNATURE_VERIFIED: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_DOGRULANDI);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[7];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "cx\u001631gu\u001a17gx\u0000,+w|\u001a1,nc\u001c\"1ae\u0011";
            int n2 = -1;
            block14: while (true) {
                char[] cArray;
                block19: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block18: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block18;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block19;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 40;
                                    break;
                                }
                                case 1: {
                                    n8 = 42;
                                    break;
                                }
                                case 2: {
                                    n8 = 95;
                                    break;
                                }
                                case 3: {
                                    n8 = 99;
                                    break;
                                }
                                default: {
                                    n8 = 101;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "ko\r7,nc\u001c\"1mu\u0011,1wy\u0016$+mn";
                        n2 = 0;
                        continue block14;
                    }
                    case 0: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 2;
                        string2 = "ad\t\")an\u000030jf\u0016 :co\u0006<,fu\u001c&7|c\u0019*&i~\u001a";
                        n2 = 1;
                        continue block14;
                    }
                    case 1: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 3;
                        string2 = "{c\u0018-$|\u007f\r&:fe\u000b<3mx\u0016%,mn";
                        n2 = 2;
                        continue block14;
                    }
                    case 2: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 4;
                        string2 = "fe\u000030jf\u0016 :co\u0006<,fu\u001c&7|c\u0019*&i~\u001a";
                        n2 = 3;
                        continue block14;
                    }
                    case 3: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 5;
                        string2 = "{c\u0018-$|\u007f\r&:~o\r*#ao\u001b";
                        n2 = 4;
                        continue block14;
                    }
                    case 4: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 6;
                        string2 = "ko\r7,nc\u001c\"1mu\u0016-3if\u0016':{~\r6&|\u007f\r&";
                        n2 = 5;
                        continue block14;
                    }
                    case 5: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            b = stringArray3;
            CERTIFICATE_NOT_SIGNED = new CertificateSignatureCheckStatus();
            CERTIFICATE_INVALID_STRUCTURE = new CertificateSignatureCheckStatus();
            NO_PUBLIC_KEY_IN_CERTIFICATE = new CertificateSignatureCheckStatus();
            INVALID_PUBLIC_KEY_IN_CERTIFICATE = new CertificateSignatureCheckStatus();
            KRIPTO_ERROR_ON_VERIFICATION = new CertificateSignatureCheckStatus();
            SIGNATURE_NOT_VERIFIED = new CertificateSignatureCheckStatus();
            SIGNATURE_VERIFIED = new CertificateSignatureCheckStatus();
            a = new CertificateSignatureCheckStatus[]{CERTIFICATE_NOT_SIGNED, CERTIFICATE_INVALID_STRUCTURE, NO_PUBLIC_KEY_IN_CERTIFICATE, INVALID_PUBLIC_KEY_IN_CERTIFICATE, KRIPTO_ERROR_ON_VERIFICATION, SIGNATURE_NOT_VERIFIED, SIGNATURE_VERIFIED};
        }
    }
}

