/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.StatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.self.CertificateSelfChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevokeCheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.issuer.CRLIssuerChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.self.CRLSelfChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.deltacrl.DeltaCRLChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;

public class CheckSystem
implements Cloneable {
    private static final Logger a;
    private IssuerCheckParameters b = new IssuerCheckParameters();
    private List<CertificateSelfChecker> c = new ArrayList<CertificateSelfChecker>();
    private List<CertificateSelfChecker> d = new ArrayList<CertificateSelfChecker>();
    private List<IssuerChecker> e = new ArrayList<IssuerChecker>();
    private List<RevocationChecker> f = new ArrayList<RevocationChecker>();
    private List<CRLSelfChecker> g = new ArrayList<CRLSelfChecker>();
    private List<CRLIssuerChecker> h = new ArrayList<CRLIssuerChecker>();
    private List<OCSPResponseChecker> i = new ArrayList<OCSPResponseChecker>();
    private List<DeltaCRLChecker> j = new ArrayList<DeltaCRLChecker>();
    private boolean k;
    private static final String[] l;

    public IssuerCheckParameters getConstraintCheckParam() {
        return this.b;
    }

    public void setConstraintCheckParam(IssuerCheckParameters aConstraintCheckParam) {
        this.b = aConstraintCheckParam;
    }

    public List<CertificateSelfChecker> getTrustedCertificateCheckers() {
        return this.c;
    }

    public void setTrustedCertificateCheckers(List<CertificateSelfChecker> aGSKontrolcu) {
        this.c = aGSKontrolcu;
    }

    public void addTrustedCertificateChecker(CertificateSelfChecker aGSKontrolcu) {
        this.c.add(aGSKontrolcu);
    }

    public List<CertificateSelfChecker> getCertificateSelfCheckers() {
        return this.d;
    }

    public void setCertificateSelfCheckers(List<CertificateSelfChecker> aTSKontrolcu) {
        this.d = aTSKontrolcu;
    }

    public void addCertificateSelfChecker(CertificateSelfChecker aTSKontrolcu) {
        this.d.add(aTSKontrolcu);
    }

    public List<IssuerChecker> getIssuerCheckers() {
        return this.e;
    }

    public void setIssuerCheckers(List<IssuerChecker> aUstSMKontrolcu) {
        this.e = aUstSMKontrolcu;
    }

    public void addIssuerChecker(IssuerChecker aUstSMKontrolcu) {
        this.e.add(aUstSMKontrolcu);
    }

    public List<RevocationChecker> getRevocationCheckers() {
        return this.f;
    }

    public void setRevocationCheckers(List<RevocationChecker> aIptalKontrolcu) {
        this.f = aIptalKontrolcu;
    }

    public void addRevocationChecker(RevocationChecker aIptalKontrolcu) {
        this.f.add(aIptalKontrolcu);
    }

    public List<CRLSelfChecker> getCRLSelfCheckers() {
        return this.g;
    }

    public void setCRLSelfCheckers(List<CRLSelfChecker> aCRLSelfChecker) {
        this.g = aCRLSelfChecker;
    }

    public void addCRLSelfChecker(CRLSelfChecker aCRLSelfChecker) {
        this.g.add(aCRLSelfChecker);
    }

    public List<CRLIssuerChecker> getCRLIssuerCheckers() {
        return this.h;
    }

    public void setCRLIssuerCheckers(List<CRLIssuerChecker> aSilSMKontrolcu) {
        this.h = aSilSMKontrolcu;
    }

    public void addCRLIssuerChecker(CRLIssuerChecker aSilSMKontrolcu) {
        this.h.add(aSilSMKontrolcu);
    }

    public List<OCSPResponseChecker> getOCSPResponseCheckers() {
        return this.i;
    }

    public void setOCSPResponseCheckers(List<OCSPResponseChecker> aOCSPCevabiKontrolcu) {
        this.i = aOCSPCevabiKontrolcu;
    }

    public void addOCSPResponseChecker(OCSPResponseChecker aOCSPCevabiKontrolcu) {
        this.i.add(aOCSPCevabiKontrolcu);
    }

    public List<DeltaCRLChecker> getDeltaCRLCheckers() {
        return this.j;
    }

    public void setDeltaCRLCheckers(List<DeltaCRLChecker> aDeltaSilKontrolcu) {
        this.j = aDeltaSilKontrolcu;
    }

    public void addDeltaCRLChecker(DeltaCRLChecker aDeltaSilKontrolcu) {
        this.j.add(aDeltaSilKontrolcu);
    }

    public boolean isAllChecksRequired() {
        return this.k;
    }

    public void setAllChecksRequired(boolean aTKY) {
        this.k = aTKY;
    }

    public PathValidationResult guvenilirSertifikaKontrolleriYap(CertificateStatusInfo aCertStatusInfo) {
        boolean bl = StatusInfo.c;
        PathValidationResult pathValidationResult = PathValidationResult.SUCCESS;
        for (CertificateSelfChecker certificateSelfChecker : this.c) {
            block3: {
                PathValidationResult pathValidationResult2;
                block4: {
                    pathValidationResult2 = certificateSelfChecker.check(aCertStatusInfo);
                    if (pathValidationResult2 == PathValidationResult.SUCCESS || !certificateSelfChecker.isCritical()) break block3;
                    if (!this.k) break block4;
                    pathValidationResult = pathValidationResult2;
                    if (!bl) break block3;
                }
                return pathValidationResult2;
            }
            if (!bl) continue;
        }
        return pathValidationResult;
    }

    public PathValidationResult checkCertificateSelf(CertificateStatusInfo aCertStatusInfo) {
        boolean bl = StatusInfo.c;
        PathValidationResult pathValidationResult = PathValidationResult.SUCCESS;
        for (CertificateSelfChecker certificateSelfChecker : this.d) {
            block3: {
                PathValidationResult pathValidationResult2;
                block4: {
                    pathValidationResult2 = certificateSelfChecker.check(aCertStatusInfo);
                    if (pathValidationResult2 == PathValidationResult.SUCCESS || !certificateSelfChecker.isCritical()) break block3;
                    a.error(certificateSelfChecker.getClass().getName() + l[2]);
                    if (!this.k) break block4;
                    pathValidationResult = pathValidationResult2;
                    if (!bl) break block3;
                }
                return pathValidationResult2;
            }
            if (!bl) continue;
        }
        return pathValidationResult;
    }

    public PathValidationResult checkIssuer(IssuerCheckParameters aIssuerCheckParams, ECertificate aIssuerCertificate, ECertificate aCertificate, CertificateStatusInfo aCertStatusInfo) {
        boolean bl = StatusInfo.c;
        PathValidationResult pathValidationResult = PathValidationResult.SUCCESS;
        for (IssuerChecker issuerChecker : this.e) {
            block3: {
                PathValidationResult pathValidationResult2;
                block4: {
                    pathValidationResult2 = issuerChecker.check(aIssuerCheckParams, aIssuerCertificate, aCertificate, aCertStatusInfo);
                    if (pathValidationResult2 == PathValidationResult.SUCCESS || !issuerChecker.isCritical()) break block3;
                    if (!this.k) break block4;
                    pathValidationResult = pathValidationResult2;
                    if (!bl) break block3;
                }
                return pathValidationResult2;
            }
            if (!bl) continue;
        }
        return pathValidationResult;
    }

    public PathValidationResult checkCRLSelf(ECRL aCRL, CRLStatusInfo aCRLStatusInfo) {
        boolean bl = StatusInfo.c;
        PathValidationResult pathValidationResult = PathValidationResult.SUCCESS;
        for (CRLSelfChecker cRLSelfChecker : this.g) {
            block3: {
                PathValidationResult pathValidationResult2;
                block4: {
                    pathValidationResult2 = cRLSelfChecker.check(aCRL, aCRLStatusInfo);
                    if (pathValidationResult2 == PathValidationResult.SUCCESS || !cRLSelfChecker.isCritical()) break block3;
                    a.error(cRLSelfChecker.getClass().getName() + l[1]);
                    if (!this.k) break block4;
                    pathValidationResult = pathValidationResult2;
                    if (!bl) break block3;
                }
                return pathValidationResult2;
            }
            if (!bl) continue;
        }
        return pathValidationResult;
    }

    public PathValidationResult checkCRLIssuer(IssuerCheckParameters aIssuerCheckParams, ECRL aCRL, ECertificate aIssuerCertificate, CRLStatusInfo aCRLStatusInfo) {
        boolean bl = StatusInfo.c;
        PathValidationResult pathValidationResult = PathValidationResult.SUCCESS;
        for (CRLIssuerChecker cRLIssuerChecker : this.h) {
            block3: {
                PathValidationResult pathValidationResult2;
                block4: {
                    pathValidationResult2 = cRLIssuerChecker.check(aIssuerCheckParams, aCRL, aIssuerCertificate, aCRLStatusInfo);
                    if (pathValidationResult2 == PathValidationResult.SUCCESS || !cRLIssuerChecker.isCritical()) break block3;
                    if (!this.k) break block4;
                    pathValidationResult = pathValidationResult2;
                    if (!bl) break block3;
                }
                return pathValidationResult2;
            }
            if (!bl) continue;
        }
        return pathValidationResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PathValidationResult checkRevocation(ECertificate aIssuerCertificate, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        boolean bl = StatusInfo.c;
        RevokeCheckStatus revokeCheckStatus = RevokeCheckStatus.NOT_REVOKED;
        boolean bl2 = false;
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        if (a.isDebugEnabled()) {
            a.debug(l[6] + eCertificate.getSubject().stringValue());
        }
        if (eCertificate.isOCSPSigningCertificate() && eCertificate.getExtensions().getExtension(EExtensions.oid_pkix_ocsp_nocheck) != null) {
            a.debug(l[9]);
            return PathValidationResult.SUCCESS;
        }
        for (RevocationChecker revocationChecker : this.f) {
            a.debug(l[8] + revocationChecker);
            revokeCheckStatus = revocationChecker.check(aIssuerCertificate, aCertStatusInfo);
            switch (revokeCheckStatus) {
                case CANT_CHECK: {
                    a.debug(l[3]);
                    if (!bl) break;
                }
                case REVOKED: {
                    a.error(l[10]);
                    return PathValidationResult.CERTIFICATE_REVOKED;
                }
                case NOT_REVOKED: {
                    a.debug(l[4]);
                    bl2 = true;
                    if (revocationChecker.isContinue()) break;
                    return PathValidationResult.SUCCESS;
                }
            }
            if (!bl) continue;
        }
        if (revokeCheckStatus != RevokeCheckStatus.NOT_REVOKED && !bl2) {
            a.error(l[7] + eCertificate.getSubject().stringValue());
            return PathValidationResult.REVOCATION_CONTROL_FAILURE;
        }
        if (a.isDebugEnabled()) {
            a.debug(l[5] + eCertificate.getSubject().stringValue());
        }
        return PathValidationResult.SUCCESS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PathValidationResult checkOCSPResponse(OCSPResponseStatusInfo aOCSPResponseStatusInfo, EOCSPResponse aOCSPResponse) throws ESYAException {
        boolean bl = StatusInfo.c;
        PathValidationResult pathValidationResult = PathValidationResult.SUCCESS;
        for (OCSPResponseChecker oCSPResponseChecker : this.i) {
            block8: {
                PathValidationResult pathValidationResult2 = oCSPResponseChecker.check(aOCSPResponseStatusInfo, aOCSPResponse);
                if (pathValidationResult2 == PathValidationResult.SUCCESS || !oCSPResponseChecker.isCritical()) break block8;
                a.error(oCSPResponseChecker.getClass().getName() + l[0]);
                if (!this.k) return pathValidationResult2;
                pathValidationResult = pathValidationResult2;
                if (bl) {
                    return pathValidationResult2;
                }
            }
            if (!bl) continue;
        }
        return pathValidationResult;
    }

    public PathValidationResult checkDeltaCRL(ECRL aCRL, CRLStatusInfo aCRLStatusInfo) {
        boolean bl = StatusInfo.c;
        PathValidationResult pathValidationResult = PathValidationResult.SUCCESS;
        for (CRLSelfChecker cRLSelfChecker : this.j) {
            block3: {
                PathValidationResult pathValidationResult2;
                block4: {
                    pathValidationResult2 = cRLSelfChecker.check(aCRL, aCRLStatusInfo);
                    if (pathValidationResult2 == PathValidationResult.SUCCESS || !cRLSelfChecker.isCritical()) break block3;
                    if (!this.k) break block4;
                    pathValidationResult = pathValidationResult2;
                    if (!bl) break block3;
                }
                return pathValidationResult2;
            }
            if (!bl) continue;
        }
        return pathValidationResult;
    }

    protected Object clone() throws CloneNotSupportedException {
        boolean bl = StatusInfo.c;
        CheckSystem checkSystem = (CheckSystem)super.clone();
        ArrayList<RevocationChecker> arrayList = new ArrayList<RevocationChecker>();
        for (RevocationChecker revocationChecker : this.f) {
            arrayList.add((RevocationChecker)revocationChecker.clone());
            if (!bl) continue;
        }
        checkSystem.setRevocationCheckers(arrayList);
        return checkSystem;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "s\u0016\u0002'\u001a6\u0014";
        int n2 = -1;
        block18: while (true) {
            char[] cArray;
            block23: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block22: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block22;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block23;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 83;
                                break;
                            }
                            case 1: {
                                n8 = 112;
                                break;
                            }
                            case 2: {
                                n8 = 99;
                                break;
                            }
                            case 3: {
                                n8 = 78;
                                break;
                            }
                            default: {
                                n8 = 118;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "s\u0016\u0002'\u001a6\u0014";
                    n2 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "s\u0016\u0002'\u001a6\u0014";
                    n2 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0010\u0011\r:V0\u0018\u0006-\u001dr";
                    n2 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u001d\u001f\u0017n\u00046\u0006\f%\u00137Q";
                    n2 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u001d\u001f\u0017n\u00046\u0006\f%\u00137PYn";
                    n2 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "~]C\r\u001e6\u0013\bn\u00046\u0006\f-\u0017'\u0019\f V5\u001f\u0011tVY";
                    n2 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0010\u0015\u0011:\u001f5\u0019\u0000/\u00026P\u0011+\u0000<\u0013\u0002:\u001f<\u001eC'\u00185\u001fC-\u0017=\u001e\f:V1\u0015C-\u001e6\u0013\b+\u0012s\u0016\f<VsJ";
                    n2 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0010\u0018\u0006-\u001d6\u0002Yn";
                    n2 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u0010\u0015\u0011:\u001f5\u0019\u0000/\u00026P\u000b/\u0005s\u001f\n*)#\u001b\n6)<\u0013\u0010>)=\u001f\u0000&\u00130\u001bC+\u000e'\u0015\r=\u001f<\u001eM";
                    n2 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u0000\u0015\u0011:\u001f5\u0019\b/V:\u0000\u0017/\u001as\u001b\f \u0002!\u001f\u000fn\u001e2\u0004\u0002=\u0147}";
                    n2 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        l = stringArray3;
        a = LoggerFactory.getLogger(CheckSystem.class);
    }
}

