/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.util;

import java.lang.reflect.Constructor;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import sun.security.x509.X509Key;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.crypto.Crypto;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.WrapAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.KeySpec;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithLength;

public class KeyUtil {
    private static Map<Algorithm, Integer> a;
    private static Map<CipherAlg, WrapAlg> b;
    public static int c;
    private static final String[] d;

    public static PublicKey decodePublicKey(AsymmetricAlg aAsymmetricAlg, byte[] aBytes) throws CryptoException {
        return Crypto.getKeyFactory().decodePublicKey(aAsymmetricAlg, aBytes);
    }

    public static PublicKey decodePublicKey(ESubjectPublicKeyInfo aSubjectPublicKeyInfo) throws CryptoException {
        AsymmetricAlg asymmetricAlg = AsymmetricAlg.fromOID(aSubjectPublicKeyInfo.getAlgorithm().getAlgorithm().value);
        return KeyUtil.decodePublicKey(asymmetricAlg, aSubjectPublicKeyInfo.getEncoded());
    }

    public static PrivateKey decodePrivateKey(AsymmetricAlg aAsymmetricAlg, byte[] aBytes) throws CryptoException {
        return Crypto.getKeyFactory().decodePrivateKey(aAsymmetricAlg, aBytes);
    }

    public static int getKeyLength(PublicKey aKey) throws CryptoException {
        if (aKey instanceof RSAKey) {
            return ((RSAKey)((Object)aKey)).getModulus().bitLength();
        }
        if (aKey instanceof DSAKey) {
            return ((DSAKey)((Object)aKey)).getParams().getG().bitLength();
        }
        if (aKey instanceof ECKey) {
            return ((ECKey)((Object)aKey)).getParams().getCurve().getField().getFieldSize();
        }
        if (aKey instanceof X509Key) {
            ECPublicKey eCPublicKey = null;
            try {
                eCPublicKey = (ECPublicKey)aKey;
                return eCPublicKey.getParams().getCurve().getField().getFieldSize();
            }
            catch (ClassCastException classCastException) {
                try {
                    Class<?> clazz = Class.forName(d[1]);
                    Constructor<?> constructor = clazz.getConstructor(byte[].class);
                    eCPublicKey = (ECPublicKey)constructor.newInstance(new Object[]{aKey.getEncoded()});
                    return eCPublicKey.getParams().getCurve().getField().getFieldSize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new ArgErrorException("");
    }

    public static int getKeyLength(java.security.spec.KeySpec publicKeySpec) throws CryptoException {
        if (publicKeySpec instanceof ECPublicKeySpec) {
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)publicKeySpec;
            return eCPublicKeySpec.getParams().getCurve().getField().getFieldSize();
        }
        if (publicKeySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)publicKeySpec;
            return rSAPublicKeySpec.getModulus().bitLength();
        }
        throw new CryptoException(d[0]);
    }

    public static KeyPair generateKeyPair(AsymmetricAlg aAsymmetricAlg, int aLength) throws CryptoException {
        ParamsWithLength paramsWithLength = new ParamsWithLength(aLength);
        return Crypto.getKeyPairGenerator(aAsymmetricAlg).generateKeyPair(paramsWithLength);
    }

    public static SecretKey generateSecretKey(CipherAlg mSymmetricAlgorithm, int keyLength) throws CryptoException {
        return Crypto.getKeyFactory().generateSecretKey(mSymmetricAlgorithm, keyLength);
    }

    public static SecretKey generateSecretKey(KeySpec aSpec) throws CryptoException {
        return Crypto.getKeyFactory().generateSecretKey(aSpec);
    }

    public static byte[] generateKey(CipherAlg aAlg, int aBitLength) throws CryptoException {
        return Crypto.getKeyFactory().generateKey(aAlg, aBitLength);
    }

    public static int getKeyLength(PrivateKey aKey) throws CryptoException {
        if (aKey instanceof RSAKey) {
            return ((RSAKey)((Object)aKey)).getModulus().bitLength();
        }
        if (aKey instanceof DSAKey) {
            return ((DSAKey)((Object)aKey)).getParams().getG().bitLength();
        }
        if (aKey instanceof ECKey) {
            return ((ECKey)((Object)aKey)).getParams().getCurve().getField().getFieldSize();
        }
        throw new ArgErrorException("");
    }

    public static int getKeyLength(Algorithm aCipheralg) {
        if (a.containsKey(aCipheralg)) {
            return a.get(aCipheralg);
        }
        return -1;
    }

    public static WrapAlg getConvenientWrapAlg(CipherAlg aCipherAlg) {
        if (b.containsKey(aCipherAlg)) {
            return b.get(aCipherAlg);
        }
        return null;
    }

    public static PublicKey generatePublicKey(java.security.spec.KeySpec aKeySpec) throws CryptoException {
        return Crypto.getKeyFactory().generatePublicKey(aKeySpec);
    }

    public static PrivateKey generatePrivateKey(java.security.spec.KeySpec aKeySpec) throws CryptoException {
        return Crypto.getKeyFactory().generatePrivateKey(aKeySpec);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "GQ-;\f`S;i\u0004x\\9;\u0003c@th\u0018|D;i\u0019iPz5L";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 12;
                                break;
                            }
                            case 1: {
                                n8 = 52;
                                break;
                            }
                            case 2: {
                                n8 = 84;
                                break;
                            }
                            case 3: {
                                n8 = 27;
                                break;
                            }
                            default: {
                                n8 = 109;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u007fA:5\u001eiW!i\u0004xMz~\u000e\"q\u0017K\u0018nX=x&iM\u001dv\u001d`";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        d = stringArray3;
        a = new HashMap<Algorithm, Integer>();
        b = new HashMap<CipherAlg, WrapAlg>();
        a.put(CipherAlg.AES128_CBC, 128);
        a.put(CipherAlg.AES128_CFB, 128);
        a.put(CipherAlg.AES128_OFB, 128);
        a.put(CipherAlg.AES128_ECB, 128);
        a.put(CipherAlg.AES128_GCM, 128);
        a.put(CipherAlg.AES192_CBC, 192);
        a.put(CipherAlg.AES192_CFB, 192);
        a.put(CipherAlg.AES192_OFB, 192);
        a.put(CipherAlg.AES192_ECB, 192);
        a.put(CipherAlg.AES192_GCM, 192);
        a.put(CipherAlg.AES256_CBC, 256);
        a.put(CipherAlg.AES256_CFB, 256);
        a.put(CipherAlg.AES256_OFB, 256);
        a.put(CipherAlg.AES256_ECB, 256);
        a.put(CipherAlg.AES256_GCM, 256);
        a.put(CipherAlg.RC2_CBC, 128);
        a.put(CipherAlg.DES_EDE3_CBC, 192);
        a.put(WrapAlg.AES128, 128);
        a.put(WrapAlg.AES128_CBC, 128);
        a.put(WrapAlg.AES192, 192);
        a.put(WrapAlg.AES192_CBC, 192);
        a.put(WrapAlg.AES256, 256);
        a.put(WrapAlg.AES256_CBC, 256);
        b.put(CipherAlg.AES128_CBC, WrapAlg.AES128_CBC);
        b.put(CipherAlg.AES128_CFB, WrapAlg.AES128);
        b.put(CipherAlg.AES128_OFB, WrapAlg.AES128);
        b.put(CipherAlg.AES128_ECB, WrapAlg.AES128);
        b.put(CipherAlg.AES192_CBC, WrapAlg.AES192_CBC);
        b.put(CipherAlg.AES192_CFB, WrapAlg.AES192);
        b.put(CipherAlg.AES192_OFB, WrapAlg.AES192);
        b.put(CipherAlg.AES192_ECB, WrapAlg.AES192);
        b.put(CipherAlg.AES256_CBC, WrapAlg.AES256_CBC);
        b.put(CipherAlg.AES256_CFB, WrapAlg.AES256);
        b.put(CipherAlg.AES256_OFB, WrapAlg.AES256);
        b.put(CipherAlg.AES256_ECB, WrapAlg.AES256);
    }
}

