/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EKeyUsage;
import tr.gov.tubitak.uekae.esya.api.common.bundle.GenelDil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.BufferedCipher;
import tr.gov.tubitak.uekae.esya.api.crypto.Crypto;
import tr.gov.tubitak.uekae.esya.api.crypto.Wrapper;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.PBEAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.WrapAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.params.PBEKeySpec;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;

public class CipherUtil {
    private static final String[] a;

    public static byte[] encrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, byte[] aData, byte[] aSecretKey) throws CryptoException {
        BufferedCipher bufferedCipher = Crypto.getEncryptor(aCipherAlg);
        bufferedCipher.init(aSecretKey, aParams);
        return bufferedCipher.doFinal(aData);
    }

    public static byte[] decrypt(EAlgorithmIdentifier aAlgorithm, byte[] aData, byte[] aSecretKey) throws CryptoException {
        Pair<CipherAlg, AlgorithmParams> pair = CipherAlg.fromAlgorithmIdentifier(aAlgorithm);
        return CipherUtil.decrypt((CipherAlg)pair.first(), (AlgorithmParams)pair.second(), aData, aSecretKey);
    }

    public static byte[] decrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, byte[] aData, byte[] aSecretKey) throws CryptoException {
        BufferedCipher bufferedCipher = Crypto.getDecryptor(aCipherAlg);
        bufferedCipher.init(aSecretKey, aParams);
        return bufferedCipher.doFinal(aData);
    }

    public static byte[] decrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, byte[] aData, SecretKey aSecretKey) throws CryptoException {
        BufferedCipher bufferedCipher = Crypto.getDecryptor(aCipherAlg);
        bufferedCipher.init(aSecretKey, aParams);
        return bufferedCipher.doFinal(aData);
    }

    public static void encrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, InputStream aToBeEncrypted, OutputStream aEncrypted, byte[] aKey) throws CryptoException, IOException {
        int n;
        int n2 = KeyUtil.c;
        BufferedCipher bufferedCipher = Crypto.getEncryptor(aCipherAlg);
        bufferedCipher.init(aKey, aParams);
        while ((n = aToBeEncrypted.available()) != 0) {
            byte[] byArray = new byte[n];
            int n3 = aToBeEncrypted.read(byArray);
            bufferedCipher.process(byArray, 0, n3);
            if (n2 == 0) continue;
        }
        aEncrypted.write(bufferedCipher.doFinal(null));
    }

    public static void decrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, InputStream aEncrypted, OutputStream aDecrypted, byte[] aKey) throws CryptoException, IOException {
        int n;
        int n2 = KeyUtil.c;
        BufferedCipher bufferedCipher = Crypto.getDecryptor(aCipherAlg);
        bufferedCipher.init(aKey, aParams);
        while ((n = aEncrypted.available()) != 0) {
            byte[] byArray = new byte[n];
            int n3 = aEncrypted.read(byArray);
            bufferedCipher.process(byArray, 0, n3);
            if (n2 == 0) continue;
        }
        aDecrypted.write(bufferedCipher.doFinal(null));
    }

    public static byte[] encrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, byte[] aData, PublicKey aSifPubKey) throws CryptoException {
        BufferedCipher bufferedCipher = Crypto.getEncryptor(aCipherAlg);
        bufferedCipher.init(aSifPubKey, aParams);
        return bufferedCipher.doFinal(aData);
    }

    public static byte[] wrap(CipherAlg cipherAlg, AlgorithmParams aParams, SecretKey aData, PublicKey aSifPubKey) throws CryptoException {
        return CipherUtil.wrap(new WrapAlg(cipherAlg), aParams, aData, aSifPubKey);
    }

    public static byte[] wrap(WrapAlg wrapperAlg, AlgorithmParams aParams, SecretKey aData, PublicKey aSifPubKey) throws CryptoException {
        if (wrapperAlg == null) {
            throw new CryptoException(a[1]);
        }
        Wrapper wrapper = Crypto.getWrapper(wrapperAlg);
        wrapper.init(aSifPubKey, aParams);
        return wrapper.wrap(aData);
    }

    public static byte[] encrypt(EAlgorithmIdentifier aAlgorithm, byte[] aData, PublicKey aSifPubKey) throws CryptoException {
        Pair<CipherAlg, AlgorithmParams> pair = CipherAlg.fromAlgorithmIdentifier(aAlgorithm);
        BufferedCipher bufferedCipher = Crypto.getEncryptor((CipherAlg)pair.first());
        bufferedCipher.init(aSifPubKey, (AlgorithmParams)pair.second());
        return bufferedCipher.doFinal(aData);
    }

    public static byte[] encrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, byte[] aData, ECertificate aCertificate) throws CryptoException {
        if (!CipherUtil.isEnciphermentCertificate(aCertificate)) {
            throw new ArgErrorException(GenelDil.mesaj((String)GenelDil.CERT_HATALI));
        }
        return CipherUtil.encrypt(aCipherAlg, aParams, aData, KeyUtil.decodePublicKey(aCertificate.getSubjectPublicKeyInfo()));
    }

    public static byte[] decrypt(CipherAlg aCipherAlg, AlgorithmParams aParams, byte[] aData, PrivateKey aSignPrivateKey) throws CryptoException {
        BufferedCipher bufferedCipher = Crypto.getDecryptor(aCipherAlg);
        bufferedCipher.init(aSignPrivateKey, aParams);
        return bufferedCipher.doFinal(aData);
    }

    public static byte[] decryptRSA(byte[] aData, PrivateKey aKey) throws CryptoException {
        CipherAlg cipherAlg = CipherAlg.RSA_PKCS1;
        try {
            return CipherUtil.decrypt(cipherAlg, null, aData, aKey);
        }
        catch (CryptoException cryptoException) {
            cipherAlg = CipherAlg.RSA_OAEP_SHA256;
            try {
                return CipherUtil.decrypt(cipherAlg, null, aData, aKey);
            }
            catch (CryptoException cryptoException2) {
                throw new CryptoException(a[0]);
            }
        }
    }

    public static byte[] decryptRSA(byte[] aData, PrivateKey aKey, EAlgorithmIdentifier algorithmIdentifier) throws CryptoException {
        Pair<CipherAlg, AlgorithmParams> pair = CipherAlg.fromAlgorithmIdentifier(algorithmIdentifier);
        return CipherUtil.decrypt((CipherAlg)pair.first(), (AlgorithmParams)pair.second(), aData, aKey);
    }

    public static byte[] decrypt(PBEAlg aCipherAlg, AlgorithmParams aParams, PBEKeySpec aKeySpec, byte[] aData) throws CryptoException {
        BufferedCipher bufferedCipher = Crypto.getDecryptor(aCipherAlg.getCipherAlg());
        PBEKey pBEKey = (PBEKey)Crypto.getKeyFactory().generateSecretKey(aKeySpec);
        bufferedCipher.init(pBEKey, aParams);
        return bufferedCipher.doFinal(aData);
    }

    public static byte[] encrypt(PBEAlg aCipherAlg, AlgorithmParams aParams, PBEKeySpec aKeySpec, byte[] aData) throws CryptoException {
        BufferedCipher bufferedCipher = Crypto.getEncryptor(aCipherAlg.getCipherAlg());
        SecretKey secretKey = Crypto.getKeyFactory().generateSecretKey(aKeySpec);
        bufferedCipher.init(secretKey, aParams);
        return bufferedCipher.doFinal(aData);
    }

    public static boolean isEnciphermentCertificate(ECertificate aCertificate) {
        EKeyUsage eKeyUsage = aCertificate.getExtensions().getKeyUsage();
        return eKeyUsage != null && (eKeyUsage.isDataEncipherment() || eKeyUsage.isKeyEncipherment());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\"<O5_\u00058B3\u0006\u0011)\u0001%\u001e\u0015<\ra\u000f\u000e.R(\u001d\r$\u0001$\u0011\u00022E(\u0011\u0006}B \u0011A3N5_\u00038\u0001%\u001a\u00158S,\u0016\u000f8Eo";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 97;
                                break;
                            }
                            case 1: {
                                n8 = 93;
                                break;
                            }
                            case 2: {
                                n8 = 33;
                                break;
                            }
                            case 3: {
                                n8 = 65;
                                break;
                            }
                            default: {
                                n8 = 127;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "/(M-_ /F2";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

