/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.alg;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tr.gov.tubitak.uekae.esya.api.asn.algorithms.ERSASSA_PSS_params;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MGF;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.params.RSAPSSParams;
import tr.gov.tubitak.uekae.esya.asn.algorithms.RSASSA_PSS_params;
import tr.gov.tubitak.uekae.esya.asn.algorithms._algorithmsValues;

public class SignatureAlg
implements Algorithm {
    private static Map<OID, Set<SignatureAlg>> a;
    private static Map<String, SignatureAlg> b;
    public static final byte[] REQUIRED;
    public static final SignatureAlg ECDSA;
    public static final SignatureAlg ECDSA_SHA1;
    public static final SignatureAlg ECDSA_SHA224;
    public static final SignatureAlg ECDSA_SHA256;
    public static final SignatureAlg ECDSA_SHA384;
    public static final SignatureAlg ECDSA_SHA512;
    public static final SignatureAlg DSA;
    public static final SignatureAlg DSA_SHA1;
    public static final SignatureAlg DSA_SHA256;
    public static final SignatureAlg RSA_NONE;
    public static final SignatureAlg RSA_RAW;
    public static final SignatureAlg RSA_MD5;
    public static final SignatureAlg RSA_SHA1;
    public static final SignatureAlg RSA_SHA224;
    public static final SignatureAlg RSA_SHA256;
    public static final SignatureAlg RSA_SHA384;
    public static final SignatureAlg RSA_SHA512;
    public static final SignatureAlg RSA_PSS;
    public static final SignatureAlg RSA_ISO9796_2_SHA1;
    public static final SignatureAlg RSA_ISO9796_2_SHA224;
    public static final SignatureAlg RSA_ISO9796_2_SHA256;
    public static final SignatureAlg RSA_ISO9796_2_SHA384;
    public static final SignatureAlg RSA_ISO9796_2_SHA512;
    private int[] c;
    private String d;
    private AsymmetricAlg e;
    private DigestAlg f;
    private byte[] g;
    private static final String[] h;

    protected SignatureAlg(int[] aOid, String aName, AsymmetricAlg aAsymmetricAlg, DigestAlg aDigestAlg, byte[] aDefaultParams) {
        this.c = aOid;
        this.d = aName;
        this.e = aAsymmetricAlg;
        this.f = aDigestAlg;
        this.g = aDefaultParams;
        this.a(this);
    }

    private void a(SignatureAlg signatureAlg) {
        String string;
        block7: {
            if (signatureAlg.getOID() != null) {
                Set<SignatureAlg> set;
                block6: {
                    string = new OID(signatureAlg.getOID());
                    set = a.get(string);
                    if (set != null) break block6;
                    a.put((OID)string, new HashSet<SignatureAlg>(Arrays.asList(signatureAlg)));
                    break block7;
                }
                set.add(signatureAlg);
            }
        }
        string = signatureAlg.getName();
        if (!b.containsKey(string)) {
            b.put(signatureAlg.getName(), this);
        }
    }

    @Override
    public int[] getOID() {
        return this.c;
    }

    @Override
    public String getName() {
        return this.d;
    }

    public AsymmetricAlg getAsymmetricAlg() {
        return this.e;
    }

    public DigestAlg getDigestAlg() {
        return this.f;
    }

    public static SignatureAlg fromName(String aSignatureAlgName) {
        return b.get(aSignatureAlgName);
    }

    private static SignatureAlg a(int[] nArray) {
        block4: {
            OID oID;
            block5: {
                oID = new OID(nArray);
                Set<SignatureAlg> set = a.get(oID);
                if (set == null) break block4;
                if (set.size() != 1) break block5;
                return set.iterator().next();
            }
            throw new ESYARuntimeException(h[2] + oID);
        }
        return null;
    }

    public static Pair<SignatureAlg, AlgorithmParams> fromAlgorithmIdentifier(EAlgorithmIdentifier aAlgoId) throws CryptoException {
        block7: {
            block8: {
                if (aAlgoId == null) {
                    return null;
                }
                OID oID = new OID(aAlgoId.getAlgorithm().value);
                if (!oID.equals((Object)new OID(_algorithmsValues.id_RSASSA_PSS))) break block7;
                if (!aAlgoId.hasParameters()) break block8;
                try {
                    RSASSA_PSS_params rSASSA_PSS_params = new RSASSA_PSS_params();
                    Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aAlgoId.getParameters().value);
                    rSASSA_PSS_params.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
                    int[] nArray = rSASSA_PSS_params.hashAlgorithm.algorithm.value;
                    DigestAlg digestAlg = DigestAlg.fromOID(nArray);
                    MGF mGF = MGF.fromOID(rSASSA_PSS_params.maskGenAlgorithm.algorithm.value);
                    RSAPSSParams rSAPSSParams = new RSAPSSParams(digestAlg, mGF, (int)rSASSA_PSS_params.saltLength.value, (int)rSASSA_PSS_params.trailerField.value);
                    return new Pair((Object)RSA_PSS, (Object)rSAPSSParams);
                }
                catch (Exception exception) {
                    throw new CryptoException(h[0]);
                }
            }
            return new Pair((Object)RSA_PSS, null);
        }
        return new Pair((Object)SignatureAlg.a(aAlgoId.getAlgorithm().value), null);
    }

    public EAlgorithmIdentifier toAlgorithmIdentifier(AlgorithmParams aParams) throws CryptoException {
        byte[] byArray;
        block9: {
            block7: {
                block8: {
                    if (this.c == null) {
                        throw new CryptoException(h[4]);
                    }
                    byArray = null;
                    if (aParams != null) break block7;
                    if (!Arrays.equals(this.g, REQUIRED)) break block8;
                    throw new CryptoException(h[3] + this.d);
                }
                byArray = this.g;
                break block9;
            }
            byArray = aParams.getEncoded();
        }
        return new EAlgorithmIdentifier(this.c, byArray);
    }

    public EAlgorithmIdentifier toAlgorithmIdentifierFromSpec(AlgorithmParameterSpec spec) throws ESYAException {
        block8: {
            byte[] byArray;
            block9: {
                if (this.c == null) {
                    throw new CryptoException(h[1]);
                }
                byArray = null;
                if (spec == null) break block8;
                if (!(spec instanceof AlgorithmParams)) break block9;
                return this.toAlgorithmIdentifier((AlgorithmParams)spec);
            }
            if (spec instanceof PSSParameterSpec) {
                PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)spec;
                byArray = new ERSASSA_PSS_params(pSSParameterSpec).getEncoded();
            }
            return new EAlgorithmIdentifier(this.c, byArray);
        }
        return this.toAlgorithmIdentifier(null);
    }

    public int hashCode() {
        int n = this.e != null ? this.e.hashCode() : 0;
        int n2 = n;
        int n3 = 31 * n2;
        int n4 = this.f != null ? this.f.hashCode() : 0;
        n2 = n3 + n4;
        return n2;
    }

    public static SignatureAlg[] getAlgorithms() {
        return b.values().toArray(new SignatureAlg[0]);
    }

    public String toString() {
        return this.d;
    }

    public boolean equals(Object o) {
        block13: {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) break block13;
            return false;
        }
        SignatureAlg signatureAlg = (SignatureAlg)o;
        if (this.e != signatureAlg.e) {
            return false;
        }
        if (this.f != signatureAlg.f) {
            return false;
        }
        return Arrays.equals(this.c, signatureAlg.getOID());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[27];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0007k\u001e\u001d{b}\t\u0011f&p\u0002\u0015)#u\u000b\u001d{+m\u0004\u001f)\u000b}\t\u001c}+\u007f\u0005\u0017{bi\r\u0000h/j";
        int n2 = -1;
        block34: while (true) {
            char[] cArray;
            block39: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block38: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block38;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block39;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 66;
                                break;
                            }
                            case 1: {
                                n8 = 25;
                                break;
                            }
                            case 2: {
                                n8 = 108;
                                break;
                            }
                            case 3: {
                                n8 = 114;
                                break;
                            }
                            default: {
                                n8 = 9;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\rP(Rg-mL\u0019g-n\u0002S";
                    n2 = 0;
                    continue block34;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u000fl\u0000\u0006`2u\tRz+~\u0002\u0013}7k\tRh.~\u0003\u0000`6q\u0001\u0001)$v\u001eRz#t\tRF\u000b]L";
                    n2 = 1;
                    continue block34;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0003u\u000b\u001d{+m\u0004\u001f)\u000b}\t\u001c}+\u007f\u0005\u0017{bz\u0003\u001c\u007f'k\u001f\u001bf,9\u001e\u0017x7p\u001e\u0017zbi\r\u0000h/|\u0018\u0017{19\n\u001d{b";
                    n2 = 2;
                    continue block34;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\rP(Rg-mL\u0019g-n\u0002S";
                    n2 = 3;
                    continue block34;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0010J-_~+m\u0004_Z\nX^G?";
                    n2 = 4;
                    continue block34;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0010J-_@\u0011VUE0t4^_~+m\u0004_Z\nX^G?";
                    n2 = 5;
                    continue block34;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0010J-_~+m\u0004_D\u0006,";
                    n2 = 6;
                    continue block34;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0007Z";
                    n2 = 7;
                    continue block34;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u0007Z(!Hon\u0005\u0006aoJ$3:z-";
                    n2 = 8;
                    continue block34;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u0006J-_~+m\u0004_Z\nX]";
                    n2 = 9;
                    continue block34;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "\u0010J-_@\u0011VUE0t4^_~+m\u0004_Z\nX_J=";
                    n2 = 10;
                    continue block34;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "\u0010J-_@\u0011VUE0t4^_~+m\u0004_Z\nX]";
                    n2 = 11;
                    continue block34;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "\u0010J-\"Z\u0011";
                    n2 = 12;
                    continue block34;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "\u0010J-_@\u0011VUE0t4^_~+m\u0004_Z\nXYC;";
                    n2 = 13;
                    continue block34;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "\u0007Z(!Hon\u0005\u0006aoJ$38";
                    n2 = 14;
                    continue block34;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "\u0010J-_~+m\u0004_Z\nX_J=";
                    n2 = 15;
                    continue block34;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "\u0006J-";
                    n2 = 16;
                    continue block34;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "\u0007Z(!Hon\u0005\u0006aoJ$3<s+";
                    n2 = 17;
                    continue block34;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "\u0010J-_~+m\u0004_Z\nXYC;";
                    n2 = 18;
                    continue block34;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "\u0007Z(!Hon\u0005\u0006aoJ$3;p-";
                    n2 = 19;
                    continue block34;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "\u0010J-_~+m\u0004_Z\nX^@=";
                    n2 = 20;
                    continue block34;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "\u0006J-_~+m\u0004_Z\nX^G?";
                    n2 = 21;
                    continue block34;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "\u0010J-_@\u0011VUE0t4^_~+m\u0004_Z\nX^@=";
                    n2 = 22;
                    continue block34;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "\u0007Z(!Hon\u0005\u0006aoJ$3;w/";
                    n2 = 23;
                    continue block34;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "\u0010J-_~+m\u0004_G\rW)";
                    n2 = 24;
                    continue block34;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "\u0010J-_~+m\u0004_Z\nX]";
                    n2 = 25;
                    continue block34;
                }
                case 25: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        h = stringArray3;
        a = new HashMap<OID, Set<SignatureAlg>>();
        b = new HashMap<String, SignatureAlg>();
        REQUIRED = new byte[0];
        ECDSA = new SignatureAlg(_algorithmsValues.id_ecPublicKey, h[8], AsymmetricAlg.ECDSA, null, null);
        ECDSA_SHA1 = new SignatureAlg(_algorithmsValues.ecdsa_with_SHA1, h[15], AsymmetricAlg.ECDSA, DigestAlg.SHA1, null);
        ECDSA_SHA224 = new SignatureAlg(_algorithmsValues.ecdsa_with_Sha224, h[20], AsymmetricAlg.ECDSA, DigestAlg.SHA224, null);
        ECDSA_SHA256 = new SignatureAlg(_algorithmsValues.ecdsa_with_Sha256, h[24], AsymmetricAlg.ECDSA, DigestAlg.SHA256, null);
        ECDSA_SHA384 = new SignatureAlg(_algorithmsValues.ecdsa_with_Sha384, h[9], AsymmetricAlg.ECDSA, DigestAlg.SHA384, null);
        ECDSA_SHA512 = new SignatureAlg(_algorithmsValues.ecdsa_with_Sha512, h[18], AsymmetricAlg.ECDSA, DigestAlg.SHA512, null);
        DSA = new SignatureAlg(_algorithmsValues.id_dsa, h[17], AsymmetricAlg.DSA, null, null);
        DSA_SHA1 = new SignatureAlg(_algorithmsValues.id_dsa_with_sha1, h[10], AsymmetricAlg.DSA, DigestAlg.SHA1, null);
        DSA_SHA256 = new SignatureAlg(null, h[22], AsymmetricAlg.DSA, DigestAlg.SHA256, null);
        RSA_NONE = new SignatureAlg(_algorithmsValues.rsaEncryption, h[25], AsymmetricAlg.RSA, null, EAlgorithmIdentifier.ASN_NULL);
        RSA_RAW = new SignatureAlg(_algorithmsValues.rsaEncryption, Algorithms.SIGNATURE_RSA_RAW, AsymmetricAlg.RSA, null, EAlgorithmIdentifier.ASN_NULL);
        RSA_MD5 = new SignatureAlg(_algorithmsValues.md5WithRSAEncryption, h[7], AsymmetricAlg.RSA, DigestAlg.MD5, EAlgorithmIdentifier.ASN_NULL);
        RSA_SHA1 = new SignatureAlg(_algorithmsValues.sha1WithRSAEncryption, h[26], AsymmetricAlg.RSA, DigestAlg.SHA1, EAlgorithmIdentifier.ASN_NULL);
        RSA_SHA224 = new SignatureAlg(_algorithmsValues.sha224WithRSAEncryption, h[21], AsymmetricAlg.RSA, DigestAlg.SHA224, EAlgorithmIdentifier.ASN_NULL);
        RSA_SHA256 = new SignatureAlg(_algorithmsValues.sha256WithRSAEncryption, h[5], AsymmetricAlg.RSA, DigestAlg.SHA256, EAlgorithmIdentifier.ASN_NULL);
        RSA_SHA384 = new SignatureAlg(_algorithmsValues.sha384WithRSAEncryption, h[16], AsymmetricAlg.RSA, DigestAlg.SHA384, EAlgorithmIdentifier.ASN_NULL);
        RSA_SHA512 = new SignatureAlg(_algorithmsValues.sha512WithRSAEncryption, h[19], AsymmetricAlg.RSA, DigestAlg.SHA512, EAlgorithmIdentifier.ASN_NULL);
        RSA_PSS = new SignatureAlg(_algorithmsValues.id_RSASSA_PSS, h[13], AsymmetricAlg.RSA, null, REQUIRED);
        RSA_ISO9796_2_SHA1 = new SignatureAlg(_algorithmsValues.id_RSASS_ISO9796d2, h[12], AsymmetricAlg.RSA, DigestAlg.SHA1, null);
        RSA_ISO9796_2_SHA224 = new SignatureAlg(_algorithmsValues.id_RSASS_ISO9796d2, h[23], AsymmetricAlg.RSA, DigestAlg.SHA224, null);
        RSA_ISO9796_2_SHA256 = new SignatureAlg(_algorithmsValues.id_RSASS_ISO9796d2, h[6], AsymmetricAlg.RSA, DigestAlg.SHA256, null);
        RSA_ISO9796_2_SHA384 = new SignatureAlg(_algorithmsValues.id_RSASS_ISO9796d2, h[11], AsymmetricAlg.RSA, DigestAlg.SHA384, null);
        RSA_ISO9796_2_SHA512 = new SignatureAlg(_algorithmsValues.id_RSASS_ISO9796d2, h[14], AsymmetricAlg.RSA, DigestAlg.SHA512, null);
    }
}

