/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.alg;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1OpenType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.crypto.algorithms._aesValues;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Mod;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.OAEPPadding;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Padding;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithGCMSpec;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithIV;
import tr.gov.tubitak.uekae.esya.asn.algorithms.GCMParameters;
import tr.gov.tubitak.uekae.esya.asn.algorithms._algorithmsValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;

public class CipherAlg
implements Algorithm {
    private static Map<OID, CipherAlg> a;
    private static Map<String, CipherAlg> b;
    public static final CipherAlg AES128_CBC;
    public static final CipherAlg AES128_CFB;
    public static final CipherAlg AES128_ECB;
    public static final CipherAlg AES128_OFB;
    public static final CipherAlg AES128_GCM;
    public static final CipherAlg AES192_CBC;
    public static final CipherAlg AES192_CFB;
    public static final CipherAlg AES192_ECB;
    public static final CipherAlg AES192_OFB;
    public static final CipherAlg AES192_GCM;
    public static final CipherAlg AES256_CBC;
    public static final CipherAlg AES256_CFB;
    public static final CipherAlg AES256_ECB;
    public static final CipherAlg AES256_OFB;
    public static final CipherAlg AES256_GCM;
    public static final CipherAlg RC2_CBC;
    public static final CipherAlg DES_EDE3_CBC;
    public static final CipherAlg RSA_PKCS1;
    public static final CipherAlg RSA_RAW;
    @Deprecated
    public static final CipherAlg RSA_OAEP;
    public static final CipherAlg RSA_ECB_PKCS1;
    @Deprecated
    public static final CipherAlg RSA_ECB_OAEP;
    public static final CipherAlg RSA_OAEP_SHA256;
    public static final CipherAlg RSA_OAEP_SHA512;
    protected int[] mOID;
    protected String mName;
    protected int mBlockSize;
    protected Mod mMod;
    protected Padding mPadding;
    public static boolean c;
    private static final String[] d;

    public CipherAlg(int[] aOId, String aName, int aBlockSize, Mod aMod, Padding aPadding) {
        this.mOID = aOId;
        this.mName = aName;
        this.mBlockSize = aBlockSize;
        this.mMod = aMod;
        this.mPadding = aPadding;
        if (aOId != null) {
            OID oID = new OID(aOId);
            a.put(oID, this);
        }
        b.put(aName, this);
    }

    @Override
    public int[] getOID() {
        return this.mOID;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public Mod getMod() {
        return this.mMod;
    }

    public Padding getPadding() {
        return this.mPadding;
    }

    public EAlgorithmIdentifier toAlgorithmIdentifier(byte[] aIV) throws CryptoException {
        EAlgorithmIdentifier eAlgorithmIdentifier = new EAlgorithmIdentifier(new AlgorithmIdentifier());
        eAlgorithmIdentifier.setAlgorithm(new Asn1ObjectIdentifier(this.getOID()));
        if (aIV != null) {
            try {
                Asn1OctetString asn1OctetString = new Asn1OctetString(aIV);
                Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                asn1OctetString.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                Asn1OpenType asn1OpenType = new Asn1OpenType(asn1DerEncodeBuffer.getMsgCopy());
                eAlgorithmIdentifier.setParameters(asn1OpenType);
            }
            catch (Asn1Exception asn1Exception) {
                throw new CryptoException(d[4], asn1Exception);
            }
        }
        return eAlgorithmIdentifier;
    }

    public static CipherAlg fromOID(int[] aOid) {
        OID oID = new OID(aOid);
        return a.get(oID);
    }

    public static CipherAlg fromName(String aAlgName) {
        return b.get(aAlgName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<CipherAlg, AlgorithmParams> fromAlgorithmIdentifier(EAlgorithmIdentifier aAlgoritma) throws CryptoException {
        CipherAlg cipherAlg;
        int[] nArray = aAlgoritma.getAlgorithm().value;
        Asn1OpenType asn1OpenType = aAlgoritma.getParameters();
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        ParamsWithIV paramsWithIV = null;
        if (Arrays.equals(nArray, _algorithmsValues.id_RSAES_OAEP)) {
            try {
                OAEPPadding oAEPPadding = null;
                if (asn1OpenType.equals(new byte[]{48, 0})) {
                    oAEPPadding = OAEPPadding.OAEP_SHA1_MGF1;
                    return new Pair((Object)new CipherAlg(_algorithmsValues.id_RSAES_OAEP, d[0], 0, Mod.NONE, oAEPPadding), null);
                }
                oAEPPadding = OAEPPadding.fromRSAES_OAEP_params(asn1OpenType.value);
                return new Pair((Object)new CipherAlg(_algorithmsValues.id_RSAES_OAEP, d[0], 0, Mod.NONE, oAEPPadding), null);
            }
            catch (IOException iOException) {
                throw new CryptoException(d[2], iOException);
            }
        }
        if (asn1OpenType != null && asn1OpenType.value.length > 1 && (asn1OpenType.value[0] != 5 || asn1OpenType.value[1] != 0)) {
            try {
                if (CipherAlg.isGCMOID(nArray)) {
                    cipherAlg = new Asn1DerDecodeBuffer(asn1OpenType.value);
                    GCMParameters gCMParameters = new GCMParameters();
                    gCMParameters.decode((Asn1BerDecodeBuffer)cipherAlg);
                    asn1OctetString = gCMParameters.aes_nonce;
                    paramsWithIV = new ParamsWithGCMSpec(asn1OctetString.value);
                } else {
                    cipherAlg = new Asn1DerEncodeBuffer();
                    asn1OpenType.encode((Asn1BerEncodeBuffer)cipherAlg);
                    Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(cipherAlg.getMsgCopy());
                    asn1OctetString.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
                    paramsWithIV = new ParamsWithIV(asn1OctetString.value);
                }
            }
            catch (Asn1Exception asn1Exception) {
                throw new CryptoException(d[1], asn1Exception);
            }
            catch (IOException iOException) {
                throw new CryptoException(d[3], iOException);
            }
        }
        cipherAlg = CipherAlg.fromOID(nArray);
        return new Pair((Object)new CipherAlg(cipherAlg.getOID(), cipherAlg.getName(), cipherAlg.getBlockSize(), cipherAlg.getMod(), cipherAlg.getPadding()), paramsWithIV);
    }

    public static boolean isGCMOID(int[] oid) {
        block7: {
            block6: {
                if (Arrays.equals(oid, _aesValues.id_aes128_GCM) || Arrays.equals(oid, _aesValues.id_aes192_GCM)) break block6;
                if (!Arrays.equals(oid, _aesValues.id_aes256_GCM)) break block7;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        CipherAlg cipherAlg;
        block28: {
            block27: {
                block26: {
                    if (this == o) {
                        return true;
                    }
                    if (o != null && this.getClass() == o.getClass()) break block26;
                    return false;
                }
                cipherAlg = (CipherAlg)o;
                if (this.mBlockSize != cipherAlg.mBlockSize) {
                    return false;
                }
                if (this.mMod != cipherAlg.mMod) {
                    return false;
                }
                if (this.mName == null) break block27;
                if (this.mName.equals(cipherAlg.mName)) break block28;
                return false;
            }
            if (cipherAlg.mName == null) break block28;
            return false;
        }
        if (!Arrays.equals(this.mOID, cipherAlg.mOID)) {
            return false;
        }
        if (this.mPadding == cipherAlg.mPadding) return true;
        return false;
    }

    public int hashCode() {
        int n;
        block12: {
            boolean bl;
            block14: {
                block13: {
                    boolean bl2 = c;
                    int n2 = this.mOID != null ? Arrays.hashCode(this.mOID) : 0;
                    int n3 = n2;
                    int n4 = 31 * n3;
                    int n5 = this.mName != null ? this.mName.hashCode() : 0;
                    n3 = n4 + n5;
                    n3 = 31 * n3 + this.mBlockSize;
                    int n6 = 31 * n3;
                    int n7 = this.mMod != null ? this.mMod.hashCode() : 0;
                    n3 = n6 + n7;
                    int n8 = 31 * n3;
                    int n9 = this.mPadding != null ? this.mPadding.hashCode() : 0;
                    n3 = n8 + n9;
                    n = n3;
                    if (!bl2) break block12;
                    if (!CryptoException.b) break block13;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
            CryptoException.b = bl;
        }
        return n;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u001f\u0011x \u0017\u0002\f| \u0016\f\u0007i";
        int n2 = -1;
        block20: while (true) {
            char[] cArray;
            block25: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block24: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block24;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block25;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 77;
                                break;
                            }
                            case 1: {
                                n8 = 66;
                                break;
                            }
                            case 2: {
                                n8 = 57;
                                break;
                            }
                            case 3: {
                                n8 = 15;
                                break;
                            }
                            default: {
                                n8 = 89;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\f.^`+$6Qby$\u00a5Pa=(,\u0019F\u000fm&\\\u0110<?+\u0019n5\u017c,\u0108}2(,\u0019g89#\u0019`58\u011dMz";
                    n2 = 0;
                    continue block20;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\f.^`+$6Qby$\u00a5Pa=(,\u0019@\u0018\b\u0012\u0019\u007f8?#Tj-?'Uj+$bXc\u0168#\u0173Kd<#bQn-,bVc,\u01126L";
                    n2 = 1;
                    continue block20;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\f.^`+$6Qby$\u00a5Pa=(,\u0019F\u000fm&\\\u0110<?+\u0019n5\u017c,\u0108}2(,\u0019g89#\u0019`58\u011dMz";
                    n2 = 2;
                    continue block20;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\f1W>y$1Uj4!'Kf7)'\u0019g89#\u0019l0&6P!";
                    n2 = 3;
                    continue block20;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u001f\u0011x \u0017\u0002\f| \u0016\f\u0007i \n\u0005\u0003\f>k";
                    n2 = 4;
                    continue block20;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u001f\u0011x \u0017\u0002\f| \u0016\f\u0007i";
                    n2 = 5;
                    continue block20;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u001f\u0011x \u0017\u0002\f| \u0016\f\u0007i \n\u0005\u0003\u000b:o";
                    n2 = 6;
                    continue block20;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "~\u0006|\\v\u000e\u0000z \t\u0006\u0001j8";
                    n2 = 7;
                    continue block20;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u001f\u0011x \u001c\u000e\u0000\u0016@\u0018\b\u0012";
                    n2 = 8;
                    continue block20;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u001f\u0011x \u0017\u0002\f| \t\u0006\u0001j>";
                    n2 = 9;
                    continue block20;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "\u001f\u0011x \u001c\u000e\u0000\u0016_\u0012\u000e\u0011\b";
                    n2 = 10;
                    continue block20;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "\u001f\u0001\u000b \u001a\u000f\u0001\u0016_\u0012\u000e\u0011\u000e";
                    n2 = 11;
                    continue block20;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        d = stringArray3;
        a = new HashMap<OID, CipherAlg>();
        b = new HashMap<String, CipherAlg>();
        AES128_CBC = new CipherAlg(_aesValues.id_aes128_CBC, Algorithms.CIPHER_AES128_CBC, 16, Mod.CBC, Padding.PKCS7);
        AES128_CFB = new CipherAlg(_aesValues.id_aes128_CFB, Algorithms.CIPHER_AES128_CFB, 16, Mod.CFB, Padding.PKCS7);
        AES128_ECB = new CipherAlg(_aesValues.id_aes128_ECB, Algorithms.CIPHER_AES128_ECB, 16, Mod.ECB, Padding.PKCS7);
        AES128_OFB = new CipherAlg(_aesValues.id_aes128_OFB, Algorithms.CIPHER_AES128_OFB, 16, Mod.OFB, Padding.PKCS7);
        AES128_GCM = new CipherAlg(_aesValues.id_aes128_GCM, Algorithms.CIPHER_AES128_GCM, 16, Mod.GCM, Padding.NONE);
        AES192_CBC = new CipherAlg(_aesValues.id_aes192_CBC, Algorithms.CIPHER_AES192_CBC, 16, Mod.CBC, Padding.PKCS7);
        AES192_CFB = new CipherAlg(_aesValues.id_aes192_CFB, Algorithms.CIPHER_AES192_CFB, 16, Mod.CFB, Padding.PKCS7);
        AES192_ECB = new CipherAlg(_aesValues.id_aes192_ECB, Algorithms.CIPHER_AES192_ECB, 16, Mod.ECB, Padding.PKCS7);
        AES192_OFB = new CipherAlg(_aesValues.id_aes192_OFB, Algorithms.CIPHER_AES192_OFB, 16, Mod.OFB, Padding.PKCS7);
        AES192_GCM = new CipherAlg(_aesValues.id_aes192_GCM, Algorithms.CIPHER_AES192_GCM, 16, Mod.GCM, Padding.NONE);
        AES256_CBC = new CipherAlg(_aesValues.id_aes256_CBC, Algorithms.CIPHER_AES256_CBC, 16, Mod.CBC, Padding.PKCS7);
        AES256_CFB = new CipherAlg(_aesValues.id_aes256_CFB, Algorithms.CIPHER_AES256_CFB, 16, Mod.CFB, Padding.PKCS7);
        AES256_ECB = new CipherAlg(_aesValues.id_aes256_ECB, Algorithms.CIPHER_AES256_ECB, 16, Mod.ECB, Padding.PKCS7);
        AES256_OFB = new CipherAlg(_aesValues.id_aes256_OFB, Algorithms.CIPHER_AES256_OFB, 16, Mod.OFB, Padding.PKCS7);
        AES256_GCM = new CipherAlg(_aesValues.id_aes256_GCM, Algorithms.CIPHER_AES256_GCM, 16, Mod.GCM, Padding.NONE);
        RC2_CBC = new CipherAlg(_algorithmsValues.rc2_cbc, d[12], 8, Mod.CBC, Padding.PKCS7);
        DES_EDE3_CBC = new CipherAlg(_algorithmsValues.des_ede3_cbc, d[8], 8, Mod.CBC, Padding.PKCS7);
        RSA_PKCS1 = new CipherAlg(_algorithmsValues.rsaEncryption, d[10], 0, Mod.NONE, Padding.PKCS1);
        RSA_RAW = new CipherAlg(null, Algorithms.CIPHER_RSA_RAW, 0, Mod.NONE, null);
        RSA_OAEP = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, d[6], 0, Mod.NONE, OAEPPadding.OAEP_SHA1_MGF1);
        RSA_ECB_PKCS1 = new CipherAlg(null, d[11], 0, Mod.ECB, Padding.PKCS1);
        RSA_ECB_OAEP = new CipherAlg(null, d[9], 0, Mod.ECB, OAEPPadding.OAEP_SHA1_MGF1);
        RSA_OAEP_SHA256 = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, d[7], 0, Mod.NONE, OAEPPadding.OAEP_SHA256_MGF1);
        RSA_OAEP_SHA512 = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, d[5], 0, Mod.NONE, OAEPPadding.OAEP_SHA512_MGF1);
    }
}

