/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.validator;

import java.util.Arrays;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.Context;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CRLReference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CompleteRevocationRefs;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.OCSPReference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.RevocationValues;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.BaseTimeStampValidator;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.Validator;

public class RevocationValuesValidator
implements Validator {
    private static final String[] a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidationResult validate(XMLSignature aSignature, ECertificate aCertificate) throws XMLSignatureException {
        int n = BaseTimeStampValidator.b;
        Context context = aSignature.getContext();
        boolean bl = context.getConfig().getValidationConfig().isForceStrictReferences();
        SignatureType signatureType = aSignature.getSignatureType();
        if (bl && (signatureType == SignatureType.XAdES_X_L || signatureType == SignatureType.XAdES_A)) {
            RevocationValues revocationValues = aSignature.getQualifyingProperties().getUnsignedSignatureProperties().getRevocationValues();
            CompleteRevocationRefs completeRevocationRefs = aSignature.getQualifyingProperties().getUnsignedSignatureProperties().getCompleteRevocationRefs();
            if (revocationValues.getCRLValueCount() != completeRevocationRefs.getCRLReferenceCount()) {
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[0], new Object[0]), I18n.translate(a[13], a[6]), null, this.getClass());
            }
            if (revocationValues.getOCSPValueCount() != completeRevocationRefs.getOCSPReferenceCount()) {
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[7], new Object[0]), I18n.translate(a[8], a[14]), null, this.getClass());
            }
            List<ECRL> list = revocationValues.getAllCRLs();
            for (int i = 0; i < completeRevocationRefs.getCRLReferenceCount(); ++i) {
                CRLReference cRLReference = completeRevocationRefs.getCRLReference(i);
                bl = false;
                for (ECRL object2 : list) {
                    try {
                        Object object = DigestUtil.digest((DigestAlg)cRLReference.getDigestMethod().getAlgorithm(), (byte[])object2.getEncoded());
                        if (Arrays.equals(cRLReference.getDigestValue(), object)) {
                            bl = true;
                            if (n == 0) break;
                        }
                    }
                    catch (CryptoException cryptoException) {
                        throw new XMLSignatureException(a[10], new Object[]{cryptoException});
                    }
                    if (n == 0) continue;
                }
                if (bl) continue;
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[1], new Object[0]), I18n.translate(a[5], a[2]), cRLReference.toString(), this.getClass());
            }
            List<EOCSPResponse> list2 = revocationValues.getAllOCSPResponses();
            for (int i = 0; i < completeRevocationRefs.getOCSPReferenceCount(); ++i) {
                OCSPReference oCSPReference = completeRevocationRefs.getOCSPReference(i);
                bl = false;
                for (Object object : list2) {
                    try {
                        byte[] byArray = DigestUtil.digest((DigestAlg)oCSPReference.getDigestAlgAndValue().getDigestMethod().getAlgorithm(), (byte[])object.getEncoded());
                        if (Arrays.equals(oCSPReference.getDigestAlgAndValue().getDigestValue(), byArray)) {
                            bl = true;
                            if (n == 0) break;
                        }
                    }
                    catch (CryptoException cryptoException) {
                        throw new XMLSignatureException(a[11], new Object[]{cryptoException});
                    }
                    if (n == 0) continue;
                }
                if (bl) continue;
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[3], new Object[0]), I18n.translate(a[4], a[12]), oCSPReference.toString(), this.getClass());
            }
        }
        return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[9], new Object[0]), I18n.translate(a[15], new Object[0]), null, this.getClass());
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "dU\u0018;@s@\u001d=J<W\u001c7Gy\u001a\u00067R}W\u0015&M}Z\"3HgQ\u0007";
        int n2 = -1;
        block23: while (true) {
            char[] cArray;
            block28: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block27: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block27;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block28;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 18;
                                break;
                            }
                            case 1: {
                                n8 = 52;
                                break;
                            }
                            case 2: {
                                n8 = 116;
                                break;
                            }
                            case 3: {
                                n8 = 82;
                                break;
                            }
                            default: {
                                n8 = 36;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "dU\u0018;@s@\u001d=J<W\u001c7Gy\u001a\u00067R}W\u0015&M}Z\"3HgQ\u0007";
                    n2 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "Qf8";
                    n2 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "dU\u0018;@s@\u001d=J<W\u001c7Gy\u001a\u00067R}W\u0015&M}Z\"3HgQ\u0007";
                    n2 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "dU\u0018;@s@\u001d=J<B\u0015>QwGZ Adb\u0015>W<Y\u001d!W{Z\u0013\u0004E~A\u0011";
                    n2 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "dU\u0018;@s@\u001d=J<B\u0015>QwGZ Adb\u0015>W<Y\u001d!W{Z\u0013\u0004E~A\u0011";
                    n2 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "Qf8";
                    n2 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "dU\u0018;@s@\u001d=J<W\u001c7Gy\u001a\u00067R}W\u0015&M}Z\"3HgQ\u0007";
                    n2 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "dU\u0018;@s@\u001d=J<B\u0015>QwGZ Adb\u0015>W<W\u001b'Jfy\u001d!Is@\u0017:";
                    n2 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "dU\u0018;@s@\u001d=J<W\u001c7Gy\u001a\u00067R}W\u0015&M}Z\"3HgQ\u0007";
                    n2 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "QU\u001a&\u0004v]\u00137Wf\u0014\u0017 H";
                    n2 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "QU\u001a&\u0004v]\u00137Wf\u0014\u001b1Wb";
                    n2 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "]w'\u0002";
                    n2 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "dU\u0018;@s@\u001d=J<B\u0015>QwGZ Adb\u0015>W<W\u001b'Jfy\u001d!Is@\u0017:";
                    n2 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "]w'\u0002";
                    n2 = 13;
                    continue block23;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "dU\u0018;@s@\u001d=J<B\u0015>QwGZ Adb\u0015>W<B\u0015>Mv";
                    n2 = 14;
                    continue block23;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

