/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.validator;

import java.util.Arrays;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.Context;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.CertID;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CertificateValues;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CompleteCertificateRefs;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.BaseTimeStampValidator;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.Validator;

public class CertificateValuesValidator
implements Validator {
    private static final String[] a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidationResult validate(XMLSignature aSignature, ECertificate aCertificate) throws XMLSignatureException {
        int n = BaseTimeStampValidator.b;
        Context context = aSignature.getContext();
        boolean bl = context.getConfig().getValidationConfig().isForceStrictReferences();
        SignatureType signatureType = aSignature.getSignatureType();
        if (bl && (signatureType == SignatureType.XAdES_X_L || signatureType == SignatureType.XAdES_A)) {
            CertificateValues certificateValues = aSignature.getQualifyingProperties().getUnsignedSignatureProperties().getCertificateValues();
            CompleteCertificateRefs completeCertificateRefs = aSignature.getQualifyingProperties().getUnsignedSignatureProperties().getCompleteCertificateRefs();
            if (certificateValues.getCertificateCount() != completeCertificateRefs.getCertificateReferenceCount()) {
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[0], new Object[0]), I18n.translate(a[3], new Object[0]), null, this.getClass());
            }
            List<ECertificate> list = certificateValues.getAllCertificates();
            for (int i = 0; i < completeCertificateRefs.getCertificateReferenceCount(); ++i) {
                CertID certID = completeCertificateRefs.getCertificateReference(i);
                bl = false;
                for (ECertificate eCertificate : list) {
                    try {
                        byte[] byArray = DigestUtil.digest((DigestAlg)certID.getDigestMethod().getAlgorithm(), (byte[])eCertificate.getEncoded());
                        if (Arrays.equals(certID.getDigestValue(), byArray)) {
                            bl = true;
                            if (n == 0) break;
                        }
                    }
                    catch (CryptoException cryptoException) {
                        throw new XMLSignatureException(a[2], new Object[]{cryptoException});
                    }
                    if (n == 0) continue;
                }
                if (bl) continue;
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[4], new Object[0]), I18n.translate(a[5], new Object[0]), certID.toString(), XMLSignature.class);
            }
        }
        return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[1], new Object[0]), I18n.translate(a[6], new Object[0]), null, this.getClass());
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "c/\u00036$t:\u00060.;-\u0007:#~`\f:2a\u0018\u000e35p=";
        int n2 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block18;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 21;
                                break;
                            }
                            case 1: {
                                n8 = 78;
                                break;
                            }
                            case 2: {
                                n8 = 111;
                                break;
                            }
                            case 3: {
                                n8 = 95;
                                break;
                            }
                            default: {
                                n8 = 64;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "c/\u00036$t:\u00060.;-\u0007:#~`\f:2a\u0018\u000e35p=";
                    n2 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "V/\u0001+`q'\b:3an\f:2a";
                    n2 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "c/\u00036$t:\u00060.;8\u000e35p=A<%g:9>,f`\f05{:\"63x/\u001b<(";
                    n2 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "c/\u00036$t:\u00060.;-\u0007:#~`\f:2a\u0018\u000e35p=";
                    n2 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "c/\u00036$t:\u00060.;8\u000e35p=A<%g:9>,f`\u000263f'\u00018\u0016t\"\u001a:";
                    n2 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "c/\u00036$t:\u00060.;8\u000e35p=A<%g:9>,f`\u0019>,|*";
                    n2 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

