/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.formats;

import java.security.Key;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.C14nMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.Context;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.algorithms.XmlSignatureAlgorithm;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.formats.SignatureFormat;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.BaseElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.Manifest;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.Reference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.SignedInfo;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.KeyValue;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.X509Data;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509Certificate;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;

public abstract class BaseSignatureFormat
implements SignatureFormat {
    private static Logger a;
    protected XMLSignature mSignature;
    protected Context mContext;
    public static int b;
    private static final String[] c;

    protected BaseSignatureFormat(Context aContext, XMLSignature aSignature) {
        this.mContext = aContext;
        this.mSignature = aSignature;
    }

    protected DigestAlg getDigestAlgorithmUrl() {
        return this.mSignature.getSignedInfo().getSignatureMethod().getDigestAlg();
    }

    protected C14nMethod getC14nMethod() {
        return this.mSignature.getSignedInfo().getCanonicalizationMethod();
    }

    protected SignatureMethod getSignatureMethod() {
        return this.mSignature.getSignedInfo().getSignatureMethod();
    }

    protected void digestReferences(Manifest aReferences) throws XMLSignatureException {
        int n = b;
        a.info(c[6] + aReferences);
        for (int i = 0; i < aReferences.getReferenceCount(); ++i) {
            Reference reference = aReferences.getReference(i);
            reference.generateDigestValue();
            Manifest manifest = reference.getReferencedManifest();
            if (manifest == null) continue;
            a.info(c[5] + manifest);
            this.digestReferences(manifest);
            continue;
        }
    }

    @Override
    public SignatureValidationResult validateCore() throws XMLSignatureException {
        PublicKey publicKey = this.mSignature.getKeyInfo().resolvePublicKey();
        if (publicKey == null) {
            throw new XMLSignatureException(c[0]);
        }
        return this.validateCore(publicKey);
    }

    @Override
    public SignatureValidationResult validateCore(Key aKey) throws XMLSignatureException {
        SignatureValidationResult signatureValidationResult;
        block11: {
            block10: {
                XmlSignatureAlgorithm xmlSignatureAlgorithm;
                a.debug(c[24]);
                signatureValidationResult = new SignatureValidationResult();
                signatureValidationResult.setVerifierClass(XMLSignature.class);
                SignedInfo signedInfo = this.mSignature.getSignedInfo();
                try {
                    xmlSignatureAlgorithm = this.getSignatureMethod().getSignatureImpl();
                    xmlSignatureAlgorithm.initVerify(aKey, signedInfo.getSignatureAlgorithmParameters());
                }
                catch (Exception exception) {
                    a.warn(c[25], (Throwable)exception);
                    signatureValidationResult.setStatus(ValidationResultType.INVALID, exception.getMessage());
                    return signatureValidationResult;
                }
                byte[] byArray = signedInfo.getCanonicalizedBytes();
                xmlSignatureAlgorithm.update(byArray);
                if (a.isDebugEnabled()) {
                    this.debugSign(signedInfo, byArray, aKey);
                }
                boolean bl = xmlSignatureAlgorithm.verify(this.mSignature.getSignatureValue());
                if (!bl) {
                    String string = I18n.translate(c[28], new Object[0]);
                    a.info(string);
                    signatureValidationResult.setStatus(ValidationResultType.INVALID, string);
                    return signatureValidationResult;
                }
                signatureValidationResult.addItem(new ValidationResult(ValidationResultType.VALID, I18n.translate(c[22], new Object[0]), I18n.translate(c[29], new Object[0]), null, XMLSignature.class));
                a.info(c[26]);
                ValidationResult validationResult = this.validateReferences(this.mSignature.getSignedInfo());
                signatureValidationResult.addItem(validationResult);
                if (validationResult.getType() == ValidationResultType.VALID) break block10;
                signatureValidationResult.setStatus(validationResult.getType(), I18n.translate(c[23], new Object[0]));
                if (b == 0) break block11;
            }
            signatureValidationResult.setStatus(ValidationResultType.VALID, I18n.translate(c[27], new Object[0]));
        }
        return signatureValidationResult;
    }

    @Override
    public SignatureValidationResult validateCore(ECertificate aCertificate) throws XMLSignatureException {
        try {
            return this.validateCore(KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)aCertificate.getSubjectPublicKeyInfo()));
        }
        catch (CryptoException cryptoException) {
            throw new XMLSignatureException(cryptoException, c[8], aCertificate.getSubjectPublicKeyInfo(), c[9]);
        }
    }

    protected ValidationResult validateReferences(Manifest aReferences) throws XMLSignatureException {
        int n = b;
        a.info(c[15] + aReferences);
        for (int i = 0; i < aReferences.getReferenceCount(); ++i) {
            Object object;
            Reference reference = aReferences.getReference(i);
            boolean bl = false;
            Exception exception = null;
            try {
                bl = reference.validateDigestValue();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (!bl) {
                object = new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[19], new Object[0]), I18n.translate(c[21], reference.getURI()), null, XMLSignature.class);
                if (exception != null) {
                    ((ValidationResult)object).setMessage(((ValidationResult)object).getMessage() + c[16] + exception.getMessage());
                }
                return object;
            }
            if (!this.mContext.isValidateManifests() || (object = reference.getReferencedManifest()) == null) continue;
            a.info(c[18] + object);
            ValidationResult validationResult = this.validateReferences((Manifest)object);
            if (validationResult.getType() == ValidationResultType.VALID) continue;
            return validationResult;
        }
        a.info(c[17]);
        return new ValidationResult(ValidationResultType.VALID, I18n.translate(c[20], new Object[0]), I18n.translate(c[14], new Object[0]), null, this.getClass());
    }

    @Override
    public XMLSignature sign(BaseSigner aSigner) throws XMLSignatureException {
        int n = b;
        this.digestReferences(this.mSignature.getSignedInfo());
        SignatureMethod signatureMethod = null;
        try {
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            String string = signedInfo.getSignatureMethod().getSignatureImpl().getAlgorithmName();
            String string2 = aSigner.getSignatureAlgorithmStr();
            signatureMethod = SignatureMethod.fromAlgorithmAndParams(string2, aSigner.getAlgorithmParameterSpec());
            if (signatureMethod == null) {
                throw new XMLSignatureException(c[4], string2);
            }
            if (!string.equals(string2)) {
                a.warn(c[1] + string + c[2] + string2);
                signedInfo.setSignatureMethod(signatureMethod);
            }
            byte[] byArray = this.mSignature.getSignedInfo().getCanonicalizedBytes();
            this.debugSign(signedInfo, byArray, aSigner.getClass());
            byte[] byArray2 = aSigner.sign(byArray);
            this.mSignature.setSignatureValue(byArray2);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, c[3]);
        }
        XMLSignature xMLSignature = this.mSignature;
        if (BaseElement.b) {
            b = ++n;
        }
        return xMLSignature;
    }

    protected void fillSignatureValue(Key aKey) throws XMLSignatureException {
        try {
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            SignatureMethod signatureMethod = signedInfo.getSignatureMethod();
            XmlSignatureAlgorithm xmlSignatureAlgorithm = signatureMethod.getSignatureImpl();
            xmlSignatureAlgorithm.initSign(aKey, signedInfo.getSignatureAlgorithmParameters());
            byte[] byArray = this.mSignature.getSignedInfo().getCanonicalizedBytes();
            if (a.isDebugEnabled()) {
                this.debugSign(signedInfo, byArray, aKey.getClass());
            }
            xmlSignatureAlgorithm.update(byArray);
            byte[] byArray2 = xmlSignatureAlgorithm.sign();
            this.mSignature.setSignatureValue(byArray2);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, c[7]);
        }
    }

    protected void debugSign(SignedInfo si, byte[] canoned, Object aKey) {
        if (a.isDebugEnabled()) {
            a.debug(c[10] + si.getCanonicalizationMethod().getURL());
            a.debug(c[12] + si.getSignatureMethod().getUrl());
            a.debug(c[11] + new String(canoned));
            a.debug(c[13] + aKey);
        }
    }

    @Override
    public void addKeyInfo(ECertificate aCertificate) {
        X509Data x509Data = new X509Data(this.mContext);
        X509Certificate x509Certificate = new X509Certificate(this.mContext, aCertificate);
        x509Data.add(x509Certificate);
        this.mSignature.createOrGetKeyInfo().add(x509Data);
    }

    @Override
    public void addKeyInfo(PublicKey pk) throws XMLSignatureException {
        KeyValue keyValue = new KeyValue(this.mContext, pk);
        this.mSignature.createOrGetKeyInfo().add(keyValue);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[30];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "hIv(\u001ahGj9fnUk!Bn\br(Fb@m.U\u007fOk#\u007fn_";
        int n2 = -1;
        block37: while (true) {
            char[] cArray;
            block42: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block41: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block41;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block42;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 11;
                                break;
                            }
                            case 1: {
                                n8 = 38;
                                break;
                            }
                            case 2: {
                                n8 = 4;
                                break;
                            }
                            case 3: {
                                n8 = 77;
                                break;
                            }
                            default: {
                                n8 = 52;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "XOc#U\u007fSv(\u0014fCp%[o\u0006";
                    n2 = 0;
                    continue block37;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "+Bk(G+Hk9\u0014fGp.\\+Qm9\\+Um*ZnTwc\u0014XI$>CbRg%]eA$9[+Um*ZnTwmUgA$";
                    n2 = 1;
                    continue block37;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "hIv(\u001ahGj9wjJg8XjRa\u001e]lHe9AyCR,X~C";
                    n2 = 2;
                    continue block37;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "~Ho#[|H*,XlIv$@cK";
                    n2 = 3;
                    continue block37;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "OOc(G\u007fOj*\u0014mIq#P+Ke#]mCw9\u000e+";
                    n2 = 4;
                    continue block37;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "OOc(G\u007fOj*\u0014yCb(FnHg(G+\u001c$";
                    n2 = 5;
                    continue block37;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "hIv(\u001ahGj9wjJg8XjRa\u001e]lHe9AyCR,X~C";
                    n2 = 6;
                    continue block37;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "nTv\"Fx\bg,Z\u007fba.[oC";
                    n2 = 7;
                    continue block37;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "[Sf!]hma4";
                    n2 = 8;
                    continue block37;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "h\u00170#\u00141\u0006";
                    n2 = 9;
                    continue block37;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "oGp,\u001chGj\"ZnB-m\u000e+";
                    n2 = 10;
                    continue block37;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "xOc#ynRl\"P+\u001c$";
                    n2 = 11;
                    continue block37;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "`C}m\u000e+";
                    n2 = 12;
                    continue block37;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "hIv(\u001ayCb(FnHg(GJTa\u001bUgO`";
                    n2 = 13;
                    continue block37;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "]Cv$RrOj*\u0014yCb(FnHg(G+\u001c$";
                    n2 = 14;
                    continue block37;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "\u0001ta,GdH>m";
                    n2 = 15;
                    continue block37;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "YCb(FnHg(G+Pe!]oGp(P%";
                    n2 = 16;
                    continue block37;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "FGj$RnUpmRdSj)\u000e";
                    n2 = 17;
                    continue block37;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "}Gh$PjRm\"Z%El(W`\bv(RnTa#Wn";
                    n2 = 18;
                    continue block37;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "}Gh$PjRm\"Z%El(W`\bv(RnTa#Wn";
                    n2 = 19;
                    continue block37;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "hIv(\u001ahGj9bnTm+M%Ta+QyCj.Q";
                    n2 = 20;
                    continue block37;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "}Gh$PjRm\"Z%El(W`\bw$SeGp8Fnpe!An";
                    n2 = 21;
                    continue block37;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "hIv(\u001ahGj9bnTm+M";
                    n2 = 22;
                    continue block37;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "]Gh$PjRamWdTac";
                    n2 = 23;
                    continue block37;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "\\Gv#]eA$$Z+de>QXOc#U\u007fSv(rdTi,@";
                    n2 = 24;
                    continue block37;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "XOc#U\u007fSv(\u0014}Gh8Q+Pe!]oGp(P%";
                    n2 = 25;
                    continue block37;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "hIv(\u001a}Cv$RbC`";
                    n2 = 26;
                    continue block37;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "hIv(\u001ahGj9bnTm+M%Um*ZjRq?Q]Gh8Q";
                    n2 = 27;
                    continue block37;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "hIv(\u001a}Cv$RbC`cGbAj,@~Ta\u001bUgSa";
                    n2 = 28;
                    continue block37;
                }
                case 28: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
        a = LoggerFactory.getLogger(BaseSignatureFormat.class);
    }
}

