/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.algorithms;

import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.algorithms.BaseXmlSignatureAlgorithm;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;

public class ECDSAXmlSignature
extends BaseXmlSignatureAlgorithm {
    private static final String[] a;

    public ECDSAXmlSignature(SignatureAlg aSignatureAlg) {
        super(aSignatureAlg);
    }

    @Override
    public byte[] sign() throws XMLSignatureException {
        try {
            byte[] byArray = this.mSigner.sign(null);
            return byArray;
        }
        catch (CryptoException cryptoException) {
            throw new XMLSignatureException(cryptoException, a[4]);
        }
    }

    @Override
    public boolean verify(byte[] aSignatureValue) throws XMLSignatureException {
        try {
            return this.mVerifier.verifySignature(aSignatureValue);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, a[9]);
        }
    }

    private byte[] a(byte[] byArray) throws XMLSignatureException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block18: {
            block17: {
                int n6;
                int n7 = BaseXmlSignatureAlgorithm.b;
                for (n5 = n4 = byArray[3]; n5 > 0; --n5) {
                    if (byArray[4 + n4 - n5] != 0) break;
                    if (n7 == 0) continue;
                    break;
                }
                for (n3 = n2 = byArray[5 + n4]; n3 > 0; --n3) {
                    if (byArray[6 + n4 + n2 - n3] != 0) break;
                    if (n7 == 0) continue;
                    break;
                }
                if ((n6 = (n3 + 7) / 8 * 8) > (n = (n5 + 7) / 8 * 8)) {
                    n = n6;
                }
                if (byArray[0] != 48 || byArray[1] != byArray.length - 2) break block17;
                if (byArray[2] != 2) break block17;
                if (n < 24) break block17;
                if (byArray[4 + n4] == 2) break block18;
            }
            throw new XMLSignatureException(a[5], a[8], a[7] + I18n.translate(a[6], new Object[0]));
        }
        byte[] byArray2 = new byte[2 * n];
        System.arraycopy(byArray, 4 + n4 - n5, byArray2, n - n5, n5);
        System.arraycopy(byArray, 6 + n4 + n2 - n3, byArray2, 2 * n - n3, n3);
        return byArray2;
    }

    private byte[] b(byte[] byArray) throws XMLSignatureException {
        int n;
        int n2;
        int n3;
        int n4 = BaseXmlSignatureAlgorithm.b;
        if (byArray.length < 48) {
            throw new XMLSignatureException(a[2], a[3], a[0] + I18n.translate(a[1], new Object[0]));
        }
        for (n3 = n2 = byArray.length / 2; n3 > 0; --n3) {
            if (byArray[n2 - n3] != 0) break;
            if (n4 == 0) continue;
            break;
        }
        int n5 = n3;
        if (byArray[n2 - n3] < 0) {
            ++n5;
        }
        for (n = n2; n > 0; --n) {
            if (byArray[2 * n2 - n] != 0) break;
            if (n4 == 0) continue;
            break;
        }
        int n6 = n;
        if (byArray[2 * n2 - n] < 0) {
            ++n6;
        }
        byte[] byArray2 = new byte[6 + n5 + n6];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n5 + n6);
        byArray2[2] = 2;
        byArray2[3] = (byte)n5;
        System.arraycopy(byArray, n2 - n3, byArray2, 4 + n5 - n3, n3);
        byArray2[4 + n5] = 2;
        byArray2[5 + n5] = (byte)n6;
        System.arraycopy(byArray, 2 * n2 - n, byArray2, 6 + n5 + n6 - n, n);
        return byArray2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "x\b\u0016q-\u001d";
        int n2 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block21;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 61;
                                break;
                            }
                            case 1: {
                                n8 = 75;
                                break;
                            }
                            case 2: {
                                n8 = 82;
                                break;
                            }
                            case 3: {
                                n8 = 34;
                                break;
                            }
                            default: {
                                n8 = 108;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "N\"5L\rI> G";
                    n2 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "^$ GBT%$C\u0000T/|D\u0003O&3V#[";
                    n2 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "e\u0006\u001ef?t\f";
                    n2 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "X9 M\u001eNe!K\u000bS";
                    n2 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "^$ GBT%$C\u0000T/|D\u0003O&3V#[";
                    n2 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "N\"5L\rI> G";
                    n2 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "x\b\u0016q-\u001d";
                    n2 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "|\u0018\u001c\f]";
                    n2 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "X9 M\u001eNe$G\u001eT-+";
                    n2 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }

    public static class ECDSAwithSHA512
    extends ECDSAXmlSignature {
        public ECDSAwithSHA512() {
            super(SignatureAlg.ECDSA_SHA512);
        }
    }

    public static class ECDSAwithSHA384
    extends ECDSAXmlSignature {
        public ECDSAwithSHA384() {
            super(SignatureAlg.ECDSA_SHA384);
        }
    }

    public static class ECDSAwithSHA256
    extends ECDSAXmlSignature {
        public ECDSAwithSHA256() {
            super(SignatureAlg.ECDSA_SHA256);
        }
    }

    public static class ECDSAwithSHA1
    extends ECDSAXmlSignature {
        public ECDSAwithSHA1() {
            super(SignatureAlg.ECDSA_SHA1);
        }
    }
}

